/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.obeonetwork.m2doc.properties.TemplateCustomProperties;

public final class POIServices {
    private static POIServices eINSTANCE = new POIServices();

    private POIServices() {
    }

    public static POIServices getInstance() {
        return eINSTANCE;
    }

    public XWPFDocument getXWPFDocument(URI templateURI) throws IOException {
        return this.getXWPFDocument(URIConverter.INSTANCE, templateURI);
    }

    public XWPFDocument getXWPFDocument(URIConverter uriConverter, URI templateURI) throws IOException {
        OPCPackage oPackage = this.getOPCPackage(uriConverter, templateURI);
        XWPFDocument document = new XWPFDocument(oPackage);
        return document;
    }

    private OPCPackage getOPCPackage(URIConverter uriConverter, URI templateURI) throws IOException {
        OPCPackage oPackage;
        Throwable throwable = null;
        Object var5_5 = null;
        try (InputStream is = uriConverter.createInputStream(templateURI);){
            try {
                oPackage = OPCPackage.open((InputStream)is);
            }
            catch (InvalidFormatException e) {
                throw new IllegalArgumentException("Couldn't open template file", e);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return oPackage;
    }

    public TemplateCustomProperties getTemplateCustomProperties(URI templateURI) throws IOException {
        return this.getTemplateCustomProperties(URIConverter.INSTANCE, templateURI);
    }

    public TemplateCustomProperties getTemplateCustomProperties(URIConverter uriConverter, URI templateURI) throws IOException {
        TemplateCustomProperties res;
        Throwable throwable = null;
        Object var5_5 = null;
        try (XWPFDocument document = this.getXWPFDocument(uriConverter, templateURI);){
            res = new TemplateCustomProperties(document);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return res;
    }

    public void saveFile(XWPFDocument document, URI theDestinationURI) throws IOException {
        this.saveFile(URIConverter.INSTANCE, document, theDestinationURI);
    }

    public void saveFile(URIConverter uriConverter, XWPFDocument document, URI theDestinationURI) throws IOException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (OutputStream os = uriConverter.createOutputStream(theDestinationURI);){
            document.write(os);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

