/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.generator;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.poi.xwpf.usermodel.IRunBody;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.xmlbeans.impl.xb.xmlschema.SpaceAttribute;
import org.obeonetwork.m2doc.generator.GenerationResult;
import org.obeonetwork.m2doc.parser.ValidationMessageLevel;
import org.obeonetwork.m2doc.util.M2DocUtils;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTBookmark;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTMarkupRange;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTText;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STFldCharType;

public class BookmarkManager {
    private static final int BUFFER_SIZE = 16;
    private static final String REF_TAG = " REF %s \\h ";
    private final Map<String, CTBookmark> bookmarks = new LinkedHashMap<String, CTBookmark>();
    private final Map<String, CTBookmark> startedBookmarks = new LinkedHashMap<String, CTBookmark>();
    private final Map<String, Set<CTText>> pendingReferences = new HashMap<String, Set<CTText>>();
    private final Map<String, byte[]> referenceIDs = new HashMap<String, byte[]>();
    private final Map<Object, XWPFRun> messagePositions = new HashMap<Object, XWPFRun>();

    public void startBookmark(GenerationResult result, XWPFParagraph paragraph, String name) {
        if (this.bookmarks.containsKey(name)) {
            result.addMessage(M2DocUtils.appendMessageRun(paragraph, ValidationMessageLevel.ERROR, "Can't start duplicated bookmark " + name));
        } else {
            CTBookmark bookmark = paragraph.getCTP().addNewBookmarkStart();
            this.messagePositions.put(bookmark, paragraph.createRun());
            bookmark.setName(name);
            BigInteger id = this.getRandomID();
            bookmark.setId(id);
            this.bookmarks.put(name, bookmark);
            this.startedBookmarks.put(name, bookmark);
            Set<CTText> pendingRefs = this.pendingReferences.remove(name);
            if (pendingRefs != null) {
                for (CTText pendingRef : pendingRefs) {
                    XWPFRun run = this.messagePositions.get(pendingRef);
                    IRunBody parent = run.getParent();
                    if (!(parent instanceof XWPFParagraph)) {
                        throw new IllegalStateException("this should not happend");
                    }
                    ((XWPFParagraph)parent).removeRun(((XWPFParagraph)parent).getRuns().indexOf(run));
                    pendingRef.setStringValue(String.format(REF_TAG, bookmark.getName()));
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void endBookmark(GenerationResult result, XWPFParagraph paragraph, String name) {
        CTBookmark bookmark = this.startedBookmarks.remove(name);
        if (bookmark != null) {
            CTMarkupRange range = paragraph.getCTP().addNewBookmarkEnd();
            range.setId(this.bookmarks.get(name).getId());
            XWPFRun run = this.messagePositions.get(bookmark);
            IRunBody parent = run.getParent();
            if (!(parent instanceof XWPFParagraph)) throw new IllegalStateException("this should not happend");
            ((XWPFParagraph)parent).removeRun(((XWPFParagraph)parent).getRuns().indexOf(run));
            return;
        } else if (this.bookmarks.containsKey(name)) {
            result.addMessage(M2DocUtils.appendMessageRun(paragraph, ValidationMessageLevel.ERROR, "Can't end already closed bookmark " + name));
            return;
        } else {
            result.addMessage(M2DocUtils.appendMessageRun(paragraph, ValidationMessageLevel.ERROR, "Can't end not existing bookmark " + name));
        }
    }

    private BigInteger getRandomID() {
        UUID uuid = UUID.randomUUID();
        ByteBuffer buffer = ByteBuffer.wrap(new byte[16]);
        buffer.putLong(uuid.getMostSignificantBits());
        buffer.putLong(uuid.getLeastSignificantBits());
        return new BigInteger(buffer.array()).abs();
    }

    public void insertReference(XWPFParagraph paragraph, String name, String text) {
        CTBookmark bookmark = this.bookmarks.get(name);
        if (bookmark != null) {
            this.insertReference(paragraph, bookmark, text);
        } else {
            XWPFRun messageRun = paragraph.createRun();
            CTText ref = this.insertPendingReference(paragraph, name, text);
            this.messagePositions.put(ref, messageRun);
            Set<CTText> pendingRefs = this.pendingReferences.get(name);
            if (pendingRefs == null) {
                pendingRefs = new LinkedHashSet<CTText>();
                this.pendingReferences.put(name, pendingRefs);
            }
            pendingRefs.add(ref);
        }
    }

    private void insertReference(XWPFParagraph paragraph, CTBookmark bookmark, String text) {
        String name = bookmark.getName();
        CTText pgcttext = this.insertPendingReference(paragraph, name, text);
        pgcttext.setStringValue(String.format(REF_TAG, name));
    }

    private CTText insertPendingReference(XWPFParagraph paragraph, String name, String text) {
        byte[] id = this.getReferenceID(name);
        XWPFRun beginRun = paragraph.createRun();
        beginRun.getCTR().setRsidR(id);
        beginRun.getCTR().addNewFldChar().setFldCharType(STFldCharType.BEGIN);
        XWPFRun preservedRun = paragraph.createRun();
        preservedRun.getCTR().setRsidR(id);
        CTText pgcttext = preservedRun.getCTR().addNewInstrText();
        pgcttext.setSpace(SpaceAttribute.Space.PRESERVE);
        XWPFRun separateRun = paragraph.createRun();
        separateRun.getCTR().setRsidR(id);
        separateRun.getCTR().addNewFldChar().setFldCharType(STFldCharType.SEPARATE);
        XWPFRun textRun = paragraph.createRun();
        textRun.getCTR().setRsidR(id);
        textRun.getCTR().addNewRPr().addNewNoProof();
        textRun.setText(text);
        textRun.setBold(true);
        XWPFRun endRun = paragraph.createRun();
        endRun.getCTR().setRsidR(id);
        endRun.getCTR().addNewFldChar().setFldCharType(STFldCharType.END);
        return pgcttext;
    }

    private byte[] getReferenceID(String name) {
        byte[] res;
        byte[] cachedID = this.referenceIDs.get(name);
        if (cachedID == null) {
            res = this.getRandomID().toByteArray();
            this.referenceIDs.put(name, res);
        } else {
            res = cachedID;
        }
        return res;
    }

    public boolean markOpenBookmarks(GenerationResult result) {
        boolean res;
        boolean bl = res = !this.startedBookmarks.isEmpty();
        if (res) {
            for (Map.Entry<String, CTBookmark> entry : this.startedBookmarks.entrySet()) {
                XWPFRun positionRun = this.messagePositions.remove(entry.getValue());
                result.addMessage(M2DocUtils.setRunMessage(positionRun, ValidationMessageLevel.ERROR, "unclosed bookmark " + entry.getKey()));
            }
        }
        return res;
    }

    public boolean markDanglingReferences(GenerationResult result) {
        boolean res;
        boolean bl = res = !this.pendingReferences.isEmpty();
        if (res) {
            for (Map.Entry<String, Set<CTText>> entry : this.pendingReferences.entrySet()) {
                for (CTText ref : entry.getValue()) {
                    XWPFRun refRun = this.messagePositions.remove(ref);
                    result.addMessage(M2DocUtils.insertMessageAfter(refRun, ValidationMessageLevel.ERROR, "dangling reference for bookmark " + entry.getKey()));
                }
            }
        }
        return res;
    }
}

