/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.generator;

import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.util.Units;
import org.apache.poi.xwpf.usermodel.BreakType;
import org.apache.poi.xwpf.usermodel.IBody;
import org.apache.poi.xwpf.usermodel.IRunBody;
import org.apache.poi.xwpf.usermodel.UnderlinePatterns;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFFooter;
import org.apache.poi.xwpf.usermodel.XWPFHeader;
import org.apache.poi.xwpf.usermodel.XWPFHeaderFooter;
import org.apache.poi.xwpf.usermodel.XWPFHyperlinkRun;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRelation;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.eclipse.acceleo.query.runtime.EvaluationResult;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IQueryEvaluationEngine;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.impl.QueryEvaluationEngine;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.ecore.EObject;
import org.obeonetwork.m2doc.element.MBookmark;
import org.obeonetwork.m2doc.element.MElement;
import org.obeonetwork.m2doc.element.MHyperLink;
import org.obeonetwork.m2doc.element.MImage;
import org.obeonetwork.m2doc.element.MPagination;
import org.obeonetwork.m2doc.element.MStyle;
import org.obeonetwork.m2doc.element.MTable;
import org.obeonetwork.m2doc.element.MText;
import org.obeonetwork.m2doc.generator.BookmarkManager;
import org.obeonetwork.m2doc.generator.GenerationResult;
import org.obeonetwork.m2doc.generator.UserContentManager;
import org.obeonetwork.m2doc.generator.UserContentRawCopy;
import org.obeonetwork.m2doc.parser.TemplateValidationMessage;
import org.obeonetwork.m2doc.parser.TokenType;
import org.obeonetwork.m2doc.parser.ValidationMessageLevel;
import org.obeonetwork.m2doc.template.Block;
import org.obeonetwork.m2doc.template.Bookmark;
import org.obeonetwork.m2doc.template.Cell;
import org.obeonetwork.m2doc.template.Comment;
import org.obeonetwork.m2doc.template.Conditional;
import org.obeonetwork.m2doc.template.ContentControl;
import org.obeonetwork.m2doc.template.DocumentTemplate;
import org.obeonetwork.m2doc.template.IConstruct;
import org.obeonetwork.m2doc.template.Let;
import org.obeonetwork.m2doc.template.Link;
import org.obeonetwork.m2doc.template.Query;
import org.obeonetwork.m2doc.template.Repetition;
import org.obeonetwork.m2doc.template.Row;
import org.obeonetwork.m2doc.template.Statement;
import org.obeonetwork.m2doc.template.StaticFragment;
import org.obeonetwork.m2doc.template.Table;
import org.obeonetwork.m2doc.template.Template;
import org.obeonetwork.m2doc.template.UserContent;
import org.obeonetwork.m2doc.template.UserDoc;
import org.obeonetwork.m2doc.template.util.TemplateSwitch;
import org.obeonetwork.m2doc.util.M2DocUtils;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTHdrFtr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTHyperlink;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTP;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTR;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRow;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSimpleField;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTbl;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTc;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTText;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STOnOff;

public class M2DocEvaluator
extends TemplateSwitch<IConstruct> {
    private static final String INVALID_BOOKMARK_STATEMENT = "Invalid bookmark statement: ";
    private static final String INVALID_CONDITIONAL_STATEMENT = "Invalid if statement: ";
    private static final String INVALID_BLOCK_STATEMENT = "Invalid block: ";
    private static final String INVALID_LET_STATEMENT = "Invalid let statement: ";
    private static final String INVALID_LINK_STATEMENT = "Invalid link statement: ";
    private static final String INVALID_QUERY_STATEMENT = "Invalid query statement: ";
    private static final String INVALID_REPETITION_STATEMENT = "Invalid for statement: ";
    private static final String INVALID_USERDOC_STATEMENT = "Invalid userDoc statement: ";
    private static final String AN_I_O_PROBLEM_OCCURED_WHILE_READING = "An I/O Problem occured while reading %s: %s.";
    private static final String PICTURE_INVALID_FORMAT = "Picture in %s has an invalid format: %s.";
    private final BookmarkManager bookmarkManager;
    private final Stack<Map<String, Object>> variablesStack = new Stack();
    private IBody generatedDocument;
    private XWPFParagraph currentTemplateParagraph;
    private XWPFParagraph currentGeneratedParagraph;
    private XWPFTable currentGeneratedTable;
    private XWPFTableRow currentGeneratedRow;
    private boolean forceNewParagraph;
    private UserContentManager userContentManager;
    private List<String> userDocIds = new ArrayList<String>();
    private final IQueryEvaluationEngine evaluator;
    private GenerationResult result;
    private Monitor monitor;

    public M2DocEvaluator(BookmarkManager bookmarkManager, UserContentManager userContentManager, IReadOnlyQueryEnvironment queryEnvironment, Monitor monitor) {
        this.bookmarkManager = bookmarkManager;
        this.userContentManager = userContentManager;
        this.evaluator = new QueryEvaluationEngine((IQueryEnvironment)queryEnvironment);
        this.monitor = monitor;
    }

    public GenerationResult generate(DocumentTemplate documentTemplate, Map<String, Object> variables, IBody destinationDocument) {
        this.generatedDocument = destinationDocument;
        this.variablesStack.push(variables);
        this.result = new GenerationResult();
        this.result.getDuplicatedUserContentIDs().addAll(this.userContentManager.getDuplicatedUserContentIDs());
        this.doSwitch(documentTemplate);
        return this.result;
    }

    @Override
    public IConstruct caseDocumentTemplate(DocumentTemplate documentTemplate) {
        this.doSwitch(documentTemplate.getBody());
        XWPFDocument document = (XWPFDocument)this.generatedDocument;
        Iterator footers = document.getFooterList().iterator();
        for (Template footer : documentTemplate.getFooters()) {
            XWPFFooter f = (XWPFFooter)footers.next();
            this.cleanHeaderFooter((XWPFHeaderFooter)f);
            this.generatedDocument = f;
            this.doSwitch(footer);
        }
        Iterator headers = document.getHeaderList().iterator();
        for (Template header : documentTemplate.getHeaders()) {
            XWPFHeader h = (XWPFHeader)headers.next();
            this.cleanHeaderFooter((XWPFHeaderFooter)h);
            this.generatedDocument = h;
            this.doSwitch(header);
        }
        return null;
    }

    void cleanHeaderFooter(XWPFHeaderFooter headerFooter) {
        CTHdrFtr ctHdrFtr = (CTHdrFtr)headerFooter._getHdrFtr().copy();
        ctHdrFtr.getPList().clear();
        ctHdrFtr.getTblList().clear();
        headerFooter.setHeaderFooter(ctHdrFtr);
    }

    @Override
    public IConstruct caseTemplate(Template template) {
        this.doSwitch(template.getBody());
        return template;
    }

    @Override
    public IConstruct caseStaticFragment(StaticFragment staticFragment) {
        for (XWPFRun run : staticFragment.getRuns()) {
            this.insertRun(run);
        }
        return staticFragment;
    }

    private XWPFRun insertRun(XWPFRun srcRun) {
        if (srcRun.getParent() != this.currentTemplateParagraph || this.forceNewParagraph) {
            this.createNewParagraph((XWPFParagraph)srcRun.getParent());
            this.forceNewParagraph = false;
        }
        XWPFRun newRun = null;
        if (srcRun instanceof XWPFHyperlinkRun) {
            CTHyperlink newHyperlink = this.currentGeneratedParagraph.getCTP().addNewHyperlink();
            newHyperlink.set((XmlObject)((XWPFHyperlinkRun)srcRun).getCTHyperlink());
            newRun = new XWPFHyperlinkRun(newHyperlink, srcRun.getCTR(), srcRun.getParent());
            this.currentGeneratedParagraph.addRun(newRun);
        } else {
            newRun = this.currentGeneratedParagraph.createRun();
            newRun.getCTR().set((XmlObject)srcRun.getCTR());
        }
        return newRun;
    }

    private XWPFRun insertFieldRunReplacement(XWPFRun srcRun, String replacement) {
        if (srcRun.getParent() != this.currentTemplateParagraph || this.forceNewParagraph) {
            this.createNewParagraph((XWPFParagraph)srcRun.getParent());
            this.forceNewParagraph = false;
        }
        return this.insertString(srcRun, replacement);
    }

    private XWPFRun insertString(XWPFRun srcRun, String text) {
        int fragmentStart = 0;
        int i = 0;
        while (i < text.length()) {
            char current = text.charAt(i);
            switch (current) {
                case '\n': {
                    XWPFRun inserted = this.insertFragment(srcRun, text.substring(fragmentStart, i));
                    inserted.addBreak();
                    fragmentStart = i + 1;
                    break;
                }
                case '\t': {
                    XWPFRun inserted = this.insertFragment(srcRun, text.substring(fragmentStart, i));
                    inserted.addTab();
                    fragmentStart = i + 1;
                    break;
                }
                case '\r': {
                    if (i + 1 >= text.length() || text.charAt(i + 1) != '\n') break;
                    XWPFRun inserted = this.insertFragment(srcRun, text.substring(fragmentStart, i));
                    inserted.addBreak();
                    fragmentStart = ++i + 1;
                    break;
                }
            }
            ++i;
        }
        return this.insertFragment(srcRun, text.substring(fragmentStart, text.length()));
    }

    private XWPFRun insertFragment(XWPFRun srcRun, String fragment) {
        XWPFRun generatedRun = this.currentGeneratedParagraph.createRun();
        generatedRun.getCTR().set(srcRun.getCTR().copy());
        generatedRun.getCTR().getInstrTextList().clear();
        generatedRun.setText(fragment);
        return generatedRun;
    }

    private void createNewParagraph(XWPFParagraph srcParagraph) {
        XWPFParagraph newParagraph;
        if (this.generatedDocument instanceof XWPFTableCell) {
            XWPFTableCell cell = (XWPFTableCell)this.generatedDocument;
            newParagraph = cell.addParagraph();
        } else if (this.generatedDocument instanceof XWPFDocument) {
            newParagraph = ((XWPFDocument)this.generatedDocument).createParagraph();
        } else if (this.generatedDocument instanceof XWPFHeaderFooter) {
            newParagraph = ((XWPFHeaderFooter)this.generatedDocument).createParagraph();
        } else {
            throw new UnsupportedOperationException("unkown IBody type :" + this.generatedDocument.getClass());
        }
        CTP ctp = (CTP)srcParagraph.getCTP().copy();
        ctp.getRList().clear();
        ctp.getFldSimpleList().clear();
        ctp.getHyperlinkList().clear();
        newParagraph.getCTP().set((XmlObject)ctp);
        int runNb = newParagraph.getRuns().size();
        int i = 0;
        while (i < runNb) {
            newParagraph.removeRun(i);
            ++i;
        }
        this.currentTemplateParagraph = srcParagraph;
        this.currentGeneratedParagraph = newParagraph;
    }

    protected boolean hasError(IConstruct construct) {
        boolean res = false;
        for (TemplateValidationMessage message : construct.getValidationMessages()) {
            if (message.getLevel() != ValidationMessageLevel.ERROR) continue;
            res = true;
            break;
        }
        return res;
    }

    @Override
    public IConstruct caseQuery(Query query) {
        if (this.hasError(query)) {
            this.insertQuerySyntaxMessages(query, INVALID_QUERY_STATEMENT);
        } else {
            EvaluationResult queryResult = this.evaluator.eval(query.getQuery(), this.variablesStack.peek());
            if (queryResult.getDiagnostic().getSeverity() != 0) {
                this.insertQueryEvaluationMessages(query, queryResult.getDiagnostic());
            } else {
                Object value = queryResult.getResult();
                XWPFRun styleRun = query.getStyleRun();
                this.insertObject(value, styleRun);
            }
        }
        return query;
    }

    private void insertObject(Object object, XWPFRun run) {
        if (object instanceof Collection) {
            for (Object child : (Collection)object) {
                this.insertObject(child, run);
            }
        } else if (object instanceof MHyperLink) {
            XWPFRun linkRun = this.insertFieldRunReplacement(run, "");
            this.insertMHyperLink(linkRun, (MHyperLink)object);
        } else if (object instanceof MBookmark) {
            this.insertMBookmark(run, (MBookmark)object);
        } else if (object instanceof MImage) {
            XWPFRun imageRun = this.insertFieldRunReplacement(run, "");
            this.insertMImage(imageRun, (MImage)object);
        } else if (object instanceof MText) {
            this.insertMText(run, (MText)object);
        } else if (object instanceof MTable) {
            XWPFRun tableRun = run;
            tableRun.getCTR().getInstrTextList().clear();
            this.insertMTable(tableRun, (MTable)object);
        } else if (object instanceof MPagination) {
            this.insertMPagination(run, (MPagination)object);
        } else if (object == null) {
            this.insertFieldRunReplacement(run, "");
        } else {
            this.insertFieldRunReplacement(run, object.toString());
        }
    }

    private void insertMText(XWPFRun run, MText text) {
        if (text.getText() != null) {
            XWPFRun textRun = this.insertFieldRunReplacement(run, text.getText());
            if (text.getStyle() != null) {
                this.applyMStyle(textRun, text.getStyle());
            }
        }
    }

    @Override
    public IConstruct caseComment(Comment comment) {
        return comment;
    }

    private void insertMBookmark(XWPFRun run, MBookmark bookmark) {
        this.insertFieldRunReplacement(run, "");
        if (bookmark.isReference()) {
            this.bookmarkManager.insertReference(this.currentGeneratedParagraph, bookmark.getId(), bookmark.getText());
        } else {
            this.bookmarkManager.startBookmark(this.result, this.currentGeneratedParagraph, bookmark.getId());
            this.insertFieldRunReplacement(run, bookmark.getText());
            this.bookmarkManager.endBookmark(this.result, this.currentGeneratedParagraph, bookmark.getId());
        }
    }

    private void insertMHyperLink(XWPFRun run, MHyperLink hyperLink) {
        String id = this.currentGeneratedParagraph.getDocument().getPackagePart().addExternalRelationship(hyperLink.getUrl(), XWPFRelation.HYPERLINK.getRelation()).getId();
        CTHyperlink cLink = this.currentGeneratedParagraph.getCTP().addNewHyperlink();
        cLink.setId(id);
        CTText ctText = CTText.Factory.newInstance();
        ctText.setStringValue(hyperLink.getText());
        CTR ctr = CTR.Factory.newInstance();
        ctr.setRPr((CTRPr)run.getCTR().getRPr().copy());
        ctr.setTArray(new CTText[]{ctText});
        cLink.setRArray(new CTR[]{ctr});
    }

    private void insertMImage(XWPFRun run, MImage image) {
        try {
            int heigth = Units.toEMU((double)image.getHeight());
            int width = Units.toEMU((double)image.getWidth());
            Throwable throwable = null;
            Object var6_9 = null;
            try (InputStream imageStream = image.getInputStream();){
                run.addPicture(imageStream, image.getType().getPoiType(), image.getURI().toString(), width, heigth);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (InvalidFormatException e) {
            this.insertMessage(this.currentGeneratedParagraph, ValidationMessageLevel.ERROR, String.format(PICTURE_INVALID_FORMAT, image.getURI().toString(), e.getMessage()));
        }
        catch (IOException e) {
            this.insertMessage(this.currentGeneratedParagraph, ValidationMessageLevel.ERROR, String.format(AN_I_O_PROBLEM_OCCURED_WHILE_READING, image.getURI().toString(), e.getMessage()));
        }
    }

    private void insertMPagination(XWPFRun run, MPagination mPagination) {
        switch (mPagination) {
            case newColumn: {
                run.addBreak(BreakType.COLUMN);
                break;
            }
            case newParagraph: {
                this.createNewParagraph((XWPFParagraph)run.getParent());
                break;
            }
            case newPage: {
                run.addBreak(BreakType.PAGE);
                break;
            }
            case newTableOfContent: {
                CTP ctP = this.currentGeneratedParagraph.getCTP();
                CTSimpleField toc = ctP.addNewFldSimple();
                toc.setInstr("TOC \\h");
                toc.setDirty(STOnOff.TRUE);
                break;
            }
            case newTextWrapping: {
                run.addBreak(BreakType.TEXT_WRAPPING);
                break;
            }
            default: {
                throw new IllegalStateException("Not supported MPagination.");
            }
        }
    }

    private void insertMTable(XWPFRun run, MTable table) {
        XWPFTable docTable;
        if (this.generatedDocument instanceof XWPFDocument) {
            if (table.getLabel() != null) {
                XWPFRun captionRun = run;
                IRunBody runBody = captionRun.getParent();
                if (runBody instanceof XWPFParagraph) {
                    ((XWPFParagraph)runBody).setSpacingAfter(0);
                }
                captionRun.setText(table.getLabel());
                captionRun.setBold(true);
            }
            docTable = ((XWPFDocument)this.generatedDocument).createTable();
        } else if (this.generatedDocument instanceof XWPFHeaderFooter) {
            XWPFHeaderFooter headerFooter = (XWPFHeaderFooter)this.generatedDocument;
            int index = headerFooter._getHdrFtr().getTblArray().length;
            CTTbl cttbl = headerFooter._getHdrFtr().insertNewTbl(index);
            docTable = new XWPFTable(cttbl, (IBody)headerFooter);
            headerFooter.insertTable(index, docTable);
        } else if (this.generatedDocument instanceof XWPFTableCell) {
            XWPFTableCell tcell = (XWPFTableCell)this.generatedDocument;
            if (table.getLabel() != null) {
                XWPFRun captionRun = run;
                IRunBody runBody = captionRun.getParent();
                if (runBody instanceof XWPFParagraph) {
                    ((XWPFParagraph)runBody).setSpacingAfter(0);
                }
                captionRun.setText(table.getLabel());
                captionRun.setBold(true);
            }
            CTTbl ctTbl = tcell.getCTTc().addNewTbl();
            docTable = new XWPFTable(ctTbl, (IBody)tcell);
            int tableRank = tcell.getTables().size();
            tcell.insertTable(tableRank, docTable);
            tcell.addParagraph();
        } else {
            docTable = null;
            this.insertMessage((XWPFParagraph)run.getParent(), ValidationMessageLevel.ERROR, "m:table can't be inserted here.");
        }
        if (docTable != null) {
            this.fillTable(docTable, table);
        }
    }

    private void fillTable(XWPFTable table, MTable mtable) {
        List<MTable.MRow> rows = mtable.getRows();
        int rowIdx = 0;
        while (rowIdx < rows.size()) {
            MTable.MRow mRow = rows.get(rowIdx);
            XWPFTableRow xwpfRow = table.getNumberOfRows() > rowIdx ? table.getRow(rowIdx) : table.createRow();
            int colIdx = 0;
            while (colIdx < mtable.getColumnsCount()) {
                XWPFTableCell xwpfCell = xwpfRow.getTableCells().size() > colIdx ? xwpfRow.getCell(colIdx) : xwpfRow.createCell();
                XWPFParagraph xwpfCellParagraph = (XWPFParagraph)xwpfCell.getParagraphs().get(0);
                xwpfCellParagraph.setSpacingBefore(0);
                xwpfCellParagraph.setSpacingAfter(0);
                MTable.MCell mCell = null;
                if (colIdx < mRow.getCells().size()) {
                    mCell = mRow.getCells().get(colIdx);
                }
                this.setCellContent(xwpfCell, mCell);
                ++colIdx;
            }
            ++rowIdx;
        }
    }

    private void setCellContent(XWPFTableCell cell, MTable.MCell mCell) {
        XWPFParagraph cellParagraph = (XWPFParagraph)cell.getParagraphs().get(0);
        XWPFRun cellRun = cellParagraph.createRun();
        if (mCell != null) {
            Color backGroundColor;
            MElement contents = mCell.getContents();
            if (contents != null) {
                IBody savedGeneratedDocument = this.generatedDocument;
                XWPFParagraph savedGeneratedParagraph = this.currentGeneratedParagraph;
                XWPFParagraph savedTemplateParagraph = this.currentTemplateParagraph;
                this.generatedDocument = cell;
                this.currentGeneratedParagraph = cellParagraph;
                this.currentTemplateParagraph = cellParagraph;
                try {
                    this.insertObject(contents, cellRun);
                }
                finally {
                    this.generatedDocument = savedGeneratedDocument;
                    this.currentGeneratedParagraph = savedGeneratedParagraph;
                    this.currentTemplateParagraph = savedTemplateParagraph;
                }
                cellParagraph.removeRun(cellParagraph.getRuns().indexOf(cellRun));
            }
            if ((backGroundColor = mCell.getBackgroundColor()) != null) {
                cell.setColor(M2DocEvaluator.hexColor(backGroundColor));
            }
        }
    }

    private void applyMStyle(XWPFRun run, MStyle style) {
        if (style.getFontSize() != -1) {
            run.setFontSize(style.getFontSize());
        }
        if (style.getFontModifiers() != -1) {
            run.setBold((style.getFontModifiers() & 1) != 0);
            run.setItalic((style.getFontModifiers() & 2) != 0);
            if ((style.getFontModifiers() & 4) != 0) {
                run.setUnderline(UnderlinePatterns.SINGLE);
            }
            run.setStrikeThrough((style.getFontModifiers() & 8) != 0);
        }
        if (style.getForegroundColor() != null) {
            run.setColor(M2DocEvaluator.hexColor(style.getForegroundColor()));
        }
    }

    private static String hexColor(Color color) {
        return String.format("%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue());
    }

    @Override
    public IConstruct caseRepetition(Repetition repetition) {
        if (this.hasError(repetition)) {
            this.insertQuerySyntaxMessages(repetition, INVALID_REPETITION_STATEMENT);
        } else {
            EvaluationResult queryResult = this.evaluator.eval(repetition.getQuery(), this.variablesStack.peek());
            if (queryResult.getDiagnostic().getSeverity() != 0) {
                this.insertQueryEvaluationMessages(repetition, queryResult.getDiagnostic());
            } else {
                ArrayList<Object> iteration = new ArrayList<Object>();
                if (queryResult.getResult() instanceof Collection) {
                    iteration.addAll((Collection)queryResult.getResult());
                } else if (queryResult.getResult() != null) {
                    iteration.add(queryResult.getResult());
                } else {
                    this.insertMessage(this.currentGeneratedParagraph, ValidationMessageLevel.WARNING, String.valueOf(repetition.getIterationVar()) + " value is null.");
                }
                HashMap<String, Object> newVariables = new HashMap<String, Object>(this.variablesStack.peek());
                this.variablesStack.push(newVariables);
                try {
                    for (Object e : iteration) {
                        newVariables.put(repetition.getIterationVar(), e);
                        this.doSwitch(repetition.getBody());
                        this.closingRepretition(repetition);
                    }
                }
                finally {
                    this.variablesStack.pop();
                }
            }
        }
        return repetition;
    }

    public IConstruct doSwitch(EObject eObject) {
        if (!this.monitor.isCanceled()) {
            return (IConstruct)super.doSwitch(eObject);
        }
        return null;
    }

    @Override
    public IConstruct caseLet(Let let) {
        if (this.hasError(let)) {
            this.insertQuerySyntaxMessages(let, INVALID_LET_STATEMENT);
        } else {
            EvaluationResult queryResult = this.evaluator.eval(let.getValue(), this.variablesStack.peek());
            if (queryResult.getDiagnostic().getSeverity() != 0) {
                this.insertQueryEvaluationMessages(let, queryResult.getDiagnostic());
            } else {
                HashMap<String, Object> newVariables = new HashMap<String, Object>(this.variablesStack.peek());
                this.variablesStack.push(newVariables);
                try {
                    newVariables.put(let.getName(), queryResult.getResult());
                    this.doSwitch(let.getBody());
                }
                finally {
                    this.variablesStack.pop();
                }
            }
        }
        return let;
    }

    @Override
    public IConstruct caseUserDoc(UserDoc userDoc) {
        if (this.hasError(userDoc)) {
            this.insertQuerySyntaxMessages(userDoc, INVALID_USERDOC_STATEMENT);
        } else {
            EvaluationResult queryResult = this.evaluator.eval(userDoc.getId(), this.variablesStack.peek());
            if (queryResult.getDiagnostic().getSeverity() != 0) {
                this.insertQueryEvaluationMessages(userDoc, queryResult.getDiagnostic());
            } else if (queryResult.getResult() == null) {
                this.insertMessage(this.currentGeneratedParagraph, ValidationMessageLevel.ERROR, "User doc id can't be null.");
            } else {
                String id = queryResult.getResult().toString();
                this.insertUserContent(userDoc, id);
            }
        }
        return userDoc;
    }

    private void insertUserContent(UserDoc userDoc, String id) {
        this.addStartUserDocField(userDoc, id);
        this.manageUserDocIdUniqueness(id, userDoc);
        UserContent userContent = this.userContentManager.consumeUserContent(id);
        boolean needNewParagraphBeforeEndTag = true;
        if (userContent == null) {
            this.doSwitch(userDoc.getBody());
            needNewParagraphBeforeEndTag = this.needNewParagraph(userDoc);
        } else {
            UserContentRawCopy userContentRawCopy = new UserContentRawCopy();
            try {
                this.currentGeneratedParagraph = userContentRawCopy.copy(userContent, this.currentGeneratedParagraph, this.generatedDocument);
                needNewParagraphBeforeEndTag = userContentRawCopy.needNewParagraph();
                if (userDoc.getClosingRuns().size() != 0) {
                    this.currentTemplateParagraph = (XWPFParagraph)((XWPFRun)userDoc.getClosingRuns().get(userDoc.getClosingRuns().size() - 1)).getParent();
                }
            }
            catch (InvalidFormatException e) {
                this.insertMessage(this.currentGeneratedParagraph, ValidationMessageLevel.ERROR, "userdoc copy error : " + e.getMessage());
            }
            catch (XmlException e) {
                this.insertMessage(this.currentGeneratedParagraph, ValidationMessageLevel.ERROR, "userdoc copy error : " + e.getMessage());
            }
            catch (IOException e) {
                this.insertMessage(this.currentGeneratedParagraph, ValidationMessageLevel.ERROR, "userdoc copy error : " + e.getMessage());
            }
        }
        this.addEndUserDocField(userDoc, needNewParagraphBeforeEndTag);
    }

    private boolean needNewParagraph(IConstruct construct) {
        boolean needNewParagraph = true;
        if (construct.getClosingRuns().size() != 0 && ((XWPFRun)construct.getClosingRuns().get(0)).getParent() == this.currentTemplateParagraph) {
            needNewParagraph = false;
        }
        return needNewParagraph;
    }

    private void manageUserDocIdUniqueness(String id, UserDoc userdoc) {
        if (this.userDocIds.contains(id)) {
            String msgError = "The id '" + id + "' is already used in generated document. Ids must be unique otherwise document part contained userContent could be lost at next generation.";
            this.insertMessage(this.currentGeneratedParagraph, ValidationMessageLevel.ERROR, msgError);
            TemplateValidationMessage templateValidationMessage = new TemplateValidationMessage(ValidationMessageLevel.ERROR, msgError, (XWPFRun)userdoc.getRuns().get(userdoc.getRuns().size() - 1));
            userdoc.getValidationMessages().add((Object)templateValidationMessage);
        } else {
            this.userDocIds.add(id);
        }
    }

    private void addStartUserDocField(IConstruct object, String id) {
        if (this.currentTemplateParagraph == null || object.getRuns().size() != 0 && ((XWPFRun)object.getRuns().get(0)).getParent() != this.currentTemplateParagraph) {
            this.createNewParagraph((XWPFParagraph)((XWPFRun)object.getRuns().get(0)).getParent());
        }
        this.currentGeneratedParagraph.getCTP().addNewFldSimple().setInstr(String.valueOf(TokenType.USERCONTENT.getValue()) + " " + id);
    }

    private void addEndUserDocField(IConstruct object, boolean needNewParagraph) {
        if (object.getClosingRuns().size() != 0) {
            if (needNewParagraph) {
                this.createNewParagraph((XWPFParagraph)((XWPFRun)object.getClosingRuns().get(0)).getParent());
            }
            this.currentGeneratedParagraph.getCTP().addNewFldSimple().setInstr(TokenType.ENDUSERCONTENT.getValue());
        }
    }

    private void closingRepretition(Repetition repetition) {
        int bodySize = repetition.getBody().getStatements().size();
        if (bodySize > 0 && ((Statement)repetition.getBody().getStatements().get(bodySize - 1)).getRuns().size() > 0) {
            IConstruct lastBodyPart = (IConstruct)repetition.getBody().getStatements().get(bodySize - 1);
            int runNumber = lastBodyPart.getRuns().size();
            XWPFRun lastRun = (XWPFRun)lastBodyPart.getRuns().get(runNumber - 1);
            int closingRunNumber = repetition.getClosingRuns().size();
            if (closingRunNumber > 0 && ((XWPFRun)repetition.getClosingRuns().get(0)).getParent() != lastRun.getParent()) {
                this.forceNewParagraph = true;
            }
        }
    }

    @Override
    public IConstruct caseBlock(Block block) {
        if (this.hasError(block)) {
            this.insertQuerySyntaxMessages(block, INVALID_BLOCK_STATEMENT);
        } else {
            for (IConstruct construct : block.getStatements()) {
                this.doSwitch(construct);
            }
        }
        return block;
    }

    @Override
    public IConstruct caseConditional(Conditional conditional) {
        block4: {
            block6: {
                block7: {
                    EvaluationResult evaluationResult;
                    block5: {
                        block3: {
                            if (!this.hasError(conditional)) break block3;
                            this.insertQuerySyntaxMessages(conditional, INVALID_CONDITIONAL_STATEMENT);
                            break block4;
                        }
                        evaluationResult = this.evaluator.eval(conditional.getCondition(), this.variablesStack.peek());
                        if (evaluationResult.getDiagnostic().getSeverity() == 0) break block5;
                        this.insertQueryEvaluationMessages(conditional, evaluationResult.getDiagnostic());
                        for (XWPFRun tagRun : conditional.getClosingRuns()) {
                            this.insertRun(tagRun);
                        }
                        break block4;
                    }
                    if (!(evaluationResult.getResult() instanceof Boolean)) break block6;
                    if (!((Boolean)evaluationResult.getResult()).booleanValue()) break block7;
                    this.doSwitch(conditional.getThen());
                    break block4;
                }
                if (conditional.getElse() == null) break block4;
                this.doSwitch(conditional.getElse());
                break block4;
            }
            for (XWPFRun tagRun : conditional.getRuns()) {
                this.insertRun(tagRun);
            }
            this.insertMessage(this.currentGeneratedParagraph, ValidationMessageLevel.ERROR, "Condition evaluation result must be a boolean.");
            for (XWPFRun tagRun : conditional.getClosingRuns()) {
                this.insertRun(tagRun);
            }
        }
        return conditional;
    }

    @Override
    public IConstruct caseTable(Table table) {
        CTTbl copy = (CTTbl)table.getTable().getCTTbl().copy();
        copy.getTrList().clear();
        XWPFTable saveTable = this.currentGeneratedTable;
        try {
            if (this.generatedDocument instanceof XWPFDocument) {
                this.currentGeneratedTable = ((XWPFDocument)this.generatedDocument).createTable();
                if (this.currentGeneratedTable.getRows().size() > 0) {
                    this.currentGeneratedTable.removeRow(0);
                }
                this.currentGeneratedTable.getCTTbl().set((XmlObject)copy);
            } else if (this.generatedDocument instanceof XWPFHeaderFooter) {
                XWPFHeaderFooter headerFooter = (XWPFHeaderFooter)this.generatedDocument;
                int index = headerFooter._getHdrFtr().getTblArray().length;
                CTTbl cttbl = headerFooter._getHdrFtr().insertNewTbl(index);
                XWPFTable newTable = new XWPFTable(cttbl, (IBody)headerFooter);
                if (newTable.getRows().size() > 0) {
                    newTable.removeRow(0);
                }
                headerFooter.insertTable(index, newTable);
                this.currentGeneratedTable = (XWPFTable)headerFooter.getTables().get(index);
                this.currentGeneratedTable.getCTTbl().set((XmlObject)copy);
            } else if (this.generatedDocument instanceof XWPFTableCell) {
                XWPFTableCell tCell = (XWPFTableCell)this.generatedDocument;
                int tableRank = tCell.getTables().size();
                XWPFTable newTable = new XWPFTable(copy, (IBody)tCell, 0, 0);
                if (newTable.getRows().size() > 0) {
                    newTable.removeRow(0);
                }
                tCell.insertTable(tableRank, newTable);
                this.currentGeneratedTable = (XWPFTable)tCell.getTables().get(tableRank);
            } else {
                throw new UnsupportedOperationException("unknown type of IBody : " + this.generatedDocument.getClass());
            }
            for (Row row : table.getRows()) {
                this.doSwitch(row);
            }
        }
        finally {
            this.currentGeneratedTable = saveTable;
        }
        return table;
    }

    @Override
    public IConstruct caseRow(Row row) {
        XWPFTableRow savedRow = this.currentGeneratedRow;
        try {
            this.currentGeneratedRow = this.currentGeneratedTable.createRow();
            CTRow ctRow = (CTRow)row.getTableRow().getCtRow().copy();
            ctRow.getTcList().clear();
            this.currentGeneratedRow.getCtRow().set((XmlObject)ctRow);
            for (Cell cell : row.getCells()) {
                this.doSwitch(cell);
            }
        }
        finally {
            this.currentGeneratedRow = savedRow;
        }
        return null;
    }

    @Override
    public IConstruct caseCell(Cell cell) {
        XWPFTableCell newCell = this.currentGeneratedRow.createCell();
        CTTc ctCell = (CTTc)cell.getTableCell().getCTTc().copy();
        ctCell.getPList().clear();
        ctCell.getTblList().clear();
        newCell.getCTTc().set((XmlObject)ctCell);
        IBody savedGeneratedDocument = this.generatedDocument;
        XWPFParagraph savedGeneratedParagraph = this.currentGeneratedParagraph;
        XWPFParagraph savedTemplateParagraph = this.currentTemplateParagraph;
        this.generatedDocument = newCell;
        try {
            this.doSwitch(cell.getTemplate());
        }
        finally {
            this.generatedDocument = savedGeneratedDocument;
            this.currentGeneratedParagraph = savedGeneratedParagraph;
            this.currentTemplateParagraph = savedTemplateParagraph;
        }
        return null;
    }

    @Override
    public IConstruct caseBookmark(Bookmark bookmark) {
        if (this.hasError(bookmark)) {
            this.insertQuerySyntaxMessages(bookmark, INVALID_BOOKMARK_STATEMENT);
        } else {
            EvaluationResult evaluationResult = this.evaluator.eval(bookmark.getName(), this.variablesStack.peek());
            if (evaluationResult.getDiagnostic().getSeverity() != 0) {
                this.insertQueryEvaluationMessages(bookmark, evaluationResult.getDiagnostic());
            } else {
                this.bookmarkManager.startBookmark(this.result, this.currentGeneratedParagraph, evaluationResult.getResult().toString());
                this.doSwitch(bookmark.getBody());
                this.bookmarkManager.endBookmark(this.result, this.currentGeneratedParagraph, evaluationResult.getResult().toString());
            }
        }
        return (IConstruct)super.caseBookmark(bookmark);
    }

    @Override
    public IConstruct caseContentControl(ContentControl contentControl) {
        return (IConstruct)super.caseContentControl(contentControl);
    }

    protected void insertQueryEvaluationMessages(IConstruct construct, Diagnostic diagnostic) {
        for (XWPFRun tagRun : construct.getRuns()) {
            this.insertRun(tagRun);
        }
        for (TemplateValidationMessage message : M2DocUtils.appendDiagnosticMessage(this.currentGeneratedParagraph, diagnostic)) {
            this.result.addMessage(message);
        }
        for (XWPFRun tagRun : construct.getClosingRuns()) {
            this.insertRun(tagRun);
        }
    }

    protected void insertQuerySyntaxMessages(IConstruct construct, String errorPrefix) {
        for (XWPFRun tagRun : construct.getRuns()) {
            this.insertRun(tagRun);
        }
        for (TemplateValidationMessage message : construct.getValidationMessages()) {
            this.insertMessage(this.currentGeneratedParagraph, message.getLevel(), String.valueOf(errorPrefix) + message.getMessage());
        }
        for (XWPFRun tagRun : construct.getClosingRuns()) {
            this.insertRun(tagRun);
        }
    }

    protected void insertMessage(XWPFParagraph paragraph, ValidationMessageLevel level, String message) {
        this.result.addMessage(M2DocUtils.appendMessageRun(paragraph, level, message));
    }

    @Override
    public IConstruct caseLink(Link link) {
        if (this.hasError(link)) {
            this.insertQuerySyntaxMessages(link, INVALID_LINK_STATEMENT);
        } else {
            EvaluationResult nameResult = this.evaluator.eval(link.getName(), this.variablesStack.peek());
            if (nameResult.getDiagnostic().getSeverity() != 0) {
                this.insertQueryEvaluationMessages(link, nameResult.getDiagnostic());
            } else {
                EvaluationResult textResult = this.evaluator.eval(link.getText(), this.variablesStack.peek());
                if (nameResult.getDiagnostic().getSeverity() != 0) {
                    this.insertQueryEvaluationMessages(link, textResult.getDiagnostic());
                } else {
                    this.bookmarkManager.insertReference(this.currentGeneratedParagraph, nameResult.getResult().toString(), textResult.getResult().toString());
                }
            }
        }
        return link;
    }
}

