/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.generator;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.xwpf.usermodel.IBody;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.xmlbeans.XmlException;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.Query;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.obeonetwork.m2doc.POIServices;
import org.obeonetwork.m2doc.generator.GenerationResult;
import org.obeonetwork.m2doc.generator.UserContentRawCopy;
import org.obeonetwork.m2doc.parser.ValidationMessageLevel;
import org.obeonetwork.m2doc.template.DocumentTemplate;
import org.obeonetwork.m2doc.template.UserContent;
import org.obeonetwork.m2doc.util.M2DocUtils;

public class UserContentManager {
    public static final String USERDOC_COPY_ERROR = "userdoc copy error : ";
    public static final String TEMP_DEST_SUFFIX = "tmpDocDest";
    private static final int BUFFER_SIZE = 8192;
    private final DateFormat format = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    private final File generatedFileCopy;
    private final Map<String, List<UserContent>> mapIdUserContent = new HashMap<String, List<UserContent>>();
    private final DocumentTemplate documentTemplate;
    private final URI destination;
    private URIConverter uriConverter;

    public UserContentManager(URIConverter uriConverter, DocumentTemplate documentTemplate, URI destination) throws IOException {
        this.uriConverter = uriConverter;
        this.documentTemplate = documentTemplate;
        this.destination = destination;
        if (uriConverter.exists(destination, Collections.EMPTY_MAP)) {
            this.generatedFileCopy = this.tempCopyFile(destination);
            this.launchParsing();
        } else {
            this.generatedFileCopy = null;
        }
    }

    private void launchParsing() throws IOException {
        IQueryEnvironment queryEnvironment = Query.newEnvironmentWithDefaultServices(null);
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (DocumentTemplate userDocDocument = M2DocUtils.parseUserContent(this.uriConverter, URI.createURI((String)this.generatedFileCopy.toURI().toString()), queryEnvironment);){
                TreeIterator iter = userDocDocument.eAllContents();
                while (iter.hasNext()) {
                    UserContent userContent;
                    EObject eObject = (EObject)iter.next();
                    if (!(eObject instanceof UserContent) || (userContent = (UserContent)eObject).getId() == null) continue;
                    String id = userContent.getId();
                    List<UserContent> userContents = this.mapIdUserContent.get(id);
                    if (userContents == null) {
                        userContents = new ArrayList<UserContent>();
                        this.mapIdUserContent.put(id, userContents);
                    }
                    userContents.add(userContent);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {}
    }

    public UserContent consumeUserContent(String id) {
        UserContent res;
        List<UserContent> userContents = this.mapIdUserContent.get(id);
        if (userContents != null && !userContents.isEmpty()) {
            res = userContents.remove(0);
            if (userContents.isEmpty()) {
                this.mapIdUserContent.remove(id);
            }
        } else {
            res = null;
        }
        return res;
    }

    private File tempCopyFile(URI source) throws IOException {
        File dest = File.createTempFile(source.lastSegment(), TEMP_DEST_SUFFIX);
        this.copyFile(source, dest);
        return dest;
    }

    public void dispose() throws IOException {
        if (this.generatedFileCopy != null && this.generatedFileCopy.exists() && this.generatedFileCopy.isFile()) {
            this.generatedFileCopy.delete();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void copyFile(URI source, File dest) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try {
            InputStream is = this.uriConverter.createInputStream(source);
            try {
                try (FileOutputStream os = new FileOutputStream(dest);){
                    int length;
                    byte[] buffer = new byte[8192];
                    while ((length = is.read(buffer)) > 0) {
                        ((OutputStream)os).write(buffer, 0, length);
                    }
                }
                if (is == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (is == null) throw throwable;
                is.close();
                throw throwable;
            }
            is.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    public List<String> getDuplicatedUserContentIDs() {
        ArrayList<String> res = new ArrayList<String>();
        for (Map.Entry<String, List<UserContent>> entry : this.mapIdUserContent.entrySet()) {
            if (entry.getValue().size() <= 1) continue;
            res.add(entry.getKey());
        }
        return res;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void generateLostFiles(GenerationResult result) throws IOException, InvalidFormatException {
        Iterator<Map.Entry<String, List<UserContent>>> iterator = this.mapIdUserContent.entrySet().iterator();
        while (iterator.hasNext()) {
            boolean isNewUserContentLoss;
            URI inputURI;
            Map.Entry<String, List<UserContent>> entry = iterator.next();
            URI lostUserContentURI = this.getLostUserContentURI(this.destination, entry.getKey());
            result.getLostUserContents().put(entry.getKey(), lostUserContentURI);
            if (this.uriConverter.exists(lostUserContentURI, Collections.EMPTY_MAP)) {
                inputURI = lostUserContentURI;
                isNewUserContentLoss = false;
            } else {
                inputURI = this.documentTemplate.eResource().getURI();
                isNewUserContentLoss = true;
            }
            Throwable throwable = null;
            Object var8_9 = null;
            try {
                InputStream is = this.uriConverter.createInputStream(inputURI);
                try {
                    block30: {
                        OPCPackage oPackage = OPCPackage.open((InputStream)is);
                        try {
                            try (XWPFDocument destinationDocument = new XWPFDocument(oPackage);){
                                if (isNewUserContentLoss) {
                                    int size = destinationDocument.getBodyElements().size();
                                    int i = 0;
                                    while (i < size) {
                                        destinationDocument.removeBodyElement(0);
                                        ++i;
                                    }
                                }
                                XWPFParagraph currentGeneratedParagraph = destinationDocument.createParagraph();
                                result.addMessage(M2DocUtils.appendMessageRun(currentGeneratedParagraph, ValidationMessageLevel.WARNING, String.valueOf(this.format.format(new Date())) + " - Lost user content " + entry.getKey()));
                                currentGeneratedParagraph = destinationDocument.createParagraph();
                                Iterator<UserContent> iterator2 = entry.getValue().iterator();
                                while (true) {
                                    if (!iterator2.hasNext()) {
                                        POIServices.getInstance().saveFile(this.uriConverter, destinationDocument, lostUserContentURI);
                                        break;
                                    }
                                    UserContent userContent = iterator2.next();
                                    UserContentRawCopy userContentRawCopy = new UserContentRawCopy();
                                    try {
                                        currentGeneratedParagraph = destinationDocument.createParagraph();
                                        currentGeneratedParagraph = userContentRawCopy.copy(userContent, currentGeneratedParagraph, (IBody)destinationDocument);
                                    }
                                    catch (InvalidFormatException e) {
                                        result.addMessage(M2DocUtils.appendMessageRun(currentGeneratedParagraph, ValidationMessageLevel.ERROR, USERDOC_COPY_ERROR + e.getMessage()));
                                    }
                                    catch (XmlException e) {
                                        result.addMessage(M2DocUtils.appendMessageRun(currentGeneratedParagraph, ValidationMessageLevel.ERROR, USERDOC_COPY_ERROR + e.getMessage()));
                                    }
                                    catch (IOException e) {
                                        result.addMessage(M2DocUtils.appendMessageRun(currentGeneratedParagraph, ValidationMessageLevel.ERROR, USERDOC_COPY_ERROR + e.getMessage()));
                                    }
                                }
                            }
                            if (oPackage == null) break block30;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (oPackage == null) throw throwable;
                            oPackage.close();
                            throw throwable;
                        }
                        oPackage.close();
                    }
                    if (is == null) continue;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    if (is == null) throw throwable;
                    is.close();
                    throw throwable;
                }
                is.close();
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                    throw throwable;
                }
                if (throwable == throwable4) throw throwable;
                throwable.addSuppressed(throwable4);
                throw throwable;
            }
        }
        return;
    }

    protected URI getLostUserContentURI(URI dest, String id) {
        URI res = URI.createURI((String)("./" + dest.lastSegment() + "-" + id + "-lost.docx"));
        return res.resolve(dest);
    }
}

