/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.generator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.xwpf.usermodel.IBody;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFFootnote;
import org.apache.poi.xwpf.usermodel.XWPFHeaderFooter;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFPicture;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFSDT;
import org.apache.poi.xwpf.usermodel.XWPFStyle;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlToken;
import org.obeonetwork.m2doc.template.ContentControl;
import org.obeonetwork.m2doc.template.IConstruct;
import org.obeonetwork.m2doc.template.Statement;
import org.obeonetwork.m2doc.template.Table;
import org.obeonetwork.m2doc.template.UserContent;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTbl;

public class UserContentRawCopy {
    private XWPFParagraph currentInputParagraph;
    private XWPFParagraph currentOutputParagraph;
    private XWPFParagraph previousInputParagraph;
    private List<XWPFParagraph> listOutputParagraphs = new ArrayList<XWPFParagraph>();
    private List<XWPFTable> listOutputTables = new ArrayList<XWPFTable>();
    private List<XWPFRun> listOutputRuns = new ArrayList<XWPFRun>();
    private Map<String, String> inputPicuteIdToOutputmap = new HashMap<String, String>();
    private boolean needNewParagraph = true;

    public boolean needNewParagraph() {
        return this.needNewParagraph;
    }

    public XWPFParagraph copy(UserContent userContent, XWPFParagraph outputParagraphBeforeUserDocContent, IBody outputBody) throws InvalidFormatException, XmlException, IOException {
        XWPFDocument containerOutputDocument = outputParagraphBeforeUserDocContent.getDocument();
        if (!this.userDocContentIsFirstRunOfParagraph(userContent)) {
            this.currentInputParagraph = this.previousInputParagraph = (XWPFParagraph)((XWPFRun)userContent.getRuns().get(userContent.getRuns().size() - 1)).getParent();
            this.currentOutputParagraph = outputParagraphBeforeUserDocContent;
        }
        XWPFParagraph currentRunParagraph = null;
        for (IConstruct abstractConstruct : userContent.getBody().getStatements()) {
            for (XWPFRun inputRun : abstractConstruct.getRuns()) {
                currentRunParagraph = (XWPFParagraph)inputRun.getParent();
                if (currentRunParagraph != this.currentInputParagraph) {
                    this.currentInputParagraph = currentRunParagraph;
                    this.currentOutputParagraph = this.createNewParagraph(outputBody);
                    this.currentOutputParagraph.getCTP().set((XmlObject)this.currentInputParagraph.getCTP());
                    this.listOutputParagraphs.add(this.currentOutputParagraph);
                }
                if (currentRunParagraph == this.previousInputParagraph) {
                    XWPFRun outputRun = this.currentOutputParagraph.createRun();
                    outputRun.getCTR().set((XmlObject)inputRun.getCTR());
                    this.listOutputRuns.add(outputRun);
                }
                this.createPictures(inputRun, containerOutputDocument);
            }
            if (abstractConstruct instanceof Table) {
                Table table = (Table)abstractConstruct;
                XWPFTable inputTable = table.getTable();
                XWPFTable outputTable = this.createNewTable(outputBody, inputTable);
                outputTable.getCTTbl().set((XmlObject)inputTable.getCTTbl());
                UserContentRawCopy.copyTableStyle(inputTable, containerOutputDocument);
                this.listOutputTables.add(outputTable);
                this.collectRelationId(inputTable, containerOutputDocument);
                continue;
            }
            if (!(abstractConstruct instanceof ContentControl)) continue;
            ContentControl contentControl = (ContentControl)abstractConstruct;
            XWPFSDT control = contentControl.getControl();
            this.copyControl(outputBody, control);
        }
        this.changePictureId();
        if (userContent.getClosingRuns().size() != 0 && this.currentInputParagraph == ((XWPFRun)userContent.getClosingRuns().get(0)).getParent()) {
            this.needNewParagraph = false;
        }
        return this.currentOutputParagraph;
    }

    private void copyControl(IBody outputBody, XWPFSDT control) {
        if (outputBody instanceof XWPFDocument) {
            ((XWPFDocument)outputBody).getDocument().getBody().addNewSdt();
        } else if (outputBody instanceof XWPFHeaderFooter) {
            ((XWPFHeaderFooter)outputBody)._getHdrFtr().addNewSdt();
        } else if (outputBody instanceof XWPFFootnote) {
            ((XWPFFootnote)outputBody).getCTFtnEdn().addNewSdt();
        } else if (outputBody instanceof XWPFTableCell) {
            ((XWPFTableCell)outputBody).getCTTc().addNewSdt();
        } else {
            throw new IllegalStateException("can't insert control in " + outputBody.getClass().getCanonicalName());
        }
    }

    private XWPFTable createNewTable(IBody document, XWPFTable inputTable) {
        XWPFTable generatedTable;
        CTTbl copy = (CTTbl)inputTable.getCTTbl().copy();
        if (document instanceof XWPFDocument) {
            generatedTable = ((XWPFDocument)document).createTable();
        } else if (document instanceof XWPFHeaderFooter) {
            XWPFHeaderFooter headerFooter = (XWPFHeaderFooter)document;
            int index = headerFooter._getHdrFtr().getTblArray().length;
            CTTbl cttbl = headerFooter._getHdrFtr().insertNewTbl(index);
            XWPFTable newTable = new XWPFTable(cttbl, (IBody)headerFooter);
            if (newTable.getRows().size() > 0) {
                newTable.removeRow(0);
            }
            headerFooter.insertTable(index, newTable);
            generatedTable = (XWPFTable)headerFooter.getTables().get(index);
            generatedTable.getCTTbl().set((XmlObject)copy);
        } else if (document instanceof XWPFTableCell) {
            XWPFTableCell tCell = (XWPFTableCell)document;
            int tableRank = tCell.getTables().size();
            tCell.insertTable(tableRank, new XWPFTable(copy, (IBody)tCell, 0, 0));
            generatedTable = (XWPFTable)tCell.getTables().get(tableRank);
        } else {
            throw new UnsupportedOperationException("unknown type of IBody : " + document.getClass());
        }
        return generatedTable;
    }

    private XWPFParagraph createNewParagraph(IBody document) {
        XWPFParagraph newParagraph;
        if (document instanceof XWPFTableCell) {
            XWPFTableCell cell = (XWPFTableCell)document;
            newParagraph = cell.addParagraph();
        } else if (document instanceof XWPFDocument) {
            newParagraph = ((XWPFDocument)document).createParagraph();
        } else if (document instanceof XWPFHeaderFooter) {
            newParagraph = ((XWPFHeaderFooter)document).createParagraph();
        } else {
            throw new UnsupportedOperationException("unkown IBody type :" + document.getClass());
        }
        return newParagraph;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void copyTableStyle(XWPFTable inputTable, XWPFDocument outputDoc) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            XWPFDocument inputDoc = inputTable.getBody().getXWPFDocument();
            try {
                XWPFStyle style = inputDoc.getStyles().getStyle(inputTable.getStyleID());
                if (outputDoc == null) return;
                if (style == null) {
                    return;
                }
                if (outputDoc.getStyles() == null) {
                    outputDoc.createStyles();
                }
                List usedStyleList = inputDoc.getStyles().getUsedStyleList(style);
                Iterator iterator = usedStyleList.iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        return;
                    }
                    XWPFStyle xwpfStyle = (XWPFStyle)iterator.next();
                    outputDoc.getStyles().addStyle(xwpfStyle);
                }
            }
            finally {
                if (inputDoc == null) return;
                inputDoc.close();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }

    private void collectRelationId(XWPFTable inputWTable, XWPFDocument outputDoc) throws InvalidFormatException {
        for (XWPFTableRow row : inputWTable.getRows()) {
            for (XWPFTableCell cell : row.getTableCells()) {
                for (XWPFParagraph paragraph : cell.getParagraphs()) {
                    this.collectRelationId(paragraph, outputDoc);
                }
            }
        }
    }

    private void collectRelationId(XWPFParagraph paragraph, XWPFDocument outputDoc) throws InvalidFormatException {
        for (XWPFRun run : paragraph.getRuns()) {
            this.createPictures(run, outputDoc);
        }
    }

    private void changePictureId() throws XmlException {
        XmlToken outputXmlObject;
        for (XWPFRun run : this.listOutputRuns) {
            outputXmlObject = this.getXmlWithOuputId(run.getCTR().xmlText());
            if (outputXmlObject == null) continue;
            run.getCTR().set((XmlObject)outputXmlObject);
        }
        for (XWPFParagraph paragraph : this.listOutputParagraphs) {
            outputXmlObject = this.getXmlWithOuputId(paragraph.getCTP().xmlText());
            if (outputXmlObject == null) continue;
            paragraph.getCTP().set((XmlObject)outputXmlObject);
        }
        for (XWPFTable table : this.listOutputTables) {
            outputXmlObject = this.getXmlWithOuputId(table.getCTTbl().xmlText());
            if (outputXmlObject == null) continue;
            table.getCTTbl().set((XmlObject)outputXmlObject);
        }
    }

    private XmlToken getXmlWithOuputId(String xmlText) throws XmlException {
        String outputXmlStr = xmlText;
        for (Map.Entry<String, String> entry : this.inputPicuteIdToOutputmap.entrySet()) {
            String inputID = entry.getKey();
            String outputID = entry.getValue();
            outputXmlStr = outputXmlStr.replaceAll("<a:blip r:embed=\"" + inputID + "\"", "<a:blip r:embed=NEW\"" + outputID + "\"");
        }
        outputXmlStr = outputXmlStr.replaceAll("<a:blip r:embed=NEW", "<a:blip r:embed=");
        XmlToken outputXmlObject = null;
        outputXmlObject = XmlToken.Factory.parse((String)outputXmlStr);
        return outputXmlObject;
    }

    private boolean userDocContentIsFirstRunOfParagraph(UserContent userContent) {
        XWPFRun userContentFirstRun;
        XWPFParagraph userContentFirstRunParagraph;
        boolean result = true;
        if (userContent.getBody() != null && userContent.getBody().getStatements().size() > 0 && ((Statement)userContent.getBody().getStatements().get(0)).getRuns().size() > 0 && (userContentFirstRunParagraph = (XWPFParagraph)(userContentFirstRun = (XWPFRun)((Statement)userContent.getBody().getStatements().get(0)).getRuns().get(0)).getParent()) != null && userContentFirstRunParagraph.getRuns().size() > 0) {
            XWPFRun paragraphFirstRun = (XWPFRun)userContentFirstRunParagraph.getRuns().get(0);
            result = userContentFirstRun == paragraphFirstRun;
        }
        return result;
    }

    private void createPictures(XWPFRun inputRun, XWPFDocument outputDoc) throws InvalidFormatException {
        for (XWPFPicture inputPic : inputRun.getEmbeddedPictures()) {
            byte[] img = inputPic.getPictureData().getData();
            String idRelationOutput = outputDoc.addPictureData(img, inputPic.getPictureData().getPictureType());
            String idRelationInput = inputPic.getCTPicture().getBlipFill().getBlip().getEmbed();
            this.inputPicuteIdToOutputmap.put(idRelationInput, idRelationOutput);
        }
    }
}

