/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.properties;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenFactory;
import org.antlr.v4.runtime.TokenFactory;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.UnbufferedCharStream;
import org.antlr.v4.runtime.UnbufferedTokenStream;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.apache.poi.POIXMLProperties;
import org.apache.poi.xwpf.usermodel.IBody;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.eclipse.acceleo.query.ast.AstPackage;
import org.eclipse.acceleo.query.ast.Binding;
import org.eclipse.acceleo.query.ast.ErrorTypeLiteral;
import org.eclipse.acceleo.query.ast.Expression;
import org.eclipse.acceleo.query.ast.Lambda;
import org.eclipse.acceleo.query.ast.Let;
import org.eclipse.acceleo.query.ast.VarRef;
import org.eclipse.acceleo.query.ast.VariableDeclaration;
import org.eclipse.acceleo.query.parser.AstBuilderListener;
import org.eclipse.acceleo.query.parser.AstValidator;
import org.eclipse.acceleo.query.parser.QueryLexer;
import org.eclipse.acceleo.query.parser.QueryParser;
import org.eclipse.acceleo.query.runtime.IQueryBuilderEngine;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IValidationResult;
import org.eclipse.acceleo.query.validation.type.EClassifierLiteralType;
import org.eclipse.acceleo.query.validation.type.EClassifierSetLiteralType;
import org.eclipse.acceleo.query.validation.type.EClassifierType;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.obeonetwork.m2doc.parser.DocumentParserException;
import org.obeonetwork.m2doc.parser.M2DocParser;
import org.obeonetwork.m2doc.template.Bookmark;
import org.obeonetwork.m2doc.template.Conditional;
import org.obeonetwork.m2doc.template.Link;
import org.obeonetwork.m2doc.template.Query;
import org.obeonetwork.m2doc.template.Repetition;
import org.obeonetwork.m2doc.template.Template;
import org.obeonetwork.m2doc.util.AQL56Compatibility;
import org.openxmlformats.schemas.officeDocument.x2006.customProperties.CTProperty;

public class TemplateCustomProperties {
    public static final String STRING_TYPE = "String";
    public static final String INTEGER_TYPE = "Integer";
    public static final String REAL_TYPE = "Real";
    public static final String BOOLEAN_TYPE = "Boolean";
    public static final String VAR_PROPERTY_PREFIX = "m:var:";
    public static final int VAR_PROPERTY_PREFIX_LENGTH = "m:var:".length();
    public static final String URI_PROPERTY_PREFIX = "m:uri:";
    public static final int URI_PROPERTY_PREFIX_LENGTH = "m:uri:".length();
    public static final String SERVICE_IMPORT_PROPERTY_PREFIX = "m:import:";
    public static final int SERVICE_IMPORT_PROPERTY_PREFIX_LENGTH = "m:import:".length();
    private final Map<String, String> variables = new LinkedHashMap<String, String>();
    private final List<String> nsURIs = new ArrayList<String>();
    private final Map<String, String> serviceClasses = new LinkedHashMap<String, String>();
    private final XWPFDocument document;

    public TemplateCustomProperties(XWPFDocument document) {
        this.document = document;
        this.parseProperties(document);
    }

    private void parseProperties(XWPFDocument doc) {
        POIXMLProperties.CustomProperties props = doc.getProperties().getCustomProperties();
        List properties = props.getUnderlyingProperties().getPropertyList();
        for (CTProperty property : properties) {
            String propertyName = property.getName();
            if (propertyName == null) continue;
            String nsURI = this.getNsURI(propertyName = propertyName.trim());
            if (nsURI != null) {
                this.nsURIs.add(nsURI);
                continue;
            }
            String serviceClasse = this.getServiceImport(propertyName);
            if (serviceClasse != null) {
                String bundleName = property.getLpwstr();
                this.serviceClasses.put(serviceClasse, bundleName);
                continue;
            }
            String variableName = this.getVariableName(propertyName);
            if (variableName == null || !TemplateCustomProperties.isValidVariableName(variableName)) continue;
            String type = property.getLpwstr();
            this.variables.put(variableName, type);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void save() {
        void var8_11;
        POIXMLProperties.CustomProperties props = this.document.getProperties().getCustomProperties();
        List properties = props.getUnderlyingProperties().getPropertyList();
        ArrayList<Integer> indexToDelete = new ArrayList<Integer>();
        int currentIndex = 0;
        ArrayList<String> tmpNsURI = new ArrayList<String>(this.nsURIs);
        LinkedHashMap<String, String> tmpServiceImports = new LinkedHashMap<String, String>(this.serviceClasses);
        LinkedHashMap<String, String> tmpVars = new LinkedHashMap<String, String>(this.variables);
        for (CTProperty cTProperty : properties) {
            String propertyName = cTProperty.getName();
            String nsURI = this.getNsURI(propertyName);
            if (nsURI != null) {
                if (!tmpNsURI.remove(nsURI)) {
                    indexToDelete.add(currentIndex);
                }
                ++currentIndex;
                continue;
            }
            String serviceClasse = this.getServiceImport(propertyName);
            if (serviceClasse != null) {
                String bundleName = (String)tmpServiceImports.remove(serviceClasse);
                if (bundleName != null) {
                    cTProperty.setLpwstr(bundleName);
                } else {
                    indexToDelete.add(currentIndex);
                }
                ++currentIndex;
                continue;
            }
            String variableName = this.getVariableName(propertyName);
            if (variableName != null) {
                String type = (String)tmpVars.remove(variableName);
                if (type != null) {
                    cTProperty.setLpwstr(type);
                } else {
                    indexToDelete.add(currentIndex);
                }
            }
            ++currentIndex;
        }
        int n = indexToDelete.size() - 1;
        while (var8_11 > -1) {
            props.getUnderlyingProperties().removeProperty(((Integer)indexToDelete.get((int)var8_11)).intValue());
            --var8_11;
        }
        for (String string : tmpNsURI) {
            props.addProperty(URI_PROPERTY_PREFIX + string, "");
        }
        for (Map.Entry entry : tmpServiceImports.entrySet()) {
            props.addProperty(SERVICE_IMPORT_PROPERTY_PREFIX + (String)entry.getKey(), (String)entry.getValue());
        }
        for (Map.Entry entry : tmpVars.entrySet()) {
            props.addProperty(VAR_PROPERTY_PREFIX + (String)entry.getKey(), (String)entry.getValue());
        }
    }

    private String getNsURI(String propertyName) {
        String res = propertyName.startsWith(URI_PROPERTY_PREFIX) && propertyName.length() > URI_PROPERTY_PREFIX_LENGTH ? propertyName.substring(URI_PROPERTY_PREFIX_LENGTH) : null;
        return res;
    }

    private String getServiceImport(String propertyName) {
        String res = propertyName.startsWith(SERVICE_IMPORT_PROPERTY_PREFIX) && propertyName.length() > SERVICE_IMPORT_PROPERTY_PREFIX_LENGTH ? propertyName.substring(SERVICE_IMPORT_PROPERTY_PREFIX_LENGTH) : null;
        return res;
    }

    private String getVariableName(String propertyName) {
        String res = propertyName.startsWith(VAR_PROPERTY_PREFIX) && propertyName.length() > VAR_PROPERTY_PREFIX_LENGTH ? propertyName.substring(VAR_PROPERTY_PREFIX_LENGTH) : null;
        return res;
    }

    public List<String> getPackagesURIs() {
        return this.nsURIs;
    }

    public Map<String, String> getVariables() {
        return this.variables;
    }

    public Map<String, String> getServiceClasses() {
        return this.serviceClasses;
    }

    public void configureQueryEnvironment(IQueryEnvironment queryEnvironment) {
        for (String nsURI : this.getPackagesURIs()) {
            EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(nsURI);
            queryEnvironment.registerEPackage(ePackage);
        }
    }

    public Map<String, Set<IType>> getVariableTypes(AstValidator validator, IReadOnlyQueryEnvironment queryEnvironment) {
        LinkedHashMap<String, Set<IType>> res = new LinkedHashMap<String, Set<IType>>();
        for (Map.Entry<String, String> entry : this.getVariables().entrySet()) {
            Set<IType> types = this.getVariableTypes(validator, queryEnvironment, entry.getValue());
            res.put(entry.getKey(), types);
        }
        return res;
    }

    public Set<IType> getVariableTypes(AstValidator validator, IReadOnlyQueryEnvironment queryEnvironment, String type) {
        LinkedHashSet<IType> res = new LinkedHashSet<IType>();
        IQueryBuilderEngine.AstResult astResult = this.parseWhileAqlTypeLiteral(queryEnvironment, type);
        IValidationResult validationResult = validator.validate(Collections.emptyMap(), astResult);
        Set variableTypes = validationResult.getPossibleTypes(astResult.getAst());
        for (IType iType : variableTypes) {
            if (iType instanceof EClassifierLiteralType) {
                res.add((IType)new EClassifierType(queryEnvironment, ((EClassifierLiteralType)iType).getType()));
                continue;
            }
            if (iType instanceof EClassifierSetLiteralType) {
                for (EClassifier eClassifier : ((EClassifierSetLiteralType)iType).getEClassifiers()) {
                    res.add((IType)new EClassifierType(queryEnvironment, eClassifier));
                }
                continue;
            }
            res.add(iType);
        }
        return res;
    }

    private IQueryBuilderEngine.AstResult parseWhileAqlTypeLiteral(IReadOnlyQueryEnvironment queryEnvironment, String type) {
        IQueryBuilderEngine.AstResult result;
        if (type != null && type.length() > 0) {
            AstBuilderListener astBuilder = AQL56Compatibility.createAstBuilderListener((IQueryEnvironment)queryEnvironment);
            UnbufferedCharStream input = new UnbufferedCharStream((Reader)new StringReader(type), type.length());
            QueryLexer lexer = new QueryLexer((CharStream)input);
            lexer.setTokenFactory((TokenFactory)new CommonTokenFactory(true));
            lexer.removeErrorListeners();
            lexer.addErrorListener(astBuilder.getErrorListener());
            UnbufferedTokenStream tokens = new UnbufferedTokenStream((TokenSource)lexer);
            QueryParser parser = new QueryParser((TokenStream)tokens);
            parser.addParseListener((ParseTreeListener)astBuilder);
            parser.removeErrorListeners();
            parser.addErrorListener(astBuilder.getErrorListener());
            parser.typeLiteral();
            result = astBuilder.getAstResult();
        } else {
            ErrorTypeLiteral errorTypeLiteral = (ErrorTypeLiteral)EcoreUtil.create((EClass)AstPackage.eINSTANCE.getErrorTypeLiteral());
            ArrayList<ErrorTypeLiteral> errors = new ArrayList<ErrorTypeLiteral>(1);
            errors.add(errorTypeLiteral);
            HashMap<ErrorTypeLiteral, Integer> positions = new HashMap<ErrorTypeLiteral, Integer>();
            if (type != null) {
                positions.put(errorTypeLiteral, 0);
            }
            BasicDiagnostic diagnostic = new BasicDiagnostic();
            diagnostic.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.acceleo.query", 0, "null or empty type.", new Object[]{errorTypeLiteral}));
            result = new IQueryBuilderEngine.AstResult((Expression)errorTypeLiteral, positions, positions, errors, (Diagnostic)diagnostic);
        }
        return result;
    }

    public static boolean isValidVariableName(String name) {
        return name != null && name.matches("[a-zA-Z_][a-zA-Z0-9_]*");
    }

    public List<String> getMissingVariables() {
        ArrayList<String> res = new ArrayList<String>();
        M2DocParser parser = new M2DocParser((IBody)this.document, org.eclipse.acceleo.query.runtime.Query.newEnvironment());
        try {
            Template template = parser.parseTemplate();
            LinkedHashSet<String> missing = new LinkedHashSet<String>();
            this.walkForNeededVariables(new ArrayList<String>(this.getVariables().keySet()), missing, template);
            res.addAll(missing);
        }
        catch (DocumentParserException documentParserException) {}
        return res;
    }

    private void walkForNeededVariables(List<String> declarations, Set<String> missing, EObject eObj) {
        if (eObj instanceof VarRef) {
            if (!declarations.contains(((VarRef)eObj).getVariableName())) {
                missing.add(((VarRef)eObj).getVariableName());
            }
        } else if (eObj instanceof Repetition) {
            this.walkForNeededVariables(declarations, missing, (EObject)((Repetition)eObj).getQuery().getAst());
            declarations.add(((Repetition)eObj).getIterationVar());
            this.walkForNeededVariables(declarations, missing, ((Repetition)eObj).getBody());
            declarations.remove(((Repetition)eObj).getIterationVar());
        } else if (eObj instanceof org.obeonetwork.m2doc.template.Let) {
            this.walkForNeededVariables(declarations, missing, (EObject)((org.obeonetwork.m2doc.template.Let)eObj).getValue().getAst());
            declarations.add(((org.obeonetwork.m2doc.template.Let)eObj).getName());
            this.walkForNeededVariables(declarations, missing, ((org.obeonetwork.m2doc.template.Let)eObj).getBody());
            declarations.remove(((org.obeonetwork.m2doc.template.Let)eObj).getName());
        } else if (eObj instanceof Conditional) {
            this.walkForNeededVariables(declarations, missing, (EObject)((Conditional)eObj).getCondition().getAst());
            this.walkForNeededVariables(declarations, missing, ((Conditional)eObj).getThen());
            if (((Conditional)eObj).getElse() != null) {
                this.walkForNeededVariables(declarations, missing, ((Conditional)eObj).getElse());
            }
        } else if (eObj instanceof Link) {
            this.walkForNeededVariables(declarations, missing, (EObject)((Link)eObj).getName().getAst());
            this.walkForNeededVariables(declarations, missing, (EObject)((Link)eObj).getText().getAst());
        } else if (eObj instanceof Bookmark) {
            this.walkForNeededVariables(declarations, missing, (EObject)((Bookmark)eObj).getName().getAst());
            this.walkForNeededVariables(declarations, missing, ((Bookmark)eObj).getBody());
        } else if (eObj instanceof Query) {
            this.walkForNeededVariables(declarations, missing, (EObject)((Query)eObj).getQuery().getAst());
        } else if (eObj instanceof Lambda) {
            ArrayList<String> lambdaDeclartations = new ArrayList<String>();
            for (VariableDeclaration parameter : ((Lambda)eObj).getParameters()) {
                lambdaDeclartations.add(parameter.getName());
            }
            declarations.addAll(lambdaDeclartations);
            this.walkForNeededVariables(declarations, missing, (EObject)((Lambda)eObj).getExpression());
            declarations.removeAll(lambdaDeclartations);
        } else if (eObj instanceof Let) {
            ArrayList<String> letDeclartations = new ArrayList<String>();
            for (Binding binding : ((Let)eObj).getBindings()) {
                letDeclartations.add(binding.getName());
                this.walkForNeededVariables(declarations, missing, (EObject)binding.getValue());
            }
            declarations.addAll(letDeclartations);
            this.walkForNeededVariables(declarations, missing, (EObject)((Let)eObj).getBody());
            declarations.removeAll(letDeclartations);
        } else {
            for (EObject child : eObj.eContents()) {
                this.walkForNeededVariables(declarations, missing, child);
            }
        }
    }
}

