/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.services;

import org.eclipse.acceleo.annotations.api.documentation.Documentation;
import org.eclipse.acceleo.annotations.api.documentation.Example;
import org.eclipse.acceleo.annotations.api.documentation.Param;
import org.eclipse.acceleo.annotations.api.documentation.ServiceProvider;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.obeonetwork.m2doc.element.MImage;
import org.obeonetwork.m2doc.element.PictureType;
import org.obeonetwork.m2doc.element.impl.MImageImpl;

@ServiceProvider(value="Services available for Images")
public class ImageServices {
    private URIConverter uriConverter;
    private final URI templateURI;

    public ImageServices(URIConverter uriConverter, URI templateURI) {
        this.uriConverter = uriConverter;
        this.templateURI = templateURI;
    }

    @Documentation(value="Convert a String representing an URI to an Image.", params={@Param(name="uri", value="The Image uri, it can be relative to the template")}, result="insert the image", examples={@Example(expression="'image.png'.asImage()", result="insert the image 'image.png'")})
    public MImage asImage(String uriStr) {
        URI imageURI = URI.createURI((String)uriStr);
        return this.asImage(uriStr, PictureType.toType(imageURI));
    }

    @Documentation(value="Convert a String representing an URI to an Image and serialize it in the given format.", params={@Param(name="uri", value="The Image uri, it can be relative to the template")}, result="insert the image", examples={@Example(expression="'image.png'.asImage('jpg')", result="insert the image 'image.jpg'")})
    public MImage asImage(String uriStr, String type) {
        return this.asImage(uriStr, PictureType.valueOf(type.toUpperCase()));
    }

    private MImage asImage(String uriStr, PictureType type) {
        URI imageURI = URI.createURI((String)uriStr);
        URI uri = imageURI.resolve(this.templateURI);
        return new MImageImpl(this.uriConverter, uri, type);
    }

    @Documentation(value="Gets the width of the image.", params={@Param(name="image", value="The Image")}, result="gets the width of the image", examples={@Example(expression="myImage.getWidth()", result="300")})
    public Integer getWidth(MImage image) {
        return image.getWidth();
    }

    @Documentation(value="Sets the width of the image.", params={@Param(name="image", value="The Image"), @Param(name="width", value="The width")}, result="sets the width of the image", examples={@Example(expression="myImage.setWidth(300)", result="set the witdh to 300")})
    public MImage setWidth(MImage image, Integer width) {
        image.setWidth(width);
        return image;
    }

    @Documentation(value="Sets the height of the image.", params={@Param(name="image", value="The Image")}, result="gets the height of the image", examples={@Example(expression="myImage.getHeight()", result="300")})
    public Integer getHeight(MImage image) {
        return image.getHeight();
    }

    @Documentation(value="Sets the height of the image.", params={@Param(name="image", value="The Image"), @Param(name="height", value="The height")}, result="sets the height of the image", examples={@Example(expression="myImage.setHeight(300)", result="set the height to 300")})
    public MImage setHeight(MImage image, Integer height) {
        image.setHeight(height);
        return image;
    }

    @Documentation(value="Sets the conserve ratio of the image.", params={@Param(name="image", value="The Image"), @Param(name="conserve", value="A Boolean")}, result="sets the conserve ratio of the image", examples={@Example(expression="myImage.setConserveRatio(false)", result="set the conserve ratio to false")})
    public MImage setConserveRatio(MImage image, Boolean conserve) {
        image.setConserveRatio(conserve);
        return image;
    }

    @Documentation(value="Fits the Image in the given the given rectangle width and height.", params={@Param(name="image", value="The Image"), @Param(name="width", value="The width to fit"), @Param(name="height", value="The height to fit")}, result="sets the conserve ratio of the image", examples={@Example(expression="myImage.fit(200, 300)", result="will fit the image in a rectangle (width=200, height=300)")})
    public MImage fit(MImage image, Integer width, Integer height) {
        image.setWidth(width);
        if (!image.conserveRatio() || image.getHeight() > height) {
            image.setHeight(height);
        }
        return image;
    }
}

