/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.services;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ServiceRegistry {
    public static final ServiceRegistry INSTANCE = new ServiceRegistry();
    public static final String DEFAULT_TOKEN = "default";
    private Map<String, Map<String, List<String>>> registry = new LinkedHashMap<String, Map<String, List<String>>>();

    public void register(String tokenName, String bundleName, List<String> services) {
        List<String> list;
        Map<String, List<String>> map = this.registry.get(tokenName);
        if (map == null) {
            map = new LinkedHashMap<String, List<String>>();
            this.registry.put(tokenName, map);
        }
        if ((list = map.get(bundleName)) == null) {
            list = new ArrayList<String>();
            map.put(bundleName, list);
        }
        list.addAll(services);
    }

    public void remove(String tokenName, String bundleName, List<String> services) {
        List<String> list;
        Map<String, List<String>> map = this.registry.get(tokenName);
        if (map != null && (list = map.get(bundleName)).removeAll(services) && list.isEmpty()) {
            map.remove(bundleName);
            if (map.isEmpty()) {
                this.registry.remove(tokenName);
            }
        }
    }

    public Map<String, List<String>> getServicePackages(String tokenName) {
        Map<String, List<String>> result = this.registry.get(tokenName);
        result = result == null ? Collections.emptyMap() : Collections.unmodifiableMap(result);
        return result;
    }

    public void clear() {
        this.registry.clear();
    }

    public Set<String> getRegisteredTokens() {
        return this.registry.keySet();
    }
}

