/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.template;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum QueryBehavior implements Enumerator
{
    ICON(0, "ICON", "ICON"),
    LABEL(1, "LABEL", "LABEL"),
    TEXT(2, "TEXT", "TEXT");

    public static final String copyright = " Copyright (c) 2016 Obeo. \r\n All rights reserved. This program and the accompanying materials\r\n are made available under the terms of the Eclipse Public License v1.0\r\n which accompanies this distribution, and is available at\r\n http://www.eclipse.org/legal/epl-v10.html\r\n  \r\n  Contributors:\r\n      Obeo - initial API and implementation";
    public static final int ICON_VALUE = 0;
    public static final int LABEL_VALUE = 1;
    public static final int TEXT_VALUE = 2;
    private static final QueryBehavior[] VALUES_ARRAY;
    public static final List<QueryBehavior> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new QueryBehavior[]{ICON, LABEL, TEXT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static QueryBehavior get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            QueryBehavior result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static QueryBehavior getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            QueryBehavior result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static QueryBehavior get(int value) {
        switch (value) {
            case 0: {
                return ICON;
            }
            case 1: {
                return LABEL;
            }
            case 2: {
                return TEXT;
            }
        }
        return null;
    }

    private QueryBehavior(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

