/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.xwpf.usermodel.IBody;
import org.apache.poi.xwpf.usermodel.IRunBody;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFFooter;
import org.apache.poi.xwpf.usermodel.XWPFHeader;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.ServiceUtils;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.obeonetwork.m2doc.POIServices;
import org.obeonetwork.m2doc.generator.DocumentGenerationException;
import org.obeonetwork.m2doc.generator.GenerationResult;
import org.obeonetwork.m2doc.generator.M2DocValidator;
import org.obeonetwork.m2doc.generator.TemplateValidationGenerator;
import org.obeonetwork.m2doc.parser.BodyGeneratedParser;
import org.obeonetwork.m2doc.parser.DocumentParserException;
import org.obeonetwork.m2doc.parser.M2DocParser;
import org.obeonetwork.m2doc.parser.ParsingErrorMessage;
import org.obeonetwork.m2doc.parser.TemplateValidationMessage;
import org.obeonetwork.m2doc.parser.ValidationMessageLevel;
import org.obeonetwork.m2doc.properties.TemplateCustomProperties;
import org.obeonetwork.m2doc.services.BooleanServices;
import org.obeonetwork.m2doc.services.ImageServices;
import org.obeonetwork.m2doc.services.LinkServices;
import org.obeonetwork.m2doc.services.PaginationServices;
import org.obeonetwork.m2doc.services.configurator.IServicesConfigurator;
import org.obeonetwork.m2doc.services.configurator.IServicesConfiguratorDescriptor;
import org.obeonetwork.m2doc.template.DocumentTemplate;
import org.obeonetwork.m2doc.template.IConstruct;
import org.obeonetwork.m2doc.template.Template;
import org.obeonetwork.m2doc.template.TemplatePackage;
import org.obeonetwork.m2doc.util.IClassProvider;

public final class M2DocUtils {
    public static final String M = "m:";
    public static final String INFO_COLOR = "0000FF";
    public static final String WARNING_COLOR = "FFA500";
    public static final String ERROR_COLOR = "FF0000";
    public static final String DOCX_EXTENSION_FILE = "docx";
    private static final List<IServicesConfiguratorDescriptor> CONFIGURATORS = new ArrayList<IServicesConfiguratorDescriptor>();

    private M2DocUtils() {
    }

    public static TemplateValidationMessage appendMessageRun(XWPFParagraph paragraph, ValidationMessageLevel level, String message) {
        XWPFRun run = paragraph.createRun();
        M2DocUtils.setRunMessage(run, level, message);
        return new TemplateValidationMessage(level, message, run);
    }

    public static List<TemplateValidationMessage> appendDiagnosticMessage(XWPFParagraph paragraph, Diagnostic diagnostic) {
        ArrayList<TemplateValidationMessage> res = new ArrayList<TemplateValidationMessage>();
        for (Diagnostic child : diagnostic.getChildren()) {
            switch (child.getSeverity()) {
                case 1: {
                    res.add(M2DocUtils.appendMessageRun(paragraph, ValidationMessageLevel.INFO, M2DocUtils.getMessageWithException(child)));
                    break;
                }
                case 2: {
                    res.add(M2DocUtils.appendMessageRun(paragraph, ValidationMessageLevel.WARNING, M2DocUtils.getMessageWithException(child)));
                    break;
                }
                case 4: {
                    res.add(M2DocUtils.appendMessageRun(paragraph, ValidationMessageLevel.ERROR, M2DocUtils.getMessageWithException(child)));
                    break;
                }
                default: {
                    res.add(M2DocUtils.appendMessageRun(paragraph, ValidationMessageLevel.INFO, M2DocUtils.getMessageWithException(child)));
                }
            }
            ((XWPFRun)paragraph.getRuns().get(paragraph.getRuns().size() - 1)).addBreak();
            if (child.getChildren().isEmpty()) continue;
            res.addAll(M2DocUtils.appendDiagnosticMessage(paragraph, child));
        }
        return res;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getMessageWithException(Diagnostic diagnostic) {
        Throwable exception = diagnostic.getException() != null ? diagnostic.getException().getCause() : null;
        if (exception == null) return diagnostic.getMessage();
        try {
            Throwable throwable = null;
            Object var4_4 = null;
            try {
                String res;
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                try {
                    try (PrintWriter printWriter = new PrintWriter(out);){
                        exception.printStackTrace(printWriter);
                        printWriter.flush();
                        out.flush();
                        res = String.valueOf(diagnostic.getMessage()) + "\n" + new String(out.toByteArray());
                    }
                    if (out == null) return res;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (out == null) throw throwable;
                    out.close();
                    throw throwable;
                }
                out.close();
                return res;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            return diagnostic.getMessage();
        }
    }

    public static TemplateValidationMessage insertMessageAfter(XWPFRun run, ValidationMessageLevel level, String message) {
        IRunBody parent = run.getParent();
        if (parent instanceof XWPFParagraph) {
            XWPFParagraph paragraph = (XWPFParagraph)parent;
            XWPFRun newRun = paragraph.insertNewRun(paragraph.getRuns().indexOf(run));
            M2DocUtils.setRunMessage(newRun, level, message);
            return new TemplateValidationMessage(level, message, newRun);
        }
        throw new IllegalStateException("this should not happend");
    }

    public static TemplateValidationMessage setRunMessage(XWPFRun run, ValidationMessageLevel level, String message) {
        run.setText(message);
        run.setBold(true);
        run.setColor(M2DocUtils.getColor(level));
        return new TemplateValidationMessage(level, message, run);
    }

    public static String getColor(ValidationMessageLevel level) {
        String res;
        switch (level) {
            case INFO: {
                res = INFO_COLOR;
                break;
            }
            case WARNING: {
                res = WARNING_COLOR;
                break;
            }
            case ERROR: {
                res = ERROR_COLOR;
                break;
            }
            default: {
                res = INFO_COLOR;
            }
        }
        return res;
    }

    public static void validationError(IConstruct construct, String msg) {
        XWPFRun lastRun = (XWPFRun)construct.getRuns().get(construct.getRuns().size() - 1);
        construct.getValidationMessages().add((Object)new TemplateValidationMessage(ValidationMessageLevel.ERROR, msg, lastRun));
    }

    public static void validationWarning(IConstruct construct, String msg) {
        XWPFRun lastRun = (XWPFRun)construct.getRuns().get(construct.getRuns().size() - 1);
        construct.getValidationMessages().add((Object)new TemplateValidationMessage(ValidationMessageLevel.WARNING, msg, lastRun));
    }

    public static void validationInfo(IConstruct construct, String msg) {
        XWPFRun lastRun = (XWPFRun)construct.getRuns().get(construct.getRuns().size() - 1);
        construct.getValidationMessages().add((Object)new TemplateValidationMessage(ValidationMessageLevel.INFO, msg, lastRun));
    }

    public static String message(ParsingErrorMessage message, Object ... objects) {
        return MessageFormat.format(message.getMessage(), objects);
    }

    public static void prepareEnvironmentServices(IQueryEnvironment queryEnvironment, URI templateURI, Map<String, String> options) {
        M2DocUtils.prepareEnvironmentServices(queryEnvironment, URIConverter.INSTANCE, templateURI, options);
    }

    public static void prepareEnvironmentServices(IQueryEnvironment queryEnvironment, URIConverter uriConverter, URI templateURI, Map<String, String> options) {
        Set services = ServiceUtils.getServices((IReadOnlyQueryEnvironment)queryEnvironment, BooleanServices.class);
        ServiceUtils.registerServices((IQueryEnvironment)queryEnvironment, (Set)services);
        services = ServiceUtils.getServices((IReadOnlyQueryEnvironment)queryEnvironment, LinkServices.class);
        ServiceUtils.registerServices((IQueryEnvironment)queryEnvironment, (Set)services);
        services = ServiceUtils.getServices((IReadOnlyQueryEnvironment)queryEnvironment, PaginationServices.class);
        ServiceUtils.registerServices((IQueryEnvironment)queryEnvironment, (Set)services);
        services = ServiceUtils.getServices((IReadOnlyQueryEnvironment)queryEnvironment, (Object)new ImageServices(uriConverter, templateURI));
        ServiceUtils.registerServices((IQueryEnvironment)queryEnvironment, (Set)services);
        for (IServicesConfigurator configurator : M2DocUtils.getConfigurators()) {
            ServiceUtils.registerServices((IQueryEnvironment)queryEnvironment, configurator.getServices((IReadOnlyQueryEnvironment)queryEnvironment, options));
        }
    }

    public static DocumentTemplate parse(URI templateURI, IQueryEnvironment queryEnvironment, IClassProvider classProvider) throws DocumentParserException {
        return M2DocUtils.parse(URIConverter.INSTANCE, templateURI, queryEnvironment, classProvider);
    }

    public static DocumentTemplate parse(URIConverter uriConverter, URI templateURI, IQueryEnvironment queryEnvironment, IClassProvider classProvider) throws DocumentParserException {
        DocumentTemplate result = (DocumentTemplate)EcoreUtil.create((EClass)TemplatePackage.Literals.DOCUMENT_TEMPLATE);
        ResourceImpl r = new ResourceImpl(templateURI);
        try {
            InputStream is = uriConverter.createInputStream(templateURI);
            OPCPackage oPackage = OPCPackage.open((InputStream)is);
            XWPFDocument document = new XWPFDocument(oPackage);
            List<TemplateValidationMessage> messages = M2DocUtils.parseTemplateCustomProperties(queryEnvironment, classProvider, document);
            r.getContents().add((Object)result);
            M2DocParser parser = new M2DocParser((IBody)document, queryEnvironment);
            Template documentBody = parser.parseTemplate();
            for (TemplateValidationMessage validationMessage : messages) {
                documentBody.getValidationMessages().add((Object)validationMessage);
            }
            result.setBody(documentBody);
            result.setInputStream(is);
            result.setOpcPackage(oPackage);
            result.setDocument(document);
            for (XWPFFooter footer : document.getFooterList()) {
                M2DocParser footerParser = new M2DocParser((IBody)footer, queryEnvironment);
                result.getFooters().add((Object)footerParser.parseTemplate());
            }
            for (XWPFHeader header : document.getHeaderList()) {
                M2DocParser headerParser = new M2DocParser((IBody)header, queryEnvironment);
                result.getHeaders().add((Object)headerParser.parseTemplate());
            }
        }
        catch (IOException e) {
            throw new DocumentParserException("Unable to open " + templateURI, e);
        }
        catch (InvalidFormatException e1) {
            throw new DocumentParserException("Invalid .docx format " + templateURI, e1);
        }
        return result;
    }

    private static List<TemplateValidationMessage> parseTemplateCustomProperties(IQueryEnvironment queryEnvironment, IClassProvider classProvider, XWPFDocument document) {
        TemplateCustomProperties properties = new TemplateCustomProperties(document);
        ArrayList<TemplateValidationMessage> messages = new ArrayList<TemplateValidationMessage>();
        for (String string : properties.getPackagesURIs()) {
            EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(string);
            if (ePackage != null) {
                queryEnvironment.registerEPackage(ePackage);
                continue;
            }
            XWPFRun run = (XWPFRun)((XWPFParagraph)document.getParagraphs().get(0)).getRuns().get(0);
            TemplateValidationMessage validationMessage = new TemplateValidationMessage(ValidationMessageLevel.ERROR, "can't find EPackage: " + string, run);
            messages.add(validationMessage);
        }
        for (Map.Entry entry : properties.getServiceClasses().entrySet()) {
            try {
                Class<?> cls = classProvider.getClass((String)entry.getKey(), (String)entry.getValue());
                Set s = ServiceUtils.getServices((IReadOnlyQueryEnvironment)queryEnvironment, cls);
                ServiceUtils.registerServices((IQueryEnvironment)queryEnvironment, (Set)s);
            }
            catch (ClassNotFoundException classNotFoundException) {
                XWPFRun run = (XWPFRun)((XWPFParagraph)document.getParagraphs().get(0)).getRuns().get(0);
                TemplateValidationMessage validationMessage = new TemplateValidationMessage(ValidationMessageLevel.ERROR, "can't load service class: " + (String)entry.getKey(), run);
                messages.add(validationMessage);
            }
        }
        return messages;
    }

    public static DocumentTemplate parseUserContent(URI documentURI, IQueryEnvironment queryEnvironment) throws DocumentParserException {
        return M2DocUtils.parseUserContent(URIConverter.INSTANCE, documentURI, queryEnvironment);
    }

    public static DocumentTemplate parseUserContent(URIConverter uriConverter, URI documentURI, IQueryEnvironment queryEnvironment) throws DocumentParserException {
        DocumentTemplate result = (DocumentTemplate)EcoreUtil.create((EClass)TemplatePackage.Literals.DOCUMENT_TEMPLATE);
        ResourceImpl r = new ResourceImpl(documentURI);
        try {
            InputStream is = uriConverter.createInputStream(documentURI);
            OPCPackage oPackage = OPCPackage.open((InputStream)is);
            XWPFDocument document = new XWPFDocument(oPackage);
            r.getContents().add((Object)result);
            BodyGeneratedParser parser = new BodyGeneratedParser((IBody)document, queryEnvironment);
            result.setBody(parser.parseTemplate());
            result.setInputStream(is);
            result.setOpcPackage(oPackage);
            result.setDocument(document);
            for (XWPFFooter footer : document.getFooterList()) {
                BodyGeneratedParser footerParser = new BodyGeneratedParser((IBody)footer, queryEnvironment);
                result.getFooters().add((Object)footerParser.parseTemplate());
            }
            for (XWPFHeader header : document.getHeaderList()) {
                BodyGeneratedParser headerParser = new BodyGeneratedParser((IBody)header, queryEnvironment);
                result.getHeaders().add((Object)headerParser.parseTemplate());
            }
        }
        catch (IOException e) {
            throw new DocumentParserException("Unable to open " + documentURI, e);
        }
        catch (InvalidFormatException e1) {
            throw new DocumentParserException("Invalid .docx format " + documentURI, e1);
        }
        return result;
    }

    public static ValidationMessageLevel validate(DocumentTemplate documentTemplate, IReadOnlyQueryEnvironment queryEnvironment) {
        M2DocValidator validator = new M2DocValidator();
        return validator.validate(documentTemplate, queryEnvironment);
    }

    public static void serializeValidatedDocumentTemplate(DocumentTemplate documentTemplate, URI destination) throws IOException {
        M2DocUtils.serializeValidatedDocumentTemplate(URIConverter.INSTANCE, documentTemplate, destination);
    }

    public static void serializeValidatedDocumentTemplate(URIConverter uriConverter, DocumentTemplate documentTemplate, URI destination) throws IOException {
        TemplateValidationGenerator generator = new TemplateValidationGenerator();
        generator.doSwitch(documentTemplate);
        POIServices.getInstance().saveFile(uriConverter, documentTemplate.getDocument(), destination);
    }

    @Deprecated
    public static GenerationResult generate(DocumentTemplate documentTemplate, IReadOnlyQueryEnvironment queryEnvironment, Map<String, Object> variables, URI destination) throws DocumentGenerationException {
        return M2DocUtils.generate(documentTemplate, queryEnvironment, variables, URIConverter.INSTANCE, destination, (Monitor)new BasicMonitor());
    }

    public static GenerationResult generate(DocumentTemplate documentTemplate, IReadOnlyQueryEnvironment queryEnvironment, Map<String, Object> variables, URI destination, Monitor monitor) throws DocumentGenerationException {
        return M2DocUtils.generate(documentTemplate, queryEnvironment, variables, URIConverter.INSTANCE, destination, monitor);
    }

    /*
     * Exception decompiling
     */
    public static GenerationResult generate(DocumentTemplate documentTemplate, IReadOnlyQueryEnvironment queryEnvironment, Map<String, Object> variables, URIConverter uriConverter, URI destination, Monitor monitor) throws DocumentGenerationException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerServicesConfigurator(IServicesConfiguratorDescriptor configurator) {
        if (configurator != null) {
            List<IServicesConfiguratorDescriptor> list = CONFIGURATORS;
            synchronized (list) {
                CONFIGURATORS.add(configurator);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterServicesConfigurator(IServicesConfiguratorDescriptor configuratorDescriptor) {
        if (configuratorDescriptor != null) {
            List<IServicesConfiguratorDescriptor> list = CONFIGURATORS;
            synchronized (list) {
                CONFIGURATORS.remove(configuratorDescriptor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<IServicesConfigurator> getConfigurators() {
        ArrayList<IServicesConfigurator> res = new ArrayList<IServicesConfigurator>();
        List<IServicesConfiguratorDescriptor> list = CONFIGURATORS;
        synchronized (list) {
            for (IServicesConfiguratorDescriptor descriptor : CONFIGURATORS) {
                IServicesConfigurator configurator = descriptor.getServicesConfigurator();
                if (configurator == null) continue;
                res.add(configurator);
            }
        }
        return res;
    }

    public static Map<String, String> getInitializedOptions(Map<String, String> options) {
        LinkedHashMap<String, String> res = new LinkedHashMap<String, String>();
        for (IServicesConfigurator configurator : M2DocUtils.getConfigurators()) {
            res.putAll(configurator.getInitializedOptions(options));
        }
        return res;
    }
}

