/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.ref;

import java.lang.ref.ReferenceQueue;
import java.lang.reflect.Array;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.net4j.util.collection.MapEntry;
import org.eclipse.net4j.util.ref.KeyedReference;
import org.eclipse.net4j.util.ref.KeyedSoftReference;
import org.eclipse.net4j.util.ref.KeyedStrongReference;
import org.eclipse.net4j.util.ref.KeyedWeakReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ReferenceValueMap2<K, V>
extends AbstractMap<K, V> {
    Map<K, KeyedReference<K, V>> map;
    ReferenceQueue<V> queue;
    private EntrySet entrySet;

    public ReferenceValueMap2() {
        this(new HashMap());
    }

    public ReferenceValueMap2(Map<K, KeyedReference<K, V>> map) {
        if (!map.isEmpty()) {
            throw new IllegalArgumentException("!map.isEmpty()");
        }
        this.map = map;
        this.queue = this.createQueue();
    }

    @Override
    public int size() {
        this.purgeQueue();
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        this.purgeQueue();
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        KeyedReference<K, V> ref = this.map.get(key);
        if (ref != null) {
            return ref.get() != null;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            throw new IllegalArgumentException("value == null");
        }
        for (KeyedReference<K, V> ref : this.map.values()) {
            V v = ref.get();
            if (v == null) {
                return false;
            }
            if (!value.equals(v)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        KeyedReference<K, V> ref = this.map.get(key);
        return this.dereference(ref);
    }

    @Override
    public V put(K key, V value) {
        try {
            KeyedReference<K, V> ref = this.createReference(key, value, this.queue);
            KeyedReference<K, V> oldRef = this.map.put(key, ref);
            V v = this.dereference(oldRef);
            return v;
        }
        finally {
            this.purgeQueue();
        }
    }

    @Override
    public V remove(Object key) {
        KeyedReference<K, V> ref = this.map.remove(key);
        return this.dereference(ref);
    }

    @Override
    public void clear() {
        this.purgeQueue();
        this.map.clear();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.purgeQueue();
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    protected ReferenceQueue<V> createQueue() {
        return new ReferenceQueue();
    }

    protected int internalPurgeQueue() {
        if (this.queue != null) {
            KeyedReference ref;
            int purged = 0;
            while ((ref = (KeyedReference)((Object)this.queue.poll())) != null) {
                Object key = ref.getKey();
                this.map.remove(key);
                this.purged(key);
                ++purged;
            }
            return purged;
        }
        return 0;
    }

    protected void purgeQueue() {
        this.internalPurgeQueue();
    }

    protected void purged(K key) {
    }

    protected V dereference(KeyedReference<K, V> ref) {
        if (ref == null) {
            return null;
        }
        return ref.get();
    }

    protected abstract KeyedReference<K, V> createReference(K var1, V var2, ReferenceQueue<V> var3);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        @Override
        public int size() {
            return ReferenceValueMap2.this.map.size();
        }

        @Override
        public boolean isEmpty() {
            return ReferenceValueMap2.this.map.isEmpty();
        }

        @Override
        public boolean contains(Object object) {
            if (object == null) {
                throw new IllegalArgumentException("object == null");
            }
            if (object instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)object;
                Object key = entry.getKey();
                Object value = entry.getValue();
                return key != null && value != null && value.equals(ReferenceValueMap2.this.get(key));
            }
            return false;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntrySetIterator();
        }

        @Override
        public Object[] toArray() {
            Object[] a = new Object[this.size()];
            int i = 0;
            for (Map.Entry entry : this) {
                a[i++] = entry;
            }
            return a;
        }

        @Override
        public <T> T[] toArray(T[] a) {
            if (a == null) {
                throw new IllegalArgumentException("array == null");
            }
            int size = this.size();
            if (a.length < size) {
                a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
            }
            int i = 0;
            for (Map.Entry entry : this) {
                a[i++] = entry;
            }
            if (a.length > size) {
                a[size] = null;
            }
            return a;
        }

        @Override
        public boolean remove(Object object) {
            if (object == null) {
                throw new IllegalArgumentException("object == null");
            }
            if (object instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)object;
                return ReferenceValueMap2.this.map.remove(entry.getKey()) != null;
            }
            return false;
        }

        @Override
        public void clear() {
            ReferenceValueMap2.this.map.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntrySetIterator
    implements Iterator<Map.Entry<K, V>> {
        private Iterator<Map.Entry<K, KeyedReference<K, V>>> it;
        private MapEntry<K, V> nextEntry;
        private K lastKey;

        public EntrySetIterator() {
            this.it = ReferenceValueMap2.this.map.entrySet().iterator();
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public boolean hasNext() {
            if (this.nextEntry == null) ** GOTO lbl9
            return true;
lbl-1000:
            // 1 sources

            {
                entry = this.it.next();
                this.lastKey = entry.getKey();
                value = ReferenceValueMap2.this.dereference(entry.getValue());
                if (value == null) continue;
                this.nextEntry = new MapEntry<K, V>(this.lastKey, value);
                return true;
lbl9:
                // 2 sources

                ** while (this.it.hasNext())
            }
lbl10:
            // 1 sources

            return false;
        }

        @Override
        public Map.Entry<K, V> next() {
            if (this.nextEntry == null && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            try {
                MapEntry mapEntry = this.nextEntry;
                return mapEntry;
            }
            finally {
                this.nextEntry = null;
            }
        }

        @Override
        public void remove() {
            if (this.lastKey == null) {
                throw new IllegalStateException("lastKey == null");
            }
            ReferenceValueMap2.this.map.remove(this.lastKey);
            this.lastKey = null;
            this.nextEntry = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Soft<K, V>
    extends ReferenceValueMap2<K, V> {
        public Soft() {
        }

        public Soft(Map<K, KeyedReference<K, V>> map) {
            super(map);
        }

        @Override
        protected KeyedReference<K, V> createReference(K key, V value, ReferenceQueue<V> queue) {
            return new KeyedSoftReference<K, V>(key, value, queue);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Strong<K, V>
    extends ReferenceValueMap2<K, V> {
        public Strong() {
        }

        public Strong(Map<K, KeyedReference<K, V>> map) {
            super(map);
        }

        @Override
        protected KeyedReference<K, V> createReference(K key, V value, ReferenceQueue<V> queue) {
            return new KeyedStrongReference<K, V>(key, value);
        }

        @Override
        protected ReferenceQueue<V> createQueue() {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Weak<K, V>
    extends ReferenceValueMap2<K, V> {
        public Weak() {
        }

        public Weak(Map<K, KeyedReference<K, V>> map) {
            super(map);
        }

        @Override
        protected KeyedReference<K, V> createReference(K key, V value, ReferenceQueue<V> queue) {
            return new KeyedWeakReference<K, V>(key, value, queue);
        }
    }
}

