/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.ui;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.net4j.util.properties.IPropertyProvider;
import org.eclipse.net4j.util.properties.Property;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPropertySource<RECEIVER>
implements IPropertySource {
    private Map<Object, IPropertyDescriptor> descriptors = new LinkedHashMap<Object, IPropertyDescriptor>();
    private RECEIVER receiver;

    public DefaultPropertySource(RECEIVER receiver) {
        this.receiver = receiver;
    }

    public DefaultPropertySource(RECEIVER object, IPropertyProvider<RECEIVER> provider) {
        this(object);
        this.addDescriptors(provider);
    }

    public RECEIVER getReceiver() {
        return this.receiver;
    }

    public boolean addDescriptor(IPropertyDescriptor descriptor) {
        Object id = descriptor.getId();
        if (this.descriptors.containsKey(id)) {
            return false;
        }
        this.descriptors.put(id, descriptor);
        return true;
    }

    public PropertyDescriptor addDescriptor(String category, Object id, String displayName, String description) {
        PropertyDescriptor descriptor = new PropertyDescriptor(id, displayName);
        descriptor.setCategory(category);
        descriptor.setDescription(description);
        if (!this.addDescriptor((IPropertyDescriptor)descriptor)) {
            return null;
        }
        return descriptor;
    }

    public void addDescriptors(IPropertyProvider<RECEIVER> provider) {
        for (Property property : provider.getProperties()) {
            if (property.getLabel() == null) continue;
            DelegatingPropertyDescriptor descriptor = new DelegatingPropertyDescriptor(property);
            this.addDescriptor(descriptor);
        }
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return this.descriptors.values().toArray(new IPropertyDescriptor[this.descriptors.size()]);
    }

    public IPropertyDescriptor getPropertyDescriptor(Object id) {
        for (IPropertyDescriptor propertyDescriptor : this.descriptors.values()) {
            if (!propertyDescriptor.getId().equals(id)) continue;
            return propertyDescriptor;
        }
        return null;
    }

    public Property<RECEIVER> getProperty(Object id) {
        IPropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(id);
        if (propertyDescriptor instanceof DelegatingPropertyDescriptor) {
            DelegatingPropertyDescriptor delegating = (DelegatingPropertyDescriptor)propertyDescriptor;
            return delegating.getProperty();
        }
        return null;
    }

    public Object getPropertyValue(Object id) {
        Property<RECEIVER> property = this.getProperty(id);
        if (property != null) {
            return property.getValue(this.receiver);
        }
        return null;
    }

    public boolean isPropertySet(Object id) {
        return true;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }

    public Object getEditableValue() {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Augmented<RECEIVER, AUGMENTING_RECEIVER>
    extends DefaultPropertySource<RECEIVER> {
        private final Map<String, Object> propertyValues = new HashMap<String, Object>();

        public Augmented(RECEIVER object, IPropertyProvider<RECEIVER> provider, AUGMENTING_RECEIVER augmentingObject) {
            super(object, provider);
            if (augmentingObject != null) {
                IPropertySource augmentingPropertySource = this.createAugmentingPropertySource(augmentingObject);
                IPropertyDescriptor[] iPropertyDescriptorArray = augmentingPropertySource.getPropertyDescriptors();
                int n = iPropertyDescriptorArray.length;
                int n2 = 0;
                while (n2 < n) {
                    DelegatingPropertyDescriptor viewPropertyDescriptor;
                    Property property;
                    IPropertyDescriptor propertyDescriptor = iPropertyDescriptorArray[n2];
                    if (propertyDescriptor instanceof DelegatingPropertyDescriptor && (property = (viewPropertyDescriptor = (DelegatingPropertyDescriptor)propertyDescriptor).getProperty()) != null) {
                        String category = propertyDescriptor.getCategory();
                        String id = "___VIEW___" + propertyDescriptor.getId();
                        String displayName = propertyDescriptor.getDisplayName();
                        String description = propertyDescriptor.getDescription();
                        Object value = property.getValue(augmentingObject);
                        this.propertyValues.put(id, value);
                        this.addDescriptor(category, id, displayName, description);
                    }
                    ++n2;
                }
            }
        }

        @Override
        public Object getPropertyValue(Object id) {
            Object value = this.propertyValues.get(id);
            if (value != null) {
                return value;
            }
            return super.getPropertyValue(id);
        }

        protected abstract IPropertySource createAugmentingPropertySource(AUGMENTING_RECEIVER var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DelegatingPropertyDescriptor<RECEIVER>
    implements IPropertyDescriptor {
        private final Property<RECEIVER> property;
        private ILabelProvider labelProvider;

        public DelegatingPropertyDescriptor(Property<RECEIVER> property) {
            this.property = property;
        }

        public Property<RECEIVER> getProperty() {
            return this.property;
        }

        public String getCategory() {
            return this.property.getCategory();
        }

        public String getId() {
            return this.property.getName();
        }

        public String getDisplayName() {
            return this.property.getLabel();
        }

        public String getDescription() {
            return this.property.getDescription();
        }

        public boolean isCompatibleWith(IPropertyDescriptor anotherProperty) {
            return anotherProperty.getCategory().equals(this.getCategory()) && anotherProperty.getId().equals(this.getId());
        }

        public ILabelProvider getLabelProvider() {
            if (this.labelProvider != null) {
                return this.labelProvider;
            }
            return new LabelProvider();
        }

        public void setLabelProvider(ILabelProvider labelProvider) {
            this.labelProvider = labelProvider;
        }

        public Object getHelpContextIds() {
            return null;
        }

        public String[] getFilterFlags() {
            return null;
        }

        public CellEditor createPropertyEditor(Composite parent) {
            return null;
        }
    }
}

