/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.cdo.services.configurator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IService;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.spi.cdo.InternalCDOView;
import org.eclipse.net4j.connector.IConnector;
import org.obeonetwork.m2doc.cdo.M2DocCDOUtils;
import org.obeonetwork.m2doc.cdo.providers.configuration.M2DocCDOURIHandler;
import org.obeonetwork.m2doc.services.configurator.IServicesConfigurator;

public class CDOServicesConfigurator
implements IServicesConfigurator {
    public static final List<String> OPTIONS = CDOServicesConfigurator.initOptions();
    private Map<Object, IConnector> connectors = new HashMap<Object, IConnector>();
    private Map<Object, CDOTransaction> transactions = new HashMap<Object, CDOTransaction>();

    private static List<String> initOptions() {
        ArrayList<String> res = new ArrayList<String>();
        res.add("CDOServer");
        res.add("CDORepository");
        res.add("CDOBranch");
        res.add("CDOLogin");
        res.add("CDOPassword");
        return res;
    }

    public List<String> getOptions() {
        return OPTIONS;
    }

    public Map<String, String> getInitializedOptions(Map<String, String> options) {
        return Collections.emptyMap();
    }

    public Map<String, List<Diagnostic>> validate(IReadOnlyQueryEnvironment queryEnvironment, Map<String, String> options) {
        return Collections.emptyMap();
    }

    public Set<IService> getServices(IReadOnlyQueryEnvironment queryEnvironment, ResourceSet resourceSetForModels, Map<String, String> options) {
        return Collections.emptySet();
    }

    public void startGeneration(IReadOnlyQueryEnvironment queryEnvironment, XWPFDocument destinationDocument) {
    }

    public void cleanServices(IReadOnlyQueryEnvironment queryEnvironment, ResourceSet resourceSetForModels) {
    }

    public ResourceSet createResourceSetForModels(Object context, Map<String, String> options) {
        ResourceSet res;
        String cdoServer = options.get("CDOServer");
        if (cdoServer != null) {
            String repository = options.get("CDORepository");
            String branch = options.get("CDOBranch");
            String login = options.get("CDOLogin");
            String password = options.get("CDOPassword");
            IConnector connector = M2DocCDOUtils.getConnector(cdoServer);
            this.connectors.put(context, connector);
            CDOSession session = M2DocCDOUtils.openSession(connector, repository, login, password);
            CDOTransaction transaction = M2DocCDOUtils.openTransaction(session, branch);
            this.transactions.put(context, transaction);
            res = transaction.getResourceSet();
            res.getURIConverter().getURIHandlers().add(0, (Object)new M2DocCDOURIHandler((InternalCDOView)transaction));
        } else {
            res = null;
        }
        return res;
    }

    public void cleanResourceSetForModels(Object context) {
        CDOTransaction transaction = this.transactions.get(context);
        if (transaction != null) {
            CDOSession session = transaction.getSession();
            transaction.close();
            session.close();
            this.connectors.remove(context).close();
        }
    }
}

