/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.om.monitor;

import org.eclipse.net4j.util.event.Event;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.event.INotifier;
import org.eclipse.net4j.util.event.Notifier;
import org.eclipse.net4j.util.om.monitor.Monitor;
import org.eclipse.net4j.util.om.monitor.MonitorCanceledException;
import org.eclipse.net4j.util.om.monitor.OMMonitorProgress;

public class NotifyingMonitor
extends Monitor
implements INotifier {
    private Notifier notifier = new Notifier();
    private String task;

    public NotifyingMonitor() {
    }

    public NotifyingMonitor(String task) {
        this.task = task;
    }

    public NotifyingMonitor(String task, IListener[] listeners) {
        this(task);
        if (listeners != null) {
            IListener[] iListenerArray = listeners;
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                IListener listener = iListenerArray[n2];
                this.addListener(listener);
                ++n2;
            }
        }
    }

    public String getTask() {
        return this.task;
    }

    public boolean hasListeners() {
        return this.notifier.hasListeners();
    }

    public IListener[] getListeners() {
        return this.notifier.getListeners();
    }

    public void addListener(IListener listener) {
        this.notifier.addListener(listener);
    }

    public void removeListener(IListener listener) {
        this.notifier.removeListener(listener);
    }

    public void worked(double work) throws MonitorCanceledException {
        super.worked(work);
        IListener[] listeners = this.getListeners();
        if (listeners != null) {
            this.notifier.fireEvent(new ProgressEvent(this, this.getTotalWork(), this.getWork()), listeners);
        }
    }

    public static class ProgressEvent
    extends Event
    implements OMMonitorProgress {
        private static final long serialVersionUID = 1L;
        private double totalWork;
        private double work;

        public ProgressEvent(INotifier notifier, double totalWork, double work) {
            super(notifier);
            this.totalWork = totalWork;
            this.work = work;
        }

        public String getTask() {
            INotifier source = this.getSource();
            if (source instanceof NotifyingMonitor) {
                NotifyingMonitor monitor = (NotifyingMonitor)source;
                return monitor.getTask();
            }
            return null;
        }

        public double getTotalWork() {
            return this.totalWork;
        }

        public double getWork() {
            return this.work;
        }

        public double getWorkPercent() {
            return NotifyingMonitor.percent(this.work, this.totalWork);
        }
    }
}

