/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.html.services;

import java.awt.Color;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFNumbering;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.obeonetwork.m2doc.element.MElement;
import org.obeonetwork.m2doc.element.MElementContainer;
import org.obeonetwork.m2doc.element.MImage;
import org.obeonetwork.m2doc.element.MList;
import org.obeonetwork.m2doc.element.MPagination;
import org.obeonetwork.m2doc.element.MParagraph;
import org.obeonetwork.m2doc.element.MStyle;
import org.obeonetwork.m2doc.element.impl.MHyperLinkImpl;
import org.obeonetwork.m2doc.element.impl.MImageImpl;
import org.obeonetwork.m2doc.element.impl.MListImpl;
import org.obeonetwork.m2doc.element.impl.MParagraphImpl;
import org.obeonetwork.m2doc.element.impl.MStyleImpl;
import org.obeonetwork.m2doc.element.impl.MTableImpl;
import org.obeonetwork.m2doc.element.impl.MTextImpl;
import org.obeonetwork.m2doc.html.services.M2DocCSSParser;
import org.obeonetwork.m2doc.html.services.Parser;
import org.obeonetwork.m2doc.services.PaginationServices;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTAbstractNum;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTDecimalNumber;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTFonts;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTInd;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTLevelText;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTLvl;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTNum;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTNumFmt;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTNumbering;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STJc;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STMultiLevelType;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STNumberFormat;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STOnOff;

public class M2DocHTMLParser
extends Parser {
    private static final String OL_TAG = "ol";
    private static final String UL_TAG = "ul";
    private static final String BLOCKQUOTE_TAG = "blockquote";
    private static final String COURIER_NEW_FONT = "Courier New";
    private static final String WINGDINGS_FONT = "Wingdings";
    private static final String SYMBOL_FONT = "Symbol";
    private static final int DEFAULT_FONT_SIZE = 11;
    private static final double BIG_RATIO = 1.33;
    private static final double SMALL_RATIO = 0.8;
    private static final String HEIGHT_ATTR = "height";
    private static final String WIDTH_ATTR = "width";
    private static final String STYLE_ATTR = "style";
    private static final String CLASS_ATTR = "class";
    private static final String DIR_ATTR = "dir";
    private static final int INDENT_LEFT = 720;
    private static final int INDENT_HANGING = 180;
    private static final String TYPE_ATTR = "type";
    private static final String DISC_SYMBOL = "\uf0b7";
    private static final String SQUARE_SYMBOL = "\uf0a7";
    private static final String CIRCLE_SYMBOL = "o";
    private static final int H6_FONT_SIZE = 8;
    private static final int H5_FONT_SIZE = 10;
    private static final int H4_FONT_SIZE = 12;
    private static final int H3_FONT_SIZE = 14;
    private static final int H2_FONT_SIZE = 18;
    private static final int H1_FONT_SIZE = 24;
    private static final int BLOCKQUOTE_DEFAULT_MARGING_LEFT = 40;
    private static final Color LINK_COLOR = Color.BLUE;
    private static final M2DocCSSParser CSS_PARSER = new M2DocCSSParser();
    private final URIConverter uriConverter;
    private XWPFDocument destinationDocument;

    public M2DocHTMLParser(URIConverter uriConverter, XWPFDocument destinationDocument) {
        this.uriConverter = uriConverter;
        this.destinationDocument = destinationDocument;
    }

    public List<MElement> parse(URI baseURI, String htmlString) {
        MListImpl res = new MListImpl();
        Document document = Jsoup.parse((String)htmlString, (String)baseURI.toString());
        document.outputSettings().syntax(Document.OutputSettings.Syntax.xml);
        document.outputSettings().charset("UTF-8");
        MStyleImpl defaultStyle = new MStyleImpl(null, -1, null, null, -1);
        if (document.body().hasAttr("bgcolor")) {
            defaultStyle.setBackgroundColor(this.htmlToColor(document.body().attr("bgcolor").toLowerCase()));
        }
        Context context = new Context(baseURI, (MStyle)defaultStyle);
        context.pushMarginLeft(null);
        try {
            this.applyGlobalAttibutes(context, (Node)document.body());
        }
        finally {
            context.popMarginLeft();
        }
        this.walkNodeTree((MList)res, context, (Node)document.body(), null);
        return res;
    }

    private void walkNodeTree(MList parent, Context context, Node node, Element lastElement) {
        Context contextCopy = context.copy();
        if (node instanceof Element) {
            if ("table".equals(node.nodeName())) {
                Node tBody = null;
                for (Node child : node.childNodes()) {
                    if (!"tbody".equals(child.nodeName())) continue;
                    tBody = child;
                    break;
                }
                if (tBody != null) {
                    this.insertTable(parent, context, tBody);
                }
            } else {
                if (UL_TAG.equals(node.nodeName()) || OL_TAG.equals(node.nodeName())) {
                    contextCopy.cssProperties.remove("list-style-type");
                }
                contextCopy.pushMarginLeft(null);
                this.applyGlobalAttibutes(contextCopy, node);
                if (BLOCKQUOTE_TAG.equals(node.nodeName())) {
                    contextCopy.replaceLastDefaultMarginLeft(40);
                }
                MList element = this.startElement(parent, contextCopy, (Element)node);
                try {
                    this.walkChildren(node, contextCopy, element);
                }
                finally {
                    contextCopy.popMarginLeft();
                }
                this.endElement(parent, (MElement)element);
            }
        } else if (node instanceof TextNode) {
            boolean needNewParagraph = lastElement != null && (UL_TAG.equals(lastElement.nodeName()) || OL_TAG.equals(lastElement.nodeName()) || BLOCKQUOTE_TAG.equals(lastElement.nodeName()));
            this.insertText(parent, contextCopy, (TextNode)node, needNewParagraph);
        }
    }

    private void walkChildren(Node node, Context context, MList parent) {
        Element lastElement = null;
        for (Node child : node.childNodes()) {
            MTextImpl mText;
            boolean needQuotes = "q".equals(child.nodeName());
            if (needQuotes) {
                mText = new MTextImpl("\u00ab", null);
                parent.add((Object)mText);
            }
            this.walkNodeTree(parent, context, child, lastElement);
            if (needQuotes) {
                mText = new MTextImpl("\u00bb", null);
                parent.add((Object)mText);
            }
            if ("div".equals(child.nodeName())) continue;
            lastElement = child instanceof Element ? (Element)child : null;
        }
    }

    private void insertTable(MList parent, Context context, Node node) {
        MTableImpl table = new MTableImpl();
        parent.add((Object)table);
        for (Node child : node.childNodes()) {
            if (!"tr".equals(child.nodeName())) continue;
            MTableImpl.MRowImpl row = new MTableImpl.MRowImpl();
            table.getRows().add(row);
            for (Node rowChild : child.childNodes()) {
                Context localContext;
                if (!"th".equals(rowChild.nodeName()) && !"td".equals(rowChild.nodeName())) continue;
                MListImpl contents = new MListImpl();
                MTableImpl.MCellImpl cell = new MTableImpl.MCellImpl((MElement)contents, null);
                if ("th".equals(rowChild.nodeName())) {
                    cell.setHAlignment(MElementContainer.HAlignment.CENTER);
                    localContext = context.copy();
                    this.setModifiers(localContext.style, 1);
                } else {
                    localContext = context;
                }
                row.getCells().add(cell);
                this.walkChildren(rowChild, localContext, (MList)contents);
            }
        }
    }

    private void endElement(MList parent, MElement element) {
        if (element instanceof MList && ((MList)element).isEmpty()) {
            for (MElement child : parent) {
                if (!(child instanceof MParagraph) || ((MParagraph)child).getContents() != element) continue;
                parent.remove((Object)child);
                break;
            }
        }
    }

    private void insertText(MList parent, Context context, TextNode node, boolean needNewParagraph) {
        String text = node.text();
        if (!text.trim().isEmpty()) {
            String textToInsert;
            if (needNewParagraph) {
                this.createMParagraph(context, parent, null, null, null);
                textToInsert = this.trimFirst(text);
            } else {
                textToInsert = text;
            }
            if (context.linkTargetURI == null) {
                MTextImpl mText = new MTextImpl(textToInsert, context.style);
                parent.add((Object)mText);
            } else {
                context.style.setForegroundColor(LINK_COLOR);
                MHyperLinkImpl mLink = new MHyperLinkImpl(textToInsert, context.style, context.linkTargetURI.toString());
                parent.add((Object)mLink);
            }
        }
    }

    private String trimFirst(String text) {
        String res;
        if (text != null && !text.isEmpty()) {
            int subStringStart = 0;
            int textLength = text.length();
            while (subStringStart < textLength && Character.isWhitespace(text.charAt(subStringStart))) {
                ++subStringStart;
            }
            res = text.substring(subStringStart);
        } else {
            res = text;
        }
        return res;
    }

    private MList startElement(MList parent, Context context, Element element) {
        MList res;
        String nodeName = element.nodeName();
        boolean isNumbering = false;
        if ("p".equals(nodeName)) {
            res = this.createMParagraph(context, parent, element, null, null);
        } else if (BLOCKQUOTE_TAG.equals(nodeName)) {
            if (element.childNodeSize() > 0 && element.childNode(0) instanceof TextNode) {
                TextNode textNode = (TextNode)element.childNode(0);
                String newText = this.trimFirst(textNode.text());
                textNode.text(newText);
                res = !newText.isEmpty() ? this.createMParagraph(context, parent, element, null, null) : parent;
            } else {
                res = parent;
            }
        } else if ("strong".equals(nodeName) || "b".equals(nodeName)) {
            this.setModifiers(context.style, 1);
            res = parent;
        } else if ("em".equals(nodeName) || "i".equals(nodeName) || "var".equals(nodeName) || "cite".equals(nodeName)) {
            this.setModifiers(context.style, 2);
            res = parent;
        } else if ("s".equals(nodeName) || "strike".equals(nodeName) || "del".equals(nodeName)) {
            this.setModifiers(context.style, 8);
            res = parent;
        } else if ("u".equals(nodeName) || "ins".equals(nodeName)) {
            this.setModifiers(context.style, 4);
            res = parent;
        } else if ("sub".equals(nodeName)) {
            this.setModifiers(context.style, 16);
            res = parent;
        } else if ("sup".equals(nodeName)) {
            this.setModifiers(context.style, 32);
            res = parent;
        } else if ("font".equals(nodeName)) {
            if (element.hasAttr("color")) {
                context.style.setForegroundColor(this.htmlToColor(element.attr("color").toLowerCase()));
            }
            if (element.hasAttr("face")) {
                context.style.setFontName(element.attr("face"));
            }
            if (element.hasAttr("size")) {
                context.style.setFontSize(this.fontSizeToPoint(Integer.valueOf(element.attr("size"))));
            }
            res = parent;
        } else if ("a".equals(nodeName)) {
            context.linkTargetURI = URI.createURI((String)element.attr("href")).resolve(context.baseURI);
            res = parent;
        } else if ("br".equals(nodeName)) {
            parent.add((Object)MPagination.ligneBreak);
            res = parent;
        } else if ("li".equals(nodeName)) {
            res = this.createMParagraph(context, parent, element, context.numberingID.longValue(), context.numberingLevel - 1L);
            isNumbering = true;
        } else if (OL_TAG.equals(nodeName)) {
            this.setOrderedListNumbering(context, element);
            isNumbering = true;
            res = parent;
        } else if (UL_TAG.equals(nodeName)) {
            this.setUnorderedListNumbering(context, element);
            isNumbering = true;
            res = parent;
        } else if ("img".equals(nodeName)) {
            MImage mImage = this.createMImage(context, element);
            parent.add((Object)mImage);
            res = parent;
        } else if ("big".equals(nodeName)) {
            this.setBigFont(context);
            res = parent;
        } else if ("small".equals(nodeName)) {
            this.setSmallFont(context);
            res = parent;
        } else if ("tt".equals(nodeName) || "code".equals(nodeName) || "samp".equals(nodeName) || "kbd".equals(nodeName)) {
            context.style.setFontName(COURIER_NEW_FONT);
            res = parent;
        } else {
            res = "h1".equals(nodeName) ? this.createHeading(parent, context, element, 24) : ("h2".equals(nodeName) ? this.createHeading(parent, context, element, 18) : ("h3".equals(nodeName) ? this.createHeading(parent, context, element, 14) : ("h4".equals(nodeName) ? this.createHeading(parent, context, element, 12) : ("h5".equals(nodeName) ? this.createHeading(parent, context, element, 10) : ("h6".equals(nodeName) ? this.createHeading(parent, context, element, 8) : parent)))));
        }
        if (!isNumbering) {
            context.numbering = null;
            context.numberingLevel = 0L;
        }
        return res;
    }

    private void applyGlobalAttibutes(Context context, Node node) {
        this.applyCSSStyle(node, context);
        this.applyMarkerClass(context, node);
        this.applyDir(context, node);
    }

    private void applyMarkerClass(Context context, Node node) {
        if (node.hasAttr(CLASS_ATTR) && "marker".equals(node.attr(CLASS_ATTR))) {
            context.style.setBackgroundColor(Color.YELLOW);
        }
    }

    private void applyDir(Context context, Node node) {
        if (node.hasAttr(DIR_ATTR)) {
            if ("ltr".equals(node.attr(DIR_ATTR))) {
                context.dir = Context.Dir.LTR;
            } else if ("rtl".equals(node.attr(DIR_ATTR))) {
                context.dir = Context.Dir.RTL;
            }
        }
    }

    private void setBigFont(Context context) {
        int fontSize = context.style.getFontSize() == -1 ? 14 : (int)((double)context.style.getFontSize() * 1.33);
        context.style.setFontSize(fontSize);
    }

    private void setSmallFont(Context context) {
        int fontSize = context.style.getFontSize() == -1 ? 8 : (int)((double)context.style.getFontSize() * 0.8);
        context.style.setFontSize(fontSize);
    }

    private void applyCSSStyle(Node node, Context context) {
        if (node.hasAttr(STYLE_ATTR)) {
            Map<String, List<String>> cssProperties = CSS_PARSER.parse(node.attr(STYLE_ATTR));
            CSS_PARSER.setStyle(cssProperties, context.style);
            context.cssProperties.putAll(cssProperties);
        }
    }

    private MList createHeading(MList parent, Context context, Element element, int fontSize) {
        MList res = this.createMParagraph(context, parent, element, null, null);
        context.style.setFontSize(fontSize);
        this.setModifiers(context.style, 1);
        return res;
    }

    private MImage createMImage(Context context, Element element) {
        URI imageURI = URI.createURI((String)element.attr("src")).resolve(context.baseURI);
        MImageImpl mImage = new MImageImpl(this.uriConverter, imageURI);
        if (element.hasAttr(WIDTH_ATTR)) {
            if (element.hasAttr(HEIGHT_ATTR)) {
                mImage.setConserveRatio(false);
                mImage.setWidth(Integer.valueOf(element.attr(WIDTH_ATTR)).intValue());
                mImage.setHeight(Integer.valueOf(element.attr(HEIGHT_ATTR)).intValue());
            } else {
                mImage.setWidth(Integer.valueOf(element.attr(WIDTH_ATTR)).intValue());
            }
        } else if (element.hasAttr(HEIGHT_ATTR)) {
            mImage.setHeight(Integer.valueOf(element.attr(HEIGHT_ATTR)).intValue());
        }
        return mImage;
    }

    private void setUnorderedListNumbering(Context context, Element element) {
        STNumberFormat.Enum type;
        String symbol;
        String typeAttr = element.attr(TYPE_ATTR);
        if ("disc".equals(typeAttr) || CSS_PARSER.hasCSS(context.cssProperties, "list-style-type", "disc")) {
            symbol = DISC_SYMBOL;
            type = STNumberFormat.BULLET;
        } else if ("square".equals(typeAttr) || CSS_PARSER.hasCSS(context.cssProperties, "list-style-type", "square")) {
            symbol = SQUARE_SYMBOL;
            type = STNumberFormat.BULLET;
        } else if ("circle".equals(typeAttr) || CSS_PARSER.hasCSS(context.cssProperties, "list-style-type", "circle")) {
            symbol = CIRCLE_SYMBOL;
            type = STNumberFormat.BULLET;
        } else if (!CSS_PARSER.hasCSS(context.cssProperties, "list-style-type", "none")) {
            symbol = DISC_SYMBOL;
            type = STNumberFormat.BULLET;
        } else {
            symbol = "";
            type = STNumberFormat.NONE;
        }
        if (context.numbering == null) {
            this.createNumbering(context);
        }
        this.incrementNumberingLevel(context, type, 1L, symbol, false);
    }

    private void setOrderedListNumbering(Context context, Element element) {
        String typeStr = element.hasAttr(TYPE_ATTR) ? element.attr(TYPE_ATTR) : null;
        STNumberFormat.Enum type = "1".equals(typeStr) || CSS_PARSER.hasCSS(context.cssProperties, "list-style-type", "decimal") ? STNumberFormat.DECIMAL : ("A".equals(typeStr) || CSS_PARSER.hasCSS(context.cssProperties, "list-style-type", "upper-alpha") ? STNumberFormat.UPPER_LETTER : ("a".equals(typeStr) || CSS_PARSER.hasCSS(context.cssProperties, "list-style-type", "lower-alpha") ? STNumberFormat.LOWER_LETTER : ("I".equals(typeStr) || CSS_PARSER.hasCSS(context.cssProperties, "list-style-type", "upper-roman") ? STNumberFormat.UPPER_ROMAN : ("i".equals(typeStr) || CSS_PARSER.hasCSS(context.cssProperties, "list-style-type", "lower-roman") ? STNumberFormat.LOWER_ROMAN : (!CSS_PARSER.hasCSS(context.cssProperties, "list-style-type", "none") ? STNumberFormat.DECIMAL : STNumberFormat.NONE)))));
        long start = element.hasAttr("start") ? Long.valueOf(element.attr("start")) : 1L;
        boolean reversed = element.hasAttr("reversed");
        if (context.numbering == null) {
            this.createNumbering(context);
        }
        this.incrementNumberingLevel(context, type, start, "", reversed);
    }

    private void createNumbering(Context context) {
        XWPFNumbering numbering = this.destinationDocument.createNumbering();
        CTNumbering ctNumbering = PaginationServices.getCTNumbering((XWPFNumbering)numbering);
        CTAbstractNum res = ctNumbering.addNewAbstractNum();
        res.addNewMultiLevelType().setVal(STMultiLevelType.HYBRID_MULTILEVEL);
        BigInteger id = BigInteger.valueOf(ctNumbering.sizeOfAbstractNumArray() - 1);
        res.setAbstractNumId(id);
        CTNum ctNum = ctNumbering.addNewNum();
        ctNum.setNumId(BigInteger.valueOf(ctNumbering.sizeOfNumArray()));
        ctNum.addNewAbstractNumId().setVal(id);
        context.numbering = res;
        context.numberingID = ctNum.getNumId();
    }

    private void incrementNumberingLevel(Context context, STNumberFormat.Enum type, long start, String symbol, boolean reversed) {
        if ((long)context.numbering.getLvlList().size() <= context.numberingLevel) {
            CTLvl level = context.numbering.addNewLvl();
            level.setIlvl(BigInteger.valueOf(context.numberingLevel));
            CTDecimalNumber strt = level.addNewStart();
            strt.setVal(BigInteger.valueOf(start));
            CTNumFmt fmt = level.addNewNumFmt();
            fmt.setVal(type);
            CTLevelText text = level.addNewLvlText();
            if (type == STNumberFormat.BULLET) {
                text.setVal(symbol);
                CTFonts font = level.addNewRPr().addNewRFonts();
                if (symbol == DISC_SYMBOL) {
                    font.setAscii(SYMBOL_FONT);
                    font.setHAnsi(SYMBOL_FONT);
                } else if (symbol == SQUARE_SYMBOL) {
                    font.setAscii(WINGDINGS_FONT);
                    font.setHAnsi(WINGDINGS_FONT);
                } else if (symbol == DISC_SYMBOL) {
                    font.setAscii(COURIER_NEW_FONT);
                    font.setHAnsi(COURIER_NEW_FONT);
                }
                level.addNewLvlJc().setVal(STJc.LEFT);
                CTInd indentation = level.addNewPPr().addNewInd();
                indentation.setHanging(BigInteger.valueOf(360L));
                indentation.setLeft(BigInteger.valueOf(720L * (context.numberingLevel + 1L)));
            } else {
                CTInd indentation = level.addNewPPr().addNewInd();
                if (type == STNumberFormat.NONE) {
                    text.setVal("%" + (context.numberingLevel + 1L));
                } else {
                    text.setVal("%" + (context.numberingLevel + 1L) + ".");
                }
                if (context.numberingLevel > 0L) {
                    level.setTentative(STOnOff.X_1);
                }
                if (type == STNumberFormat.UPPER_ROMAN) {
                    level.addNewLvlJc().setVal(STJc.RIGHT);
                    indentation.setHanging(BigInteger.valueOf(360L));
                } else if (type == STNumberFormat.LOWER_ROMAN) {
                    level.addNewLvlJc().setVal(STJc.RIGHT);
                    indentation.setHanging(BigInteger.valueOf(180L));
                } else {
                    level.addNewLvlJc().setVal(STJc.LEFT);
                    indentation.setHanging(BigInteger.valueOf(360L));
                }
                indentation.setLeft(BigInteger.valueOf(720L * (context.numberingLevel + 1L)));
            }
        }
        context.numberingLevel = context.numberingLevel + 1L;
    }

    private MList createMParagraph(Context context, MList parent, Element element, Long numberingID, Long numberingLevel) {
        MListImpl res = new MListImpl();
        MParagraphImpl paragraph = new MParagraphImpl((MElement)res, null);
        parent.add((Object)paragraph);
        paragraph.setNumberingID(numberingID);
        paragraph.setNumberingLevel(numberingLevel);
        if (element != null && element.hasAttr("align")) {
            String align = element.attr("align");
            if ("left".equals(align)) {
                paragraph.setHAlignment(MElementContainer.HAlignment.LEFT);
            } else if ("right".equals(align)) {
                paragraph.setHAlignment(MElementContainer.HAlignment.RIGHT);
            } else if ("center".equals(align)) {
                paragraph.setHAlignment(MElementContainer.HAlignment.CENTER);
            } else if ("justify".equals(align)) {
                paragraph.setHAlignment(MElementContainer.HAlignment.DISTRIBUTE);
            }
        }
        if (context.dir == Context.Dir.LTR) {
            paragraph.setTextDirection(MParagraph.Dir.LTR);
        } else if (context.dir == Context.Dir.RTL) {
            paragraph.setTextDirection(MParagraph.Dir.RTL);
        } else {
            paragraph.setTextDirection(null);
        }
        CSS_PARSER.setStyle(context.cssProperties, context, (MParagraph)paragraph);
        return res;
    }

    protected static final class Context {
        private final MStyle style;
        private CTAbstractNum numbering;
        private final URI baseURI;
        private URI linkTargetURI;
        private BigInteger numberingID;
        private long numberingLevel;
        private Dir dir;
        private final Map<String, List<String>> cssProperties = new HashMap<String, List<String>>();
        private Stack<Integer> marginLefts = new Stack();

        private Context(URI baseURI, MStyle style) {
            this.baseURI = baseURI;
            this.style = style;
        }

        private Context copy() {
            MStyleImpl mStyle = new MStyleImpl(this.style.getFontName(), this.style.getFontSize(), this.style.getForegroundColor(), this.style.getBackgroundColor(), this.style.getFontModifiers());
            Context res = new Context(this.baseURI, (MStyle)mStyle);
            res.linkTargetURI = this.linkTargetURI;
            res.numbering = this.numbering;
            res.numberingID = this.numberingID;
            res.numberingLevel = this.numberingLevel;
            res.dir = this.dir;
            res.cssProperties.putAll(this.cssProperties);
            res.marginLefts = this.marginLefts;
            return res;
        }

        public void pushMarginLeft(Integer value) {
            this.marginLefts.push(value);
        }

        public Integer popMarginLeft() {
            return this.marginLefts.pop();
        }

        public void replaceLastDefaultMarginLeft(Integer value) {
            if (this.marginLefts.peek() == null) {
                this.popMarginLeft();
                this.pushMarginLeft(value);
            }
        }

        public Integer getMarginLeft() {
            int sum = 0;
            boolean hasValue = false;
            for (Integer currentMarginLeft : this.marginLefts) {
                if (currentMarginLeft == null) continue;
                hasValue = true;
                sum += currentMarginLeft.intValue();
            }
            Integer res = hasValue ? Integer.valueOf(sum) : null;
            return res;
        }

        private static enum Dir {
            LTR,
            RTL;

        }
    }
}

