/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.genconf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.eclipse.acceleo.query.parser.AstValidator;
import org.eclipse.acceleo.query.runtime.CrossReferenceProvider;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IRootEObjectProvider;
import org.eclipse.acceleo.query.runtime.Query;
import org.eclipse.acceleo.query.runtime.impl.ValidationServices;
import org.eclipse.acceleo.query.validation.type.ClassType;
import org.eclipse.acceleo.query.validation.type.EClassifierType;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EStringToStringMapEntryImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.obeonetwork.m2doc.POIServices;
import org.obeonetwork.m2doc.genconf.BooleanDefinition;
import org.obeonetwork.m2doc.genconf.Definition;
import org.obeonetwork.m2doc.genconf.GenconfFactory;
import org.obeonetwork.m2doc.genconf.GenconfPackage;
import org.obeonetwork.m2doc.genconf.GenconfPlugin;
import org.obeonetwork.m2doc.genconf.Generation;
import org.obeonetwork.m2doc.genconf.IntegerDefinition;
import org.obeonetwork.m2doc.genconf.ModelDefinition;
import org.obeonetwork.m2doc.genconf.Option;
import org.obeonetwork.m2doc.genconf.RealDefinition;
import org.obeonetwork.m2doc.genconf.StringDefinition;
import org.obeonetwork.m2doc.generator.DocumentGenerationException;
import org.obeonetwork.m2doc.ide.M2DocPlugin;
import org.obeonetwork.m2doc.parser.DocumentParserException;
import org.obeonetwork.m2doc.parser.TemplateValidationMessage;
import org.obeonetwork.m2doc.parser.ValidationMessageLevel;
import org.obeonetwork.m2doc.properties.TemplateCustomProperties;
import org.obeonetwork.m2doc.template.DocumentTemplate;
import org.obeonetwork.m2doc.util.IClassProvider;
import org.obeonetwork.m2doc.util.M2DocUtils;

public final class GenconfUtils {
    public static final String GENCONF_EXTENSION_FILE = "genconf";
    public static final String GENCONF_URI_OPTION = "GenconfURI";

    static {
        M2DocPlugin.INSTANCE.getBaseURL();
    }

    private GenconfUtils() {
    }

    public static Map<String, String> getOptions(Generation generation) {
        LinkedHashMap<String, String> res = new LinkedHashMap<String, String>();
        Resource eResource = generation.eResource();
        if (eResource != null && eResource.getURI() != null) {
            res.put(GENCONF_URI_OPTION, eResource.getURI().toString());
        }
        if (generation.getTemplateFileName() != null) {
            res.put("TemplateURI", GenconfUtils.getResolvedURI(generation, URI.createURI((String)generation.getTemplateFileName(), (boolean)false)).toString());
        }
        if (generation.getResultFileName() != null) {
            res.put("ResultURI", GenconfUtils.getResolvedURI(generation, URI.createURI((String)generation.getResultFileName(), (boolean)false)).toString());
        }
        if (generation.getValidationFileName() != null) {
            res.put("ValidationURI", GenconfUtils.getResolvedURI(generation, URI.createURI((String)generation.getValidationFileName(), (boolean)false)).toString());
        }
        for (Option option : generation.getOptions()) {
            res.put(option.getName(), option.getValue());
        }
        return res;
    }

    public static void initializeOptions(Generation generation) {
        Map<String, String> options = GenconfUtils.getOptions(generation);
        Map initializedOptions = M2DocUtils.getInitializedOptions(options);
        for (Option option : generation.getOptions()) {
            if (!initializedOptions.containsKey(option.getName())) continue;
            option.setValue((String)initializedOptions.remove(option.getName()));
        }
        for (Map.Entry entry : initializedOptions.entrySet()) {
            Option option = GenconfPackage.eINSTANCE.getGenconfFactory().createOption();
            option.setName((String)entry.getKey());
            option.setValue((String)entry.getValue());
            generation.getOptions().add((Object)option);
        }
    }

    public static IQueryEnvironment getQueryEnvironment(ResourceSet resourceSetForModels, Generation generation) {
        URI templateURI = GenconfUtils.getResolvedURI(generation, URI.createURI((String)generation.getTemplateFileName(), (boolean)false));
        Map<String, String> options = GenconfUtils.getOptions(generation);
        IQueryEnvironment queryEnvironment = M2DocUtils.getQueryEnvironment((ResourceSet)resourceSetForModels, (URI)templateURI, options);
        return queryEnvironment;
    }

    public static IQueryEnvironment getQueryEnvironment(ResourceSet resourceSetForModels, CrossReferenceProvider crossReferenceProvider, IRootEObjectProvider rootProvider, Generation generation) {
        URI templateURI = GenconfUtils.getResolvedURI(generation, URI.createURI((String)generation.getTemplateFileName(), (boolean)false));
        Map<String, String> options = GenconfUtils.getOptions(generation);
        IQueryEnvironment queryEnvironment = M2DocUtils.getQueryEnvironment((ResourceSet)resourceSetForModels, (CrossReferenceProvider)crossReferenceProvider, (IRootEObjectProvider)rootProvider, (URI)templateURI, options);
        return queryEnvironment;
    }

    public static Map<String, Object> getVariables(Generation generation, ResourceSet resourceSetForModels) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Definition def : generation.getDefinitions()) {
            if (def instanceof ModelDefinition) {
                EObject val;
                block9: {
                    val = null;
                    EObject originalValue = ((ModelDefinition)def).getValue();
                    if (originalValue != null) {
                        URI uri = EcoreUtil.getURI((EObject)originalValue);
                        try {
                            val = resourceSetForModels.getEObject(uri, true);
                        }
                        catch (WrappedException e) {
                            if (originalValue == null) break block9;
                            InternalEObject eobj = (InternalEObject)EcoreUtil.create((EClass)originalValue.eClass());
                            eobj.eSetProxyURI(uri);
                            val = eobj;
                        }
                    }
                }
                result.put(((ModelDefinition)def).getKey(), val);
                continue;
            }
            if (def instanceof StringDefinition) {
                result.put(((StringDefinition)def).getKey(), ((StringDefinition)def).getValue());
                continue;
            }
            if (def instanceof IntegerDefinition) {
                result.put(((IntegerDefinition)def).getKey(), ((IntegerDefinition)def).getValue());
                continue;
            }
            if (def instanceof RealDefinition) {
                result.put(((RealDefinition)def).getKey(), ((RealDefinition)def).getValue());
                continue;
            }
            if (def instanceof BooleanDefinition) {
                result.put(((BooleanDefinition)def).getKey(), ((BooleanDefinition)def).isValue());
                continue;
            }
            throw new UnsupportedOperationException();
        }
        return result;
    }

    public static List<Definition> getOldDefinitions(Generation generation, TemplateCustomProperties templateCustomProperties) {
        ArrayList<Definition> oldDefinitions = new ArrayList<Definition>();
        IQueryEnvironment queryEnvironment = Query.newEnvironment();
        queryEnvironment.registerEPackage((EPackage)EcorePackage.eINSTANCE);
        queryEnvironment.registerCustomClassMapping((EClassifier)EcorePackage.eINSTANCE.getEStringToStringMapEntry(), EStringToStringMapEntryImpl.class);
        templateCustomProperties.configureQueryEnvironmentWithResult(queryEnvironment);
        AstValidator validator = new AstValidator(new ValidationServices((IReadOnlyQueryEnvironment)queryEnvironment));
        Map variablesTypes = templateCustomProperties.getVariableTypes(validator, (IReadOnlyQueryEnvironment)queryEnvironment);
        for (Definition definition : generation.getDefinitions()) {
            if (variablesTypes.containsKey(definition.getKey()) && GenconfUtils.isValidDefinitionForType((IReadOnlyQueryEnvironment)queryEnvironment, definition, (Set)variablesTypes.get(definition.getKey()))) continue;
            oldDefinitions.add(definition);
        }
        return oldDefinitions;
    }

    public static List<Definition> getNewDefinitions(Generation generation, TemplateCustomProperties templateCustomProperties) {
        IQueryEnvironment queryEnvironment = Query.newEnvironment();
        queryEnvironment.registerEPackage((EPackage)EcorePackage.eINSTANCE);
        queryEnvironment.registerCustomClassMapping((EClassifier)EcorePackage.eINSTANCE.getEStringToStringMapEntry(), EStringToStringMapEntryImpl.class);
        templateCustomProperties.configureQueryEnvironmentWithResult(queryEnvironment);
        AstValidator validator = new AstValidator(new ValidationServices((IReadOnlyQueryEnvironment)queryEnvironment));
        Map variablesTypes = templateCustomProperties.getVariableTypes(validator, (IReadOnlyQueryEnvironment)queryEnvironment);
        HashSet<String> existingVariables = new HashSet<String>();
        for (Definition definition : generation.getDefinitions()) {
            if (!variablesTypes.containsKey(definition.getKey()) || !GenconfUtils.isValidDefinitionForType((IReadOnlyQueryEnvironment)queryEnvironment, definition, (Set)variablesTypes.get(definition.getKey()))) continue;
            existingVariables.add(definition.getKey());
        }
        ArrayList<Definition> newDefinitions = new ArrayList<Definition>();
        for (Map.Entry entry : variablesTypes.entrySet()) {
            Definition newDefinition;
            if (existingVariables.contains(entry.getKey()) || (newDefinition = GenconfUtils.createDefinition((IReadOnlyQueryEnvironment)queryEnvironment, (String)entry.getKey(), (Set)entry.getValue())) == null) continue;
            newDefinitions.add(newDefinition);
        }
        return newDefinitions;
    }

    private static Definition createDefinition(IReadOnlyQueryEnvironment queryEnvironment, String name, Set<IType> types) {
        Definition res = null;
        ClassType eObjectType = new ClassType(queryEnvironment, EObject.class);
        ClassType stringType = new ClassType(queryEnvironment, String.class);
        for (IType type : types) {
            if (eObjectType.isAssignableFrom(type)) {
                res = GenconfPackage.eINSTANCE.getGenconfFactory().createModelDefinition();
                res.setKey(name);
                break;
            }
            if (!stringType.isAssignableFrom(type)) continue;
            res = GenconfPackage.eINSTANCE.getGenconfFactory().createStringDefinition();
            res.setKey(name);
            break;
        }
        return res;
    }

    private static boolean isValidDefinitionForType(IReadOnlyQueryEnvironment queryEnvironment, Definition definition, Set<IType> types) {
        boolean res = false;
        ClassType eObjectType = new ClassType(queryEnvironment, EObject.class);
        ClassType stringType = new ClassType(queryEnvironment, String.class);
        ClassType integerType = new ClassType(queryEnvironment, Integer.class);
        ClassType realType = new ClassType(queryEnvironment, Double.class);
        ClassType booleanType = new ClassType(queryEnvironment, Boolean.class);
        for (IType type : types) {
            if (eObjectType.isAssignableFrom(type) && definition instanceof ModelDefinition) {
                res = true;
                break;
            }
            if (stringType.isAssignableFrom(type) && definition instanceof StringDefinition) {
                res = true;
                break;
            }
            if (integerType.isAssignableFrom(type) && definition instanceof IntegerDefinition) {
                res = true;
                break;
            }
            if (realType.isAssignableFrom(type) && definition instanceof RealDefinition) {
                res = true;
                break;
            }
            if (!booleanType.isAssignableFrom(type) || !(definition instanceof BooleanDefinition)) continue;
            res = true;
            break;
        }
        return res;
    }

    public static List<URI> generate(Generation generation, IClassProvider classProvider, Monitor monitor) throws DocumentGenerationException, IOException, DocumentParserException {
        if (generation == null) {
            throw new IllegalArgumentException("Null configuration object passed.");
        }
        String templateFilePath = generation.getTemplateFileName();
        if (templateFilePath == null) {
            throw new DocumentGenerationException("The template file path isn't set in the provided configuration");
        }
        String resultFilePath = generation.getResultFileName();
        if (resultFilePath == null) {
            throw new DocumentGenerationException("The result file path isn't set in the provided configuration");
        }
        URI templateURI = GenconfUtils.getResolvedURI(generation, URI.createURI((String)generation.getTemplateFileName(), (boolean)false));
        URI generatedURI = GenconfUtils.getResolvedURI(generation, URI.createURI((String)generation.getResultFileName(), (boolean)false));
        URI validationURI = generation.getValidationFileName() != null && !generation.getValidationFileName().isEmpty() ? GenconfUtils.getResolvedURI(generation, URI.createURI((String)generation.getValidationFileName(), (boolean)false)) : null;
        return GenconfUtils.generate(generation, classProvider, templateURI, generatedURI, validationURI, monitor);
    }

    public static URI getResolvedURI(Generation generation, URI uri) {
        URI res = generation.eResource() != null && generation.eResource().getURI() != null ? uri.resolve(generation.eResource().getURI()) : uri;
        return res;
    }

    private static List<URI> generate(Generation generation, IClassProvider classProvider, URI templateURI, URI generatedURI, URI validationURI, Monitor monitor) throws IOException, DocumentParserException, DocumentGenerationException {
        ArrayList exceptions = new ArrayList();
        Map<String, String> options = GenconfUtils.getOptions(generation);
        ResourceSet resourceSetForModels = M2DocUtils.createResourceSetForModels(exceptions, (Object)generation, (ResourceSet)new ResourceSetImpl(), options);
        URIConverter uriConverter = resourceSetForModels.getURIConverter();
        IQueryEnvironment queryEnvironment = GenconfUtils.getQueryEnvironment(resourceSetForModels, generation);
        if (!uriConverter.exists(templateURI, Collections.EMPTY_MAP)) {
            throw new DocumentGenerationException("The template doest not exist " + templateURI);
        }
        Throwable throwable = null;
        Object var12_13 = null;
        try (DocumentTemplate documentTemplate = M2DocUtils.parse((URIConverter)uriConverter, (URI)templateURI, (IQueryEnvironment)queryEnvironment, (IClassProvider)classProvider, (Monitor)monitor);){
            Map<String, Object> definitions = GenconfUtils.getVariables(generation, resourceSetForModels);
            URI resultValidationURI = GenconfUtils.validate(uriConverter, generatedURI, validationURI, documentTemplate, (IReadOnlyQueryEnvironment)queryEnvironment, monitor);
            boolean updateFields = Boolean.valueOf(options.get("UpdateFields"));
            M2DocUtils.generate((DocumentTemplate)documentTemplate, (IReadOnlyQueryEnvironment)queryEnvironment, definitions, (ResourceSet)resourceSetForModels, (URI)generatedURI, (boolean)updateFields, (Monitor)monitor);
            ArrayList<URI> generatedURIs = new ArrayList<URI>();
            generatedURIs.add(generatedURI);
            if (resultValidationURI != null) {
                generatedURIs.add(resultValidationURI);
            }
            M2DocUtils.cleanResourceSetForModels((Object)generation, (ResourceSet)resourceSetForModels);
            return generatedURIs;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static boolean validate(Generation generation, IClassProvider classProvider, Monitor monitor) throws IOException, DocumentParserException, DocumentGenerationException {
        boolean res;
        ArrayList exceptions = new ArrayList();
        ResourceSet resourceSetForModel = M2DocUtils.createResourceSetForModels(exceptions, (Object)generation, (ResourceSet)new ResourceSetImpl(), GenconfUtils.getOptions(generation));
        IQueryEnvironment queryEnvironment = GenconfUtils.getQueryEnvironment(resourceSetForModel, generation);
        String templateFilePath = generation.getTemplateFileName();
        if (templateFilePath == null || templateFilePath.isEmpty()) {
            throw new DocumentGenerationException("The template file path isn't set in the provided configuration");
        }
        URI templateURI = GenconfUtils.getResolvedURI(generation, URI.createURI((String)templateFilePath, (boolean)false));
        if (!resourceSetForModel.getURIConverter().exists(templateURI, Collections.EMPTY_MAP)) {
            throw new DocumentGenerationException("The template file does not exist " + templateFilePath);
        }
        String validationFilePath = generation.getValidationFileName();
        URI validationURI = validationFilePath == null || validationFilePath.isEmpty() ? null : GenconfUtils.getResolvedURI(generation, URI.createURI((String)validationFilePath, (boolean)false));
        Throwable throwable = null;
        Object var12_12 = null;
        try (DocumentTemplate documentTemplate = M2DocUtils.parse((URIConverter)resourceSetForModel.getURIConverter(), (URI)templateURI, (IQueryEnvironment)queryEnvironment, (IClassProvider)classProvider, (Monitor)monitor);){
            XWPFRun run = (XWPFRun)((XWPFParagraph)documentTemplate.getDocument().getParagraphs().get(0)).getRuns().get(0);
            for (Exception e : exceptions) {
                documentTemplate.getBody().getValidationMessages().add((Object)new TemplateValidationMessage(ValidationMessageLevel.ERROR, e.getMessage(), run));
            }
            res = GenconfUtils.validate(resourceSetForModel.getURIConverter(), templateURI, validationURI, documentTemplate, (IReadOnlyQueryEnvironment)queryEnvironment, monitor) != null;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        String outputPath = generation.getResultFileName();
        if (outputPath == null || outputPath.isEmpty()) {
            throw new DocumentGenerationException("The output path isn't set in the provided configuration");
        }
        URI outputURI = GenconfUtils.getResolvedURI(generation, URI.createURI((String)outputPath, (boolean)false));
        if (resourceSetForModel.getURIConverter().exists(outputURI, Collections.EMPTY_MAP)) {
            HashMap options = new HashMap();
            LinkedHashSet<String> attributs = new LinkedHashSet<String>();
            attributs.add("directory");
            attributs.add("readOnly");
            options.put("requestedAttributes", attributs);
            Map attributeValues = resourceSetForModel.getURIConverter().getAttributes(outputURI, options);
            if (((Boolean)attributeValues.get("directory")).booleanValue()) {
                throw new DocumentGenerationException("The output path is a folder");
            }
            if (((Boolean)attributeValues.get("readOnly")).booleanValue()) {
                throw new DocumentGenerationException("The output path is read only");
            }
        }
        M2DocUtils.cleanResourceSetForModels((Object)generation, (ResourceSet)resourceSetForModel);
        return res;
    }

    private static URI validate(URIConverter uriConverter, URI generatedURI, URI validationURI, DocumentTemplate documentTemplate, IReadOnlyQueryEnvironment queryEnvironment, Monitor monitor) throws DocumentGenerationException, IOException {
        URI res;
        ValidationMessageLevel validationLevel = M2DocUtils.validate((DocumentTemplate)documentTemplate, (IReadOnlyQueryEnvironment)queryEnvironment, (Monitor)monitor);
        if (validationLevel != ValidationMessageLevel.OK) {
            res = validationURI != null ? validationURI : GenconfUtils.getValidationLogFile(generatedURI, validationLevel);
            M2DocUtils.serializeValidatedDocumentTemplate((URIConverter)uriConverter, (DocumentTemplate)documentTemplate, (URI)res);
        } else {
            res = null;
        }
        return res;
    }

    private static URI getValidationLogFile(URI generatedURI, ValidationMessageLevel level) {
        String lastSegmentNoExtension = generatedURI.lastSegment().replaceFirst("[.][^.]+$", "");
        URI uri = generatedURI.trimSegments(1).appendSegment(String.valueOf(lastSegmentNoExtension) + "-" + level.name().toLowerCase());
        URI res = URI.validSegment((String)generatedURI.fileExtension()) ? uri.appendFileExtension(generatedURI.fileExtension()) : uri;
        return res;
    }

    public static Resource createConfigurationModel(URIConverter uriConverter, URI templateURI) throws IOException {
        Resource resource = null;
        TemplateCustomProperties templateProperties = POIServices.getInstance().getTemplateCustomProperties(uriConverter, templateURI);
        if (templateProperties != null) {
            resource = GenconfUtils.createConfigurationModel(templateProperties, templateURI);
        }
        return resource;
    }

    private static Resource createResource(URI templateFile, URI genConfURI) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.createResource(genConfURI);
        return resource;
    }

    private static Resource createConfigurationModel(TemplateCustomProperties templateProperties, URI templateURI) {
        URI genConfURI = templateURI.trimFileExtension().appendFileExtension(GENCONF_EXTENSION_FILE);
        Resource resource = GenconfUtils.createResource(templateURI, genConfURI);
        Generation generation = GenconfUtils.createInitialModel(genConfURI.trimFileExtension().lastSegment(), templateURI.deresolve(genConfURI).toString());
        List<Definition> definitions = GenconfUtils.getNewDefinitions(generation, templateProperties);
        generation.getDefinitions().addAll(definitions);
        if (generation != null) {
            resource.getContents().add((Object)generation);
        }
        try {
            GenconfUtils.saveResource(resource);
        }
        catch (IOException e) {
            GenconfPlugin.INSTANCE.log(new Status(4, "org.obeonetwork.m2doc.genconf", 4, e.getMessage(), (Throwable)e));
        }
        try {
            GenconfUtils.saveResource(resource);
        }
        catch (IOException e) {
            GenconfPlugin.INSTANCE.log(new Status(4, "org.obeonetwork.m2doc.genconf", 4, e.getMessage(), (Throwable)e));
        }
        return resource;
    }

    private static Generation createInitialModel(String name, String templateFileName) {
        Generation generation = GenconfFactory.eINSTANCE.createGeneration();
        generation.setName(URI.decode((String)name));
        generation.setTemplateFileName(URI.decode((String)templateFileName));
        return generation;
    }

    private static void saveResource(Resource resource) throws IOException {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("ENCODING", "UTF-8");
        resource.save(options);
    }

    public static Option getOrCreateOption(Generation generation, String name) {
        Option res;
        Option foundOption = null;
        for (Option option : generation.getOptions()) {
            if (!name.equals(option.getName())) continue;
            foundOption = option;
            break;
        }
        if (foundOption != null) {
            res = foundOption;
        } else {
            res = GenconfPackage.eINSTANCE.getGenconfFactory().createOption();
            res.setName(name);
            generation.getOptions().add((Object)res);
        }
        return res;
    }

    public static List<String> getAvailableOptionNames(Generation generation) {
        List availableOptions = M2DocUtils.getPossibleOptionNames();
        for (Option option : generation.getOptions()) {
            availableOptions.remove(option.getName());
        }
        return availableOptions;
    }

    public static void initializeVariableDefinition(Generation generation, IReadOnlyQueryEnvironment queryEnvironment, TemplateCustomProperties properties, ResourceSet resourceSetForModels) {
        AstValidator validator = new AstValidator(new ValidationServices(queryEnvironment));
        HashMap<ModelDefinition, Set> toInitialilize = new HashMap<ModelDefinition, Set>();
        for (Definition definition : generation.getDefinitions()) {
            if (!(definition instanceof ModelDefinition) || ((ModelDefinition)definition).getValue() != null) continue;
            ModelDefinition modelDefinition = (ModelDefinition)definition;
            Set possibleTypes = properties.getVariableTypes(validator, queryEnvironment, (String)properties.getVariables().get(modelDefinition.getKey()));
            toInitialilize.put(modelDefinition, possibleTypes);
        }
        TreeIterator it = resourceSetForModels.getAllContents();
        while (!toInitialilize.isEmpty() && it.hasNext()) {
            Notifier notifier = (Notifier)it.next();
            if (!(notifier instanceof EObject)) continue;
            EObject element = (EObject)notifier;
            EClassifierType elementType = new EClassifierType(queryEnvironment, (EClassifier)element.eClass());
            ModelDefinition initialized = null;
            for (Map.Entry entry : toInitialilize.entrySet()) {
                for (IType definitionType : (Set)entry.getValue()) {
                    if (!definitionType.isAssignableFrom((IType)elementType)) continue;
                    initialized = (ModelDefinition)entry.getKey();
                    initialized.setValue(element);
                }
            }
            if (initialized == null) continue;
            toInitialilize.remove(initialized);
        }
    }

    public static Generation getGeneration(URI uri) {
        EObject root;
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource modelResource = rs.getResource(uri, true);
        if (modelResource != null && !modelResource.getContents().isEmpty() && (root = (EObject)modelResource.getContents().get(0)) instanceof Generation) {
            return (Generation)root;
        }
        return null;
    }
}

