/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.generator;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.poi.xwpf.usermodel.IBody;
import org.apache.poi.xwpf.usermodel.IRunBody;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.impl.xb.xmlschema.SpaceAttribute;
import org.obeonetwork.m2doc.generator.GenerationResult;
import org.obeonetwork.m2doc.parser.ValidationMessageLevel;
import org.obeonetwork.m2doc.util.M2DocUtils;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTBookmark;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTMarkupRange;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTText;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STFldCharType;

public class BookmarkManager {
    private static final int BUFFER_SIZE = 16;
    private static final String REF_TAG = " REF %s \\h ";
    private final Map<String, CTBookmark> bookmarks = new LinkedHashMap<String, CTBookmark>();
    private final Map<String, CTBookmark> startedBookmarks = new LinkedHashMap<String, CTBookmark>();
    private final Map<String, Set<CTText>> pendingReferences = new HashMap<String, Set<CTText>>();
    private final Map<XmlObject, String> xmlObjectToName = new HashMap<XmlObject, String>();
    private final Map<String, byte[]> referenceIDs = new HashMap<String, byte[]>();
    private final Map<XmlObject, XWPFRun> messagePositions = new HashMap<XmlObject, XWPFRun>();

    public void startBookmark(GenerationResult result, XWPFParagraph paragraph, String name) {
        if (this.bookmarks.containsKey(name)) {
            result.addMessage(M2DocUtils.appendMessageRun(paragraph, ValidationMessageLevel.ERROR, "Can't start duplicated bookmark " + name));
        } else {
            CTBookmark bookmark = paragraph.getCTP().addNewBookmarkStart();
            this.messagePositions.put((XmlObject)bookmark, paragraph.createRun());
            bookmark.setName(name);
            BigInteger id = this.getRandomID();
            bookmark.setId(id);
            this.bookmarks.put(name, bookmark);
            this.xmlObjectToName.put((XmlObject)bookmark, name);
            this.startedBookmarks.put(name, bookmark);
            Set<CTText> pendingRefs = this.pendingReferences.remove(name);
            if (pendingRefs != null) {
                for (CTText pendingRef : pendingRefs) {
                    this.xmlObjectToName.remove(pendingRef);
                    XWPFRun run = this.messagePositions.get(pendingRef);
                    IRunBody parent = run.getParent();
                    if (!(parent instanceof XWPFParagraph)) {
                        throw new IllegalStateException("this should not happend");
                    }
                    ((XWPFParagraph)parent).removeRun(((XWPFParagraph)parent).getRuns().indexOf(run));
                    pendingRef.setStringValue(String.format(REF_TAG, bookmark.getName()));
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void endBookmark(GenerationResult result, XWPFParagraph paragraph, String name) {
        CTBookmark bookmark = this.startedBookmarks.remove(name);
        if (bookmark != null) {
            CTMarkupRange range = paragraph.getCTP().addNewBookmarkEnd();
            range.setId(this.bookmarks.get(name).getId());
            XWPFRun run = this.messagePositions.get(bookmark);
            IRunBody parent = run.getParent();
            if (!(parent instanceof XWPFParagraph)) throw new IllegalStateException("this should not happend");
            ((XWPFParagraph)parent).removeRun(((XWPFParagraph)parent).getRuns().indexOf(run));
            return;
        } else if (this.bookmarks.containsKey(name)) {
            result.addMessage(M2DocUtils.appendMessageRun(paragraph, ValidationMessageLevel.ERROR, "Can't end already closed bookmark " + name));
            return;
        } else {
            result.addMessage(M2DocUtils.appendMessageRun(paragraph, ValidationMessageLevel.ERROR, "Can't end not existing bookmark " + name));
        }
    }

    private BigInteger getRandomID() {
        UUID uuid = UUID.randomUUID();
        ByteBuffer buffer = ByteBuffer.wrap(new byte[16]);
        buffer.putLong(uuid.getMostSignificantBits());
        buffer.putLong(uuid.getLeastSignificantBits());
        return new BigInteger(buffer.array()).abs();
    }

    public void insertReference(XWPFParagraph paragraph, String name, String text) {
        CTBookmark bookmark = this.bookmarks.get(name);
        if (bookmark != null) {
            this.insertReference(paragraph, bookmark, text);
        } else {
            XWPFRun messageRun = paragraph.createRun();
            CTText ref = this.insertPendingReference(paragraph, name, text);
            ref.setStringValue(String.format(REF_TAG, name));
            this.messagePositions.put((XmlObject)ref, messageRun);
            Set<CTText> pendingRefs = this.pendingReferences.get(name);
            if (pendingRefs == null) {
                pendingRefs = new LinkedHashSet<CTText>();
                this.pendingReferences.put(name, pendingRefs);
            }
            pendingRefs.add(ref);
            this.xmlObjectToName.put((XmlObject)ref, name);
        }
    }

    private void insertReference(XWPFParagraph paragraph, CTBookmark bookmark, String text) {
        String name = bookmark.getName();
        CTText pendingCTText = this.insertPendingReference(paragraph, name, text);
        pendingCTText.setStringValue(String.format(REF_TAG, name));
    }

    private CTText insertPendingReference(XWPFParagraph paragraph, String name, String text) {
        byte[] id = this.getReferenceID(name);
        XWPFRun beginRun = paragraph.createRun();
        beginRun.getCTR().setRsidR(id);
        beginRun.getCTR().addNewFldChar().setFldCharType(STFldCharType.BEGIN);
        XWPFRun preservedRun = paragraph.createRun();
        preservedRun.getCTR().setRsidR(id);
        CTText pgcttext = preservedRun.getCTR().addNewInstrText();
        pgcttext.setSpace(SpaceAttribute.Space.PRESERVE);
        XWPFRun separateRun = paragraph.createRun();
        separateRun.getCTR().setRsidR(id);
        separateRun.getCTR().addNewFldChar().setFldCharType(STFldCharType.SEPARATE);
        XWPFRun textRun = paragraph.createRun();
        textRun.getCTR().setRsidR(id);
        textRun.getCTR().addNewRPr().addNewNoProof();
        textRun.setText(text);
        textRun.setBold(true);
        XWPFRun endRun = paragraph.createRun();
        endRun.getCTR().setRsidR(id);
        endRun.getCTR().addNewFldChar().setFldCharType(STFldCharType.END);
        return pgcttext;
    }

    private byte[] getReferenceID(String name) {
        byte[] res;
        byte[] cachedID = this.referenceIDs.get(name);
        if (cachedID == null) {
            res = this.getRandomID().toByteArray();
            this.referenceIDs.put(name, res);
        } else {
            res = cachedID;
        }
        return res;
    }

    public boolean markOpenBookmarks(GenerationResult result) {
        boolean res;
        boolean bl = res = !this.startedBookmarks.isEmpty();
        if (res) {
            for (Map.Entry<String, CTBookmark> entry : this.startedBookmarks.entrySet()) {
                XWPFRun positionRun = this.messagePositions.remove(entry.getValue());
                result.addMessage(M2DocUtils.setRunMessage(positionRun, ValidationMessageLevel.ERROR, "unclosed bookmark " + entry.getKey()));
            }
        }
        return res;
    }

    public boolean markDanglingReferences(GenerationResult result) {
        boolean res;
        boolean bl = res = !this.pendingReferences.isEmpty();
        if (res) {
            for (Map.Entry<String, Set<CTText>> entry : this.pendingReferences.entrySet()) {
                for (CTText ref : entry.getValue()) {
                    XWPFRun refRun = this.messagePositions.remove(ref);
                    result.addMessage(M2DocUtils.insertMessageAfter(refRun, ValidationMessageLevel.ERROR, "dangling reference for bookmark " + entry.getKey()));
                }
            }
        }
        return res;
    }

    public <T extends XmlObject> void updateXmlObject(T newObject, T oldObject, IBody outputBoby) {
        XWPFRun run;
        String name = this.xmlObjectToName.remove(oldObject);
        if (name != null) {
            this.xmlObjectToName.put(newObject, name);
            if (this.bookmarks.get(name) == oldObject) {
                this.bookmarks.put(name, (CTBookmark)newObject);
                if (this.startedBookmarks.get(name) == oldObject) {
                    this.startedBookmarks.put(name, (CTBookmark)newObject);
                }
                newObject.validate();
            } else {
                Set<CTText> refs = this.pendingReferences.get(name);
                if (refs != null && refs.contains(oldObject)) {
                    refs.remove(oldObject);
                    refs.add((CTText)newObject);
                    newObject.validate();
                }
            }
        }
        if ((run = this.messagePositions.remove(oldObject)) != null) {
            XWPFRun newRun = outputBoby.getParagraphs().size() > 0 ? ((XWPFParagraph)outputBoby.getParagraphs().get(0)).createRun() : null;
            this.messagePositions.put(newObject, newRun);
        }
    }

    public void reset() {
        this.bookmarks.clear();
        this.startedBookmarks.clear();
        this.pendingReferences.clear();
        this.xmlObjectToName.clear();
        this.referenceIDs.clear();
        this.messagePositions.clear();
    }
}

