/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.net4j.protocol;

import java.io.IOException;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.lock.IDurableLockingManager;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientProtocol;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenViewRequest
extends CDOClientRequest<CDOBranchPoint> {
    private int viewID;
    private boolean readOnly;
    private CDOBranchPoint branchPoint;
    private String durableLockingID;

    public OpenViewRequest(CDOClientProtocol protocol, int viewID, boolean readOnly, CDOBranchPoint branchPoint) {
        super(protocol, (short)3);
        this.viewID = viewID;
        this.readOnly = readOnly;
        this.branchPoint = branchPoint;
    }

    public OpenViewRequest(CDOClientProtocol protocol, int viewID, boolean readOnly, String durableLockingID) {
        super(protocol, (short)3);
        this.viewID = viewID;
        this.readOnly = readOnly;
        this.durableLockingID = durableLockingID;
    }

    @Override
    protected void requesting(CDODataOutput out) throws IOException {
        out.writeXInt(this.viewID);
        out.writeBoolean(this.readOnly);
        if (this.branchPoint != null) {
            out.writeBoolean(true);
            out.writeCDOBranchPoint(this.branchPoint);
        } else {
            out.writeBoolean(false);
            out.writeString(this.durableLockingID);
        }
    }

    @Override
    protected CDOBranchPoint confirming(CDODataInput in) throws IOException {
        if (in.readBoolean()) {
            return in.readCDOBranchPoint();
        }
        if (this.durableLockingID != null) {
            String message = in.readString();
            if (message != null) {
                throw new IllegalStateException(message);
            }
            throw new IDurableLockingManager.LockAreaNotFoundException(this.durableLockingID);
        }
        return null;
    }
}

