/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.ui.refactoring.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptorProxy;
import org.eclipse.ltk.internal.core.refactoring.history.RefactoringHistoryService;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIPlugin;
import org.eclipse.ltk.internal.ui.refactoring.model.ModelMessages;
import org.eclipse.ltk.internal.ui.refactoring.model.RefactoringDescriptorSynchronizationProxy;
import org.eclipse.team.core.mapping.IMergeContext;
import org.eclipse.team.core.mapping.ISynchronizationContext;
import org.eclipse.ui.PlatformUI;

public final class RejectRefactoringsAction
extends Action {
    private final ISynchronizationContext fContext;
    private RefactoringDescriptorProxy[] fProxies = null;

    public RejectRefactoringsAction(ISynchronizationContext context) {
        Assert.isNotNull((Object)context);
        this.fContext = context;
        this.setText(ModelMessages.RejectRefactoringsAction_title);
        this.setToolTipText(ModelMessages.RejectRefactoringsAction_tool_tip);
        this.setDescription(ModelMessages.RejectRefactoringsAction_description);
    }

    public boolean isEnabled() {
        if (this.fProxies != null && this.fProxies.length > 0 && this.fContext instanceof IMergeContext) {
            RefactoringDescriptorProxy[] refactoringDescriptorProxyArray = this.fProxies;
            int n = this.fProxies.length;
            int n2 = 0;
            while (n2 < n) {
                RefactoringDescriptorSynchronizationProxy proxy;
                RefactoringDescriptorProxy fproxy = refactoringDescriptorProxyArray[n2];
                if (fproxy instanceof RefactoringDescriptorSynchronizationProxy && (proxy = (RefactoringDescriptorSynchronizationProxy)fproxy).getDirection() == 512) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public void run() {
        if (this.fProxies != null) {
            try {
                PlatformUI.getWorkbench().getProgressService().run(true, true, new IRunnableWithProgress(){

                    public final void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            monitor.beginTask("", RejectRefactoringsAction.this.fProxies.length + 100);
                            RefactoringHistoryService service = RefactoringHistoryService.getInstance();
                            RefactoringDescriptorProxy[] refactoringDescriptorProxyArray = RejectRefactoringsAction.this.fProxies;
                            int n = refactoringDescriptorProxyArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                RefactoringDescriptorProxy proxy = refactoringDescriptorProxyArray[n2];
                                service.addRefactoringDescriptor(proxy, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                ++n2;
                            }
                        }
                        finally {
                            monitor.done();
                        }
                    }
                });
            }
            catch (InvocationTargetException exception) {
                RefactoringUIPlugin.log(exception);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void setRefactoringDescriptors(RefactoringDescriptorProxy[] proxies) {
        Assert.isNotNull((Object)proxies);
        this.fProxies = proxies;
    }
}

