/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.xwpf.usermodel.IBody;
import org.apache.poi.xwpf.usermodel.IBodyElement;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFFooter;
import org.apache.poi.xwpf.usermodel.XWPFHeader;
import org.apache.poi.xwpf.usermodel.XWPFHeaderFooter;
import org.apache.poi.xwpf.usermodel.XWPFHyperlinkRun;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.obeonetwork.m2doc.properties.TemplateCustomProperties;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTFldChar;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTHyperlink;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTP;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTR;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSimpleField;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTbl;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STOnOff;

public final class POIServices {
    private static final POIServices INSTANCE = new POIServices();

    private POIServices() {
    }

    public static POIServices getInstance() {
        return INSTANCE;
    }

    public XWPFDocument getXWPFDocument(URIConverter uriConverter, URI templateURI) throws IOException {
        OPCPackage oPackage = this.getOPCPackage(uriConverter, templateURI);
        XWPFDocument document = new XWPFDocument(oPackage);
        return document;
    }

    private OPCPackage getOPCPackage(URIConverter uriConverter, URI templateURI) throws IOException {
        OPCPackage oPackage;
        Throwable throwable = null;
        Object var5_5 = null;
        try (InputStream is = uriConverter.createInputStream(templateURI);){
            try {
                oPackage = OPCPackage.open((InputStream)is);
            }
            catch (InvalidFormatException e) {
                throw new IllegalArgumentException("Couldn't open template file", e);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return oPackage;
    }

    public TemplateCustomProperties getTemplateCustomProperties(URIConverter uriConverter, URI templateURI) throws IOException {
        TemplateCustomProperties res;
        Throwable throwable = null;
        Object var5_5 = null;
        try (XWPFDocument document = this.getXWPFDocument(uriConverter, templateURI);){
            res = new TemplateCustomProperties(document);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return res;
    }

    public void saveFile(URIConverter uriConverter, XWPFDocument document, URI theDestinationURI) throws IOException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (OutputStream os = uriConverter.createOutputStream(theDestinationURI);){
            document.write(os);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void markFieldsAsDirty(IBody body) {
        if (body instanceof XWPFDocument) {
            XWPFDocument document = (XWPFDocument)body;
            for (XWPFHeader header : document.getHeaderList()) {
                this.markFieldsAsDirty((IBody)header);
            }
            for (XWPFFooter footer : document.getFooterList()) {
                this.markFieldsAsDirty((IBody)footer);
            }
        }
        for (IBodyElement element : body.getBodyElements()) {
            this.markFieldsAsDirty(element);
        }
    }

    public void markFieldsAsDirty(IBodyElement element) {
        block10: {
            block9: {
                if (!(element instanceof XWPFParagraph)) break block9;
                XWPFParagraph paragraph = (XWPFParagraph)element;
                CTP ctp = paragraph.getCTP();
                if (ctp != null) {
                    for (CTSimpleField field : ctp.getFldSimpleList()) {
                        field.setDirty(STOnOff.TRUE);
                    }
                }
                for (XWPFRun run : paragraph.getRuns()) {
                    CTR ctr = run.getCTR();
                    if (ctr == null) continue;
                    for (CTFldChar field : ctr.getFldCharList()) {
                        field.setDirty(STOnOff.TRUE);
                    }
                    if (!(run instanceof XWPFHyperlinkRun)) continue;
                    CTHyperlink ctHyperlink = ((XWPFHyperlinkRun)run).getCTHyperlink();
                    for (CTSimpleField field : ctHyperlink.getFldSimpleList()) {
                        field.setDirty(STOnOff.TRUE);
                    }
                    for (CTR ctrHyperlink : ctHyperlink.getRList()) {
                        for (CTFldChar field : ctrHyperlink.getFldCharList()) {
                            field.setDirty(STOnOff.TRUE);
                        }
                    }
                }
                break block10;
            }
            if (!(element instanceof XWPFTable)) break block10;
            XWPFTable table = (XWPFTable)element;
            for (XWPFTableRow row : table.getRows()) {
                for (XWPFTableCell cell : row.getTableCells()) {
                    this.markFieldsAsDirty((IBody)cell);
                }
            }
        }
    }

    public XWPFTable createTable(IBody body) {
        XWPFTable res;
        if (body instanceof XWPFDocument) {
            XWPFDocument document = (XWPFDocument)body;
            CTTbl cttbl = document.getDocument().getBody().addNewTbl();
            res = new XWPFTable(cttbl, (IBody)document);
            if (res.getRows().size() > 0) {
                res.removeRow(0);
            }
            document.insertTable(body.getBodyElements().size(), res);
        } else if (body instanceof XWPFHeaderFooter) {
            XWPFHeaderFooter headerFooter = (XWPFHeaderFooter)body;
            CTTbl cttbl = headerFooter._getHdrFtr().addNewTbl();
            res = new XWPFTable(cttbl, (IBody)headerFooter);
            if (res.getRows().size() > 0) {
                res.removeRow(0);
            }
            headerFooter.insertTable(body.getBodyElements().size(), res);
        } else if (body instanceof XWPFTableCell) {
            XWPFTableCell tCell = (XWPFTableCell)body;
            CTTbl tbl = tCell.getCTTc().addNewTbl();
            res = new XWPFTable(tbl, (IBody)tCell);
            if (res.getRows().size() > 0) {
                res.removeRow(0);
            }
            tCell.insertTable(body.getBodyElements().size(), res);
        } else {
            throw new UnsupportedOperationException("unknown type of IBody : " + body.getClass());
        }
        return res;
    }
}

