/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedHashSet;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackagingURIHelper;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EcorePackage;
import org.obeonetwork.m2doc.properties.TemplateCustomProperties;

public class SampleTemplateGenerator {
    private static final String VARIABLE_NAME_TAG = "VARIABLE_NAME";
    private static final String FEATURE_NAME_TAG = "FEATURE_NAME";
    private static final int BUFFER_SIZE = 8192;

    public XWPFDocument generate(String variableName, EClass eCls) throws InvalidFormatException, IOException {
        InputStream partIS22;
        InputStream is = SampleTemplateGenerator.class.getResourceAsStream("/resources/sampleTemplate.docx");
        OPCPackage pkg = OPCPackage.open((InputStream)is);
        String featureName = ((EAttribute)eCls.getEAllAttributes().get(0)).getName();
        for (EAttribute attribute : eCls.getEAllAttributes()) {
            if (attribute.getEType() != EcorePackage.eINSTANCE.getEString()) continue;
            featureName = attribute.getName();
            break;
        }
        StringBuilder builder = new StringBuilder();
        byte[] buffer = new byte[8192];
        PackagePart part = pkg.getPart(PackagingURIHelper.createPartName((String)"/word/document.xml"));
        Throwable throwable = null;
        Throwable throwable2 = null;
        try {
            partIS22 = part.getInputStream();
            try {
                int nbBytes = partIS22.read(buffer);
                while (nbBytes != -1) {
                    builder.append(new String(buffer, 0, nbBytes));
                    nbBytes = partIS22.read(buffer);
                }
            }
            finally {
                if (partIS22 != null) {
                    partIS22.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        String xml = builder.toString().replace(VARIABLE_NAME_TAG, variableName);
        xml = xml.replace(FEATURE_NAME_TAG, featureName);
        throwable2 = null;
        partIS22 = null;
        try (OutputStream partOS = part.getOutputStream();){
            partOS.write(xml.getBytes("UTF-8"));
        }
        catch (Throwable partIS22) {
            if (throwable2 == null) {
                throwable2 = partIS22;
            } else if (throwable2 != partIS22) {
                throwable2.addSuppressed(partIS22);
            }
            throw throwable2;
        }
        XWPFDocument res = new XWPFDocument(pkg);
        TemplateCustomProperties customProperties = new TemplateCustomProperties(res);
        customProperties.setM2DocVersion("3.2.2");
        customProperties.getVariables().put(variableName, String.valueOf(eCls.getEPackage().getName()) + "::" + eCls.getName());
        LinkedHashSet<String> packages = new LinkedHashSet<String>();
        packages.add(eCls.getEPackage().getNsURI());
        for (EClass superCls : eCls.getEAllSuperTypes()) {
            packages.add(superCls.getEPackage().getNsURI());
        }
        customProperties.getPackagesURIs().addAll(packages);
        customProperties.save();
        return res;
    }
}

