/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.html.services;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.obeonetwork.m2doc.element.MParagraph;
import org.obeonetwork.m2doc.element.MStyle;
import org.obeonetwork.m2doc.html.services.M2DocHTMLParser;
import org.obeonetwork.m2doc.html.services.Parser;

public class M2DocCSSParser
extends Parser {
    protected static final String CSS_COLOR = "color";
    protected static final String CSS_BACKGROUND_COLOR = "background-color";
    protected static final String CSS_LIST_STYLE_TYPE = "list-style-type";
    protected static final String CSS_TEXT_ALIGN = "text-align";
    protected static final String CSS_TEXT_TRANSFORM = "text-transform";
    protected static final String CSS_VERTICAL_ALIGN = "vertical-align";
    protected static final String CSS_TEXT_DECORATION = "text-decoration";
    protected static final String CSS_FONT_STYLE = "font-style";
    protected static final String CSS_FONT_WEIGHT = "font-weight";
    protected static final String CSS_MARGIN_LEFT = "margin-left";
    private static final String FIELD_SEPARATOR = ";";
    private static final String VALUE_SEPARATOR = ":";
    private static final int ALL_FONT_MODIFIERS_MASK = -1;

    public Map<String, List<String>> parse(String cssStyle) {
        HashMap<String, List<String>> res = new HashMap<String, List<String>>();
        String[] stringArray = cssStyle.split(FIELD_SEPARATOR);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String field = stringArray[n2];
            String[] keyValue = field.split(VALUE_SEPARATOR);
            if (keyValue.length >= 1 && !keyValue[0].trim().isEmpty()) {
                List values = res.computeIfAbsent(keyValue[0].trim().toLowerCase(), key -> new ArrayList());
                if (keyValue.length == 2) {
                    values.add(keyValue[1].trim().toLowerCase());
                }
            }
            ++n2;
        }
        return res;
    }

    public void setStyle(Map<String, List<String>> cssProperties, MStyle mStyle) {
        List<String> cssVerticalAligns;
        List<String> cssFontWeights;
        List<String> cssFontStyles;
        List<String> cssTextDecorations;
        int modifiers;
        List<String> cssBackgroundColors;
        List<String> cssColors = cssProperties.get(CSS_COLOR);
        if (cssColors != null) {
            for (String cssColor : cssColors) {
                mStyle.setForegroundColor(this.htmlToColor(cssColor));
            }
        }
        if ((cssBackgroundColors = cssProperties.get(CSS_BACKGROUND_COLOR)) != null) {
            for (String cssBackgroundColor : cssBackgroundColors) {
                mStyle.setBackgroundColor(this.htmlToColor(cssBackgroundColor));
            }
        }
        if ((modifiers = mStyle.getFontModifiers()) == -1) {
            modifiers = 0;
        }
        if ((cssTextDecorations = cssProperties.get(CSS_TEXT_DECORATION)) != null) {
            for (String cssTextDecoration : cssTextDecorations) {
                if ("line-through".equals(cssTextDecoration)) {
                    modifiers |= 8;
                    continue;
                }
                if (!"underline".equals(cssTextDecoration)) continue;
                modifiers |= 4;
            }
        }
        if ((cssFontStyles = cssProperties.get(CSS_FONT_STYLE)) != null) {
            for (String cssFontStyle : cssFontStyles) {
                if ("italic".equals(cssFontStyle) || "oblique".equals(cssFontStyle)) {
                    modifiers |= 2;
                    continue;
                }
                if (!"normal".equals(cssFontStyle)) continue;
                modifiers &= 0xFFFFFFFD;
            }
        }
        if ((cssFontWeights = cssProperties.get(CSS_FONT_WEIGHT)) != null) {
            for (String cssFontWeight : cssFontWeights) {
                if ("bold".equals(cssFontWeight)) {
                    modifiers |= 1;
                    continue;
                }
                if (!"normal".equals(cssFontWeight) && !"lighter".equals(cssFontWeight)) continue;
                modifiers &= 0xFFFFFFFE;
            }
        }
        if ((cssVerticalAligns = cssProperties.get(CSS_VERTICAL_ALIGN)) != null) {
            for (String cssVerticalAlign : cssVerticalAligns) {
                if ("sub".equals(cssVerticalAlign)) {
                    modifiers |= 0x10;
                    continue;
                }
                if (!"super".equals(cssVerticalAlign)) continue;
                modifiers |= 0x20;
            }
        }
        mStyle.setModifiers(modifiers);
    }

    public boolean hasCSS(Map<String, List<String>> cssProperties, String propertyName, String propertyValue) {
        boolean res = false;
        List<String> values = cssProperties.get(propertyName);
        if (values != null) {
            for (String value : values) {
                if (!value.equals(propertyValue)) continue;
                res = true;
                break;
            }
        }
        return res;
    }

    public void setStyle(Map<String, List<String>> cssProperties, M2DocHTMLParser.Context context, MParagraph paragraph) {
        Integer marginLeft;
        List<String> cssMarginLefts = cssProperties.get(CSS_MARGIN_LEFT);
        if (cssMarginLefts != null) {
            int value = -1;
            for (String cssMarginLeft : cssMarginLefts) {
                value = this.getPixels(cssMarginLeft);
            }
            if (value != -1) {
                context.replaceLastDefaultMarginLeft(value);
            }
        }
        if ((marginLeft = context.getMarginLeft()) != null) {
            paragraph.setMarginLeft(marginLeft.intValue());
        }
    }
}

