/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.resolver;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.osgi.framework.util.ArrayMap;
import org.eclipse.osgi.internal.container.ComputeNodeOrder;
import org.eclipse.osgi.internal.resolver.BaseDescriptionImpl;
import org.eclipse.osgi.internal.resolver.BundleDescriptionImpl;
import org.eclipse.osgi.internal.resolver.ImportsHolder;
import org.eclipse.osgi.internal.resolver.RequiresHolder;
import org.eclipse.osgi.internal.resolver.StateImpl;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.GenericDescription;
import org.eclipse.osgi.service.resolver.GenericSpecification;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.NativeCodeSpecification;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateHelper;
import org.eclipse.osgi.service.resolver.VersionConstraint;
import org.osgi.framework.hooks.resolver.ResolverHook;
import org.osgi.framework.hooks.resolver.ResolverHookFactory;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRevision;

public final class StateHelperImpl
implements StateHelper {
    private static final StateHelper instance = new StateHelperImpl();

    public BundleDescription[] getDependentBundles(BundleDescription[] bundles) {
        if (bundles == null || bundles.length == 0) {
            return new BundleDescription[0];
        }
        LinkedHashSet<BundleDescription> reachable = new LinkedHashSet<BundleDescription>(bundles.length);
        BundleDescription[] bundleDescriptionArray = bundles;
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            BundleDescription bundle = bundleDescriptionArray[n2];
            if (bundle.isResolved()) {
                this.addDependentBundles(bundle, reachable);
            }
            ++n2;
        }
        return reachable.toArray(new BundleDescription[reachable.size()]);
    }

    private void addDependentBundles(BundleDescription bundle, Set<BundleDescription> reachable) {
        BundleDescription[] dependents;
        if (reachable.contains(bundle)) {
            return;
        }
        reachable.add(bundle);
        BundleDescription[] bundleDescriptionArray = dependents = bundle.getDependents();
        int n = dependents.length;
        int n2 = 0;
        while (n2 < n) {
            BundleDescription dependent = bundleDescriptionArray[n2];
            this.addDependentBundles(dependent, reachable);
            ++n2;
        }
    }

    public BundleDescription[] getPrerequisites(BundleDescription[] bundles) {
        if (bundles == null || bundles.length == 0) {
            return new BundleDescription[0];
        }
        LinkedHashSet<BundleDescription> reachable = new LinkedHashSet<BundleDescription>(bundles.length);
        BundleDescription[] bundleDescriptionArray = bundles;
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            BundleDescription bundle = bundleDescriptionArray[n2];
            this.addPrerequisites(bundle, reachable);
            ++n2;
        }
        return reachable.toArray(new BundleDescription[reachable.size()]);
    }

    private void addPrerequisites(BundleDescription bundle, Set<BundleDescription> reachable) {
        BundleDescription[] dependencies;
        if (reachable.contains(bundle)) {
            return;
        }
        reachable.add(bundle);
        List<BundleDescription> depList = ((BundleDescriptionImpl)bundle).getBundleDependencies();
        BundleDescription[] bundleDescriptionArray = dependencies = depList.toArray(new BundleDescription[depList.size()]);
        int n = dependencies.length;
        int n2 = 0;
        while (n2 < n) {
            BundleDescription dependency = bundleDescriptionArray[n2];
            this.addPrerequisites(dependency, reachable);
            ++n2;
        }
    }

    private Map<String, List<ExportPackageDescription>> getExportedPackageMap(State state) {
        BundleDescription[] bundles;
        HashMap<String, List<ExportPackageDescription>> result = new HashMap<String, List<ExportPackageDescription>>();
        BundleDescription[] bundleDescriptionArray = bundles = state.getBundles();
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            ExportPackageDescription[] packages;
            BundleDescription bundle = bundleDescriptionArray[n2];
            ExportPackageDescription[] exportPackageDescriptionArray = packages = bundle.getExportPackages();
            int n3 = packages.length;
            int n4 = 0;
            while (n4 < n3) {
                ExportPackageDescription description = exportPackageDescriptionArray[n4];
                ArrayList<ExportPackageDescription> exports = (ArrayList<ExportPackageDescription>)result.get(description.getName());
                if (exports == null) {
                    exports = new ArrayList<ExportPackageDescription>();
                    result.put(description.getName(), exports);
                }
                exports.add(description);
                ++n4;
            }
            ++n2;
        }
        return result;
    }

    private Map<String, List<GenericDescription>> getGenericsMap(State state, boolean resolved) {
        BundleDescription[] bundles;
        HashMap<String, List<GenericDescription>> result = new HashMap<String, List<GenericDescription>>();
        BundleDescription[] bundleDescriptionArray = bundles = state.getBundles();
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            BundleDescription bundle = bundleDescriptionArray[n2];
            if (!resolved || bundle.isResolved()) {
                GenericDescription[] generics;
                GenericDescription[] genericDescriptionArray = generics = bundle.getGenericCapabilities();
                int n3 = generics.length;
                int n4 = 0;
                while (n4 < n3) {
                    GenericDescription description = genericDescriptionArray[n4];
                    ArrayList<GenericDescription> genericList = (ArrayList<GenericDescription>)result.get(description.getName());
                    if (genericList == null) {
                        genericList = new ArrayList<GenericDescription>(1);
                        result.put(description.getName(), genericList);
                    }
                    genericList.add(description);
                    ++n4;
                }
            }
            ++n2;
        }
        return result;
    }

    private VersionConstraint[] getUnsatisfiedLeaves(State state, BundleDescription[] bundles, ResolverHook hook) {
        Map<String, List<ExportPackageDescription>> packages = this.getExportedPackageMap(state);
        Map<String, List<GenericDescription>> generics = this.getGenericsMap(state, false);
        HashSet<VersionConstraint> result = new HashSet<VersionConstraint>();
        ArrayList<BundleDescription> bundleList = new ArrayList<BundleDescription>(bundles.length);
        Collections.addAll(bundleList, bundles);
        int i = 0;
        while (i < bundleList.size()) {
            VersionConstraint[] constraints;
            BundleDescription description = (BundleDescription)bundleList.get(i);
            VersionConstraint[] versionConstraintArray = constraints = this.getUnsatisfiedConstraints(description, hook);
            int n = constraints.length;
            int n2 = 0;
            while (n2 < n) {
                List<GenericDescription> genericSet;
                VersionConstraint constraint = versionConstraintArray[n2];
                List<BaseDescription> satisfied = null;
                if (constraint instanceof BundleSpecification || constraint instanceof HostSpecification) {
                    BundleDescription[] suppliers = state.getBundles(constraint.getName());
                    satisfied = this.getPossibleCandidates(constraint, (BaseDescription[])suppliers, constraint instanceof HostSpecification ? "osgi.wiring.host" : null, hook, false);
                } else if (constraint instanceof ImportPackageSpecification) {
                    List<ExportPackageDescription> exports = packages.get(constraint.getName());
                    if (exports != null) {
                        satisfied = this.getPossibleCandidates(constraint, exports.toArray(new BaseDescription[exports.size()]), null, hook, false);
                    }
                } else if (constraint instanceof GenericSpecification && (genericSet = generics.get(constraint.getName())) != null) {
                    satisfied = this.getPossibleCandidates(constraint, genericSet.toArray(new BaseDescription[genericSet.size()]), null, hook, false);
                }
                if (satisfied == null || satisfied.isEmpty()) {
                    result.add(constraint);
                } else {
                    for (BaseDescription baseDescription : satisfied) {
                        if (baseDescription.getSupplier().isResolved() || bundleList.contains(baseDescription.getSupplier())) continue;
                        bundleList.add(baseDescription.getSupplier());
                        break;
                    }
                }
                ++n2;
            }
            ++i;
        }
        return result.toArray(new VersionConstraint[result.size()]);
    }

    public VersionConstraint[] getUnsatisfiedLeaves(BundleDescription[] bundles) {
        if (bundles.length == 0) {
            return new VersionConstraint[0];
        }
        State state = bundles[0].getContainingState();
        ResolverHook hook = this.beginHook(state, Arrays.asList(bundles));
        try {
            VersionConstraint[] versionConstraintArray = this.getUnsatisfiedLeaves(state, bundles, hook);
            return versionConstraintArray;
        }
        finally {
            if (hook != null) {
                hook.end();
            }
        }
    }

    private ResolverHook beginHook(State state, Collection<BundleRevision> triggers) {
        if (!(state instanceof StateImpl)) {
            return null;
        }
        ResolverHookFactory hookFactory = ((StateImpl)state).getResolverHookFactory();
        return hookFactory == null ? null : hookFactory.begin(triggers);
    }

    public VersionConstraint[] getUnsatisfiedConstraints(BundleDescription bundle) {
        ResolverHook hook = this.beginHook(bundle.getContainingState(), Arrays.asList(bundle));
        try {
            VersionConstraint[] versionConstraintArray = this.getUnsatisfiedConstraints(bundle, hook);
            return versionConstraintArray;
        }
        finally {
            if (hook != null) {
                hook.end();
            }
        }
    }

    private VersionConstraint[] getUnsatisfiedConstraints(BundleDescription bundle, ResolverHook hook) {
        GenericSpecification[] generics;
        ImportPackageSpecification[] packages;
        BundleSpecification[] requiredBundles;
        State containingState = bundle.getContainingState();
        if (containingState == null) {
            throw new IllegalStateException("Does not belong to a state");
        }
        ArrayList<Object> unsatisfied = new ArrayList<Object>();
        HostSpecification host = bundle.getHost();
        if (host != null && !host.isResolved() && !this.isBundleConstraintResolvable((VersionConstraint)host, "osgi.wiring.host", hook)) {
            unsatisfied.add(host);
        }
        BundleSpecification[] bundleSpecificationArray = requiredBundles = bundle.getRequiredBundles();
        int n = requiredBundles.length;
        int n2 = 0;
        while (n2 < n) {
            BundleSpecification requiredBundle = bundleSpecificationArray[n2];
            if (!requiredBundle.isResolved() && !this.isBundleConstraintResolvable((VersionConstraint)requiredBundle, null, hook)) {
                unsatisfied.add(requiredBundle);
            }
            ++n2;
        }
        ImportPackageSpecification[] importPackageSpecificationArray = packages = bundle.getImportPackages();
        int n3 = packages.length;
        n = 0;
        while (n < n3) {
            ImportPackageSpecification importSpecification = importPackageSpecificationArray[n];
            if (!(importSpecification.isResolved() || this.isResolvable(importSpecification, hook) || bundle.isResolved() && !"optional".equals(importSpecification.getDirective("resolution")))) {
                unsatisfied.add(importSpecification);
            }
            ++n;
        }
        GenericSpecification[] genericSpecificationArray = generics = bundle.getGenericRequires();
        int n4 = generics.length;
        n3 = 0;
        while (n3 < n4) {
            GenericSpecification generic = genericSpecificationArray[n3];
            if (!generic.isResolved() && !this.isResolvable(generic, hook)) {
                unsatisfied.add(generic);
            }
            ++n3;
        }
        NativeCodeSpecification nativeCode = bundle.getNativeCodeSpecification();
        if (nativeCode != null && !nativeCode.isResolved()) {
            unsatisfied.add(nativeCode);
        }
        return unsatisfied.toArray(new VersionConstraint[unsatisfied.size()]);
    }

    private ArrayMap<BundleCapability, BaseDescription> asArrayMap(List<BaseDescription> descriptions, String namespace) {
        ArrayList<BundleCapability> capabilities = new ArrayList<BundleCapability>(descriptions.size());
        for (BaseDescription description : descriptions) {
            capabilities.add(((BaseDescriptionImpl)description).getCapability(namespace));
        }
        return new ArrayMap(capabilities, descriptions);
    }

    private List<BaseDescription> getPossibleCandidates(VersionConstraint constraint, BaseDescription[] descriptions, String namespace, ResolverHook hook, boolean resolved) {
        ArrayList<BaseDescription> candidates = new ArrayList<BaseDescription>();
        BaseDescription[] baseDescriptionArray = descriptions;
        int n = descriptions.length;
        int n2 = 0;
        while (n2 < n) {
            BaseDescription description = baseDescriptionArray[n2];
            if ((!resolved || description.getSupplier().isResolved()) && constraint.isSatisfiedBy(description)) {
                candidates.add(description);
            }
            ++n2;
        }
        if (hook != null) {
            hook.filterMatches(constraint.getRequirement(), this.asArrayMap(candidates, namespace));
        }
        return candidates;
    }

    public boolean isResolvable(ImportPackageSpecification constraint) {
        ResolverHook hook = this.beginHook(constraint.getBundle().getContainingState(), Arrays.asList(constraint.getBundle()));
        try {
            boolean bl = this.isResolvable(constraint, hook);
            return bl;
        }
        finally {
            if (hook != null) {
                hook.end();
            }
        }
    }

    private boolean isResolvable(ImportPackageSpecification constraint, ResolverHook hook) {
        ExportPackageDescription[] exports = constraint.getBundle().getContainingState().getExportedPackages();
        return this.getPossibleCandidates((VersionConstraint)constraint, (BaseDescription[])exports, null, hook, true).size() > 0;
    }

    private boolean isResolvable(GenericSpecification constraint, ResolverHook hook) {
        Map<String, List<GenericDescription>> genericCapabilities = this.getGenericsMap(constraint.getBundle().getContainingState(), true);
        List<GenericDescription> genericList = genericCapabilities.get(constraint.getName());
        if (genericList == null) {
            return false;
        }
        return this.getPossibleCandidates((VersionConstraint)constraint, genericList.toArray(new BaseDescription[genericList.size()]), null, hook, true).size() > 0;
    }

    public boolean isResolvable(BundleSpecification specification) {
        return this.isBundleConstraintResolvable((VersionConstraint)specification, null);
    }

    public boolean isResolvable(HostSpecification specification) {
        return this.isBundleConstraintResolvable((VersionConstraint)specification, "osgi.wiring.host");
    }

    private boolean isBundleConstraintResolvable(VersionConstraint constraint, String namespace) {
        ResolverHook hook = this.beginHook(constraint.getBundle().getContainingState(), Arrays.asList(constraint.getBundle()));
        try {
            boolean bl = this.isBundleConstraintResolvable(constraint, namespace, hook);
            return bl;
        }
        finally {
            if (hook != null) {
                hook.end();
            }
        }
    }

    private boolean isBundleConstraintResolvable(VersionConstraint constraint, String namespace, ResolverHook hook) {
        BundleDescription[] availableBundles = constraint.getBundle().getContainingState().getBundles(constraint.getName());
        return this.getPossibleCandidates(constraint, (BaseDescription[])availableBundles, namespace, hook, true).size() > 0;
    }

    public Object[][] sortBundles(BundleDescription[] toSort) {
        ArrayList<Object[]> references = new ArrayList<Object[]>(toSort.length);
        BundleDescription[] bundleDescriptionArray = toSort;
        int n = toSort.length;
        int n2 = 0;
        while (n2 < n) {
            BundleDescription toAddReference = bundleDescriptionArray[n2];
            if (toAddReference.isResolved()) {
                this.buildReferences(toAddReference, references);
            }
            ++n2;
        }
        Object[][] cycles = ComputeNodeOrder.computeNodeOrder((Object[])toSort, (Object[][])((Object[][])references.toArray((T[])new Object[references.size()][])));
        if (cycles.length == 0) {
            return cycles;
        }
        Object[][] objectArray = cycles;
        int n3 = cycles.length;
        n = 0;
        while (n < n3) {
            Object[] cycle;
            Object[] objectArray2 = cycle = objectArray[n];
            int n4 = cycle.length;
            int n5 = 0;
            while (n5 < n4) {
                BundleDescription host;
                Object possibleFragment = objectArray2[n5];
                BundleDescription fragment = (BundleDescription)possibleFragment;
                if (fragment.getHost() != null && (host = (BundleDescription)fragment.getHost().getSupplier()) != null) {
                    this.fixFragmentOrder(host, fragment, toSort);
                }
                ++n5;
            }
            ++n;
        }
        return cycles;
    }

    private void fixFragmentOrder(BundleDescription host, BundleDescription fragment, BundleDescription[] toSort) {
        int hostIndex = -1;
        int fragIndex = -1;
        int i = 0;
        while (i < toSort.length && (hostIndex == -1 || fragIndex == -1)) {
            if (toSort[i] == host) {
                hostIndex = i;
            } else if (toSort[i] == fragment) {
                fragIndex = i;
            }
            ++i;
        }
        if (fragIndex > -1 && fragIndex < hostIndex) {
            i = fragIndex;
            while (i < hostIndex) {
                toSort[i] = toSort[i + 1];
                ++i;
            }
            toSort[hostIndex] = fragment;
        }
    }

    private void buildReferences(BundleDescription description, List<Object[]> references) {
        HostSpecification hostSpecification = description.getHost();
        if (hostSpecification != null) {
            int n;
            int n2;
            BundleDescription[] bundleDescriptionArray;
            if (hostSpecification.getHosts() != null) {
                BundleDescription[] hosts;
                bundleDescriptionArray = hosts = hostSpecification.getHosts();
                n2 = hosts.length;
                n = 0;
                while (n < n2) {
                    BundleDescription host = bundleDescriptionArray[n];
                    if (host != description) {
                        references.add(new Object[]{description, host});
                    }
                    ++n;
                }
            }
            GenericDescription[] genericDependencies = description.getResolvedGenericRequires();
            bundleDescriptionArray = genericDependencies;
            n2 = genericDependencies.length;
            n = 0;
            while (n < n2) {
                BundleDescription dependency = bundleDescriptionArray[n];
                if ("osgi.ee".equals(dependency.getType())) {
                    references.add(new Object[]{description, dependency.getSupplier()});
                }
                ++n;
            }
        } else {
            this.buildReferences(description, ((BundleDescriptionImpl)description).getBundleDependencies(), references);
        }
    }

    private void buildReferences(BundleDescription description, List<BundleDescription> dependencies, List<Object[]> references) {
        Iterator<BundleDescription> iter = dependencies.iterator();
        while (iter.hasNext()) {
            this.addReference(description, iter.next(), references);
        }
    }

    private void addReference(BundleDescription description, BundleDescription reference, List<Object[]> references) {
        BundleDescription[] fragments;
        if (description == reference || reference == null) {
            return;
        }
        BundleDescription[] bundleDescriptionArray = fragments = reference.getFragments();
        int n = fragments.length;
        int n2 = 0;
        while (n2 < n) {
            ExportPackageDescription[] exports;
            BundleDescription fragment = bundleDescriptionArray[n2];
            if (fragment.isResolved() && (exports = fragment.getExportPackages()).length > 0) {
                references.add(new Object[]{description, fragment});
            }
            ++n2;
        }
        references.add(new Object[]{description, reference});
    }

    public ExportPackageDescription[] getVisiblePackages(BundleDescription bundle) {
        return this.getVisiblePackages(bundle, 0);
    }

    public ExportPackageDescription[] getVisiblePackages(BundleDescription bundle, int options) {
        StateImpl state = (StateImpl)bundle.getContainingState();
        boolean strict = false;
        if (state != null) {
            strict = state.inStrictMode();
        }
        BundleDescription host = bundle.getHost() == null ? bundle : bundle.getHost().getSupplier();
        ArrayList<ExportPackageDescription> orderedPkgList = new ArrayList<ExportPackageDescription>();
        HashSet<ExportPackageDescription> pkgSet = new HashSet<ExportPackageDescription>();
        HashSet<String> importList = new HashSet<String>();
        ImportsHolder imports = new ImportsHolder(bundle, options);
        int i = 0;
        while (i < imports.getSize()) {
            ExportPackageDescription pkgSupplier = imports.getSupplier(i);
            if (pkgSupplier != null && pkgSupplier.getExporter() != host) {
                if (!this.isSystemExport(pkgSupplier, options) && !pkgSet.contains(pkgSupplier)) {
                    orderedPkgList.add(pkgSupplier);
                    pkgSet.add(pkgSupplier);
                }
                BundleSpecification[] requires = pkgSupplier.getExporter().getRequiredBundles();
                HashSet<BundleDescription> visited = new HashSet<BundleDescription>();
                visited.add(bundle);
                HashSet<String> importNames = new HashSet<String>(1);
                importNames.add(imports.getName(i));
                BundleSpecification[] bundleSpecificationArray = requires;
                int n = requires.length;
                int n2 = 0;
                while (n2 < n) {
                    BundleSpecification require = bundleSpecificationArray[n2];
                    BundleDescription bundleSupplier = (BundleDescription)require.getSupplier();
                    if (bundleSupplier != null) {
                        this.getPackages(bundleSupplier, bundle.getSymbolicName(), importList, orderedPkgList, pkgSet, visited, strict, importNames, options);
                    }
                    ++n2;
                }
                importList.add(imports.getName(i));
            }
            ++i;
        }
        RequiresHolder requires = new RequiresHolder(bundle, options);
        HashSet<BundleDescription> visited = new HashSet<BundleDescription>(requires.getSize());
        visited.add(bundle);
        int i2 = 0;
        while (i2 < requires.getSize()) {
            BundleDescription bundleSupplier = requires.getSupplier(i2);
            if (bundleSupplier != null) {
                this.getPackages(bundleSupplier, bundle.getSymbolicName(), importList, orderedPkgList, pkgSet, visited, strict, null, options);
            }
            ++i2;
        }
        return orderedPkgList.toArray(new ExportPackageDescription[orderedPkgList.size()]);
    }

    private void getPackages(BundleDescription requiredBundle, String symbolicName, Set<String> importList, List<ExportPackageDescription> orderedPkgList, Set<ExportPackageDescription> pkgSet, Set<BundleDescription> visited, boolean strict, Set<String> pkgNames, int options) {
        ExportPackageDescription substitutedExport;
        if (visited.contains(requiredBundle)) {
            return;
        }
        visited.add(requiredBundle);
        ExportPackageDescription[] substitutedExports = requiredBundle.getSubstitutedExports();
        ExportPackageDescription[] imports = requiredBundle.getResolvedImports();
        HashSet<String> substituteNames = null;
        ExportPackageDescription[] exportPackageDescriptionArray = substitutedExports;
        int n = substitutedExports.length;
        int n2 = 0;
        while (n2 < n) {
            substitutedExport = exportPackageDescriptionArray[n2];
            if (pkgNames == null || pkgNames.contains(substitutedExport.getName())) {
                ExportPackageDescription[] exportPackageDescriptionArray2 = imports;
                int n3 = imports.length;
                int n4 = 0;
                while (n4 < n3) {
                    ExportPackageDescription resolvedImport = exportPackageDescriptionArray2[n4];
                    if (substitutedExport.getName().equals(resolvedImport.getName()) && !pkgSet.contains(resolvedImport)) {
                        if (substituteNames == null) {
                            substituteNames = new HashSet<String>(1);
                        } else {
                            substituteNames.clear();
                        }
                        substituteNames.add(substitutedExport.getName());
                        this.getPackages(resolvedImport.getSupplier(), symbolicName, importList, orderedPkgList, pkgSet, new HashSet<BundleDescription>(0), strict, substituteNames, options);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        importList = substitutedExports.length == 0 ? importList : new HashSet<String>(importList);
        exportPackageDescriptionArray = substitutedExports;
        n = substitutedExports.length;
        n2 = 0;
        while (n2 < n) {
            substitutedExport = exportPackageDescriptionArray[n2];
            importList.add(substitutedExport.getName());
            ++n2;
        }
        ExportPackageDescription[] exports = requiredBundle.getSelectedExports();
        HashSet<String> exportNames = new HashSet<String>(exports.length);
        ExportPackageDescription[] exportPackageDescriptionArray3 = exports;
        int resolvedImport = exports.length;
        int n5 = 0;
        while (n5 < resolvedImport) {
            ExportPackageDescription export = exportPackageDescriptionArray3[n5];
            if (!(pkgNames != null && !pkgNames.contains(export.getName()) || this.isSystemExport(export, options) || !this.isFriend(symbolicName, export, strict) || importList.contains(export.getName()) || pkgSet.contains(export) || exportNames.contains(export.getName()))) {
                orderedPkgList.add(export);
                pkgSet.add(export);
                exportNames.add(export.getName());
            }
            ++n5;
        }
        RequiresHolder requiredBundles = new RequiresHolder(requiredBundle, options);
        int i = 0;
        while (i < requiredBundles.getSize()) {
            if (requiredBundles.getSupplier(i) != null) {
                if (requiredBundles.isExported(i)) {
                    this.getPackages(requiredBundles.getSupplier(i), symbolicName, importList, orderedPkgList, pkgSet, visited, strict, pkgNames, options);
                } else if (exportNames.size() > 0) {
                    HashSet<BundleDescription> tmpVisited = new HashSet<BundleDescription>();
                    this.getPackages(requiredBundles.getSupplier(i), symbolicName, importList, orderedPkgList, pkgSet, tmpVisited, strict, exportNames, options);
                }
            }
            ++i;
        }
    }

    private boolean isSystemExport(ExportPackageDescription export, int options) {
        if ((options & 1) != 0) {
            return false;
        }
        return (Integer)export.getDirective("x-equinox-ee") >= 0;
    }

    private boolean isFriend(String consumerBSN, ExportPackageDescription export, boolean strict) {
        if (!strict) {
            return true;
        }
        String[] friends = (String[])export.getDirective("x-friends");
        if (friends == null) {
            return true;
        }
        String[] stringArray = friends;
        int n = friends.length;
        int n2 = 0;
        while (n2 < n) {
            String friend = stringArray[n2];
            if (friend.equals(consumerBSN)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public int getAccessCode(BundleDescription bundle, ExportPackageDescription export) {
        if (((Boolean)export.getDirective("x-internal")).booleanValue()) {
            return 2;
        }
        if (!this.isFriend(bundle.getSymbolicName(), export, true)) {
            return 2;
        }
        return 1;
    }

    public static StateHelper getInstance() {
        return instance;
    }
}

