/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.ui.views;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.net4j.internal.util.bundle.OM;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.event.EventUtil;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.event.INotifier;
import org.eclipse.net4j.util.factory.ProductCreationException;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.net4j.util.ui.views.ValueFormatter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public abstract class IntrospectionProvider
implements Comparable<IntrospectionProvider> {
    public static final int DEFAULT_PRIORITY = 100;
    private static final List<ValueFormatter> FORMATTERS = new ArrayList<ValueFormatter>();
    private final String id;
    private final String label;

    static {
        IPluginContainer.INSTANCE.forEachElement("org.eclipse.net4j.util.ui.valueFormatters", ValueFormatter.class, FORMATTERS::add);
        FORMATTERS.sort(null);
    }

    public IntrospectionProvider(String id, String label) {
        this.id = id;
        this.label = label;
    }

    public int getPriority() {
        return 100;
    }

    public final String getId() {
        return this.id;
    }

    public final String getLabel() {
        return this.label;
    }

    public void open(Event selectionEvent, Object parent, Object element, Consumer<Object> introspector) {
        introspector.accept(element);
    }

    public void attachListener(TableViewer viewer, Object value) {
        if (value instanceof INotifier) {
            INotifier notifier = (INotifier)value;
            ValueListener listener = new ValueListener(viewer);
            notifier.addListener((IListener)listener);
        }
    }

    public void detachListener(TableViewer viewer, Object value) {
        EventUtil.removeListeners((Object)value, listener -> listener.getClass() == ValueListener.class);
    }

    public abstract boolean canHandle(Object var1);

    public TableViewer createViewer(Composite parent) {
        TableViewer viewer = new TableViewer(parent, 66306);
        viewer.getTable().setLayoutData((Object)UIUtil.createGridData());
        viewer.getTable().setHeaderVisible(true);
        viewer.getTable().setLinesVisible(true);
        return viewer;
    }

    public abstract void createColumns(TableViewer var1);

    public abstract Object[] getElements(Object var1) throws Exception;

    public abstract Object getElementByName(Object var1, String var2) throws Exception;

    public abstract NameAndValue getNameAndValue(Object var1) throws Exception;

    public abstract String getColumnText(Object var1, int var2) throws Exception;

    public Image getColumnImage(Object element, int index) throws Exception {
        return null;
    }

    public Color getForeground(Object element) {
        return null;
    }

    public Color getBackground(Object element) {
        return null;
    }

    public ViewerComparator getComparator() {
        return null;
    }

    @Override
    public final int compareTo(IntrospectionProvider o) {
        return Integer.compare(this.getPriority(), o.getPriority());
    }

    public final String toString() {
        return this.getLabel();
    }

    protected static TableColumn createColumn(TableViewer viewer, String name, int width) {
        Table table = viewer.getTable();
        int index = table.getColumnCount();
        TableColumn column = new TableColumn(table, 16384, index);
        column.setText(name);
        column.setWidth(width);
        column.setMoveable(true);
        column.setResizable(true);
        return column;
    }

    protected static String getClassName(Object value) {
        if (value == null) {
            return "";
        }
        Class<?> type = value.getClass();
        return IntrospectionProvider.getName(type);
    }

    protected static String getName(Class<?> type) {
        if (type.isArray()) {
            Class<?> componentType = type.getComponentType();
            return String.valueOf(IntrospectionProvider.getName(componentType)) + "[]";
        }
        return type.getName();
    }

    protected static String formatValue(Object value) {
        Class<?> valueClass;
        for (ValueFormatter formatter : FORMATTERS) {
            if (!formatter.canHandle(value)) continue;
            try {
                return formatter.formatValue(value);
            }
            catch (Exception ex) {
                OM.LOG.error((Throwable)ex);
            }
        }
        if (value != null && (valueClass = value.getClass()).isArray()) {
            if (valueClass == byte[].class) {
                return Arrays.toString((byte[])value);
            }
            if (valueClass == short[].class) {
                return Arrays.toString((short[])value);
            }
            if (valueClass == int[].class) {
                return Arrays.toString((int[])value);
            }
            if (valueClass == long[].class) {
                return Arrays.toString((long[])value);
            }
            if (valueClass == char[].class) {
                return Arrays.toString((char[])value);
            }
            if (valueClass == float[].class) {
                return Arrays.toString((float[])value);
            }
            if (valueClass == double[].class) {
                return Arrays.toString((double[])value);
            }
            if (valueClass == boolean[].class) {
                return Arrays.toString((boolean[])value);
            }
            return Arrays.deepToString((Object[])value);
        }
        return "" + value;
    }

    public static abstract class Factory
    extends org.eclipse.net4j.util.factory.Factory {
        public static final String PRODUCT_GROUP = "org.eclipse.net4j.util.ui.introspectionProviders";

        public Factory(String type) {
            super(PRODUCT_GROUP, type);
        }

        public abstract IntrospectionProvider create(String var1) throws ProductCreationException;
    }

    public static class NameAndValue {
        private final String name;
        private final Object value;

        public NameAndValue(String name, Object value) {
            this.name = name;
            this.value = value;
        }

        public NameAndValue(int index, Object value) {
            this(Integer.toString(index), value);
        }

        public NameAndValue(Map.Entry<?, ?> entry) {
            this("" + entry.getKey(), entry.getValue());
        }

        public String getName() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }

        public int hashCode() {
            return Objects.hash(this.name);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof NameAndValue)) {
                return false;
            }
            NameAndValue other = (NameAndValue)obj;
            return Objects.equals(this.name, other.name);
        }

        public String toString() {
            return String.valueOf(this.name) + "=" + this.value;
        }
    }

    private static final class ValueListener
    implements IListener {
        private final TableViewer viewer;

        public ValueListener(TableViewer viewer) {
            this.viewer = viewer;
        }

        public void notifyEvent(IEvent event) {
            UIUtil.refreshViewer((Viewer)this.viewer);
        }
    }
}

