/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.generator;

import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.CancellationException;
import org.apache.poi.ooxml.POIXMLDocumentPart;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.util.Units;
import org.apache.poi.xwpf.usermodel.BreakType;
import org.apache.poi.xwpf.usermodel.IBody;
import org.apache.poi.xwpf.usermodel.IRunBody;
import org.apache.poi.xwpf.usermodel.ParagraphAlignment;
import org.apache.poi.xwpf.usermodel.TableRowAlign;
import org.apache.poi.xwpf.usermodel.TableRowHeightRule;
import org.apache.poi.xwpf.usermodel.TableWidthType;
import org.apache.poi.xwpf.usermodel.UnderlinePatterns;
import org.apache.poi.xwpf.usermodel.VerticalAlign;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFFooter;
import org.apache.poi.xwpf.usermodel.XWPFFootnote;
import org.apache.poi.xwpf.usermodel.XWPFHeader;
import org.apache.poi.xwpf.usermodel.XWPFHeaderFooter;
import org.apache.poi.xwpf.usermodel.XWPFHyperlinkRun;
import org.apache.poi.xwpf.usermodel.XWPFNumbering;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRelation;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFSDT;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.eclipse.acceleo.query.runtime.EvaluationResult;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IQueryEvaluationEngine;
import org.eclipse.acceleo.query.runtime.impl.QueryEvaluationEngine;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.ecore.EObject;
import org.obeonetwork.m2doc.POIServices;
import org.obeonetwork.m2doc.element.MBookmark;
import org.obeonetwork.m2doc.element.MBorder;
import org.obeonetwork.m2doc.element.MElement;
import org.obeonetwork.m2doc.element.MElementContainer;
import org.obeonetwork.m2doc.element.MHyperLink;
import org.obeonetwork.m2doc.element.MImage;
import org.obeonetwork.m2doc.element.MList;
import org.obeonetwork.m2doc.element.MPagination;
import org.obeonetwork.m2doc.element.MParagraph;
import org.obeonetwork.m2doc.element.MStyle;
import org.obeonetwork.m2doc.element.MTable;
import org.obeonetwork.m2doc.element.MText;
import org.obeonetwork.m2doc.element.impl.AbosluteResizedImage;
import org.obeonetwork.m2doc.generator.BookmarkManager;
import org.obeonetwork.m2doc.generator.GenerationResult;
import org.obeonetwork.m2doc.generator.M2DocEvaluationEnvironment;
import org.obeonetwork.m2doc.generator.RawCopier;
import org.obeonetwork.m2doc.generator.UserContentManager;
import org.obeonetwork.m2doc.parser.TemplateValidationMessage;
import org.obeonetwork.m2doc.parser.TokenType;
import org.obeonetwork.m2doc.parser.ValidationMessageLevel;
import org.obeonetwork.m2doc.services.PaginationServices;
import org.obeonetwork.m2doc.template.Block;
import org.obeonetwork.m2doc.template.Bookmark;
import org.obeonetwork.m2doc.template.Cell;
import org.obeonetwork.m2doc.template.Comment;
import org.obeonetwork.m2doc.template.Conditional;
import org.obeonetwork.m2doc.template.ContentControl;
import org.obeonetwork.m2doc.template.DocumentTemplate;
import org.obeonetwork.m2doc.template.IConstruct;
import org.obeonetwork.m2doc.template.IGenerateable;
import org.obeonetwork.m2doc.template.Let;
import org.obeonetwork.m2doc.template.Link;
import org.obeonetwork.m2doc.template.Query;
import org.obeonetwork.m2doc.template.Repetition;
import org.obeonetwork.m2doc.template.Row;
import org.obeonetwork.m2doc.template.Statement;
import org.obeonetwork.m2doc.template.StaticFragment;
import org.obeonetwork.m2doc.template.Table;
import org.obeonetwork.m2doc.template.Template;
import org.obeonetwork.m2doc.template.UserContent;
import org.obeonetwork.m2doc.template.UserDoc;
import org.obeonetwork.m2doc.template.util.TemplateSwitch;
import org.obeonetwork.m2doc.util.FieldUtils;
import org.obeonetwork.m2doc.util.M2DocUtils;
import org.obeonetwork.m2doc.util.SequenceField;
import org.openxmlformats.schemas.officeDocument.x2006.sharedTypes.STOnOff;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTAbstractNum;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTHMerge;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTHdrFtr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTHyperlink;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTLvl;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTNum;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTNumbering;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTOnOff;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTP;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTR;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRow;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSdtBlock;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSectPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTShd;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSimpleField;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTbl;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTc;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTcPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTVMerge;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STFldCharType;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STMerge;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STShd;

public class M2DocEvaluator
extends TemplateSwitch<XWPFParagraph> {
    public static final int MONITOR_WORK = 30;
    private static final double UNIT_CONVERSION = 20.0;
    private static final int BORDER_SIZE_CONSTANT = 8;
    private static final String INVALID_BOOKMARK_STATEMENT = "Invalid bookmark statement: ";
    private static final String INVALID_CONDITIONAL_STATEMENT = "Invalid if statement: ";
    private static final String INVALID_BLOCK_STATEMENT = "Invalid block: ";
    private static final String INVALID_LET_STATEMENT = "Invalid let statement: ";
    private static final String INVALID_LINK_STATEMENT = "Invalid link statement: ";
    private static final String INVALID_QUERY_STATEMENT = "Invalid query statement: ";
    private static final String INVALID_REPETITION_STATEMENT = "Invalid for statement: ";
    private static final String INVALID_USERDOC_STATEMENT = "Invalid userDoc statement: ";
    private static final String AN_I_O_PROBLEM_OCCURED_WHILE_READING = "An I/O Problem occured while reading %s: %s.";
    private static final String PICTURE_INVALID_FORMAT = "Picture in %s has an invalid format: %s.";
    private static final FieldUtils FIELD_UTILS = new FieldUtils();
    private final BookmarkManager bookmarkManager;
    private final Stack<Map<String, Object>> variablesStack = new Stack();
    private IBody generatedDocument;
    private final RawCopier copier;
    private XWPFParagraph currentTemplateParagraph;
    private XWPFParagraph currentGeneratedParagraph;
    private XWPFTable currentGeneratedTable;
    private XWPFTableRow currentGeneratedRow;
    private boolean forceNewParagraph;
    private UserContentManager userContentManager;
    private Set<String> encountereduserDocIds = new HashSet<String>();
    private final IQueryEvaluationEngine evaluator;
    private GenerationResult result;
    private Monitor monitor;

    public M2DocEvaluator(M2DocEvaluationEnvironment m2docEnv, Monitor monitor) {
        this.bookmarkManager = m2docEnv.getBookmarkManager();
        this.userContentManager = m2docEnv.getUserContentManager();
        this.copier = m2docEnv.getCopier();
        this.evaluator = new QueryEvaluationEngine((IQueryEnvironment)m2docEnv.getQueryEnvironment());
        this.monitor = monitor;
    }

    public GenerationResult generate(IGenerateable generateable, Map<String, Object> variables, IBody destinationDocument) {
        this.generatedDocument = destinationDocument;
        this.variablesStack.push(variables);
        try {
            this.result = new GenerationResult(destinationDocument);
            this.result.getDuplicatedUserContentIDs().addAll(this.userContentManager.getDuplicatedUserContentIDs());
            this.doSwitch(generateable);
        }
        finally {
            this.variablesStack.pop();
        }
        return this.result;
    }

    @Override
    public XWPFParagraph caseDocumentTemplate(DocumentTemplate documentTemplate) {
        this.cleanBody(this.generatedDocument);
        int unitOfWork = 30 / (1 + documentTemplate.getFooters().size() + documentTemplate.getHeaders().size());
        this.doSwitch(documentTemplate.getBody());
        this.updateSequences((XmlObject)this.generatedDocument.getXWPFDocument().getDocument(), new HashMap<String, Integer>());
        this.worked(this.monitor, unitOfWork);
        XWPFDocument document = (XWPFDocument)this.generatedDocument;
        Iterator footers = document.getFooterList().iterator();
        for (Block footer : documentTemplate.getFooters()) {
            XWPFFooter f = (XWPFFooter)footers.next();
            this.cleanBody((IBody)f);
            this.generatedDocument = f;
            this.doSwitch(footer);
            this.worked(this.monitor, unitOfWork);
        }
        Iterator headers = document.getHeaderList().iterator();
        for (Block header : documentTemplate.getHeaders()) {
            XWPFHeader h = (XWPFHeader)headers.next();
            this.cleanBody((IBody)h);
            this.generatedDocument = h;
            this.doSwitch(header);
            this.worked(this.monitor, unitOfWork);
        }
        return this.currentGeneratedParagraph;
    }

    private void updateSequences(XmlObject xmlObject, HashMap<String, Integer> sequenceToIndex) {
        if (xmlObject instanceof CTR) {
            SequenceField sequence = FIELD_UTILS.getSequenceField((CTR)xmlObject);
            if (sequence != null) {
                int index = sequenceToIndex.getOrDefault(sequence.getName(), 1);
                sequence.setIndex(index);
                sequenceToIndex.put(sequence.getName(), index + 1);
            }
        } else {
            Throwable throwable = null;
            Object var4_7 = null;
            try (XmlCursor cursor = xmlObject.newCursor();){
                if (cursor.toFirstChild()) {
                    this.updateSequences(cursor.getObject(), sequenceToIndex);
                    while (cursor.toNextSibling()) {
                        this.updateSequences(cursor.getObject(), sequenceToIndex);
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    private void worked(Monitor progressMonitor, int work) {
        if (progressMonitor.isCanceled()) {
            throw new CancellationException("Canceled by user");
        }
        progressMonitor.worked(work);
    }

    @Override
    public XWPFParagraph caseTemplate(Template template) {
        this.cleanBody(this.generatedDocument);
        return this.doSwitch(template.getBody());
    }

    public void cleanBody(IBody body) {
        if (body instanceof XWPFDocument) {
            XWPFDocument document = (XWPFDocument)body;
            int size = body.getBodyElements().size();
            int i = 0;
            while (i < size) {
                document.removeBodyElement(0);
                ++i;
            }
            document.getDocument().getBody().getSdtList().clear();
        } else if (body instanceof XWPFHeaderFooter) {
            CTHdrFtr ctHdrFtr = (CTHdrFtr)((XWPFHeaderFooter)body)._getHdrFtr().copy();
            ctHdrFtr.getPList().clear();
            ctHdrFtr.getTblList().clear();
            ctHdrFtr.getSdtList().clear();
            ((XWPFHeaderFooter)body).setHeaderFooter(ctHdrFtr);
        } else {
            throw new UnsupportedOperationException("unkown IBody type :" + body.getClass());
        }
    }

    @Override
    public XWPFParagraph caseStaticFragment(StaticFragment staticFragment) {
        XWPFParagraph currentParagraph = this.currentGeneratedParagraph;
        for (XWPFRun run : staticFragment.getRuns()) {
            currentParagraph = (XWPFParagraph)this.insertRun(currentParagraph, run).getParent();
        }
        return currentParagraph;
    }

    private XWPFRun insertRun(XWPFParagraph paragraph, XWPFRun srcRun) {
        XWPFParagraph newParagraph = srcRun.getParent() != this.currentTemplateParagraph || this.forceNewParagraph || paragraph == null ? this.createNewParagraph(this.generatedDocument, (XWPFParagraph)srcRun.getParent()) : paragraph;
        XWPFRun newRun = null;
        if (srcRun instanceof XWPFHyperlinkRun) {
            CTHyperlink newHyperlink = newParagraph.getCTP().addNewHyperlink();
            newHyperlink.set((XmlObject)((XWPFHyperlinkRun)srcRun).getCTHyperlink());
            newRun = new XWPFHyperlinkRun(newHyperlink, srcRun.getCTR(), srcRun.getParent());
            newParagraph.addRun(newRun);
        } else {
            newRun = newParagraph.createRun();
            newRun.getCTR().set((XmlObject)srcRun.getCTR());
        }
        return newRun;
    }

    private XWPFRun insertFieldRunReplacement(XWPFParagraph paragraph, XWPFRun srcRun, String replacement) {
        XWPFParagraph newParagraph = srcRun.getParent() != this.currentTemplateParagraph || this.forceNewParagraph ? this.createNewParagraph(this.generatedDocument, (XWPFParagraph)srcRun.getParent()) : paragraph;
        return this.insertString(newParagraph, srcRun, replacement);
    }

    private XWPFRun insertString(XWPFParagraph paragraph, XWPFRun srcRun, String text) {
        int fragmentStart = 0;
        int i = 0;
        while (i < text.length()) {
            char current = text.charAt(i);
            switch (current) {
                case '\n': {
                    XWPFRun inserted = this.insertFragment(paragraph, srcRun, text.substring(fragmentStart, i));
                    inserted.addBreak();
                    fragmentStart = i + 1;
                    break;
                }
                case '\t': {
                    XWPFRun inserted = this.insertFragment(paragraph, srcRun, text.substring(fragmentStart, i));
                    inserted.addTab();
                    fragmentStart = i + 1;
                    break;
                }
                case '\r': {
                    if (i + 1 >= text.length() || text.charAt(i + 1) != '\n') break;
                    XWPFRun inserted = this.insertFragment(paragraph, srcRun, text.substring(fragmentStart, i));
                    inserted.addBreak();
                    fragmentStart = ++i + 1;
                    break;
                }
            }
            ++i;
        }
        return this.insertFragment(paragraph, srcRun, text.substring(fragmentStart, text.length()));
    }

    private XWPFRun insertFragment(XWPFParagraph paragraph, XWPFRun srcRun, String fragment) {
        XWPFRun generatedRun = paragraph.createRun();
        generatedRun.getCTR().set(srcRun.getCTR().copy());
        generatedRun.getCTR().getInstrTextList().clear();
        generatedRun.setText(fragment);
        return generatedRun;
    }

    private XWPFParagraph createNewParagraph(IBody body, XWPFParagraph srcParagraph) {
        XWPFParagraph res = this.createParagraph(body);
        CTP ctp = (CTP)srcParagraph.getCTP().copy();
        ctp.getRList().clear();
        ctp.getFldSimpleList().clear();
        ctp.getHyperlinkList().clear();
        res.getCTP().set((XmlObject)ctp);
        int runNb = res.getRuns().size();
        int i = 0;
        while (i < runNb) {
            res.removeRun(i);
            ++i;
        }
        this.currentTemplateParagraph = srcParagraph;
        this.currentGeneratedParagraph = res;
        this.forceNewParagraph = false;
        return res;
    }

    private XWPFParagraph createParagraph(IBody body) {
        XWPFParagraph res;
        if (body instanceof XWPFTableCell) {
            XWPFTableCell cell = (XWPFTableCell)body;
            res = cell.addParagraph();
        } else if (body instanceof XWPFDocument) {
            res = ((XWPFDocument)body).createParagraph();
        } else if (body instanceof XWPFHeaderFooter) {
            res = ((XWPFHeaderFooter)body).createParagraph();
        } else {
            throw new UnsupportedOperationException("unkown IBody type :" + body.getClass());
        }
        return res;
    }

    protected boolean hasError(IConstruct construct) {
        boolean res = false;
        for (TemplateValidationMessage message : construct.getValidationMessages()) {
            if (message.getLevel() != ValidationMessageLevel.ERROR) continue;
            res = true;
            break;
        }
        return res;
    }

    @Override
    public XWPFParagraph caseQuery(Query query) {
        XWPFParagraph currentParagraph = this.currentGeneratedParagraph;
        if (this.hasError(query)) {
            currentParagraph = this.insertQuerySyntaxMessages(currentParagraph, query, INVALID_QUERY_STATEMENT);
        } else {
            EvaluationResult queryResult = this.evaluator.eval(query.getQuery(), this.variablesStack.peek());
            if (queryResult.getDiagnostic().getSeverity() != 0) {
                currentParagraph = this.insertQueryEvaluationMessages(currentParagraph, query, queryResult.getDiagnostic());
            } else {
                Object value = queryResult.getResult();
                XWPFRun styleRun = query.getStyleRun();
                currentParagraph = this.insertObject(currentParagraph, value, styleRun);
            }
        }
        return currentParagraph;
    }

    private XWPFParagraph insertObject(XWPFParagraph paragraph, Object object, XWPFRun run) {
        XWPFParagraph res;
        if (object instanceof Collection) {
            XWPFParagraph currentParagraph = paragraph;
            for (Object child : (Collection)object) {
                currentParagraph = this.insertObject(currentParagraph, child, run);
            }
            res = currentParagraph;
        } else if (object instanceof MHyperLink) {
            res = this.insertMHyperLink(paragraph, run, (MHyperLink)object);
        } else if (object instanceof MBookmark) {
            res = this.insertMBookmark(paragraph, run, (MBookmark)object);
        } else if (object instanceof MImage) {
            if (object != MImage.EMPTY) {
                XWPFRun imageRun = this.insertFieldRunReplacement(paragraph, run, "");
                XWPFParagraph imageParagraph = (XWPFParagraph)imageRun.getParent();
                this.insertMImage(imageParagraph, imageRun, (MImage)object);
                res = imageParagraph;
            } else {
                res = paragraph;
            }
        } else if (object instanceof MText) {
            res = ((MText)object).getText() != null && !((MText)object).getText().isEmpty() ? (XWPFParagraph)this.insertMText(paragraph, run, (MText)object).getParent() : paragraph;
        } else if (object instanceof MTable) {
            if (!((MTable)object).getRows().isEmpty() && ((MTable)object).getColumnsCount() != 0) {
                XWPFRun tableRun = run;
                tableRun.getCTR().getInstrTextList().clear();
                this.insertMTable(tableRun, (MTable)object);
                res = (XWPFParagraph)tableRun.getParent();
            } else {
                res = paragraph;
            }
        } else if (object instanceof MPagination) {
            res = this.insertMPagination(paragraph, run, (MPagination)object);
        } else if (object instanceof MParagraph) {
            res = this.insertMParagraph(this.generatedDocument, (MParagraph)object, run);
        } else if (object instanceof IBody) {
            if (!((IBody)object).getBodyElements().isEmpty()) {
                XWPFRun bodyRun = this.insertFieldRunReplacement(paragraph, run, "");
                res = this.insertBody((XWPFParagraph)bodyRun.getParent(), (IBody)object);
            } else {
                res = paragraph;
            }
        } else if (object instanceof GenerationResult) {
            if (!((GenerationResult)object).getBody().getBodyElements().isEmpty()) {
                XWPFRun generationRun = this.insertFieldRunReplacement(paragraph, run, "");
                res = this.insertGenerationResult((XWPFParagraph)generationRun.getParent(), (GenerationResult)object);
            } else {
                res = paragraph;
            }
        } else {
            String stringValue;
            res = object == null ? paragraph : ((stringValue = object.toString()) != null && !stringValue.isEmpty() ? (XWPFParagraph)this.insertFieldRunReplacement(paragraph, run, stringValue).getParent() : paragraph);
        }
        return res;
    }

    private XWPFParagraph insertGenerationResult(XWPFParagraph paragraph, GenerationResult generationResult) {
        XWPFParagraph res;
        for (TemplateValidationMessage message : generationResult.getMessages()) {
            this.result.addMessage(message);
        }
        this.currentGeneratedParagraph = res = this.insertBody(paragraph, generationResult.getBody());
        return res;
    }

    private XWPFParagraph insertBody(XWPFParagraph paragraph, IBody body) {
        XWPFParagraph res;
        try {
            res = this.copier.copyBody(paragraph, body, this.bookmarkManager);
        }
        catch (Exception e) {
            this.result.addMessage(M2DocUtils.appendMessageRun(paragraph, ValidationMessageLevel.ERROR, e.getMessage()));
            res = paragraph;
        }
        return res;
    }

    private XWPFRun insertMText(XWPFParagraph paragraph, XWPFRun run, MText text) {
        XWPFRun res;
        if (text.getText() != null) {
            XWPFRun textRun = this.insertFieldRunReplacement(paragraph, run, text.getText());
            if (text.getStyle() != null) {
                this.applyMStyle(textRun, text.getStyle());
            }
            res = textRun;
        } else {
            res = run;
        }
        return res;
    }

    @Override
    public XWPFParagraph caseComment(Comment comment) {
        return this.currentGeneratedParagraph;
    }

    private XWPFParagraph insertMBookmark(XWPFParagraph paragraph, XWPFRun run, MBookmark bookmark) {
        XWPFParagraph res = (XWPFParagraph)this.insertFieldRunReplacement(paragraph, run, "").getParent();
        if (bookmark.isReference()) {
            this.bookmarkManager.insertReference(res, bookmark.getId(), bookmark.getText(), bookmark.isOptional());
        } else {
            this.bookmarkManager.startBookmark(this.result, res, bookmark.getId());
            this.insertFieldRunReplacement(res, run, bookmark.getText());
            this.bookmarkManager.endBookmark(this.result, res, bookmark.getId());
        }
        return res;
    }

    private XWPFParagraph insertMHyperLink(XWPFParagraph paragraph, XWPFRun run, MHyperLink hyperLink) {
        XWPFRun linkRun = this.insertMText(paragraph, run, hyperLink);
        XWPFParagraph res = (XWPFParagraph)linkRun.getParent();
        String id = res.getBody().getPart().getPackagePart().addExternalRelationship(hyperLink.getUrl(), XWPFRelation.HYPERLINK.getRelation()).getId();
        CTHyperlink cLink = res.getCTP().addNewHyperlink();
        cLink.setId(id);
        String toolTip = hyperLink.getToolTip();
        if (toolTip != null) {
            cLink.setTooltip(toolTip);
        }
        if (hyperLink.getStyle() != null) {
            this.applyMStyle(linkRun, hyperLink.getStyle());
        }
        cLink.setRArray(new CTR[]{linkRun.getCTR()});
        res.removeRun(res.getRuns().indexOf(linkRun));
        return res;
    }

    private void insertMImage(XWPFParagraph paragraph, XWPFRun run, MImage image) {
        try {
            MImage asoluteImage = this.getAbsoluteSizedImage(paragraph, image);
            int heigth = Units.toEMU((double)asoluteImage.getHeight());
            int width = Units.toEMU((double)asoluteImage.getWidth());
            Throwable throwable = null;
            Object var8_11 = null;
            try (InputStream imageStream = asoluteImage.getInputStream();){
                run.addPicture(imageStream, asoluteImage.getType().getPoiType(), asoluteImage.getURI().toString(), width, heigth);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (InvalidFormatException e) {
            this.insertMessage(paragraph, ValidationMessageLevel.ERROR, String.format(PICTURE_INVALID_FORMAT, image.getURI().toString(), e.getMessage()));
        }
        catch (IOException e) {
            this.insertMessage(paragraph, ValidationMessageLevel.ERROR, String.format(AN_I_O_PROBLEM_OCCURED_WHILE_READING, image.getURI().toString(), e.getMessage()));
        }
    }

    private MImage getAbsoluteSizedImage(XWPFParagraph paragraph, MImage image) {
        MImage res;
        if (image.getRelativeWidth() >= 0) {
            res = new AbosluteResizedImage(image);
            int width = this.getAbsoluteImageWidth(paragraph, image);
            if (image.getRelativeHeight() >= 0) {
                int height = this.getAbsoluteImageHeight(paragraph, image);
                res.setConserveRatio(false);
                res.setWidth(width);
                res.setHeight(height);
            } else {
                res.setWidth(width);
            }
        } else if (image.getRelativeHeight() >= 0) {
            res = new AbosluteResizedImage(image);
            int height = this.getAbsoluteImageHeight(paragraph, image);
            res.setHeight(height);
        } else {
            res = image;
        }
        return res;
    }

    private int getAbsoluteImageWidth(XWPFParagraph paragraph, MImage image) {
        int res;
        if (paragraph.getCTP() != null && paragraph.getCTP().getPPr() != null && paragraph.getCTP().getPPr().getSectPr() != null) {
            CTSectPr section = paragraph.getCTP().getPPr().getSectPr();
            res = this.getAbsoluteWidthFromSection(image, section);
        } else {
            IBody body = paragraph.getBody();
            if (body instanceof XWPFDocument) {
                CTSectPr section = ((XWPFDocument)body).getDocument().getBody().getSectPr();
                res = this.getAbsoluteWidthFromSection(image, section);
            } else if (body instanceof XWPFHeaderFooter) {
                CTSectPr section = ((XWPFHeaderFooter)body).getXWPFDocument().getDocument().getBody().getSectPr();
                res = this.getAbsoluteWidthFromSection(image, section);
            } else if (body instanceof XWPFTableCell) {
                int cellWidth = ((XWPFTableCell)body).getWidth();
                res = (int)((double)(cellWidth * image.getRelativeWidth()) / 100.0 / 20.0);
            } else {
                throw new UnsupportedOperationException("unknown type of IBody : " + body.getClass());
            }
        }
        return res;
    }

    private int getAbsoluteWidthFromSection(MImage image, CTSectPr section) {
        int res;
        if (section.getPgSz() != null) {
            int containerWidth;
            int pageWidth = this.bigIntegerToInt((BigInteger)section.getPgSz().getW());
            if (section.getPgMar() != null) {
                int leftMargin = this.bigIntegerToInt((BigInteger)section.getPgMar().getLeft());
                int rightMargin = this.bigIntegerToInt((BigInteger)section.getPgMar().getRight());
                containerWidth = pageWidth - leftMargin - rightMargin;
            } else {
                containerWidth = pageWidth;
            }
            res = (int)((double)(containerWidth * image.getRelativeWidth()) / 100.0 / 20.0);
        } else {
            res = image.getWidth();
        }
        return res;
    }

    private int getAbsoluteImageHeight(XWPFParagraph paragraph, MImage image) {
        int res;
        if (paragraph.getCTP() != null && paragraph.getCTP().getPPr() != null && paragraph.getCTP().getPPr().getSectPr() != null) {
            CTSectPr section = paragraph.getCTP().getPPr().getSectPr();
            res = this.getAbsoluteHeightFromSection(image, section);
        } else {
            IBody body = paragraph.getBody();
            if (body instanceof XWPFDocument) {
                CTSectPr section = ((XWPFDocument)body).getDocument().getBody().getSectPr();
                res = this.getAbsoluteHeightFromSection(image, section);
            } else if (body instanceof XWPFHeaderFooter) {
                CTSectPr section = ((XWPFHeaderFooter)body).getXWPFDocument().getDocument().getBody().getSectPr();
                res = this.getAbsoluteHeightFromSection(image, section);
            } else if (body instanceof XWPFTableCell) {
                res = image.getHeight();
            } else {
                throw new UnsupportedOperationException("unknown type of IBody : " + body.getClass());
            }
        }
        return res;
    }

    private int getAbsoluteHeightFromSection(MImage image, CTSectPr section) {
        int res;
        if (section.getPgSz() != null) {
            int containerHeight;
            int pageHeight = this.bigIntegerToInt((BigInteger)section.getPgSz().getH());
            if (section.getPgMar() != null) {
                int topMargin = this.bigIntegerToInt((BigInteger)section.getPgMar().getTop());
                int bottomMargin = this.bigIntegerToInt((BigInteger)section.getPgMar().getBottom());
                containerHeight = pageHeight - topMargin - bottomMargin;
            } else {
                containerHeight = pageHeight;
            }
            res = (int)((double)(containerHeight * image.getRelativeHeight()) / 100.0 / 20.0);
        } else {
            res = image.getHeight();
        }
        return res;
    }

    private int bigIntegerToInt(BigInteger bigInteger) {
        int res = bigInteger != null ? bigInteger.intValue() : 0;
        return res;
    }

    private XWPFParagraph insertMPagination(XWPFParagraph paragraph, XWPFRun run, MPagination mPagination) {
        XWPFParagraph res;
        switch (mPagination) {
            case newColumn: {
                XWPFRun newColumnRun = this.insertFieldRunReplacement(paragraph, run, "");
                newColumnRun.addBreak(BreakType.COLUMN);
                res = (XWPFParagraph)newColumnRun.getParent();
                break;
            }
            case newParagraph: {
                res = this.createNewParagraph(this.generatedDocument, (XWPFParagraph)run.getParent());
                break;
            }
            case newPage: {
                XWPFRun newPageRun = this.insertFieldRunReplacement(paragraph, run, "");
                newPageRun.addBreak(BreakType.PAGE);
                res = (XWPFParagraph)newPageRun.getParent();
                break;
            }
            case newTableOfContent: {
                CTP ctP = paragraph.getCTP();
                CTSimpleField toc = ctP.addNewFldSimple();
                toc.setInstr("TOC \\h");
                STOnOff onOff = (STOnOff)STOnOff.Factory.newInstance();
                onOff.setStringValue("true");
                toc.xsetDirty(onOff);
                res = paragraph;
                break;
            }
            case newTextWrapping: {
                XWPFRun newTextWrappingRun = this.insertFieldRunReplacement(paragraph, run, "");
                newTextWrappingRun.addBreak(BreakType.TEXT_WRAPPING);
                res = (XWPFParagraph)newTextWrappingRun.getParent();
                break;
            }
            case ligneBreak: {
                XWPFRun ligneBreakRun = this.insertFieldRunReplacement(paragraph, run, "");
                ligneBreakRun.addBreak();
                res = (XWPFParagraph)ligneBreakRun.getParent();
                break;
            }
            default: {
                throw new IllegalStateException("Not supported MPagination.");
            }
        }
        return res;
    }

    private XWPFParagraph insertMParagraph(IBody body, MParagraph paragraph, XWPFRun run) {
        MBorder bottomBorder;
        MBorder topBorder;
        MBorder rightBorder;
        STOnOff onOff;
        CTOnOff value;
        XWPFParagraph newParagraph = this.createNewParagraph(body, (XWPFParagraph)run.getParent());
        if (paragraph.getStyleName() != null) {
            newParagraph.setStyle(paragraph.getStyleName());
        }
        if (paragraph.getHAlignment() != null) {
            newParagraph.setAlignment(this.getHAllignment(paragraph.getHAlignment()));
        }
        if (paragraph.getNumberingID() != null) {
            newParagraph.setNumID(BigInteger.valueOf(paragraph.getNumberingID()));
        }
        if (paragraph.getNumberingLevel() != null) {
            newParagraph.getCTP().getPPr().getNumPr().addNewIlvl().setVal(BigInteger.valueOf(paragraph.getNumberingLevel()));
            if (paragraph.getMarginLeft() != -1) {
                newParagraph.setIndentationLeft(paragraph.getMarginLeft() * 14 + this.getNumberingIndentLeft(paragraph.getNumberingID(), paragraph.getNumberingLevel()));
            }
        } else if (paragraph.getMarginLeft() != -1) {
            newParagraph.setIndentationLeft(paragraph.getMarginLeft() * 14);
        }
        if (paragraph.getMarginRight() != -1) {
            newParagraph.setIndentationRight(paragraph.getMarginLeft() * 14);
        }
        if (paragraph.getMarginTop() != -1) {
            newParagraph.setSpacingBefore(paragraph.getMarginLeft() * 14);
        }
        if (paragraph.getMarginBottom() != -1) {
            newParagraph.setSpacingAfter(paragraph.getMarginLeft() * 14);
        }
        if (paragraph.getTextDirection() == MParagraph.Dir.LTR) {
            if (newParagraph.getCTP().getPPr() == null) {
                newParagraph.getCTP().addNewPPr();
            }
            if (newParagraph.getCTP().getPPr().getBidi() == null) {
                newParagraph.getCTP().getPPr().addNewBidi();
            }
            value = (CTOnOff)CTOnOff.Factory.newInstance();
            onOff = (STOnOff)STOnOff.Factory.newInstance();
            onOff.setStringValue("off");
            value.xsetVal(onOff);
            newParagraph.getCTP().getPPr().setBidi(value);
        } else if (paragraph.getTextDirection() == MParagraph.Dir.RTL) {
            if (newParagraph.getCTP().getPPr() == null) {
                newParagraph.getCTP().addNewPPr();
            }
            if (newParagraph.getCTP().getPPr().getBidi() == null) {
                newParagraph.getCTP().getPPr().addNewBidi();
            }
            value = (CTOnOff)CTOnOff.Factory.newInstance();
            onOff = (STOnOff)STOnOff.Factory.newInstance();
            onOff.setStringValue("on");
            value.xsetVal(onOff);
            newParagraph.getCTP().getPPr().setBidi(value);
        }
        MBorder leftBorder = paragraph.getLeftBorder();
        if (leftBorder != null) {
            int size;
            newParagraph.setBorderLeft(leftBorder.getType().toPOI());
            Color color = leftBorder.getColor();
            if (color != null) {
                newParagraph.getCTP().getPPr().getPBdr().getLeft().setColor((Object)M2DocEvaluator.hexColor(color));
            }
            if ((size = leftBorder.getSize()) >= 0) {
                newParagraph.getCTP().getPPr().getPBdr().getLeft().setSz(BigInteger.valueOf(size * 8));
            }
        }
        if ((rightBorder = paragraph.getRightBorder()) != null) {
            int size;
            newParagraph.setBorderRight(rightBorder.getType().toPOI());
            Color color = rightBorder.getColor();
            if (color != null) {
                newParagraph.getCTP().getPPr().getPBdr().getRight().setColor((Object)M2DocEvaluator.hexColor(color));
            }
            if ((size = rightBorder.getSize()) >= 0) {
                newParagraph.getCTP().getPPr().getPBdr().getRight().setSz(BigInteger.valueOf(size * 8));
            }
        }
        if ((topBorder = paragraph.getTopBorder()) != null) {
            int size;
            newParagraph.setBorderTop(topBorder.getType().toPOI());
            Color color = topBorder.getColor();
            if (color != null) {
                newParagraph.getCTP().getPPr().getPBdr().getTop().setColor((Object)M2DocEvaluator.hexColor(color));
            }
            if ((size = topBorder.getSize()) >= 0) {
                newParagraph.getCTP().getPPr().getPBdr().getTop().setSz(BigInteger.valueOf(size * 8));
            }
        }
        if ((bottomBorder = paragraph.getBottomBorder()) != null) {
            int size;
            newParagraph.setBorderBottom(bottomBorder.getType().toPOI());
            Color color = bottomBorder.getColor();
            if (color != null) {
                newParagraph.getCTP().getPPr().getPBdr().getBottom().setColor((Object)M2DocEvaluator.hexColor(color));
            }
            if ((size = bottomBorder.getSize()) >= 0) {
                newParagraph.getCTP().getPPr().getPBdr().getBottom().setSz(BigInteger.valueOf(size * 8));
            }
        }
        return this.insertObject(newParagraph, paragraph.getContents(), run);
    }

    private int getNumberingIndentLeft(Long numberingID, Long numberingLevel) {
        int res = 0;
        if (numberingID != null) {
            CTAbstractNum absNum = null;
            for (POIXMLDocumentPart.RelationPart relationPart : this.generatedDocument.getXWPFDocument().getRelationParts()) {
                if (XWPFRelation.NUMBERING.getRelation().equals(relationPart.getRelationship().getRelationshipType())) {
                    XWPFNumbering numbering = (XWPFNumbering)relationPart.getDocumentPart();
                    CTNumbering ctNumbering = PaginationServices.getCTNumbering(numbering);
                    absNum = this.getAbstractNumbering(ctNumbering, numberingID);
                }
                if (absNum == null) continue;
                for (CTLvl lvl : absNum.getLvlList()) {
                    if (lvl.getIlvl().longValue() != numberingLevel.longValue()) continue;
                    res = ((BigInteger)lvl.getPPr().getInd().getLeft()).intValue();
                }
            }
        } else {
            res = 0;
        }
        return res;
    }

    private CTAbstractNum getAbstractNumbering(CTNumbering ctNumbering, Long numberingID) {
        CTAbstractNum res = null;
        block0: for (CTNum ctNum : ctNumbering.getNumList()) {
            if (ctNum.getNumId().longValue() != numberingID.longValue()) continue;
            for (CTAbstractNum ctAbsNumering : ctNumbering.getAbstractNumList()) {
                if (!ctAbsNumering.getAbstractNumId().equals(ctNum.getAbstractNumId().getVal())) continue;
                res = ctAbsNumering;
                continue block0;
            }
        }
        return res;
    }

    private void insertMTable(XWPFRun run, MTable table) {
        XWPFTable xwpfTable;
        if (this.generatedDocument instanceof XWPFDocument) {
            if (table.getLabel() != null) {
                XWPFRun captionRun = run;
                IRunBody runBody = captionRun.getParent();
                if (runBody instanceof XWPFParagraph) {
                    ((XWPFParagraph)runBody).setSpacingAfter(0);
                }
                captionRun.setText(table.getLabel());
                captionRun.setBold(true);
            }
            if ((xwpfTable = ((XWPFDocument)this.generatedDocument).createTable()).getRows().size() > 0) {
                xwpfTable.removeRow(0);
            }
        } else if (this.generatedDocument instanceof XWPFHeaderFooter) {
            XWPFHeaderFooter headerFooter = (XWPFHeaderFooter)this.generatedDocument;
            int index = headerFooter._getHdrFtr().getTblList().size();
            CTTbl ctTbl = headerFooter._getHdrFtr().insertNewTbl(index);
            xwpfTable = new XWPFTable(ctTbl, (IBody)headerFooter);
            if (xwpfTable.getRows().size() > 0) {
                xwpfTable.removeRow(0);
            }
            headerFooter.insertTable(index, xwpfTable);
        } else if (this.generatedDocument instanceof XWPFTableCell) {
            CTTbl ctTbl;
            XWPFTableCell tcell = (XWPFTableCell)this.generatedDocument;
            if (table.getLabel() != null) {
                XWPFRun captionRun = run;
                IRunBody runBody = captionRun.getParent();
                if (runBody instanceof XWPFParagraph) {
                    ((XWPFParagraph)runBody).setSpacingAfter(0);
                }
                captionRun.setText(table.getLabel());
                captionRun.setBold(true);
            }
            if ((xwpfTable = new XWPFTable(ctTbl = tcell.getCTTc().addNewTbl(), (IBody)tcell)).getRows().size() > 0) {
                xwpfTable.removeRow(0);
            }
            int tableRank = tcell.getTables().size();
            tcell.insertTable(tableRank, xwpfTable);
            tcell.addParagraph();
        } else {
            xwpfTable = null;
            this.insertMessage((XWPFParagraph)run.getParent(), ValidationMessageLevel.ERROR, "m:table can't be inserted here.");
        }
        if (xwpfTable != null) {
            this.fillTable(xwpfTable, table);
            this.setTableAlign(xwpfTable, table);
        }
    }

    private void setTableAlign(XWPFTable xwpfTable, MTable table) {
        MTable.MTableAlign tableAlign = table.getTableAlign();
        if (tableAlign != null) {
            switch (tableAlign) {
                case LEFT: {
                    xwpfTable.setTableAlignment(TableRowAlign.LEFT);
                    break;
                }
                case CENTER: {
                    xwpfTable.setTableAlignment(TableRowAlign.CENTER);
                    break;
                }
                case RIGHT: {
                    xwpfTable.setTableAlignment(TableRowAlign.RIGHT);
                    break;
                }
            }
        }
    }

    private void fillTable(XWPFTable xwpfTable, MTable mTable) {
        boolean removeBorders;
        if (mTable.getStyleID() != null) {
            xwpfTable.setStyleID(mTable.getStyleID());
            removeBorders = true;
            if (xwpfTable.getCTTbl().getTblPr() != null && xwpfTable.getCTTbl().getTblPr().isSetTblBorders()) {
                xwpfTable.getCTTbl().getTblPr().unsetTblBorders();
            }
        } else {
            removeBorders = false;
        }
        for (MTable.MRow mRow : mTable.getRows()) {
            XWPFTableRow xwpfRow = xwpfTable.createRow();
            while (!xwpfRow.getTableCells().isEmpty()) {
                xwpfRow.removeCell(0);
            }
            xwpfRow.getCtRow().getTcList().clear();
            this.setRowHeight(xwpfRow, mRow);
            int column = 0;
            while (column < mRow.getCells().size()) {
                MTable.MCell mCell = mRow.getCells().get(column);
                XWPFTableCell xwpfCell = xwpfRow.createCell();
                XWPFParagraph xwpfCellParagraph = (XWPFParagraph)xwpfCell.getParagraphs().get(0);
                xwpfCellParagraph.setSpacingBefore(0);
                xwpfCellParagraph.setSpacingAfter(0);
                if (mCell != null && mCell.getHAlignment() != null) {
                    xwpfCellParagraph.setAlignment(this.getHAllignment(mCell.getHAlignment()));
                }
                this.setCellContent(xwpfCell, mCell);
                this.setVMerge(xwpfCell, mCell);
                this.setHMerge(xwpfCell, mCell);
                this.setCellWidth(xwpfCell, mCell);
                if (removeBorders && xwpfCell.getCTTc().getTcPr() != null && xwpfCell.getCTTc().getTcPr().isSetTcBorders()) {
                    xwpfCell.getCTTc().getTcPr().unsetTcBorders();
                }
                ++column;
            }
        }
    }

    private void setRowHeight(XWPFTableRow xwpfRow, MTable.MRow mRow) {
        if (mRow != null) {
            if (mRow.getHeightRule() != null) {
                TableRowHeightRule rule;
                switch (mRow.getHeightRule()) {
                    case AUTO: {
                        rule = TableRowHeightRule.AUTO;
                        break;
                    }
                    case EXACT: {
                        rule = TableRowHeightRule.AT_LEAST;
                        break;
                    }
                    case AT_LEAST: {
                        rule = TableRowHeightRule.AT_LEAST;
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                xwpfRow.setHeightRule(rule);
            }
            if (mRow.getHeight() != -1) {
                xwpfRow.setHeight(mRow.getHeight());
            }
        }
    }

    private void setCellWidth(XWPFTableCell xwpfCell, MTable.MCell mCell) {
        if (mCell != null) {
            if (mCell.getWidthType() != null) {
                TableWidthType type;
                switch (mCell.getWidthType()) {
                    case AUTO: {
                        type = TableWidthType.AUTO;
                        break;
                    }
                    case DXA: {
                        type = TableWidthType.DXA;
                        break;
                    }
                    case NIL: {
                        type = TableWidthType.NIL;
                        break;
                    }
                    case PCT: {
                        type = TableWidthType.PCT;
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                xwpfCell.setWidthType(type);
            }
            if (mCell.getWitdh() != -1) {
                xwpfCell.setWidth(String.valueOf(mCell.getWitdh()));
            }
        }
    }

    private void setVMerge(XWPFTableCell xwpfCell, MTable.MCell mCell) {
        if (mCell != null && mCell.getVMerge() != null) {
            CTVMerge hmerge = (CTVMerge)CTVMerge.Factory.newInstance();
            switch (mCell.getVMerge()) {
                case RESTART: {
                    hmerge.setVal(STMerge.RESTART);
                    break;
                }
                case CONTINUE: {
                    hmerge.setVal(STMerge.CONTINUE);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            this.getTcPr(xwpfCell).setVMerge(hmerge);
        }
    }

    private CTTcPr getTcPr(XWPFTableCell xwpfCell) {
        if (!xwpfCell.getCTTc().isSetTcPr()) {
            xwpfCell.getCTTc().addNewTcPr();
        }
        return xwpfCell.getCTTc().getTcPr();
    }

    private void setHMerge(XWPFTableCell xwpfCell, MTable.MCell mCell) {
        if (mCell != null && mCell.getHMerge() != null) {
            CTHMerge hmerge = (CTHMerge)CTHMerge.Factory.newInstance();
            switch (mCell.getHMerge()) {
                case RESTART: {
                    hmerge.setVal(STMerge.RESTART);
                    break;
                }
                case CONTINUE: {
                    hmerge.setVal(STMerge.CONTINUE);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            this.getTcPr(xwpfCell).setHMerge(hmerge);
        }
    }

    private ParagraphAlignment getHAllignment(MElementContainer.HAlignment hAlignment) {
        ParagraphAlignment res;
        switch (hAlignment) {
            case BOTH: {
                res = ParagraphAlignment.BOTH;
                break;
            }
            case CENTER: {
                res = ParagraphAlignment.CENTER;
                break;
            }
            case DISTRIBUTE: {
                res = ParagraphAlignment.DISTRIBUTE;
                break;
            }
            case HIGH_KASHIDA: {
                res = ParagraphAlignment.HIGH_KASHIDA;
                break;
            }
            case LEFT: {
                res = ParagraphAlignment.LEFT;
                break;
            }
            case LOW_KASHIDA: {
                res = ParagraphAlignment.LOW_KASHIDA;
                break;
            }
            case MEDIUM_KASHIDA: {
                res = ParagraphAlignment.MEDIUM_KASHIDA;
                break;
            }
            case NUM_TAB: {
                res = ParagraphAlignment.NUM_TAB;
                break;
            }
            case RIGHT: {
                res = ParagraphAlignment.RIGHT;
                break;
            }
            case THAI_DISTRIBUTE: {
                res = ParagraphAlignment.THAI_DISTRIBUTE;
                break;
            }
            default: {
                throw new IllegalStateException("can't convert " + (Object)((Object)hAlignment));
            }
        }
        return res;
    }

    private void setCellContent(XWPFTableCell cell, MTable.MCell mCell) {
        XWPFParagraph cellParagraph = (XWPFParagraph)cell.getParagraphs().get(0);
        XWPFRun cellRun = cellParagraph.createRun();
        if (mCell != null) {
            Color backGroundColor;
            MElement contents = mCell.getContents();
            if (mCell.getVAlignment() != null) {
                cell.setVerticalAlignment(this.getVAglignment(mCell.getVAlignment()));
            }
            if (contents != null) {
                IBody savedGeneratedDocument = this.generatedDocument;
                XWPFParagraph savedGeneratedParagraph = this.currentGeneratedParagraph;
                XWPFParagraph savedTemplateParagraph = this.currentTemplateParagraph;
                this.generatedDocument = cell;
                this.currentGeneratedParagraph = cellParagraph;
                this.currentTemplateParagraph = cellParagraph;
                try {
                    this.insertObject(cellParagraph, contents, cellRun);
                }
                finally {
                    this.generatedDocument = savedGeneratedDocument;
                    this.currentGeneratedParagraph = savedGeneratedParagraph;
                    this.currentTemplateParagraph = savedTemplateParagraph;
                }
                cellParagraph.removeRun(cellParagraph.getRuns().indexOf(cellRun));
                if (this.startWithMParagraph(contents)) {
                    cell.removeParagraph(0);
                }
            }
            if ((backGroundColor = mCell.getBackgroundColor()) != null) {
                cell.setColor(M2DocEvaluator.hexColor(backGroundColor));
            }
        }
    }

    private boolean startWithMParagraph(MElement contents) {
        MList mList;
        boolean res = contents instanceof MParagraph ? true : (contents instanceof MList ? !(mList = (MList)contents).isEmpty() && this.startWithMParagraph((MElement)mList.get(0)) : false);
        return res;
    }

    private XWPFTableCell.XWPFVertAlign getVAglignment(MTable.MCell.VAlignment vAlignment) {
        XWPFTableCell.XWPFVertAlign res;
        switch (vAlignment) {
            case BOTH: {
                res = XWPFTableCell.XWPFVertAlign.BOTH;
                break;
            }
            case BOTTOM: {
                res = XWPFTableCell.XWPFVertAlign.BOTTOM;
                break;
            }
            case CENTER: {
                res = XWPFTableCell.XWPFVertAlign.CENTER;
                break;
            }
            case TOP: {
                res = XWPFTableCell.XWPFVertAlign.TOP;
                break;
            }
            default: {
                throw new IllegalStateException("can't convert " + (Object)((Object)vAlignment));
            }
        }
        return res;
    }

    private void applyMStyle(XWPFRun run, MStyle style) {
        if (style.getFontSize() != -1) {
            run.setFontSize(style.getFontSize());
        }
        if (style.getFontName() != null) {
            run.setFontFamily(style.getFontName());
        }
        if (style.getFontModifiers() != -1) {
            run.setBold((style.getFontModifiers() & 1) != 0);
            run.setItalic((style.getFontModifiers() & 2) != 0);
            if ((style.getFontModifiers() & 4) != 0) {
                run.setUnderline(UnderlinePatterns.SINGLE);
            }
            run.setStrikeThrough((style.getFontModifiers() & 8) != 0);
            if ((style.getFontModifiers() & 0x10) != 0) {
                run.setSubscript(VerticalAlign.SUBSCRIPT);
            }
            if ((style.getFontModifiers() & 0x20) != 0) {
                run.setSubscript(VerticalAlign.SUPERSCRIPT);
            }
            if ((style.getFontModifiers() & 0x40) != 0) {
                run.setSmallCaps(true);
            }
        }
        if (style.getForegroundColor() != null) {
            run.setColor(M2DocEvaluator.hexColor(style.getForegroundColor()));
        }
        if (style.getBackgroundColor() != null) {
            CTShd[] ctshd;
            CTRPr ctrpr = run.getCTR().getRPr() != null ? run.getCTR().getRPr() : run.getCTR().addNewRPr();
            if (ctrpr.getShdArray() != null && ctrpr.getShdArray().length != 0) {
                ctshd = ctrpr.getShdArray();
            } else {
                ctrpr.addNewShd();
                ctshd = ctrpr.getShdArray();
            }
            int i = 0;
            while (i < ctshd.length) {
                ctshd[i].setVal(STShd.CLEAR);
                ctshd[i].setColor((Object)"auto");
                ctshd[i].setFill((Object)M2DocEvaluator.hexColor(style.getBackgroundColor()));
                ++i;
            }
        }
    }

    private static String hexColor(Color color) {
        return String.format("%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue());
    }

    @Override
    public XWPFParagraph caseRepetition(Repetition repetition) {
        XWPFParagraph currentParagraph = this.currentGeneratedParagraph;
        if (this.hasError(repetition)) {
            currentParagraph = this.insertQuerySyntaxMessages(currentParagraph, repetition, INVALID_REPETITION_STATEMENT);
        } else {
            EvaluationResult queryResult = this.evaluator.eval(repetition.getQuery(), this.variablesStack.peek());
            if (queryResult.getDiagnostic().getSeverity() != 0) {
                currentParagraph = this.insertQueryEvaluationMessages(currentParagraph, repetition, queryResult.getDiagnostic());
            } else {
                ArrayList<Object> iteration = new ArrayList<Object>();
                if (queryResult.getResult() instanceof Collection) {
                    iteration.addAll((Collection)queryResult.getResult());
                } else if (queryResult.getResult() != null) {
                    iteration.add(queryResult.getResult());
                } else {
                    this.insertMessage(currentParagraph, ValidationMessageLevel.WARNING, String.valueOf(repetition.getIterationVar()) + " value is null.");
                }
                HashMap<String, Object> newVariables = new HashMap<String, Object>(this.variablesStack.peek());
                this.variablesStack.push(newVariables);
                try {
                    for (Object e : iteration) {
                        newVariables.put(repetition.getIterationVar(), e);
                        currentParagraph = this.doSwitch(repetition.getBody());
                        this.closingRepretition(repetition);
                    }
                }
                finally {
                    this.variablesStack.pop();
                }
            }
        }
        return currentParagraph;
    }

    public XWPFParagraph doSwitch(EObject eObject) {
        if (!this.monitor.isCanceled()) {
            return (XWPFParagraph)super.doSwitch(eObject);
        }
        return null;
    }

    @Override
    public XWPFParagraph caseLet(Let let) {
        XWPFParagraph currentParagraph = this.currentGeneratedParagraph;
        if (this.hasError(let)) {
            currentParagraph = this.insertQuerySyntaxMessages(currentParagraph, let, INVALID_LET_STATEMENT);
        } else {
            EvaluationResult queryResult = this.evaluator.eval(let.getValue(), this.variablesStack.peek());
            if (queryResult.getDiagnostic().getSeverity() != 0) {
                currentParagraph = this.insertQueryEvaluationMessages(currentParagraph, let, queryResult.getDiagnostic());
            } else {
                HashMap<String, Object> newVariables = new HashMap<String, Object>(this.variablesStack.peek());
                this.variablesStack.push(newVariables);
                try {
                    newVariables.put(let.getName(), queryResult.getResult());
                    currentParagraph = this.doSwitch(let.getBody());
                }
                finally {
                    this.variablesStack.pop();
                }
            }
        }
        return currentParagraph;
    }

    @Override
    public XWPFParagraph caseUserDoc(UserDoc userDoc) {
        XWPFParagraph currentParagraph = this.currentGeneratedParagraph;
        if (this.hasError(userDoc)) {
            currentParagraph = this.insertQuerySyntaxMessages(currentParagraph, userDoc, INVALID_USERDOC_STATEMENT);
        } else {
            EvaluationResult queryResult = this.evaluator.eval(userDoc.getId(), this.variablesStack.peek());
            if (queryResult.getDiagnostic().getSeverity() != 0) {
                currentParagraph = this.insertQueryEvaluationMessages(currentParagraph, userDoc, queryResult.getDiagnostic());
            } else if (queryResult.getResult() == null) {
                this.insertMessage(currentParagraph, ValidationMessageLevel.ERROR, "User doc id can't be null.");
            } else {
                String id = queryResult.getResult().toString();
                currentParagraph = this.insertUserContent(currentParagraph, userDoc, id);
            }
        }
        return currentParagraph;
    }

    private XWPFParagraph insertUserContent(XWPFParagraph paragraph, UserDoc userDoc, String id) {
        XWPFParagraph currentParagraph = paragraph;
        currentParagraph = this.addStartUserDocField(currentParagraph, userDoc, id);
        this.manageUserDocIdUniqueness(currentParagraph, id, userDoc);
        UserContent userContent = this.userContentManager.consumeUserContent(id);
        boolean needNewParagraphBeforeEndTag = true;
        if (userContent == null) {
            currentParagraph = this.doSwitch(userDoc.getBody());
        } else {
            try {
                currentParagraph = this.copier.copyUserContent(userContent, currentParagraph);
                needNewParagraphBeforeEndTag = this.copier.needNewParagraph();
            }
            catch (Exception e) {
                this.insertMessage(currentParagraph, ValidationMessageLevel.ERROR, "userdoc copy error : " + e.getMessage());
            }
        }
        if (currentParagraph == null) {
            currentParagraph = this.createNewParagraph(this.generatedDocument, (XWPFParagraph)((XWPFRun)userDoc.getRuns().get(0)).getParent());
            needNewParagraphBeforeEndTag = false;
        }
        if (!currentParagraph.getCTP().xmlText().contains("<w:instrText>" + TokenType.ENDUSERCONTENT.getValue() + "</w:instrText>")) {
            currentParagraph = this.addEndUserContentField(currentParagraph, userDoc, needNewParagraphBeforeEndTag);
        }
        return currentParagraph;
    }

    private void manageUserDocIdUniqueness(XWPFParagraph paragraph, String id, UserDoc userdoc) {
        if (!this.encountereduserDocIds.add(id)) {
            String msgError = "The id '" + id + "' is already used in generated document. Ids must be unique otherwise document part contained userContent could be lost at next generation.";
            this.insertMessage(paragraph, ValidationMessageLevel.ERROR, msgError);
            TemplateValidationMessage templateValidationMessage = new TemplateValidationMessage(ValidationMessageLevel.ERROR, msgError, (XWPFRun)userdoc.getRuns().get(userdoc.getRuns().size() - 1));
            userdoc.getValidationMessages().add((Object)templateValidationMessage);
        }
    }

    private XWPFParagraph addStartUserDocField(XWPFParagraph paragraph, UserDoc userDoc, String id) {
        XWPFParagraph res;
        if (paragraph == null || userDoc.getRuns().size() != 0 && ((XWPFRun)userDoc.getRuns().get(0)).getParent() != this.currentTemplateParagraph) {
            XWPFParagraph newParagraph = this.createNewParagraph(this.generatedDocument, (XWPFParagraph)((XWPFRun)userDoc.getRuns().get(0)).getParent());
            this.insertTag(newParagraph, String.valueOf(TokenType.USERCONTENT.getValue()) + " " + id);
            res = newParagraph;
        } else {
            this.insertTag(paragraph, String.valueOf(TokenType.USERCONTENT.getValue()) + " " + id);
            res = paragraph;
        }
        return res;
    }

    private XWPFParagraph addEndUserContentField(XWPFParagraph paragraph, UserDoc userDoc, boolean needNewParagraph) {
        XWPFParagraph res;
        if (needNewParagraph) {
            XWPFParagraph newParagraph = this.createNewParagraph(this.generatedDocument, paragraph);
            this.insertTag(newParagraph, TokenType.ENDUSERCONTENT.getValue());
            res = newParagraph;
        } else {
            this.insertTag(paragraph, TokenType.ENDUSERCONTENT.getValue());
            res = paragraph;
        }
        return res;
    }

    private void insertTag(XWPFParagraph paragraph, String instrText) {
        paragraph.getCTP().addNewR().addNewFldChar().setFldCharType(STFldCharType.BEGIN);
        paragraph.getCTP().addNewR().addNewInstrText().setStringValue(instrText);
        paragraph.getCTP().addNewR().addNewFldChar().setFldCharType(STFldCharType.SEPARATE);
        paragraph.getCTP().addNewR().addNewFldChar().setFldCharType(STFldCharType.END);
    }

    private void closingRepretition(Repetition repetition) {
        int bodySize = repetition.getBody().getStatements().size();
        if (bodySize > 0 && ((Statement)repetition.getBody().getStatements().get(bodySize - 1)).getRuns().size() > 0) {
            IConstruct lastBodyPart = (IConstruct)repetition.getBody().getStatements().get(bodySize - 1);
            int runNumber = lastBodyPart.getRuns().size();
            XWPFRun lastRun = (XWPFRun)lastBodyPart.getRuns().get(runNumber - 1);
            int closingRunNumber = repetition.getClosingRuns().size();
            if (closingRunNumber > 0 && ((XWPFRun)repetition.getClosingRuns().get(0)).getParent() != lastRun.getParent()) {
                this.forceNewParagraph = true;
            }
        }
    }

    @Override
    public XWPFParagraph caseBlock(Block block) {
        XWPFParagraph currentParagraph = this.currentGeneratedParagraph;
        if (this.hasError(block)) {
            if (currentParagraph == null && block.getRuns().isEmpty()) {
                currentParagraph = this.createParagraph(this.generatedDocument);
            }
            currentParagraph = this.insertQuerySyntaxMessages(currentParagraph, block, INVALID_BLOCK_STATEMENT);
        } else {
            for (IConstruct construct : block.getStatements()) {
                currentParagraph = this.doSwitch(construct);
            }
        }
        return currentParagraph;
    }

    @Override
    public XWPFParagraph caseConditional(Conditional conditional) {
        XWPFParagraph currentParagraph;
        block4: {
            block6: {
                block7: {
                    EvaluationResult evaluationResult;
                    block5: {
                        block3: {
                            currentParagraph = this.currentGeneratedParagraph;
                            if (!this.hasError(conditional)) break block3;
                            currentParagraph = this.insertQuerySyntaxMessages(currentParagraph, conditional, INVALID_CONDITIONAL_STATEMENT);
                            break block4;
                        }
                        evaluationResult = this.evaluator.eval(conditional.getCondition(), this.variablesStack.peek());
                        if (evaluationResult.getDiagnostic().getSeverity() == 0) break block5;
                        currentParagraph = this.insertQueryEvaluationMessages(currentParagraph, conditional, evaluationResult.getDiagnostic());
                        for (XWPFRun tagRun : conditional.getClosingRuns()) {
                            currentParagraph = (XWPFParagraph)this.insertRun(currentParagraph, tagRun).getParent();
                        }
                        break block4;
                    }
                    if (!(evaluationResult.getResult() instanceof Boolean)) break block6;
                    if (!((Boolean)evaluationResult.getResult()).booleanValue()) break block7;
                    currentParagraph = this.doSwitch(conditional.getThen());
                    break block4;
                }
                if (conditional.getElse() == null) break block4;
                currentParagraph = this.doSwitch(conditional.getElse());
                break block4;
            }
            for (XWPFRun tagRun : conditional.getRuns()) {
                currentParagraph = (XWPFParagraph)this.insertRun(currentParagraph, tagRun).getParent();
            }
            this.insertMessage(currentParagraph, ValidationMessageLevel.ERROR, "Condition evaluation result must be a boolean.");
            for (XWPFRun tagRun : conditional.getClosingRuns()) {
                currentParagraph = (XWPFParagraph)this.insertRun(currentParagraph, tagRun).getParent();
            }
        }
        return currentParagraph;
    }

    @Override
    public XWPFParagraph caseTable(Table table) {
        CTTbl copy = (CTTbl)table.getTable().getCTTbl().copy();
        copy.getTrList().clear();
        XWPFTable saveTable = this.currentGeneratedTable;
        try {
            XWPFTable newTable = POIServices.getInstance().createTable(this.generatedDocument);
            newTable.getCTTbl().set((XmlObject)copy);
            this.currentGeneratedTable = newTable;
            for (Row row : table.getRows()) {
                this.doSwitch(row);
            }
        }
        finally {
            this.currentGeneratedTable = saveTable;
        }
        this.currentTemplateParagraph = null;
        return null;
    }

    @Deprecated
    public static XWPFTable createTable(IBody body) {
        return POIServices.getInstance().createTable(body);
    }

    @Override
    public XWPFParagraph caseRow(Row row) {
        XWPFTableRow savedRow = this.currentGeneratedRow;
        try {
            this.currentGeneratedRow = new XWPFTableRow(this.currentGeneratedTable.getCTTbl().addNewTr(), this.currentGeneratedTable);
            CTRow ctRow = (CTRow)row.getTableRow().getCtRow().copy();
            ctRow.getTcList().clear();
            while (!this.currentGeneratedRow.getTableCells().isEmpty()) {
                this.currentGeneratedRow.removeCell(0);
            }
            this.currentGeneratedRow.getCtRow().set((XmlObject)ctRow);
            for (Cell cell : row.getCells()) {
                this.doSwitch(cell);
            }
        }
        finally {
            this.currentGeneratedRow = savedRow;
        }
        return this.currentGeneratedParagraph;
    }

    @Override
    public XWPFParagraph caseCell(Cell cell) {
        XWPFParagraph firstParagraph;
        XWPFTableCell newCell = new XWPFTableCell(this.currentGeneratedRow.getCtRow().addNewTc(), this.currentGeneratedRow, this.generatedDocument);
        CTTc ctCell = (CTTc)cell.getTableCell().getCTTc().copy();
        ctCell.getPList().clear();
        ctCell.getTblList().clear();
        ctCell.getSdtList().clear();
        ctCell.getPList().clear();
        newCell.getCTTc().set((XmlObject)ctCell);
        IBody savedGeneratedDocument = this.generatedDocument;
        XWPFParagraph savedGeneratedParagraph = this.currentGeneratedParagraph;
        XWPFParagraph savedTemplateParagraph = this.currentTemplateParagraph;
        this.generatedDocument = newCell;
        try {
            this.doSwitch(cell.getBody());
        }
        finally {
            this.generatedDocument = savedGeneratedDocument;
            this.currentGeneratedParagraph = savedGeneratedParagraph;
            this.currentTemplateParagraph = savedTemplateParagraph;
        }
        if (newCell.getParagraphs().size() == 0) {
            XWPFParagraph newParagraph = newCell.addParagraph();
            newParagraph.createRun();
        } else if (newCell.getParagraphs().size() == 1 && (firstParagraph = (XWPFParagraph)newCell.getParagraphs().get(0)).getRuns().isEmpty()) {
            newCell.getCTTc().addNewP();
        }
        return this.currentGeneratedParagraph;
    }

    @Override
    public XWPFParagraph caseBookmark(Bookmark bookmark) {
        XWPFParagraph currentParagraph = this.currentGeneratedParagraph;
        if (this.hasError(bookmark)) {
            currentParagraph = this.insertQuerySyntaxMessages(currentParagraph, bookmark, INVALID_BOOKMARK_STATEMENT);
        } else {
            EvaluationResult evaluationResult = this.evaluator.eval(bookmark.getName(), this.variablesStack.peek());
            if (evaluationResult.getDiagnostic().getSeverity() != 0) {
                currentParagraph = this.insertQueryEvaluationMessages(currentParagraph, bookmark, evaluationResult.getDiagnostic());
            } else {
                if (currentParagraph == null) {
                    currentParagraph = this.createNewParagraph(this.generatedDocument, (XWPFParagraph)bookmark.getStyleRun().getParent());
                }
                this.bookmarkManager.startBookmark(this.result, currentParagraph, evaluationResult.getResult().toString());
                currentParagraph = this.doSwitch(bookmark.getBody());
                this.bookmarkManager.endBookmark(this.result, currentParagraph, evaluationResult.getResult().toString());
            }
        }
        return currentParagraph;
    }

    @Override
    public XWPFParagraph caseContentControl(ContentControl contentControl) {
        CTSdtBlock sdtBlock;
        if (this.generatedDocument instanceof XWPFDocument) {
            sdtBlock = ((XWPFDocument)this.generatedDocument).getDocument().getBody().addNewSdt();
        } else if (this.generatedDocument instanceof XWPFHeaderFooter) {
            sdtBlock = ((XWPFHeaderFooter)this.generatedDocument)._getHdrFtr().addNewSdt();
        } else if (this.generatedDocument instanceof XWPFFootnote) {
            sdtBlock = ((XWPFFootnote)this.generatedDocument).getCTFtnEdn().addNewSdt();
        } else if (this.generatedDocument instanceof XWPFTableCell) {
            sdtBlock = ((XWPFTableCell)this.generatedDocument).getCTTc().addNewSdt();
        } else {
            throw new IllegalStateException("can't insert control in " + this.generatedDocument.getClass().getCanonicalName());
        }
        sdtBlock.set(contentControl.getBlock().copy());
        new XWPFSDT(sdtBlock, this.generatedDocument);
        return this.currentGeneratedParagraph;
    }

    protected XWPFParagraph insertQueryEvaluationMessages(XWPFParagraph paragraph, IConstruct construct, Diagnostic diagnostic) {
        XWPFParagraph currentParagraph = paragraph;
        for (XWPFRun tagRun : construct.getRuns()) {
            currentParagraph = (XWPFParagraph)this.insertRun(currentParagraph, tagRun).getParent();
        }
        for (TemplateValidationMessage message : M2DocUtils.appendDiagnosticMessage(currentParagraph, diagnostic)) {
            this.result.addMessage(message);
        }
        for (XWPFRun tagRun : construct.getClosingRuns()) {
            currentParagraph = (XWPFParagraph)this.insertRun(currentParagraph, tagRun).getParent();
        }
        return currentParagraph;
    }

    protected XWPFParagraph insertQuerySyntaxMessages(XWPFParagraph paragraph, IConstruct construct, String errorPrefix) {
        XWPFParagraph currentParagraph = paragraph;
        for (XWPFRun tagRun : construct.getRuns()) {
            currentParagraph = (XWPFParagraph)this.insertRun(currentParagraph, tagRun).getParent();
        }
        for (TemplateValidationMessage message : construct.getValidationMessages()) {
            this.insertMessage(currentParagraph, message.getLevel(), String.valueOf(errorPrefix) + message.getMessage());
        }
        for (XWPFRun tagRun : construct.getClosingRuns()) {
            currentParagraph = (XWPFParagraph)this.insertRun(currentParagraph, tagRun).getParent();
        }
        return currentParagraph;
    }

    protected void insertMessage(XWPFParagraph paragraph, ValidationMessageLevel level, String message) {
        this.result.addMessage(M2DocUtils.appendMessageRun(paragraph, level, message));
    }

    @Override
    public XWPFParagraph caseLink(Link link) {
        XWPFParagraph currentParagraph = this.currentGeneratedParagraph;
        if (this.hasError(link)) {
            currentParagraph = this.insertQuerySyntaxMessages(currentParagraph, link, INVALID_LINK_STATEMENT);
        } else {
            EvaluationResult nameResult = this.evaluator.eval(link.getName(), this.variablesStack.peek());
            if (nameResult.getDiagnostic().getSeverity() != 0) {
                currentParagraph = this.insertQueryEvaluationMessages(currentParagraph, link, nameResult.getDiagnostic());
            } else {
                EvaluationResult textResult = this.evaluator.eval(link.getText(), this.variablesStack.peek());
                if (nameResult.getDiagnostic().getSeverity() != 0) {
                    currentParagraph = this.insertQueryEvaluationMessages(currentParagraph, link, textResult.getDiagnostic());
                } else {
                    this.bookmarkManager.insertReference(currentParagraph, nameResult.getResult().toString(), textResult.getResult().toString(), false);
                }
            }
        }
        return currentParagraph;
    }
}

