/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.generator;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.URI;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.poi.ooxml.POIXMLDocumentPart;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackagePartName;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.openxml4j.opc.PackagingURIHelper;
import org.apache.poi.openxml4j.opc.TargetMode;
import org.apache.poi.xwpf.usermodel.IBody;
import org.apache.poi.xwpf.usermodel.IBodyElement;
import org.apache.poi.xwpf.usermodel.XWPFAbstractNum;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFFootnote;
import org.apache.poi.xwpf.usermodel.XWPFHeaderFooter;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFSDT;
import org.apache.poi.xwpf.usermodel.XWPFStyle;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.impl.common.IOUtil;
import org.obeonetwork.m2doc.POIServices;
import org.obeonetwork.m2doc.generator.BookmarkManager;
import org.obeonetwork.m2doc.parser.AbstractBodyParser;
import org.obeonetwork.m2doc.template.UserContent;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTAbstractNum;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTBookmark;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTDecimalNumber;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTNumPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTP;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTR;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSdtBlock;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTText;
import org.w3c.dom.NodeList;

public class RawCopier {
    private static final String RELATIONSHIPS_URI = "http://schemas.openxmlformats.org/officeDocument/2006/relationships";
    private static final int MASK_16 = 16;
    private static final int MASK_0X100 = 256;
    private static final int MASK_0XFF = 255;
    private static final int BUFFER_SIZE = 8192;
    private static final Pattern INTEGER_PATTERN = Pattern.compile("[0-9]+");
    private boolean needNewParagraph = true;
    private final Map<XWPFDocument, Map<String, URI>> partMD5ToName = new HashMap<XWPFDocument, Map<String, URI>>();

    public Map<String, URI> getPartMD5ToName(XWPFDocument document) {
        Map<String, URI> res = this.partMD5ToName.get(document);
        if (res == null) {
            res = new HashMap<String, URI>();
            try {
                for (POIXMLDocumentPart.RelationPart part : document.getRelationParts()) {
                    PackagePart packagePart = part.getDocumentPart().getPackagePart();
                    Throwable throwable = null;
                    Object var7_10 = null;
                    try (InputStream is = packagePart.getInputStream();){
                        res.put(this.getMD5(is), packagePart.getPartName().getURI());
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.partMD5ToName.put(document, res);
        }
        return res;
    }

    private String getMD5(InputStream is) throws NoSuchAlgorithmException, IOException {
        int nbBytes;
        StringBuilder res = new StringBuilder();
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        byte[] buffer = new byte[8192];
        do {
            if ((nbBytes = is.read(buffer)) <= 0) continue;
            md5.update(buffer, 0, nbBytes);
        } while (nbBytes != -1);
        byte[] digest = md5.digest();
        int i = 0;
        while (i < digest.length) {
            res.append(Integer.toString((digest[i] & 0xFF) + 256, 16).substring(1));
            ++i;
        }
        return res.toString();
    }

    public boolean needNewParagraph() {
        return this.needNewParagraph;
    }

    public XWPFParagraph copyUserContent(UserContent userContent, XWPFParagraph outputParagraph) throws Exception {
        boolean inline;
        boolean inlineEndUserContent;
        NodeList endSiblings;
        CTR endXmlObject;
        XWPFParagraph endUserContentParagraph;
        XWPFRun endUserContentRun;
        boolean inlineStartUserContent;
        XWPFParagraph res = null;
        XWPFRun startUserContentRun = (XWPFRun)userContent.getRuns().get(userContent.getRuns().size() - 1);
        XWPFParagraph startUserContentParagraph = (XWPFParagraph)startUserContentRun.getParent();
        CTR startXmlObject = startUserContentRun.getCTR();
        NodeList startSiblings = startXmlObject.getDomNode().getParentNode().getChildNodes();
        boolean bl = inlineStartUserContent = startSiblings.item(startSiblings.getLength() - 1) != startXmlObject.getDomNode();
        if (!userContent.getClosingRuns().isEmpty()) {
            endUserContentRun = (XWPFRun)userContent.getClosingRuns().get(0);
            endUserContentParagraph = (XWPFParagraph)endUserContentRun.getParent();
            endXmlObject = endUserContentRun.getCTR();
            endSiblings = endXmlObject.getDomNode().getParentNode().getChildNodes();
            inlineEndUserContent = endSiblings.item(0) != endXmlObject.getDomNode();
        } else {
            endUserContentRun = null;
            endUserContentParagraph = null;
            endXmlObject = null;
            endSiblings = null;
            inlineEndUserContent = false;
        }
        IBody inputBody = startUserContentParagraph.getBody();
        IBody outputBody = outputParagraph.getBody();
        if (!(outputBody instanceof XWPFTableCell) && outputParagraph.getRuns().size() == 1 && ((XWPFRun)outputParagraph.getRuns().get(0)).getText(0).length() == 0) {
            this.removeParagraph(outputBody, outputParagraph);
            inline = false;
        } else {
            inline = true;
        }
        Iterator it = inputBody.getBodyElements().iterator();
        while (it.hasNext()) {
            if (((IBodyElement)it.next()).equals(startUserContentParagraph)) break;
        }
        HashMap<String, String> inputRelationIdToOutputMap = new HashMap<String, String>();
        HashMap<URI, URI> inputPartURIToOutputPartURI = new HashMap<URI, URI>();
        HashMap<BigInteger, BigInteger> numIDmap = new HashMap<BigInteger, BigInteger>();
        if (inlineStartUserContent) {
            if (inline) {
                if (endUserContentParagraph == startUserContentParagraph) {
                    this.copyParagraphFragment(inputRelationIdToOutputMap, inputPartURIToOutputPartURI, numIDmap, outputParagraph, startUserContentParagraph, (XmlObject)startXmlObject, (XmlObject)endXmlObject);
                } else {
                    this.copyParagraphFragment(inputRelationIdToOutputMap, inputPartURIToOutputPartURI, numIDmap, outputParagraph, startUserContentParagraph, (XmlObject)startXmlObject, null);
                }
                res = outputParagraph;
            } else if (endUserContentParagraph == startUserContentParagraph) {
                res = this.createNewParagraph(outputBody);
                this.copyParagraphFragment(inputRelationIdToOutputMap, inputPartURIToOutputPartURI, numIDmap, res, endUserContentParagraph, null, (XmlObject)endXmlObject);
            }
        }
        if (endUserContentParagraph != startUserContentParagraph) {
            IBodyElement element = null;
            while (it.hasNext()) {
                element = (IBodyElement)it.next();
                if (endUserContentParagraph == element) break;
                if (element instanceof XWPFParagraph) {
                    XWPFParagraph inputParagraph = (XWPFParagraph)element;
                    res = this.copyParagraph(outputBody, inputRelationIdToOutputMap, inputPartURIToOutputPartURI, numIDmap, inputParagraph, null);
                    continue;
                }
                if (element instanceof XWPFTable) {
                    this.copyTable(outputBody, inputRelationIdToOutputMap, inputPartURIToOutputPartURI, numIDmap, (XWPFTable)element, null);
                    res = null;
                    continue;
                }
                if (element instanceof XWPFSDT) {
                    this.copyCTSdtBlock(outputBody, AbstractBodyParser.getCTSdtBlock(inputBody, (XWPFSDT)element));
                    res = null;
                    continue;
                }
                throw new IllegalStateException("unknown body element.");
            }
            if (inlineEndUserContent) {
                res = this.createNewParagraph(outputBody);
                CTP ctp = (CTP)((XWPFParagraph)element).getCTP().copy();
                ctp.getRList().clear();
                ctp.getFldSimpleList().clear();
                ctp.getHyperlinkList().clear();
                res.getCTP().set((XmlObject)ctp);
                this.copyParagraphFragment(inputRelationIdToOutputMap, inputPartURIToOutputPartURI, numIDmap, res, endUserContentParagraph, null, (XmlObject)endXmlObject);
            }
        }
        this.needNewParagraph = !inlineEndUserContent;
        return res;
    }

    private XWPFParagraph copyParagraph(IBody outputBody, Map<String, String> inputRelationIdToOutputMap, Map<URI, URI> inputPartURIToOutputPartURI, Map<BigInteger, BigInteger> numIDmap, XWPFParagraph inputParagraph, BookmarkManager bookmarkManager) throws InvalidFormatException, NoSuchAlgorithmException, IOException, XmlException {
        XWPFParagraph res = this.createNewParagraph(outputBody);
        res.getCTP().set((XmlObject)inputParagraph.getCTP());
        this.updateRelationAndNumberingIds(inputRelationIdToOutputMap, inputPartURIToOutputPartURI, numIDmap, inputParagraph.getBody(), outputBody, (XmlObject)res.getCTP());
        if (bookmarkManager != null) {
            this.updateBookmarks(bookmarkManager, res.getCTP(), inputParagraph.getCTP(), outputBody);
        }
        return res;
    }

    private BigInteger copyNumID(IBody inputBody, IBody outputBody, BigInteger inputNumID) {
        XWPFDocument inputDocument = inputBody.getXWPFDocument();
        XWPFDocument ouptutDocument = outputBody.getXWPFDocument();
        XWPFAbstractNum inputNum = inputDocument.getNumbering().getAbstractNum(inputNumID.subtract(BigInteger.ONE));
        XWPFAbstractNum outputNum = new XWPFAbstractNum((CTAbstractNum)inputNum.getCTAbstractNum().copy());
        BigInteger newID = BigInteger.valueOf(ouptutDocument.getNumbering().getAbstractNums().size());
        outputNum.getAbstractNum().setAbstractNumId(newID);
        BigInteger outputNumID = ouptutDocument.getNumbering().addAbstractNum(outputNum);
        ouptutDocument.getNumbering().addNum(outputNumID);
        return outputNumID;
    }

    private XWPFTable copyTable(IBody outputBody, Map<String, String> inputRelationIdToOutputMap, Map<URI, URI> inputPartURIToOutputPartURI, Map<BigInteger, BigInteger> numIDmap, XWPFTable inputTable, BookmarkManager bookmarkManager) throws IOException, InvalidFormatException, NoSuchAlgorithmException, XmlException {
        XWPFTable res = POIServices.getInstance().createTable(outputBody);
        res.getCTTbl().set(inputTable.getCTTbl().copy());
        RawCopier.copyTableStyle(inputTable, outputBody.getXWPFDocument());
        this.updateRelationAndNumberingIds(inputRelationIdToOutputMap, inputPartURIToOutputPartURI, numIDmap, inputTable.getBody(), res.getBody(), (XmlObject)res.getCTTbl());
        if (bookmarkManager != null) {
            this.updateBookmarks(bookmarkManager, res, inputTable);
        }
        return res;
    }

    private void copyParagraphFragment(Map<String, String> inputRelationIdToOutputMap, Map<URI, URI> inputPartURIToOutputPartURI, Map<BigInteger, BigInteger> numIDmap, XWPFParagraph outputParagraph, XWPFParagraph inputParagraph, XmlObject startXmlObject, XmlObject endXmlObject) throws XmlException, InvalidFormatException, NoSuchAlgorithmException, IOException {
        block26: {
            XmlCursor inputCursor;
            if (inputParagraph.getCTP().isSetPPr()) {
                outputParagraph.getCTP().setPPr((CTPPr)inputParagraph.getCTP().getPPr().copy());
            }
            if (startXmlObject != null) {
                inputCursor = startXmlObject.newCursor();
            } else {
                inputCursor = inputParagraph.getCTP().newCursor();
                inputCursor.toFirstChild();
            }
            try {
                if (startXmlObject != null && !inputCursor.getObject().equals(startXmlObject)) break block26;
                Throwable throwable = null;
                Object var10_11 = null;
                try (XmlCursor outputCursor = outputParagraph.getCTP().newCursor();){
                    outputCursor.toLastChild();
                    outputCursor.toEndToken();
                    outputCursor.toNextToken();
                    do {
                        if (endXmlObject != null && inputCursor.getObject().equals(endXmlObject)) {
                            break;
                        }
                        inputCursor.copyXml(outputCursor);
                        Throwable throwable2 = null;
                        Object var13_16 = null;
                        try (XmlCursor tmpCursor = outputCursor.newCursor();){
                            tmpCursor.toPrevSibling();
                            tmpCursor.getObject();
                            this.updateRelationAndNumberingIds(inputRelationIdToOutputMap, inputPartURIToOutputPartURI, numIDmap, inputParagraph.getBody(), outputParagraph.getBody(), tmpCursor.getObject());
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                            } else if (throwable2 != throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            throw throwable2;
                        }
                    } while (inputCursor.toNextSibling());
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            finally {
                inputCursor.close();
            }
        }
    }

    private void removeParagraph(IBody body, XWPFParagraph outputParagraph) {
        if (body instanceof XWPFDocument) {
            XWPFDocument document = (XWPFDocument)body;
            int index = document.getBodyElements().indexOf(outputParagraph);
            if (index != -1) {
                document.removeBodyElement(index);
            }
        } else if (body instanceof XWPFHeaderFooter) {
            XWPFHeaderFooter headerFooter = (XWPFHeaderFooter)body;
            headerFooter.removeParagraph(outputParagraph);
        } else if (body instanceof XWPFTableCell) {
            XWPFTableCell cell = (XWPFTableCell)body;
            int index = cell.getBodyElements().indexOf(outputParagraph);
            if (index != -1) {
                cell.removeParagraph(index);
            }
        } else {
            throw new IllegalStateException("can't delete paragraph from " + body.getClass().getCanonicalName());
        }
    }

    private void copyCTSdtBlock(IBody outputBody, CTSdtBlock block) {
        CTSdtBlock stdBlock;
        if (outputBody instanceof XWPFDocument) {
            stdBlock = ((XWPFDocument)outputBody).getDocument().getBody().addNewSdt();
        } else if (outputBody instanceof XWPFHeaderFooter) {
            stdBlock = ((XWPFHeaderFooter)outputBody)._getHdrFtr().addNewSdt();
        } else if (outputBody instanceof XWPFFootnote) {
            stdBlock = ((XWPFFootnote)outputBody).getCTFtnEdn().addNewSdt();
        } else if (outputBody instanceof XWPFTableCell) {
            stdBlock = ((XWPFTableCell)outputBody).getCTTc().addNewSdt();
        } else {
            throw new IllegalStateException("can't insert control in " + outputBody.getClass().getCanonicalName());
        }
        stdBlock.set(block.copy());
        new XWPFSDT(stdBlock, outputBody);
    }

    private XWPFParagraph createNewParagraph(IBody document) {
        XWPFParagraph res;
        if (document instanceof XWPFTableCell) {
            XWPFTableCell cell = (XWPFTableCell)document;
            res = cell.addParagraph();
        } else if (document instanceof XWPFDocument) {
            res = ((XWPFDocument)document).createParagraph();
        } else if (document instanceof XWPFHeaderFooter) {
            res = ((XWPFHeaderFooter)document).createParagraph();
        } else {
            throw new UnsupportedOperationException("unkown IBody type :" + document.getClass());
        }
        return res;
    }

    private static void copyTableStyle(XWPFTable inputTable, XWPFDocument outputDoc) throws IOException {
        XWPFDocument inputDoc = inputTable.getBody().getXWPFDocument();
        XWPFStyle style = inputDoc.getStyles().getStyle(inputTable.getStyleID());
        if (outputDoc != null && style != null) {
            if (outputDoc.getStyles() == null) {
                outputDoc.createStyles();
            }
            List usedStyleList = inputDoc.getStyles().getUsedStyleList(style);
            for (XWPFStyle xwpfStyle : usedStyleList) {
                outputDoc.getStyles().addStyle(xwpfStyle);
            }
        }
    }

    private void updateRelationAndNumberingIds(Map<String, String> inputRelationIdToOutputMap, Map<URI, URI> inputPartURIToOutputPartURI, Map<BigInteger, BigInteger> numIDmap, IBody inputBody, IBody outputBody, XmlObject xmlObject) throws XmlException, InvalidFormatException, NoSuchAlgorithmException, IOException {
        XmlObject idAttr;
        CTNumPr ctNumPr;
        CTDecimalNumber numIdChild;
        BigInteger inputNumID;
        if (xmlObject instanceof CTNumPr && (inputNumID = (numIdChild = (ctNumPr = (CTNumPr)xmlObject).getNumId()).getVal()) != null) {
            BigInteger outputNumID = numIDmap.computeIfAbsent(inputNumID, id -> this.copyNumID(inputBody, outputBody, (BigInteger)id));
            numIdChild.setVal(outputNumID);
        }
        if ((idAttr = xmlObject.selectAttribute(RELATIONSHIPS_URI, "id")) != null) {
            this.updateRelationAttribute(inputRelationIdToOutputMap, inputPartURIToOutputPartURI, inputBody, outputBody, idAttr);
        } else {
            XmlObject embedAttr = xmlObject.selectAttribute(RELATIONSHIPS_URI, "embed");
            if (embedAttr != null) {
                this.updateRelationAttribute(inputRelationIdToOutputMap, inputPartURIToOutputPartURI, inputBody, outputBody, embedAttr);
            }
        }
        Throwable throwable = null;
        Object var9_10 = null;
        try (XmlCursor cursor = xmlObject.newCursor();){
            if (cursor.toFirstChild()) {
                this.updateRelationAndNumberingIds(inputRelationIdToOutputMap, inputPartURIToOutputPartURI, numIDmap, inputBody, outputBody, cursor.getObject());
                while (cursor.toNextSibling()) {
                    this.updateRelationAndNumberingIds(inputRelationIdToOutputMap, inputPartURIToOutputPartURI, numIDmap, inputBody, outputBody, cursor.getObject());
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void updateRelationAttribute(Map<String, String> inputRelationIdToOutputMap, Map<URI, URI> inputPartURIToOutputPartURI, IBody inputBody, IBody outputBody, XmlObject attribute) throws InvalidFormatException, NoSuchAlgorithmException, IOException {
        String oldID = attribute.getDomNode().getNodeValue();
        if (oldID != null) {
            String newID = inputRelationIdToOutputMap.get(oldID);
            if (newID == null) {
                newID = this.createRelation(inputRelationIdToOutputMap, inputPartURIToOutputPartURI, oldID, inputBody, outputBody);
            }
            attribute.getDomNode().setNodeValue(newID);
        }
    }

    private String createRelation(Map<String, String> inputRelationIdToOutputMap, Map<URI, URI> inputPartURIToOutputPartURI, String inputRelationID, IBody inputBody, IBody outputBody) throws InvalidFormatException, NoSuchAlgorithmException, IOException {
        PackagePart outputPart;
        PackageRelationship inputRelationship = inputBody.getPart().getPackagePart().getRelationship(inputRelationID);
        if (inputRelationship.getTargetMode() == TargetMode.INTERNAL) {
            PackagePart source = inputBody.getXWPFDocument().getPackagePart().getPackage().getPart(PackagingURIHelper.createPartName((URI)inputRelationship.getTargetURI()));
            outputPart = this.getOrCopyPart(inputPartURIToOutputPartURI, source, outputBody.getXWPFDocument());
        } else {
            outputPart = null;
            inputPartURIToOutputPartURI.put(inputRelationship.getTargetURI(), inputRelationship.getTargetURI());
        }
        PackageRelationship outputRelationship = this.getOrCreateRelationship(inputPartURIToOutputPartURI, outputBody, outputPart, inputRelationship);
        inputRelationIdToOutputMap.put(inputRelationship.getId(), outputRelationship.getId());
        return outputRelationship.getId();
    }

    private PackageRelationship getOrCreateRelationship(Map<URI, URI> inputPartURIToOutputPartURI, IBody outputBody, PackagePart outputPart, PackageRelationship inputRelationship) throws InvalidFormatException {
        PackageRelationship existingRelationship = null;
        for (PackageRelationship relationship : outputBody.getPart().getPackagePart().getRelationshipsByType(inputRelationship.getRelationshipType())) {
            if (relationship.getTargetMode() != inputRelationship.getTargetMode() || !inputPartURIToOutputPartURI.get(inputRelationship.getTargetURI()).equals(relationship.getTargetURI())) continue;
            existingRelationship = relationship;
            break;
        }
        PackageRelationship res = existingRelationship != null ? existingRelationship : (outputPart != null ? outputBody.getPart().getPackagePart().addRelationship(outputPart.getPartName(), inputRelationship.getTargetMode(), inputRelationship.getRelationshipType()) : outputBody.getPart().getPackagePart().addExternalRelationship(inputRelationship.getTargetURI().toString(), inputRelationship.getRelationshipType()));
        return res;
    }

    private PackagePart getOrCopyPart(Map<URI, URI> inputPartURIToOutputPartURI, PackagePart source, XWPFDocument outputDoc) throws InvalidFormatException, NoSuchAlgorithmException, IOException {
        URI existingPartURI = inputPartURIToOutputPartURI.get(source.getPartName().getURI());
        PackagePart res = existingPartURI != null ? outputDoc.getPackage().getPart(PackagingURIHelper.createPartName((URI)existingPartURI)) : this.copyPart(source, outputDoc);
        inputPartURIToOutputPartURI.put(source.getPartName().getURI(), res.getPartName().getURI());
        return res;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private PackagePart copyPart(PackagePart source, XWPFDocument outputDoc) throws InvalidFormatException, NoSuchAlgorithmException, IOException {
        PackagePart res;
        MessageDigest md5;
        PackagePart copiedPart;
        block21: {
            PackagePartName outputPartName = this.getOutputPartName(source, outputDoc);
            copiedPart = outputDoc.getPackage().createPart(outputPartName, source.getContentType());
            md5 = MessageDigest.getInstance("MD5");
            Throwable throwable = null;
            Object var8_8 = null;
            try {
                InputStream is = source.getInputStream();
                try {
                    block20: {
                        DigestInputStream dis = new DigestInputStream(is, md5);
                        try {
                            try (OutputStream os = copiedPart.getOutputStream();){
                                IOUtil.copyCompletely((InputStream)dis, (OutputStream)os);
                            }
                            if (dis == null) break block20;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (dis == null) throw throwable;
                            dis.close();
                            throw throwable;
                        }
                        dis.close();
                    }
                    if (is == null) break block21;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    if (is == null) throw throwable;
                    is.close();
                    throw throwable;
                }
                is.close();
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                    throw throwable;
                }
                if (throwable == throwable4) throw throwable;
                throwable.addSuppressed(throwable4);
                throw throwable;
            }
        }
        byte[] digest = md5.digest();
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (true) {
            if (i >= digest.length) {
                URI existingPartURI = this.getPartMD5ToName(outputDoc).get(builder.toString());
                if (existingPartURI == null) break;
                res = outputDoc.getPackage().getPart(PackagingURIHelper.createPartName((URI)existingPartURI));
                outputDoc.getPackage().removePart(copiedPart);
                return res;
            }
            builder.append(Integer.toString((digest[i] & 0xFF) + 256, 16).substring(1));
            ++i;
        }
        res = copiedPart;
        this.getPartMD5ToName(outputDoc).put(builder.toString(), res.getPartName().getURI());
        return res;
    }

    private PackagePartName getOutputPartName(PackagePart source, XWPFDocument outputDoc) throws InvalidFormatException {
        PackagePartName possiblePartName = source.getPartName();
        PackagePart existingPart = outputDoc.getPackage().getPart(possiblePartName);
        int index = 1;
        Matcher matcher = INTEGER_PATTERN.matcher(possiblePartName.getName());
        boolean indexFound = matcher.find();
        while (existingPart != null) {
            existingPart = outputDoc.getPackage().getPart(possiblePartName);
            if (existingPart == null) continue;
            possiblePartName = indexFound ? PackagingURIHelper.createPartName((String)matcher.replaceFirst(String.valueOf(index++))) : PackagingURIHelper.createPartName((String)source.getPartName().getName().replace(".", String.valueOf(index++) + "."));
        }
        return possiblePartName;
    }

    public XWPFParagraph copyBody(XWPFParagraph outputParagraph, IBody body, BookmarkManager bookmarkManager) throws Exception {
        XWPFParagraph res = null;
        if (body.getBodyElements().isEmpty()) {
            res = outputParagraph;
        } else {
            boolean inline;
            IBody outputBody = outputParagraph.getBody();
            if (!(outputBody instanceof XWPFTableCell) && outputParagraph.getRuns().size() == 1 && ((XWPFRun)outputParagraph.getRuns().get(0)).getText(0).length() == 0) {
                this.removeParagraph(outputBody, outputParagraph);
                inline = false;
            } else {
                inline = true;
            }
            HashMap<String, String> inputRelationIdToOutputMap = new HashMap<String, String>();
            HashMap<URI, URI> inputPartURIToOutputPartURI = new HashMap<URI, URI>();
            HashMap<BigInteger, BigInteger> numIDmap = new HashMap<BigInteger, BigInteger>();
            for (IBodyElement element : body.getBodyElements()) {
                if (element instanceof XWPFParagraph) {
                    XWPFParagraph inputParagraph = (XWPFParagraph)element;
                    if (inline) {
                        this.copyParagraphFragment(inputRelationIdToOutputMap, inputPartURIToOutputPartURI, numIDmap, outputParagraph, inputParagraph, null, null);
                        res = outputParagraph;
                    } else {
                        res = this.copyParagraph(outputBody, inputRelationIdToOutputMap, inputPartURIToOutputPartURI, numIDmap, inputParagraph, bookmarkManager);
                    }
                } else if (element instanceof XWPFTable) {
                    XWPFTable inputTable = (XWPFTable)element;
                    this.copyTable(outputBody, inputRelationIdToOutputMap, inputPartURIToOutputPartURI, numIDmap, inputTable, bookmarkManager);
                    res = null;
                } else if (element instanceof XWPFSDT) {
                    this.copyCTSdtBlock(outputBody, AbstractBodyParser.getCTSdtBlock(outputBody, (XWPFSDT)element));
                    res = null;
                } else {
                    throw new IllegalStateException("unknown body element.");
                }
                inline = false;
            }
            if (res != null && outputBody instanceof XWPFTableCell && res.getRuns().isEmpty()) {
                res.createRun();
            }
        }
        return res;
    }

    private void updateBookmarks(BookmarkManager bookmarkManager, XWPFTable outputTable, XWPFTable inputTable) {
        List inputRows = inputTable.getRows();
        List outputRows = outputTable.getRows();
        if (inputRows.size() == outputRows.size()) {
            int rowIndex = 0;
            while (rowIndex < inputRows.size()) {
                XWPFTableRow inputRow = (XWPFTableRow)inputRows.get(rowIndex);
                XWPFTableRow outputRow = (XWPFTableRow)outputRows.get(rowIndex);
                List inputCells = inputRow.getTableCells();
                List outputCells = outputRow.getTableCells();
                int cellIndex = 0;
                while (cellIndex < inputCells.size()) {
                    XWPFTableCell inputCell = (XWPFTableCell)inputCells.get(cellIndex);
                    XWPFTableCell outputCell = (XWPFTableCell)outputCells.get(cellIndex);
                    List inputBodyElements = inputCell.getBodyElements();
                    List outputBodyElements = outputCell.getBodyElements();
                    int bodyElementIndex = 0;
                    while (bodyElementIndex < inputBodyElements.size()) {
                        IBodyElement inputBodyElement = (IBodyElement)inputBodyElements.get(bodyElementIndex);
                        if (inputBodyElement instanceof XWPFParagraph) {
                            IBodyElement outputBodyElement = (IBodyElement)outputBodyElements.get(bodyElementIndex);
                            this.updateBookmarks(bookmarkManager, ((XWPFParagraph)outputBodyElement).getCTP(), ((XWPFParagraph)inputBodyElement).getCTP(), outputTable.getBody());
                        }
                        ++bodyElementIndex;
                    }
                    ++cellIndex;
                }
                ++rowIndex;
            }
        }
    }

    private void updateBookmarks(BookmarkManager bookmarkManager, CTP outputParagraph, CTP inputParagraph, IBody outputBody) {
        List oldBookmarks = inputParagraph.getBookmarkStartList();
        List newBookmarks = outputParagraph.getBookmarkStartList();
        int bookmarkIndex = 0;
        while (bookmarkIndex < oldBookmarks.size()) {
            bookmarkManager.updateXmlObject((CTBookmark)newBookmarks.get(bookmarkIndex), (CTBookmark)oldBookmarks.get(bookmarkIndex), outputBody);
            ++bookmarkIndex;
        }
        List inputRuns = inputParagraph.getRList();
        List outputRuns = outputParagraph.getRList();
        int runIndex = 0;
        while (runIndex < inputRuns.size()) {
            CTR inputRun = (CTR)inputRuns.get(runIndex);
            CTR outputRun = (CTR)outputRuns.get(runIndex);
            List inputTexts = inputRun.getInstrTextList();
            List outputTexts = outputRun.getInstrTextList();
            int textIndex = 0;
            while (textIndex < inputTexts.size()) {
                bookmarkManager.updateXmlObject((CTText)outputTexts.get(textIndex), (CTText)inputTexts.get(textIndex), outputBody);
                ++textIndex;
            }
            ++runIndex;
        }
    }
}

