/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.services;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.xwpf.usermodel.IBody;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.eclipse.acceleo.query.ast.Call;
import org.eclipse.acceleo.query.ast.TypeLiteral;
import org.eclipse.acceleo.query.parser.AstValidator;
import org.eclipse.acceleo.query.runtime.ICompletionProposal;
import org.eclipse.acceleo.query.runtime.IQueryBuilderEngine;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IValidationResult;
import org.eclipse.acceleo.query.runtime.impl.AbstractService;
import org.eclipse.acceleo.query.runtime.impl.ValidationServices;
import org.eclipse.acceleo.query.validation.type.ClassType;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.obeonetwork.m2doc.generator.GenerationResult;
import org.obeonetwork.m2doc.generator.M2DocEvaluationEnvironment;
import org.obeonetwork.m2doc.generator.M2DocEvaluator;
import org.obeonetwork.m2doc.services.M2DocTemplateServiceCompletionProposal;
import org.obeonetwork.m2doc.template.Parameter;
import org.obeonetwork.m2doc.template.Template;

public class M2DocTemplateService
extends AbstractService {
    private static final int MAX_DEPTH = 256;
    private final Template template;
    private final M2DocEvaluationEnvironment m2docEnv;
    private final Monitor monitor;
    private final String shortSignature;
    private final int numberOfParameters;
    private final Set<IType> returnTypes;
    private final List<IType> parameterTypes;
    private Exception exception;
    private final byte[] serializedDocument;
    private final XWPFDocument[] documents = new XWPFDocument[256];
    private int callDepth = -1;

    public M2DocTemplateService(Template template, IReadOnlyQueryEnvironment queryEnvironment) {
        this(template, null, new M2DocEvaluationEnvironment(queryEnvironment, null, null, null), null);
    }

    public M2DocTemplateService(Template template, byte[] serializedDocument, M2DocEvaluationEnvironment m2docEnv, Monitor monitor) {
        this.template = template;
        this.m2docEnv = m2docEnv;
        this.monitor = monitor;
        this.shortSignature = this.computeShortSignature(template);
        this.numberOfParameters = template.getParameters().size();
        this.serializedDocument = serializedDocument;
        this.returnTypes = new HashSet<IType>();
        this.returnTypes.add((IType)new ClassType(m2docEnv.getQueryEnvironment(), GenerationResult.class));
        this.parameterTypes = new ArrayList<IType>();
        AstValidator aqlValidator = new AstValidator(new ValidationServices(m2docEnv.getQueryEnvironment()));
        for (Parameter parameter : template.getParameters()) {
            IQueryBuilderEngine.AstResult type = parameter.getType();
            IValidationResult validatationResult = aqlValidator.validate(null, type);
            Set possibleTypes = aqlValidator.getDeclarationTypes(m2docEnv.getQueryEnvironment(), validatationResult.getPossibleTypes(type.getAst()));
            this.parameterTypes.add((IType)possibleTypes.iterator().next());
        }
        if (serializedDocument != null) {
            try {
                this.documents[0] = this.deserializeDocument(serializedDocument);
            }
            catch (IOException e) {
                this.exception = e;
            }
            catch (InvalidFormatException e) {
                this.exception = e;
            }
        }
    }

    private String computeShortSignature(Template t) {
        Object[] argumentTypes = new Object[t.getParameters().size()];
        int index = 0;
        for (Parameter parameter : t.getParameters()) {
            argumentTypes[index++] = ((TypeLiteral)parameter.getType().getAst()).getValue();
        }
        return this.serviceShortSignature(argumentTypes);
    }

    public String getName() {
        return this.template.getName();
    }

    public String getShortSignature() {
        return this.shortSignature;
    }

    public String getLongSignature() {
        return String.valueOf(EcoreUtil.getURI((EObject)this.template).toString()) + " (" + this.getShortSignature() + ")";
    }

    public List<IType> getParameterTypes(IReadOnlyQueryEnvironment env) {
        return this.parameterTypes;
    }

    public int getNumberOfParameters() {
        return this.numberOfParameters;
    }

    public int getPriority() {
        return 0;
    }

    public Set<IType> getType(Call call, ValidationServices services, IValidationResult validationResult, IReadOnlyQueryEnvironment env, List<IType> argTypes) {
        return this.returnTypes;
    }

    protected GenerationResult internalInvoke(Object[] arguments) throws Exception {
        if (this.exception != null) {
            throw new IllegalStateException("Initialization problem: " + this.getShortSignature(), this.exception);
        }
        HashMap<String, Object> variables = new HashMap<String, Object>();
        int index = 0;
        for (Parameter parameter : this.template.getParameters()) {
            variables.put(parameter.getName(), arguments[index++]);
        }
        M2DocEvaluator evaluator = new M2DocEvaluator(this.m2docEnv, this.monitor);
        ++this.callDepth;
        try {
            if (this.documents[this.callDepth] == null) {
                this.documents[this.callDepth] = this.deserializeDocument(this.serializedDocument);
            }
            GenerationResult generationResult = evaluator.generate(this.template, variables, (IBody)this.documents[this.callDepth]);
            return generationResult;
        }
        finally {
            --this.callDepth;
        }
    }

    private XWPFDocument deserializeDocument(byte[] document) throws IOException, InvalidFormatException {
        ByteArrayInputStream is = new ByteArrayInputStream(document);
        OPCPackage oPackage = OPCPackage.open((InputStream)is);
        XWPFDocument res = new XWPFDocument(oPackage);
        return res;
    }

    public List<ICompletionProposal> getProposals(IReadOnlyQueryEnvironment queryEnvironment, Set<IType> receiverTypes) {
        return Collections.singletonList(new M2DocTemplateServiceCompletionProposal(this));
    }

    public Template getTemplate() {
        return this.template;
    }
}

