/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.util;

import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Base64;
import java.util.Collection;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.util.IOUtils;
import org.apache.poi.util.Units;
import org.apache.poi.xwpf.usermodel.IBody;
import org.apache.poi.xwpf.usermodel.IBodyElement;
import org.apache.poi.xwpf.usermodel.ParagraphAlignment;
import org.apache.poi.xwpf.usermodel.UnderlinePatterns;
import org.apache.poi.xwpf.usermodel.XWPFHyperlinkRun;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFPicture;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFStyle;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.obeonetwork.m2doc.element.MBookmark;
import org.obeonetwork.m2doc.element.MElement;
import org.obeonetwork.m2doc.element.MElementContainer;
import org.obeonetwork.m2doc.element.MHyperLink;
import org.obeonetwork.m2doc.element.MImage;
import org.obeonetwork.m2doc.element.MList;
import org.obeonetwork.m2doc.element.MPagination;
import org.obeonetwork.m2doc.element.MParagraph;
import org.obeonetwork.m2doc.element.MStyle;
import org.obeonetwork.m2doc.element.MTable;
import org.obeonetwork.m2doc.element.MText;
import org.obeonetwork.m2doc.generator.GenerationResult;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTColor;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTHpsMeasure;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTShd;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTStyle;

public class HtmlSerializer {
    private static final String BASELINE = "baseline";
    private static final String TOP = "top";
    private static final String BOTTOM = "bottom";
    private static final String LEFT = "left";
    private static final String RIGHT = "right";
    private static final String CENTER = "center";
    private static final String JUSTIFY = "justify";
    private static final String BACKGROUND_COLOR_FORMAT = "background-color:#%s;";
    private static final String COLOR_FORMAT = "color:#%s;";
    private static final String COLOR_RGB_FOMRAT = "color:#%02X%02X%02X;";
    private static final String VERTICAL_ALIGN_FORMAT = "vertical-align:%s;";
    private static final String TEXT_ALIGN_FORMAT = "text-align:%s;";
    private static final String BORDER_COLLAPSE_COLLAPSE = "border-collapse: collapse;";
    private static final String FONT_SIZE_FORMAT = "font-size:%spx;";
    private static final String BACKGROUND_COLOR_RGB_FORMAT = "background-color:#%02X%02X%02X;";
    private static final String TABLE_OF_CONTENT = "[TABLE OF CONTENT]";
    private static final String BORDER_1PX_SOLID_BLACK = "border: 1px solid black;";
    private static final String BR = "<br>";
    private static final String LINK_FORMAT = "<a href=\"%s\">%s</a>";
    private static final String PARAGRAPH_FORMAT = "<p>%s</p>";
    private static final String PARAGRAPH_STYLED_FORMAT = "<p style=\"%s\">%s</p>";
    private static final String IMAGE_FORMAT = "<img width=%s height=%s src=\"data:%s;base64, %s\">";
    private static final String STRONG_FORMAT = "<strong>%s</strong>";
    private static final String ITALIC_FORMAT = "<i>%s</i>";
    private static final String STRIKETHROUGH_FORMAT = "<del>%s</del>";
    private static final String UNDERLINE_FORMAT = "<u>%s</u>";
    private static final String TABLE_STYLED_FORMAT = "<table style=\"%s\">%s</table>";
    private static final String TD_STYLED_FORMAT = "<td style=\"%s\">%s</td>";
    private static final String TR_STYLED_FORMAT = "<tr style=\"%s\">%s</tr>";
    private static final String SPAWN_STYLED_FORMAT = "<spawn style=\"%s\">%s</spawn>";

    public String serialize(Object object) {
        String res;
        if (object instanceof MElement) {
            res = this.serialize((MElement)object);
        } else if (object instanceof GenerationResult) {
            res = this.serialize((GenerationResult)object);
        } else if (object instanceof IBody) {
            res = this.serialize(object);
        } else if (object instanceof Collection) {
            StringBuilder builder = new StringBuilder();
            for (Object child : (Collection)object) {
                builder.append(this.serialize(child));
            }
            res = builder.toString();
        } else {
            res = object != null ? String.format(PARAGRAPH_FORMAT, object.toString()) : String.format(PARAGRAPH_FORMAT, "null");
        }
        return res;
    }

    public String serialize(MElement element) {
        String res;
        if (element instanceof MList) {
            StringBuilder builder = new StringBuilder();
            for (MElement child : (MList)element) {
                builder.append(this.serialize(child));
            }
            res = builder.toString();
        } else if (element instanceof MPagination) {
            res = this.serialize((MPagination)element);
        } else if (element instanceof MBookmark) {
            MBookmark bookmark = (MBookmark)element;
            res = String.format(LINK_FORMAT, bookmark.getText(), bookmark.getId());
        } else if (element instanceof MImage) {
            MImage image = (MImage)element;
            res = this.serialize(image);
        } else if (element instanceof MParagraph) {
            res = this.serialize((MParagraph)element);
        } else if (element instanceof MTable) {
            MTable table = (MTable)element;
            res = this.serialize(table);
        } else if (element instanceof MText) {
            MText text = (MText)element;
            res = this.serialize(text);
        } else {
            res = element != null ? element.toString() : "";
        }
        return res;
    }

    private String serialize(MParagraph paragraph) {
        String res;
        String content = this.serialize(paragraph.getContents());
        if (paragraph.getHAlignment() != null) {
            String style = String.format(TEXT_ALIGN_FORMAT, this.getHTMLAlignment(paragraph.getHAlignment()));
            res = String.format(PARAGRAPH_STYLED_FORMAT, style, content);
        } else {
            res = String.format(PARAGRAPH_FORMAT, content);
        }
        return res;
    }

    private String serialize(MPagination pagination) {
        String res;
        switch (pagination) {
            case ligneBreak: {
                res = BR;
                break;
            }
            case newColumn: {
                res = BR;
                break;
            }
            case newPage: {
                res = BR;
                break;
            }
            case newParagraph: {
                res = BR;
                break;
            }
            case newTableOfContent: {
                res = TABLE_OF_CONTENT;
                break;
            }
            case newTextWrapping: {
                res = BR;
                break;
            }
            default: {
                res = "";
            }
        }
        return res;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String serialize(MImage image) {
        StringBuilder builder = new StringBuilder();
        try {
            Throwable throwable = null;
            Object var5_6 = null;
            try {
                InputStream is = image.getInputStream();
                try {
                    try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
                        IOUtils.copy((InputStream)is, (OutputStream)os);
                        builder.append(String.format(IMAGE_FORMAT, image.getWidth(), image.getHeight(), "image/" + image.getType().name().toLowerCase(), new String(Base64.getEncoder().encode(os.toByteArray()))));
                    }
                    if (is == null) return builder.toString();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (is == null) throw throwable;
                    is.close();
                    throw throwable;
                }
                is.close();
                return builder.toString();
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            builder.append(String.format(PARAGRAPH_FORMAT, e.getMessage()));
        }
        return builder.toString();
    }

    private String serialize(MTable table) {
        StringBuilder res = new StringBuilder();
        for (MTable.MRow row : table.getRows()) {
            StringBuilder rowBuilder = new StringBuilder();
            for (MTable.MCell cell : row.getCells()) {
                String style = BORDER_1PX_SOLID_BLACK;
                if (cell.getBackgroundColor() != null) {
                    Color color = cell.getBackgroundColor();
                    style = String.valueOf(style) + String.format(BACKGROUND_COLOR_RGB_FORMAT, color.getRed(), color.getGreen(), color.getBlue());
                }
                if (cell.getHAlignment() != null) {
                    style = String.valueOf(style) + String.format(TEXT_ALIGN_FORMAT, this.getHTMLAlignment(cell.getHAlignment()));
                }
                if (cell.getVAlignment() != null) {
                    style = String.valueOf(style) + String.format(VERTICAL_ALIGN_FORMAT, this.getHTMLAlignment(cell.getVAlignment()));
                }
                rowBuilder.append(String.format(TD_STYLED_FORMAT, style, this.serialize(cell.getContents())));
            }
            res.append(String.format(TR_STYLED_FORMAT, BORDER_1PX_SOLID_BLACK, rowBuilder.toString()));
        }
        return String.format(TABLE_STYLED_FORMAT, "border: 1px solid black;border-collapse: collapse;", res.toString());
    }

    private String getHTMLAlignment(MElementContainer.HAlignment alignment) {
        String res;
        switch (alignment) {
            case CENTER: {
                res = CENTER;
                break;
            }
            case BOTH: 
            case DISTRIBUTE: {
                res = JUSTIFY;
                break;
            }
            case RIGHT: {
                res = RIGHT;
                break;
            }
            default: {
                res = LEFT;
            }
        }
        return res;
    }

    private String getHTMLAlignment(MTable.MCell.VAlignment alignment) {
        String res;
        switch (alignment) {
            case BOTTOM: {
                res = BOTTOM;
                break;
            }
            case TOP: {
                res = TOP;
                break;
            }
            default: {
                res = BASELINE;
            }
        }
        return res;
    }

    private String serialize(MText text) {
        String formatedText = String.format(this.getStyleFormat(text.getStyle()), HtmlSerializer.escapeHTML(text.getText()));
        String res = text instanceof MHyperLink ? String.format(LINK_FORMAT, ((MHyperLink)text).getUrl(), formatedText) : formatedText;
        return res;
    }

    private String getStyleFormat(MStyle style) {
        String res = "%s";
        if (style != null) {
            Color color;
            if (style.getFontModifiers() != -1) {
                if ((style.getFontModifiers() & 1) != 0) {
                    res = String.format(STRONG_FORMAT, res);
                }
                if ((style.getFontModifiers() & 2) != 0) {
                    res = String.format(ITALIC_FORMAT, res);
                }
                if ((style.getFontModifiers() & 8) != 0) {
                    res = String.format(STRIKETHROUGH_FORMAT, res);
                }
                if ((style.getFontModifiers() & 4) != 0) {
                    res = String.format(UNDERLINE_FORMAT, res);
                }
            }
            String spawnStyle = "";
            if (style.getFontSize() != -1) {
                spawnStyle = String.valueOf(spawnStyle) + String.format(FONT_SIZE_FORMAT, style.getFontSize());
            }
            if (style.getBackgroundColor() != null) {
                color = style.getBackgroundColor();
                spawnStyle = String.valueOf(spawnStyle) + String.format(BACKGROUND_COLOR_RGB_FORMAT, color.getRed(), color.getGreen(), color.getBlue());
            }
            if (style.getForegroundColor() != null) {
                color = style.getForegroundColor();
                spawnStyle = String.valueOf(spawnStyle) + String.format(COLOR_RGB_FOMRAT, color.getRed(), color.getGreen(), color.getBlue());
            }
            if (!spawnStyle.isEmpty()) {
                res = String.format(SPAWN_STYLED_FORMAT, spawnStyle, res);
            }
        }
        return res;
    }

    private String serialize(GenerationResult result) {
        return this.serialize(result.getBody());
    }

    public String serialize(IBody body) {
        StringBuilder res = new StringBuilder();
        for (IBodyElement element : body.getBodyElements()) {
            res.append(this.serialize(element));
        }
        return res.toString();
    }

    public String serialize(IBodyElement element) {
        String res = element instanceof XWPFParagraph ? this.serialize((XWPFParagraph)element) : (element instanceof XWPFTable ? this.serialize((XWPFTable)element) : "");
        return res;
    }

    private String serialize(XWPFParagraph paragraph) {
        XWPFStyle style;
        CTStyle ctStyle;
        String paragraphStyle = "";
        XWPFParagraph localParagraph = new XWPFParagraph(paragraph.getCTP(), paragraph.getBody());
        if (localParagraph.getStyleID() != null && (ctStyle = (style = localParagraph.getBody().getXWPFDocument().getStyles().getStyle(localParagraph.getStyleID())).getCTStyle()).isSetRPr()) {
            CTRPr rPr = ctStyle.getRPr();
            for (CTHpsMeasure mesure : rPr.getSzCsList()) {
                double size = ((BigInteger)mesure.getVal()).doubleValue();
                paragraphStyle = String.valueOf(paragraphStyle) + String.format(FONT_SIZE_FORMAT, size);
            }
            for (CTColor ctColor : rPr.getColorList()) {
                String color = ctColor.xgetVal().getStringValue();
                paragraphStyle = String.valueOf(paragraphStyle) + String.format(COLOR_FORMAT, color);
            }
        }
        if (localParagraph.getAlignment() != null) {
            paragraphStyle = String.valueOf(paragraphStyle) + String.format(TEXT_ALIGN_FORMAT, this.getHTMLAlignment(localParagraph.getAlignment()));
        }
        StringBuilder contentBuilder = new StringBuilder();
        for (XWPFRun run : localParagraph.getRuns()) {
            String escapedText = HtmlSerializer.escapeHTML(run.getText(0));
            String formatedText = String.format(this.getStyleFormat(run), escapedText);
            for (XWPFPicture picture : run.getEmbeddedPictures()) {
                int width = Units.pointsToPixel((double)Units.toPoints((long)picture.getCTPicture().getSpPr().getXfrm().getExt().getCx()));
                int height = Units.pointsToPixel((double)Units.toPoints((long)picture.getCTPicture().getSpPr().getXfrm().getExt().getCy()));
                contentBuilder.append(String.format(IMAGE_FORMAT, width, height, picture.getPictureData().getPackagePart().getContentType(), new String(Base64.getEncoder().encode(picture.getPictureData().getData()))));
            }
            if (run instanceof XWPFHyperlinkRun) {
                String id = ((XWPFHyperlinkRun)run).getCTHyperlink().getId();
                PackageRelationship relation = localParagraph.getBody().getPart().getPackagePart().getRelationship(id);
                String url = relation.getSourceURI().toString();
                contentBuilder.append(String.format(LINK_FORMAT, HtmlSerializer.escapeHTML(url), formatedText));
                continue;
            }
            contentBuilder.append(formatedText);
        }
        String res = !paragraphStyle.isEmpty() ? String.format(PARAGRAPH_STYLED_FORMAT, paragraphStyle, contentBuilder.toString()) : String.format(PARAGRAPH_FORMAT, contentBuilder.toString());
        return res;
    }

    private String getStyleFormat(XWPFRun run) {
        String res = "%s";
        if (run.isBold()) {
            res = String.format(STRONG_FORMAT, res);
        }
        if (run.isItalic()) {
            res = String.format(ITALIC_FORMAT, res);
        }
        if (run.isStrikeThrough()) {
            res = String.format(STRIKETHROUGH_FORMAT, res);
        }
        if (run.getUnderline() != null && run.getUnderline() != UnderlinePatterns.NONE) {
            res = String.format(UNDERLINE_FORMAT, res);
        }
        String spawnStyle = "";
        if (run.getFontSize() != -1) {
            spawnStyle = String.valueOf(spawnStyle) + String.format(FONT_SIZE_FORMAT, run.getFontSize());
        }
        if (run.getCTR().getRPr() != null) {
            for (CTShd ctShd : run.getCTR().getRPr().getShdList()) {
                if (ctShd.getFill() == null) continue;
                spawnStyle = String.valueOf(spawnStyle) + String.format(BACKGROUND_COLOR_FORMAT, ctShd.getFill());
            }
        }
        if (run.getColor() != null) {
            spawnStyle = String.valueOf(spawnStyle) + String.format(COLOR_FORMAT, run.getColor());
        }
        if (!spawnStyle.isEmpty()) {
            res = String.format(SPAWN_STYLED_FORMAT, spawnStyle, res);
        }
        return res;
    }

    public static String escapeHTML(String str) {
        StringBuilder res = new StringBuilder();
        if (str != null) {
            int i = 0;
            while (i < str.length()) {
                char c = str.charAt(i);
                switch (c) {
                    case '\"': 
                    case '&': 
                    case '\'': 
                    case '<': 
                    case '>': {
                        res.append("&#");
                        res.append((int)c);
                        res.append(';');
                        break;
                    }
                    default: {
                        res.append(c);
                    }
                }
                ++i;
            }
        }
        return res.toString();
    }

    private String getHTMLAlignment(ParagraphAlignment alignment) {
        String res;
        switch (alignment) {
            case CENTER: {
                res = CENTER;
                break;
            }
            case BOTH: 
            case DISTRIBUTE: {
                res = JUSTIFY;
                break;
            }
            case RIGHT: {
                res = RIGHT;
                break;
            }
            default: {
                res = LEFT;
            }
        }
        return res;
    }

    private String serialize(XWPFTable table) {
        StringBuilder res = new StringBuilder();
        XWPFTable localTable = new XWPFTable(table.getCTTbl(), table.getBody());
        for (XWPFTableRow row : localTable.getRows()) {
            StringBuilder rowBuilder = new StringBuilder();
            for (XWPFTableCell cell : row.getTableCells()) {
                String style = BORDER_1PX_SOLID_BLACK;
                if (cell.getColor() != null) {
                    style = String.valueOf(style) + String.format(BACKGROUND_COLOR_FORMAT, cell.getColor());
                }
                if (cell.getVerticalAlignment() != null) {
                    style = String.valueOf(style) + String.format(VERTICAL_ALIGN_FORMAT, this.getHTMLAlignment(cell.getVerticalAlignment()));
                }
                rowBuilder.append(String.format(TD_STYLED_FORMAT, style, this.serialize((IBody)cell)));
            }
            res.append(String.format(TR_STYLED_FORMAT, BORDER_1PX_SOLID_BLACK, rowBuilder.toString()));
        }
        return String.format(TABLE_STYLED_FORMAT, "border: 1px solid black;border-collapse: collapse;", res.toString());
    }

    private String getHTMLAlignment(XWPFTableCell.XWPFVertAlign verticalAlignment) {
        String res;
        switch (verticalAlignment) {
            case BOTTOM: {
                res = BOTTOM;
                break;
            }
            case TOP: {
                res = TOP;
                break;
            }
            default: {
                res = BASELINE;
            }
        }
        return res;
    }
}

