/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.html.services;

import java.awt.Color;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFNumbering;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.obeonetwork.m2doc.element.MElement;
import org.obeonetwork.m2doc.element.MElementContainer;
import org.obeonetwork.m2doc.element.MImage;
import org.obeonetwork.m2doc.element.MList;
import org.obeonetwork.m2doc.element.MPagination;
import org.obeonetwork.m2doc.element.MParagraph;
import org.obeonetwork.m2doc.element.MStyle;
import org.obeonetwork.m2doc.element.MTable;
import org.obeonetwork.m2doc.element.PictureType;
import org.obeonetwork.m2doc.element.impl.MHyperLinkImpl;
import org.obeonetwork.m2doc.element.impl.MImageImpl;
import org.obeonetwork.m2doc.element.impl.MListImpl;
import org.obeonetwork.m2doc.element.impl.MParagraphImpl;
import org.obeonetwork.m2doc.element.impl.MStyleImpl;
import org.obeonetwork.m2doc.element.impl.MTableImpl;
import org.obeonetwork.m2doc.element.impl.MTextImpl;
import org.obeonetwork.m2doc.html.services.M2DocCSSParser;
import org.obeonetwork.m2doc.html.services.Parser;
import org.obeonetwork.m2doc.services.PaginationServices;
import org.openxmlformats.schemas.officeDocument.x2006.sharedTypes.STOnOff;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTAbstractNum;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTDecimalNumber;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTFonts;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTInd;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTLevelText;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTLvl;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTNum;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTNumFmt;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTNumbering;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STJc;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STMultiLevelType;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STNumberFormat;

public class M2DocHTMLParser
extends Parser {
    private static final String NONE = "none";
    private static final String OL_TAG = "ol";
    private static final String UL_TAG = "ul";
    private static final String BR_TAG = "br";
    private static final Set<String> BR_CONTINUE_TAGS = M2DocHTMLParser.initializeBrContinueTags();
    private static final String SMALL_TAG = "small";
    private static final String BIG_TAG = "big";
    private static final String A_TAG = "a";
    private static final String FONT_TAG = "font";
    private static final String SUP_TAG = "sup";
    private static final String SUB_TAG = "sub";
    private static final String INS_TAG = "ins";
    private static final String U_TAG = "u";
    private static final String DEL_TAG = "del";
    private static final String STRIKE_TAG = "strike";
    private static final String S_TAG = "s";
    private static final String CITE_TAG = "cite";
    private static final String VAR_TAG = "var";
    private static final String I_TAG = "i";
    private static final String EM_TAG = "em";
    private static final String B_TAG = "b";
    private static final String STRONG_TAG = "strong";
    private static final String SPAN_TAG = "span";
    private static final String P_TAG = "p";
    private static final String SVG_TAG = "svg";
    private static final String BLOCKQUOTE_TAG = "blockquote";
    private static final String CENTER_TAG = "center";
    private static final String PRE_TAG = "pre";
    private static final String COURIER_NEW_FONT = "Courier New";
    private static final int CODE_GREEN = 16384;
    private static final String WINGDINGS_FONT = "Wingdings";
    private static final String SYMBOL_FONT = "Symbol";
    private static final double BIG_RATIO = 1.33;
    private static final double SMALL_RATIO = 0.8;
    private static final String HEIGHT_ATTR = "height";
    private static final String WIDTH_ATTR = "width";
    private static final String DIR_ATTR = "dir";
    private static final String HREF_ATTR = "href";
    private static final String SIZE_ATTR = "size";
    private static final int INDENT_LEFT = 720;
    private static final int INDENT_HANGING = 180;
    private static final String TYPE_ATTR = "type";
    private static final String DISC_SYMBOL = "\uf0b7";
    private static final String SQUARE_SYMBOL = "\uf0a7";
    private static final String CIRCLE_SYMBOL = "o";
    private static final int H6_FONT_SIZE = 8;
    private static final int H5_FONT_SIZE = 10;
    private static final int H4_FONT_SIZE = 12;
    private static final int H3_FONT_SIZE = 14;
    private static final int H2_FONT_SIZE = 18;
    private static final int H1_FONT_SIZE = 24;
    private static final int BLOCKQUOTE_DEFAULT_MARGING_LEFT = 40;
    private static final Color LINK_COLOR = Color.BLUE;
    private static final M2DocCSSParser CSS_PARSER = new M2DocCSSParser();
    private final Map<String, Map<String, List<String>>> cssClasses = new LinkedHashMap<String, Map<String, List<String>>>();
    private final URIConverter uriConverter;
    private final XWPFDocument destinationDocument;
    private List<String> svgs;
    private int svgIndex;

    public M2DocHTMLParser(URIConverter uriConverter, XWPFDocument destinationDocument) {
        this.uriConverter = uriConverter;
        this.destinationDocument = destinationDocument;
    }

    private static Set<String> initializeBrContinueTags() {
        HashSet<String> res = new HashSet<String>();
        res.add(BR_TAG);
        res.add(SMALL_TAG);
        res.add(BIG_TAG);
        res.add(A_TAG);
        res.add(FONT_TAG);
        res.add(SUP_TAG);
        res.add(SUB_TAG);
        res.add(INS_TAG);
        res.add(U_TAG);
        res.add(DEL_TAG);
        res.add(STRIKE_TAG);
        res.add(S_TAG);
        res.add(CITE_TAG);
        res.add(VAR_TAG);
        res.add(I_TAG);
        res.add(EM_TAG);
        res.add(B_TAG);
        res.add(STRONG_TAG);
        res.add(SPAN_TAG);
        return res;
    }

    public List<MElement> parse(URI baseURI, String htmlString) {
        MListImpl res = new MListImpl();
        MParagraphImpl parent = new MParagraphImpl((MElement)res, null);
        this.svgs = new ArrayList<String>();
        this.initializeSVGs(this.svgs, (Node)Jsoup.parse((String)htmlString, (String)baseURI.toString(), (org.jsoup.parser.Parser)org.jsoup.parser.Parser.xmlParser()));
        this.svgIndex = 0;
        Document document = Jsoup.parse((String)htmlString, (String)baseURI.toString());
        document.outputSettings().syntax(Document.OutputSettings.Syntax.xml);
        document.outputSettings().charset(StandardCharsets.UTF_8);
        Element htmlElement = (Element)document.getElementsByTag("html").get(0);
        Element headElement = (Element)htmlElement.getElementsByTag("head").get(0);
        this.parseHead(baseURI, headElement);
        Element bodyElement = (Element)htmlElement.getElementsByTag("body").get(0);
        this.cleanHTML((Node)bodyElement);
        MStyleImpl defaultStyle = new MStyleImpl(null, -1, null, null, -1);
        if (document.body().hasAttr("bgcolor")) {
            defaultStyle.setBackgroundColor(this.htmlToColor(bodyElement.attr("bgcolor").toLowerCase()));
        }
        Context context = new Context(baseURI, (MStyle)defaultStyle);
        context.pushMarginLeft(null);
        context.pushMarginRight(null);
        context.pushMarginTop(null);
        context.pushMarginBottom(null);
        try {
            this.applyGlobalAttibutes(context, (Node)bodyElement);
        }
        finally {
            context.popMarginLeft();
            context.popMarginRight();
            context.popMarginTop();
            context.popMarginBottom();
        }
        this.walkChildren((Node)bodyElement, context, (MParagraph)parent);
        this.createNeededParagraphes((MParagraph)parent);
        return res;
    }

    private void cleanHTML(Node node) {
        ArrayList<Node> toRemove = new ArrayList<Node>();
        if (node instanceof Element) {
            if (this.isHidden(node)) {
                toRemove.add(node);
            } else {
                ArrayList<Object> nodeList = new ArrayList<Node>();
                for (Node child : node.childNodes()) {
                    this.cleanHTML(child);
                    if (this.continueBrList(child)) {
                        nodeList.add(child);
                        continue;
                    }
                    if (nodeList.isEmpty()) continue;
                    this.removeBrTags(toRemove, nodeList);
                    nodeList = new ArrayList();
                }
                if (!nodeList.isEmpty()) {
                    this.removeBrTags(toRemove, nodeList);
                }
            }
        }
        for (Node remove : toRemove) {
            remove.remove();
        }
    }

    private boolean continueBrList(Node node) {
        boolean res = node instanceof TextNode ? true : BR_CONTINUE_TAGS.contains(node.nodeName());
        return res;
    }

    private void removeBrTags(List<Node> toRemove, List<Node> nodeList) {
        boolean onlyBrTag = true;
        Node lastBrTag = null;
        for (Node child : nodeList) {
            boolean isEmptyTextChild = child instanceof TextNode && this.text((TextNode)child).trim().isEmpty();
            boolean isBrChild = BR_TAG.equals(child.nodeName());
            boolean bl = onlyBrTag = onlyBrTag && (isBrChild || isEmptyTextChild);
            if (isBrChild) {
                lastBrTag = child;
                continue;
            }
            if (lastBrTag == null || isEmptyTextChild) continue;
            lastBrTag = null;
        }
        if (!onlyBrTag && lastBrTag != null) {
            toRemove.add(lastBrTag);
        }
    }

    private void initializeSVGs(List<String> svgsResults, Node node) {
        if (node instanceof Element) {
            if (SVG_TAG.equals(node.nodeName())) {
                svgsResults.add(node.toString());
            } else {
                for (Node child : node.childNodes()) {
                    this.initializeSVGs(svgsResults, child);
                }
            }
        }
    }

    private void parseHead(URI baseURI, Element headElement) {
        for (Node child : headElement.childNodes()) {
            if (!(child instanceof Element)) continue;
            Element element = (Element)child;
            if ("link".equals(element.nodeName()) && element.hasAttr("rel") && "stylesheet".equals(element.attr("rel")) && element.hasAttr(HREF_ATTR)) {
                URI cssURI = this.toURI(baseURI, element.attr(HREF_ATTR));
                try {
                    Throwable throwable = null;
                    Object var8_10 = null;
                    try (InputStream is = this.uriConverter.createInputStream(cssURI);){
                        Map<String, Map<String, List<String>>> loadedCssClasses = CSS_PARSER.parseClasses(M2DocHTMLParser.getContent(is, "UTF-8"));
                        CSS_PARSER.mergeCSSStyles(loadedCssClasses, this.cssClasses);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException iOException) {}
                continue;
            }
            if (!"style".equals(element.nodeName()) || element.childNodeSize() < 1) continue;
            Map<String, Map<String, List<String>>> parsedCssClasses = CSS_PARSER.parseClasses(((Node)element.childNodes().get(0)).toString());
            CSS_PARSER.mergeCSSStyles(parsedCssClasses, this.cssClasses);
        }
    }

    private void walkNodeTree(MParagraph parent, Context context, Node node, Element lastElement) {
        Context contextCopy = context.copy();
        if (node instanceof Element) {
            if ("table".equals(node.nodeName())) {
                Node tHeader = null;
                for (Node child : node.childNodes()) {
                    if (!"thead".equals(child.nodeName())) continue;
                    tHeader = child;
                    break;
                }
                Node tBody = null;
                for (Node child : node.childNodes()) {
                    if (!"tbody".equals(child.nodeName())) continue;
                    tBody = child;
                    break;
                }
                if (tBody != null) {
                    this.insertTable(parent, context, tHeader, tBody);
                }
            } else if (SVG_TAG.equals(node.nodeName())) {
                MImageImpl mImage = new MImageImpl(this.svgs.get(this.svgIndex++).getBytes(StandardCharsets.UTF_8), PictureType.SVG);
                MList parentContents = (MList)parent.getContents();
                parentContents.add((Object)mImage);
            } else {
                if (UL_TAG.equals(node.nodeName()) || OL_TAG.equals(node.nodeName())) {
                    contextCopy.cssProperties.remove("list-style-type");
                }
                contextCopy.pushMarginLeft(null);
                contextCopy.pushMarginRight(null);
                contextCopy.pushMarginTop(null);
                contextCopy.pushMarginBottom(null);
                this.applyGlobalAttibutes(contextCopy, node);
                if (BLOCKQUOTE_TAG.equals(node.nodeName())) {
                    contextCopy.replaceLastDefaultMarginLeft(40);
                }
                MParagraph element = this.startElement(parent, contextCopy, (Element)node);
                try {
                    this.walkChildren(node, contextCopy, element);
                }
                finally {
                    contextCopy.popMarginLeft();
                    contextCopy.popMarginRight();
                    contextCopy.popMarginTop();
                    contextCopy.popMarginBottom();
                }
                this.endParagraph(parent, element);
                if (element != parent) {
                    this.createNeededParagraphes(element);
                }
            }
        } else if (node instanceof TextNode) {
            this.insertText(parent, contextCopy, (TextNode)node, lastElement);
        }
    }

    private boolean isHidden(Node node) {
        boolean res;
        if (node.hasAttr("hidden")) {
            res = true;
        } else {
            Map<String, List<String>> cssProperties = CSS_PARSER.getCSSProperties(node, this.cssClasses);
            res = CSS_PARSER.hasCSS(cssProperties, "display", NONE);
        }
        return res;
    }

    private void walkChildren(Node node, Context context, MParagraph parent) {
        Element lastElement = null;
        MList parentContents = (MList)parent.getContents();
        for (Node child : node.childNodes()) {
            MTextImpl mText;
            boolean needQuotes = "q".equals(child.nodeName());
            if (needQuotes) {
                mText = new MTextImpl("\u00ab", null);
                parentContents.add((Object)mText);
            }
            this.walkNodeTree(parent, context, child, lastElement);
            if (needQuotes) {
                mText = new MTextImpl("\u00bb", null);
                parentContents.add((Object)mText);
            }
            if ("div".equals(child.nodeName())) continue;
            lastElement = child instanceof Element ? (Element)child : null;
        }
    }

    private void createNeededParagraphes(MParagraph parent) {
        MListImpl newParent = new MListImpl();
        MList parentContents = (MList)parent.getContents();
        MListImpl paragraphList = new MListImpl();
        MParagraph currentParagraph = this.createEmptyParagraphWithSameStyle(parent, (MList)paragraphList);
        boolean paragraphEncountered = false;
        boolean tableEncountered = false;
        for (MElement child : parentContents) {
            if (child instanceof MParagraph || child instanceof MTable) {
                paragraphEncountered = true;
                tableEncountered = child instanceof MTable;
                if (!paragraphList.isEmpty()) {
                    newParent.add((Object)currentParagraph);
                    paragraphList = new MListImpl();
                    currentParagraph = this.createEmptyParagraphWithSameStyle(parent, (MList)paragraphList);
                }
                newParent.add((Object)child);
                continue;
            }
            if (paragraphEncountered) {
                if (tableEncountered || child != MPagination.ligneBreak || !paragraphList.isEmpty()) {
                    paragraphList.add((Object)child);
                }
                tableEncountered = false;
                continue;
            }
            newParent.add((Object)child);
        }
        if (!paragraphList.isEmpty()) {
            newParent.add((Object)currentParagraph);
        }
        parentContents.clear();
        parentContents.addAll((Collection)newParent);
    }

    private MParagraph createEmptyParagraphWithSameStyle(MParagraph paragraph, MList contents) {
        MParagraphImpl currentParagraph = new MParagraphImpl((MElement)contents, paragraph.getStyleName());
        currentParagraph.setHAlignment(paragraph.getHAlignment());
        currentParagraph.setMarginLeft(paragraph.getMarginLeft());
        currentParagraph.setNumberingID(paragraph.getNumberingID());
        currentParagraph.setNumberingLevel(paragraph.getNumberingLevel());
        currentParagraph.setTextDirection(paragraph.getTextDirection());
        return currentParagraph;
    }

    private void insertTable(MParagraph parent, Context context, Node header, Node body) {
        ArrayList childNodes;
        MTableImpl table = new MTableImpl();
        MList parentContents = (MList)parent.getContents();
        parentContents.add((Object)table);
        this.setTableAlign(parent, (MTable)table);
        HashMap<Integer, Integer> rowSpans = new HashMap<Integer, Integer>();
        HashMap<Integer, List<MTable.MCell>> vMergeCopies = new HashMap<Integer, List<MTable.MCell>>();
        if (header != null) {
            childNodes = new ArrayList(header.childNodes());
            childNodes.addAll(body.childNodes());
        } else {
            childNodes = new ArrayList(body.childNodes());
        }
        for (Node child : childNodes) {
            if (!"tr".equals(child.nodeName())) continue;
            MTableImpl.MRowImpl row = new MTableImpl.MRowImpl();
            table.getRows().add(row);
            if (child.hasAttr(HEIGHT_ATTR)) {
                this.setRowHeight((MTable.MRow)row, child.attr(HEIGHT_ATTR));
            }
            Context localRowContext = context.copy();
            this.applyGlobalAttibutes(localRowContext, child);
            CSS_PARSER.setStyle((Map<String, List<String>>)localRowContext.cssProperties, (MTable.MRow)row);
            for (Node rowChild : child.childNodes()) {
                if (!"th".equals(rowChild.nodeName()) && !"td".equals(rowChild.nodeName())) continue;
                MListImpl contents = new MListImpl();
                MParagraphImpl newParagraph = new MParagraphImpl((MElement)contents, null);
                MTableImpl.MCellImpl cell = new MTableImpl.MCellImpl((MElement)contents, null);
                Context localCellContext = context.copy();
                this.applyGlobalAttibutes(localCellContext, rowChild);
                if ("th".equals(rowChild.nodeName())) {
                    cell.setHAlignment(MElementContainer.HAlignment.CENTER);
                    this.setModifiers(localCellContext.style, 1);
                }
                if (rowChild.hasAttr(WIDTH_ATTR)) {
                    this.setCellWidth((MTable.MCell)cell, rowChild.attr(WIDTH_ATTR));
                }
                CSS_PARSER.setStyle((Map<String, List<String>>)localCellContext.cssProperties, (MTable.MCell)cell);
                this.walkChildren(rowChild, localCellContext, (MParagraph)newParagraph);
                this.createNeededParagraphes((MParagraph)newParagraph);
                this.insertMergedCells((MTable.MRow)row, rowChild, (MTable.MCell)cell, rowSpans, vMergeCopies);
            }
            this.insertRowspans((MTable.MRow)row, rowSpans, vMergeCopies);
        }
    }

    private void setTableAlign(MParagraph parent, MTable table) {
        MElementContainer.HAlignment parentAlignment = parent.getHAlignment();
        if (parentAlignment != null) {
            switch (parentAlignment) {
                case LEFT: {
                    table.setTableAlign(MTable.MTableAlign.LEFT);
                    break;
                }
                case CENTER: {
                    table.setTableAlign(MTable.MTableAlign.CENTER);
                    break;
                }
                case RIGHT: {
                    table.setTableAlign(MTable.MTableAlign.RIGHT);
                    break;
                }
            }
        }
    }

    private void insertRowspans(MTable.MRow row, Map<Integer, Integer> rowSpans, Map<Integer, List<MTable.MCell>> vMergeCopies) {
        int currentColumn = row.getCells().size();
        Integer remainingRowSpan = rowSpans.remove(currentColumn);
        while (remainingRowSpan != null) {
            List<MTable.MCell> toCopy = vMergeCopies.get(currentColumn);
            row.getCells().addAll(toCopy);
            int newRemainingRowSpan = remainingRowSpan - 1;
            if (newRemainingRowSpan > 0) {
                rowSpans.put(currentColumn, newRemainingRowSpan);
            } else {
                vMergeCopies.remove(currentColumn);
            }
            currentColumn = row.getCells().size();
            remainingRowSpan = rowSpans.remove(currentColumn);
        }
    }

    private void insertMergedCells(MTable.MRow row, Node rowChild, MTable.MCell cell, Map<Integer, Integer> rowSpans, Map<Integer, List<MTable.MCell>> vMergeCopies) {
        boolean restartHMerge;
        boolean restartVMerge;
        int currentColumn;
        this.insertRowspans(row, rowSpans, vMergeCopies);
        int lastColumn = currentColumn = row.getCells().size();
        int rowSpan = this.getRowSpan(rowChild);
        if (rowSpan > -1) {
            cell.setVMerge(MTable.MCell.Merge.RESTART);
            restartVMerge = true;
            if (rowSpan == 0) {
                rowSpans.put(currentColumn, Integer.MAX_VALUE);
            } else {
                rowSpans.put(currentColumn, rowSpan - 1);
            }
        } else {
            restartVMerge = false;
        }
        row.getCells().add(cell);
        ++lastColumn;
        int colSpan = this.getColSpan(rowChild);
        if (colSpan > 1) {
            cell.setHMerge(MTable.MCell.Merge.RESTART);
            restartHMerge = true;
            int i = 1;
            while (i < colSpan) {
                MListImpl hMergedContents = new MListImpl();
                MTableImpl.MCellImpl hMergedCell = new MTableImpl.MCellImpl((MElement)hMergedContents, null);
                hMergedCell.setHMerge(MTable.MCell.Merge.CONTINUE);
                hMergedCell.setVMerge(cell.getVMerge());
                row.getCells().add(hMergedCell);
                ++lastColumn;
                ++i;
            }
        } else {
            restartHMerge = false;
        }
        if (restartVMerge) {
            ArrayList<MTableImpl.MCellImpl> vMergeCopy = new ArrayList<MTableImpl.MCellImpl>();
            MListImpl vMergedContents = new MListImpl();
            MTableImpl.MCellImpl vMergedCell = new MTableImpl.MCellImpl((MElement)vMergedContents, null);
            vMergedCell.setVMerge(MTable.MCell.Merge.CONTINUE);
            if (restartHMerge) {
                vMergedCell.setHMerge(MTable.MCell.Merge.RESTART);
            }
            vMergeCopy.add(vMergedCell);
            int i = 0;
            while (i < lastColumn - currentColumn - 1) {
                MListImpl hMergedContents = new MListImpl();
                MTableImpl.MCellImpl hMergedCell = new MTableImpl.MCellImpl((MElement)hMergedContents, null);
                hMergedCell.setVMerge(MTable.MCell.Merge.CONTINUE);
                hMergedCell.setHMerge(MTable.MCell.Merge.CONTINUE);
                vMergeCopy.add(hMergedCell);
                ++i;
            }
            vMergeCopies.put(currentColumn, vMergeCopy);
        }
    }

    private int getColSpan(Node node) {
        int res;
        if (node.hasAttr("colspan")) {
            try {
                res = Integer.valueOf(node.attr("colspan"));
            }
            catch (NumberFormatException e) {
                res = -1;
            }
        } else {
            res = -1;
        }
        return res;
    }

    private int getRowSpan(Node node) {
        int res;
        if (node.hasAttr("rowspan")) {
            try {
                res = Integer.valueOf(node.attr("rowspan"));
            }
            catch (NumberFormatException e) {
                res = -1;
            }
        } else {
            res = -1;
        }
        return res;
    }

    private void endParagraph(MParagraph parent, MParagraph element) {
        MList parentContents = (MList)parent.getContents();
        MList elementContents = (MList)element.getContents();
        if (elementContents.isEmpty()) {
            for (MElement child : parentContents) {
                if (!(child instanceof MParagraph) || ((MParagraph)child).getContents() != elementContents) continue;
                parentContents.remove((Object)child);
                break;
            }
        }
    }

    private void insertText(MParagraph parent, Context context, TextNode node, Element lastElement) {
        boolean needTrimFirst;
        String text = this.text(node);
        boolean bl = needTrimFirst = lastElement != null && (UL_TAG.equals(lastElement.nodeName()) || OL_TAG.equals(lastElement.nodeName()) || BLOCKQUOTE_TAG.equals(lastElement.nodeName()));
        if (!text.trim().isEmpty()) {
            String textToInsert = needTrimFirst ? this.trimFirst(text) : text;
            MList parentContents = (MList)parent.getContents();
            if (context.linkTargetURI == null) {
                MTextImpl mText = new MTextImpl(textToInsert, context.style);
                parentContents.add((Object)mText);
            } else {
                context.style.setForegroundColor(LINK_COLOR);
                MHyperLinkImpl mLink = new MHyperLinkImpl(textToInsert, context.style, context.linkTargetURI.toString(), context.linkTitle);
                parentContents.add((Object)mLink);
            }
        }
    }

    private String trimFirst(String text) {
        String res;
        if (text != null && !text.isEmpty()) {
            int subStringStart = 0;
            int textLength = text.length();
            while (subStringStart < textLength && Character.isWhitespace(text.charAt(subStringStart))) {
                ++subStringStart;
            }
            res = text.substring(subStringStart);
        } else {
            res = text;
        }
        return res;
    }

    private String text(TextNode textNode) {
        String string = textNode.getWholeText();
        StringBuilder sb = new StringBuilder(string.length());
        if (PRE_TAG.equals(textNode.parent().nodeName())) {
            sb.append(string);
        } else {
            this.appendNormalisedWhitespace(sb, string, false);
        }
        return sb.toString();
    }

    private boolean isWhitespace(int c) {
        return c == 32 || c == 9 || c == 10 || c == 12 || c == 13;
    }

    public void appendNormalisedWhitespace(StringBuilder accum, String string, boolean stripLeading) {
        boolean lastWasWhite = false;
        boolean reachedNonWhite = false;
        int len = string.length();
        int i = 0;
        while (i < len) {
            int c = string.codePointAt(i);
            if (this.isWhitespace(c)) {
                if (!(stripLeading && !reachedNonWhite || lastWasWhite)) {
                    accum.append(' ');
                    lastWasWhite = true;
                }
            } else {
                accum.appendCodePoint(c);
                lastWasWhite = false;
                reachedNonWhite = true;
            }
            i += Character.charCount(c);
        }
    }

    private MParagraph startElement(MParagraph parent, Context context, Element element) {
        MParagraph res;
        String nodeName = element.nodeName();
        boolean isNumbering = false;
        if (P_TAG.equals(nodeName)) {
            res = this.createMParagraph(context, parent, element, null, null);
        } else if (PRE_TAG.equals(nodeName)) {
            res = this.createMParagraph(context, parent, element, null, null);
            CSS_PARSER.setContainerBackgroundColor(context.cssProperties, (MElementContainer)res);
        } else if (BLOCKQUOTE_TAG.equals(nodeName)) {
            if (element.childNodeSize() > 0 && element.childNode(0) instanceof TextNode) {
                TextNode textNode = (TextNode)element.childNode(0);
                String newText = this.trimFirst(this.text(textNode));
                textNode.text(newText);
                res = !newText.isEmpty() ? this.createMParagraph(context, parent, element, null, null) : parent;
            } else {
                res = parent;
            }
        } else if (STRONG_TAG.equals(nodeName) || B_TAG.equals(nodeName)) {
            this.setModifiers(context.style, 1);
            res = parent;
        } else if (EM_TAG.equals(nodeName) || I_TAG.equals(nodeName) || VAR_TAG.equals(nodeName) || CITE_TAG.equals(nodeName)) {
            this.setModifiers(context.style, 2);
            res = parent;
        } else if (S_TAG.equals(nodeName) || STRIKE_TAG.equals(nodeName) || DEL_TAG.equals(nodeName)) {
            this.setModifiers(context.style, 8);
            res = parent;
        } else if (U_TAG.equals(nodeName) || INS_TAG.equals(nodeName)) {
            this.setModifiers(context.style, 4);
            res = parent;
        } else if (SUB_TAG.equals(nodeName)) {
            this.setModifiers(context.style, 16);
            res = parent;
        } else if (SUP_TAG.equals(nodeName)) {
            this.setModifiers(context.style, 32);
            res = parent;
        } else if (FONT_TAG.equals(nodeName)) {
            if (element.hasAttr("color")) {
                context.style.setForegroundColor(this.htmlToColor(element.attr("color").toLowerCase()));
            }
            if (element.hasAttr("face")) {
                context.style.setFontName(element.attr("face"));
            }
            if (element.hasAttr(SIZE_ATTR)) {
                context.style.setFontSize(this.fontSizeToPoint(element.attr(SIZE_ATTR)));
            }
            res = parent;
        } else if (A_TAG.equals(nodeName)) {
            context.linkTargetURI = this.toURI(context.baseURI, element.attr(HREF_ATTR));
            if (element.hasAttr("title")) {
                context.linkTitle = element.attr("title");
            }
            res = parent;
        } else if (BR_TAG.equals(nodeName)) {
            MList parentContents = (MList)parent.getContents();
            parentContents.add((Object)MPagination.ligneBreak);
            res = parent;
        } else if ("li".equals(nodeName)) {
            res = this.createMParagraph(context, parent, element, context.numberingID.longValue(), context.numberingLevel - 1L);
            isNumbering = true;
        } else if (OL_TAG.equals(nodeName)) {
            this.setOrderedListNumbering(context, element);
            isNumbering = true;
            res = parent;
        } else if (UL_TAG.equals(nodeName)) {
            this.setUnorderedListNumbering(context, element);
            isNumbering = true;
            res = parent;
        } else if ("img".equals(nodeName)) {
            MImage mImage = this.createMImage(context, element);
            MList parentContents = (MList)parent.getContents();
            parentContents.add((Object)mImage);
            res = parent;
        } else if (BIG_TAG.equals(nodeName)) {
            this.setBigFont(context);
            res = parent;
        } else if (SMALL_TAG.equals(nodeName)) {
            this.setSmallFont(context);
            res = parent;
        } else if ("tt".equals(nodeName) || "code".equals(nodeName) || "samp".equals(nodeName) || "kbd".equals(nodeName)) {
            context.style.setFontName(COURIER_NEW_FONT);
            res = parent;
        } else if ("h1".equals(nodeName)) {
            res = this.createHeading(parent, context, element, 24);
        } else if ("h2".equals(nodeName)) {
            res = this.createHeading(parent, context, element, 18);
        } else if ("h3".equals(nodeName)) {
            res = this.createHeading(parent, context, element, 14);
        } else if ("h4".equals(nodeName)) {
            res = this.createHeading(parent, context, element, 12);
        } else if ("h5".equals(nodeName)) {
            res = this.createHeading(parent, context, element, 10);
        } else if ("h6".equals(nodeName)) {
            res = this.createHeading(parent, context, element, 8);
        } else if (CENTER_TAG.equals(nodeName)) {
            res = this.createMParagraph(context, parent, element, null, null);
            res.setHAlignment(MElementContainer.HAlignment.CENTER);
        } else {
            res = parent;
        }
        if (!isNumbering) {
            context.numbering = null;
            context.numberingLevel = 0L;
        }
        return res;
    }

    private void applyGlobalAttibutes(Context context, Node node) {
        this.applyMarkerClass(context, node);
        this.applyCodeClass(context, node);
        this.applyCSSStyle(node, context);
        this.applyDir(context, node);
    }

    private void applyMarkerClass(Context context, Node node) {
        if (node.hasAttr("class") && "marker".equals(node.attr("class"))) {
            context.style.setBackgroundColor(Color.YELLOW);
        }
    }

    private void applyCodeClass(Context context, Node node) {
        if (node.hasAttr("class") && "code".equals(node.attr("class"))) {
            context.style.setForegroundColor(new Color(16384));
            this.setModifiers(context.style, 1);
            context.style.setFontName(COURIER_NEW_FONT);
        }
    }

    private void applyDir(Context context, Node node) {
        if (node.hasAttr(DIR_ATTR)) {
            if ("ltr".equals(node.attr(DIR_ATTR))) {
                context.dir = Context.Dir.LTR;
            } else if ("rtl".equals(node.attr(DIR_ATTR))) {
                context.dir = Context.Dir.RTL;
            }
        }
    }

    private void setBigFont(Context context) {
        int fontSize = context.style.getFontSize() == -1 ? 14 : (int)((double)context.style.getFontSize() * 1.33);
        context.style.setFontSize(fontSize);
    }

    private void setSmallFont(Context context) {
        int fontSize = context.style.getFontSize() == -1 ? 8 : (int)((double)context.style.getFontSize() * 0.8);
        context.style.setFontSize(fontSize);
    }

    private void applyCSSStyle(Node node, Context context) {
        Map<String, List<String>> cssProperties = CSS_PARSER.getCSSProperties(node, this.cssClasses);
        if (!cssProperties.isEmpty()) {
            CSS_PARSER.setStyle(cssProperties, context.style);
            context.cssProperties.putAll(cssProperties);
        }
    }

    private MParagraph createHeading(MParagraph parent, Context context, Element element, int fontSize) {
        MParagraph res = this.createMParagraph(context, parent, element, null, null);
        context.style.setFontSize(fontSize);
        this.setModifiers(context.style, 1);
        return res;
    }

    private MImage createMImage(Context context, Element element) {
        URI imageURI = this.toURI(context.baseURI, element.attr("src"));
        MImageImpl mImage = new MImageImpl(this.uriConverter, imageURI);
        String width = element.hasAttr(WIDTH_ATTR) ? element.attr(WIDTH_ATTR) : null;
        String height = element.hasAttr(HEIGHT_ATTR) ? element.attr(HEIGHT_ATTR) : null;
        this.setImageSize((MImage)mImage, width, height);
        CSS_PARSER.setStyle((Map<String, List<String>>)context.cssProperties, (MImage)mImage);
        return mImage;
    }

    private URI toURI(URI baseURI, String uri) {
        File file = new File(uri);
        URI res = file.isAbsolute() ? URI.createFileURI((String)uri) : URI.createURI((String)uri.replace('\\', '/')).resolve(baseURI);
        return res;
    }

    private void setUnorderedListNumbering(Context context, Element element) {
        STNumberFormat.Enum type;
        String symbol;
        String typeAttr = element.attr(TYPE_ATTR);
        if ("disc".equals(typeAttr) || CSS_PARSER.hasCSS(context.cssProperties, "list-style-type", "disc")) {
            symbol = DISC_SYMBOL;
            type = STNumberFormat.BULLET;
        } else if ("square".equals(typeAttr) || CSS_PARSER.hasCSS(context.cssProperties, "list-style-type", "square")) {
            symbol = SQUARE_SYMBOL;
            type = STNumberFormat.BULLET;
        } else if ("circle".equals(typeAttr) || CSS_PARSER.hasCSS(context.cssProperties, "list-style-type", "circle")) {
            symbol = CIRCLE_SYMBOL;
            type = STNumberFormat.BULLET;
        } else if (!CSS_PARSER.hasCSS(context.cssProperties, "list-style-type", NONE)) {
            symbol = DISC_SYMBOL;
            type = STNumberFormat.BULLET;
        } else {
            symbol = "";
            type = STNumberFormat.NONE;
        }
        if (context.numbering == null) {
            this.createNumbering(context);
        }
        this.incrementNumberingLevel(context, type, 1L, symbol, false);
    }

    private void setOrderedListNumbering(Context context, Element element) {
        long start;
        String typeStr = element.hasAttr(TYPE_ATTR) ? element.attr(TYPE_ATTR) : null;
        STNumberFormat.Enum type = "1".equals(typeStr) || CSS_PARSER.hasCSS(context.cssProperties, "list-style-type", "decimal") ? STNumberFormat.DECIMAL : ("A".equals(typeStr) || CSS_PARSER.hasCSS(context.cssProperties, "list-style-type", "upper-alpha") ? STNumberFormat.UPPER_LETTER : (A_TAG.equals(typeStr) || CSS_PARSER.hasCSS(context.cssProperties, "list-style-type", "lower-alpha") ? STNumberFormat.LOWER_LETTER : ("I".equals(typeStr) || CSS_PARSER.hasCSS(context.cssProperties, "list-style-type", "upper-roman") ? STNumberFormat.UPPER_ROMAN : (I_TAG.equals(typeStr) || CSS_PARSER.hasCSS(context.cssProperties, "list-style-type", "lower-roman") ? STNumberFormat.LOWER_ROMAN : (!CSS_PARSER.hasCSS(context.cssProperties, "list-style-type", NONE) ? STNumberFormat.DECIMAL : STNumberFormat.NONE)))));
        if (element.hasAttr("start")) {
            try {
                start = Long.valueOf(element.attr("start"));
            }
            catch (NumberFormatException e) {
                start = 1L;
            }
        } else {
            start = 1L;
        }
        boolean reversed = element.hasAttr("reversed");
        if (context.numbering == null) {
            this.createNumbering(context);
        }
        this.incrementNumberingLevel(context, type, start, "", reversed);
    }

    private void createNumbering(Context context) {
        XWPFNumbering numbering = this.destinationDocument.createNumbering();
        CTNumbering ctNumbering = PaginationServices.getCTNumbering((XWPFNumbering)numbering);
        CTAbstractNum res = ctNumbering.addNewAbstractNum();
        res.addNewMultiLevelType().setVal(STMultiLevelType.HYBRID_MULTILEVEL);
        BigInteger id = BigInteger.valueOf(ctNumbering.sizeOfAbstractNumArray() - 1);
        res.setAbstractNumId(id);
        CTNum ctNum = ctNumbering.addNewNum();
        ctNum.setNumId(BigInteger.valueOf(ctNumbering.sizeOfNumArray()));
        ctNum.addNewAbstractNumId().setVal(id);
        context.numbering = res;
        context.numberingID = ctNum.getNumId();
    }

    private void incrementNumberingLevel(Context context, STNumberFormat.Enum type, long start, String symbol, boolean reversed) {
        if ((long)context.numbering.getLvlList().size() <= context.numberingLevel) {
            CTLvl level = context.numbering.addNewLvl();
            level.setIlvl(BigInteger.valueOf(context.numberingLevel));
            CTDecimalNumber strt = level.addNewStart();
            strt.setVal(BigInteger.valueOf(start));
            CTNumFmt fmt = level.addNewNumFmt();
            fmt.setVal(type);
            CTLevelText text = level.addNewLvlText();
            if (type == STNumberFormat.BULLET) {
                text.setVal(symbol);
                CTFonts font = level.addNewRPr().addNewRFonts();
                if (symbol == DISC_SYMBOL) {
                    font.setAscii(SYMBOL_FONT);
                    font.setHAnsi(SYMBOL_FONT);
                } else if (symbol == SQUARE_SYMBOL) {
                    font.setAscii(WINGDINGS_FONT);
                    font.setHAnsi(WINGDINGS_FONT);
                } else if (symbol == DISC_SYMBOL) {
                    font.setAscii(COURIER_NEW_FONT);
                    font.setHAnsi(COURIER_NEW_FONT);
                }
                level.addNewLvlJc().setVal(STJc.LEFT);
                CTInd indentation = level.addNewPPr().addNewInd();
                indentation.setHanging((Object)BigInteger.valueOf(360L));
                indentation.setLeft((Object)BigInteger.valueOf(720L * (context.numberingLevel + 1L)));
            } else {
                CTInd indentation = level.addNewPPr().addNewInd();
                if (type == STNumberFormat.NONE) {
                    text.setVal("%" + (context.numberingLevel + 1L));
                } else {
                    text.setVal("%" + (context.numberingLevel + 1L) + ".");
                }
                if (context.numberingLevel > 0L) {
                    STOnOff onOff = (STOnOff)STOnOff.Factory.newInstance();
                    onOff.setStringValue("1");
                    level.xsetTentative(onOff);
                }
                if (type == STNumberFormat.UPPER_ROMAN) {
                    level.addNewLvlJc().setVal(STJc.RIGHT);
                    indentation.setHanging((Object)BigInteger.valueOf(360L));
                } else if (type == STNumberFormat.LOWER_ROMAN) {
                    level.addNewLvlJc().setVal(STJc.RIGHT);
                    indentation.setHanging((Object)BigInteger.valueOf(180L));
                } else {
                    level.addNewLvlJc().setVal(STJc.LEFT);
                    indentation.setHanging((Object)BigInteger.valueOf(360L));
                }
                indentation.setLeft((Object)BigInteger.valueOf(720L * (context.numberingLevel + 1L)));
            }
        }
        context.numberingLevel = context.numberingLevel + 1L;
    }

    private MParagraph createMParagraph(Context context, MParagraph parent, Element element, Long numberingID, Long numberingLevel) {
        MListImpl newParagraphContents = new MListImpl();
        MParagraphImpl res = new MParagraphImpl((MElement)newParagraphContents, null);
        MList parentContents = (MList)parent.getContents();
        parentContents.add((Object)res);
        res.setNumberingID(numberingID);
        res.setNumberingLevel(numberingLevel);
        if (element != null && element.hasAttr("align")) {
            String align = element.attr("align");
            if ("left".equals(align)) {
                res.setHAlignment(MElementContainer.HAlignment.LEFT);
            } else if ("right".equals(align)) {
                res.setHAlignment(MElementContainer.HAlignment.RIGHT);
            } else if (CENTER_TAG.equals(align)) {
                res.setHAlignment(MElementContainer.HAlignment.CENTER);
            } else if ("justify".equals(align)) {
                res.setHAlignment(MElementContainer.HAlignment.DISTRIBUTE);
            }
        }
        if (context.dir == Context.Dir.LTR) {
            res.setTextDirection(MParagraph.Dir.LTR);
        } else if (context.dir == Context.Dir.RTL) {
            res.setTextDirection(MParagraph.Dir.RTL);
        } else {
            res.setTextDirection(null);
        }
        CSS_PARSER.setStyle(context, (MParagraph)res);
        return res;
    }

    public static String getContent(InputStream stream, String charsetName) throws IOException {
        int len = 8192;
        StringBuilder res = new StringBuilder(8192);
        Throwable throwable = null;
        Object var5_6 = null;
        try (InputStreamReader input = new InputStreamReader((InputStream)new BufferedInputStream(stream), charsetName);){
            char[] buffer = new char[8192];
            int length = input.read(buffer);
            while (length != -1) {
                res.append(buffer, 0, length);
                length = input.read(buffer);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return res.toString();
    }

    protected static final class Context {
        private final MStyle style;
        private CTAbstractNum numbering;
        private final URI baseURI;
        private URI linkTargetURI;
        private String linkTitle;
        private BigInteger numberingID;
        private long numberingLevel;
        private Dir dir;
        private final Map<String, List<String>> cssProperties = new HashMap<String, List<String>>();
        private Stack<Integer> marginLefts = new Stack();
        private Stack<Integer> marginRights = new Stack();
        private Stack<Integer> marginTops = new Stack();
        private Stack<Integer> marginBottoms = new Stack();

        private Context(URI baseURI, MStyle style) {
            this.baseURI = baseURI;
            this.style = style;
        }

        private Context copy() {
            MStyleImpl mStyle = new MStyleImpl(this.style.getFontName(), this.style.getFontSize(), this.style.getForegroundColor(), this.style.getBackgroundColor(), this.style.getFontModifiers());
            Context res = new Context(this.baseURI, (MStyle)mStyle);
            res.linkTargetURI = this.linkTargetURI;
            res.linkTitle = this.linkTitle;
            res.numbering = this.numbering;
            res.numberingID = this.numberingID;
            res.numberingLevel = this.numberingLevel;
            res.dir = this.dir;
            res.cssProperties.putAll(this.cssProperties);
            res.marginLefts = this.marginLefts;
            res.marginRights = this.marginRights;
            res.marginTops = this.marginTops;
            res.marginBottoms = this.marginBottoms;
            return res;
        }

        public void pushMarginLeft(Integer value) {
            this.marginLefts.push(value);
        }

        public void pushMarginRight(Integer value) {
            this.marginRights.push(value);
        }

        public void pushMarginTop(Integer value) {
            this.marginTops.push(value);
        }

        public void pushMarginBottom(Integer value) {
            this.marginBottoms.push(value);
        }

        public Integer popMarginLeft() {
            return this.marginLefts.pop();
        }

        public Integer popMarginRight() {
            return this.marginRights.pop();
        }

        public Integer popMarginTop() {
            return this.marginTops.pop();
        }

        public Integer popMarginBottom() {
            return this.marginBottoms.pop();
        }

        public void replaceLastDefaultMarginLeft(Integer value) {
            if (this.marginLefts.peek() == null) {
                this.popMarginLeft();
                this.pushMarginLeft(value);
            }
        }

        public void replaceLastDefaultMarginTop(Integer value) {
            if (this.marginTops.peek() == null) {
                this.popMarginTop();
                this.pushMarginTop(value);
            }
        }

        public void replaceLastDefaultMarginBottom(Integer value) {
            if (this.marginBottoms.peek() == null) {
                this.popMarginBottom();
                this.pushMarginBottom(value);
            }
        }

        public void replaceLastDefaultMarginRight(Integer value) {
            if (this.marginRights.peek() == null) {
                this.popMarginRight();
                this.pushMarginRight(value);
            }
        }

        public Integer getMarginLeft() {
            int sum = 0;
            boolean hasValue = false;
            for (Integer currentMarginLeft : this.marginLefts) {
                if (currentMarginLeft == null) continue;
                hasValue = true;
                sum += currentMarginLeft.intValue();
            }
            Integer res = hasValue ? Integer.valueOf(sum) : null;
            return res;
        }

        public Integer getMarginRight() {
            int sum = 0;
            boolean hasValue = false;
            for (Integer currentMarginRight : this.marginRights) {
                if (currentMarginRight == null) continue;
                hasValue = true;
                sum += currentMarginRight.intValue();
            }
            Integer res = hasValue ? Integer.valueOf(sum) : null;
            return res;
        }

        public Integer getMarginTop() {
            int sum = 0;
            boolean hasValue = false;
            for (Integer currentMarginTop : this.marginTops) {
                if (currentMarginTop == null) continue;
                hasValue = true;
                sum += currentMarginTop.intValue();
            }
            Integer res = hasValue ? Integer.valueOf(sum) : null;
            return res;
        }

        public Integer getMarginBottom() {
            int sum = 0;
            boolean hasValue = false;
            for (Integer currentMarginBottom : this.marginBottoms) {
                if (currentMarginBottom == null) continue;
                hasValue = true;
                sum += currentMarginBottom.intValue();
            }
            Integer res = hasValue ? Integer.valueOf(sum) : null;
            return res;
        }

        public Map<String, List<String>> getCssProperties() {
            return this.cssProperties;
        }

        private static enum Dir {
            LTR,
            RTL;

        }
    }
}

