/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.element;

import org.apache.poi.xwpf.usermodel.Document;
import org.eclipse.emf.common.util.URI;

public enum PictureType {
    BMP(Document.PICTURE_TYPE_BMP),
    DIB(Document.PICTURE_TYPE_DIB),
    EMF(Document.PICTURE_TYPE_EMF),
    EPS(Document.PICTURE_TYPE_EPS),
    GIF(Document.PICTURE_TYPE_GIF),
    JPG(Document.PICTURE_TYPE_JPEG),
    JPEG(Document.PICTURE_TYPE_JPEG),
    PICT(Document.PICTURE_TYPE_PICT),
    PNG(Document.PICTURE_TYPE_PNG),
    SVG(Document.PICTURE_TYPE_PNG),
    TIFF(Document.PICTURE_TYPE_TIFF),
    WMF(Document.PICTURE_TYPE_WMF),
    WPG(Document.PICTURE_TYPE_WPG);

    private static final String DATA = "data";
    private static final String MIME_IMAGE_TYPE = "image/";
    private static final String SEMI_COLON = ";";
    private int poiType;

    private PictureType(int poiType) {
        this.poiType = poiType;
    }

    public int getPoiType() {
        return this.poiType;
    }

    public static PictureType toType(URI pictureURI) {
        String type;
        int semiColonIndex;
        PictureType res = null;
        if (pictureURI.fileExtension() != null) {
            String extension = pictureURI.fileExtension();
            try {
                res = PictureType.valueOf(extension.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        } else if (DATA.equalsIgnoreCase(pictureURI.scheme()) && (semiColonIndex = pictureURI.opaquePart().indexOf(SEMI_COLON)) > 0 && (type = pictureURI.opaquePart().substring(0, semiColonIndex).toLowerCase()).startsWith(MIME_IMAGE_TYPE)) {
            try {
                res = PictureType.valueOf(type.substring(MIME_IMAGE_TYPE.length()).toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (res == null) {
            res = JPG;
        }
        return res;
    }
}

