/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.parser;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenFactory;
import org.antlr.v4.runtime.TokenFactory;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.UnbufferedCharStream;
import org.antlr.v4.runtime.UnbufferedTokenStream;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.apache.poi.xwpf.usermodel.IBody;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFSDT;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.eclipse.acceleo.query.ast.AstPackage;
import org.eclipse.acceleo.query.ast.ErrorExpression;
import org.eclipse.acceleo.query.ast.ErrorTypeLiteral;
import org.eclipse.acceleo.query.ast.Expression;
import org.eclipse.acceleo.query.parser.AstBuilderListener;
import org.eclipse.acceleo.query.parser.QueryLexer;
import org.eclipse.acceleo.query.parser.QueryParser;
import org.eclipse.acceleo.query.runtime.IQueryBuilderEngine;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.obeonetwork.m2doc.parser.AbstractBodyParser;
import org.obeonetwork.m2doc.parser.DocumentParserException;
import org.obeonetwork.m2doc.parser.ParsingErrorMessage;
import org.obeonetwork.m2doc.parser.ParsingToken;
import org.obeonetwork.m2doc.parser.TemplateValidationMessage;
import org.obeonetwork.m2doc.parser.TokenType;
import org.obeonetwork.m2doc.parser.ValidationMessageLevel;
import org.obeonetwork.m2doc.template.Block;
import org.obeonetwork.m2doc.template.Bookmark;
import org.obeonetwork.m2doc.template.Comment;
import org.obeonetwork.m2doc.template.Conditional;
import org.obeonetwork.m2doc.template.Let;
import org.obeonetwork.m2doc.template.Link;
import org.obeonetwork.m2doc.template.Parameter;
import org.obeonetwork.m2doc.template.Query;
import org.obeonetwork.m2doc.template.Repetition;
import org.obeonetwork.m2doc.template.Template;
import org.obeonetwork.m2doc.template.TemplatePackage;
import org.obeonetwork.m2doc.template.UserDoc;
import org.obeonetwork.m2doc.util.AQL56Compatibility;
import org.obeonetwork.m2doc.util.M2DocUtils;

public class M2DocParser
extends AbstractBodyParser {
    private static final Map<TokenType, Pattern> EXTRA_SPACES_PATTERNS = M2DocParser.initExtraSpacesPatterns();

    public M2DocParser(IBody inputDocument, IQueryEnvironment queryEnvironment) {
        super(inputDocument, queryEnvironment);
    }

    private M2DocParser(IBody inputDocument, IQueryBuilderEngine queryParser, IQueryEnvironment queryEnvironment) {
        super(inputDocument, queryParser, queryEnvironment);
    }

    private static Map<TokenType, Pattern> initExtraSpacesPatterns() {
        HashMap<TokenType, Pattern> res = new HashMap<TokenType, Pattern>();
        TokenType[] tokenTypeArray = TokenType.values();
        int n = tokenTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            TokenType tokenType = tokenTypeArray[n2];
            if (tokenType.needExtraSpacesCheck()) {
                String value = tokenType.getValue();
                String tag = value.substring(TokenType.QUERY.getValue().length());
                res.put(tokenType, Pattern.compile("m:\\s+" + tag));
            }
            ++n2;
        }
        return res;
    }

    @Override
    protected TokenType getNextTokenMTag(ParsingToken token) {
        String type;
        XWPFRun run = token.getRun();
        TokenType result = this.fieldUtils.isFieldBegin(run) ? ((type = this.getType(this.fieldUtils.lookAheadTag(this.runIterator))) == null ? TokenType.STATIC : (type.equals(TokenType.FOR.getValue()) ? TokenType.FOR : (type.equals(TokenType.ENDFOR.getValue()) ? TokenType.ENDFOR : (type.equals(TokenType.IF.getValue()) ? TokenType.IF : (type.equals(TokenType.ELSEIF.getValue()) ? TokenType.ELSEIF : (type.equals(TokenType.ELSE.getValue()) ? TokenType.ELSE : (type.equals(TokenType.ENDIF.getValue()) ? TokenType.ENDIF : (type.equals(TokenType.USERDOC.getValue()) ? TokenType.USERDOC : (type.equals(TokenType.ENDUSERDOC.getValue()) ? TokenType.ENDUSERDOC : (type.equals(TokenType.LET.getValue()) ? TokenType.LET : (type.equals(TokenType.ENDLET.getValue()) ? TokenType.ENDLET : (type.equals(TokenType.BOOKMARK.getValue()) ? TokenType.BOOKMARK : (type.equals(TokenType.ENDBOOKMARK.getValue()) ? TokenType.ENDBOOKMARK : (type.equals(TokenType.LINK.getValue()) ? TokenType.LINK : (type.equals(TokenType.COMMENT.getValue()) ? TokenType.COMMENT : (type.equals(TokenType.COMMENTBLOCK.getValue()) ? TokenType.COMMENTBLOCK : (type.equals(TokenType.ENDCOMMENTBLOCK.getValue()) ? TokenType.ENDCOMMENTBLOCK : (type.equals(TokenType.TEMPLATE.getValue()) ? TokenType.TEMPLATE : (type.equals(TokenType.ENDTEMPLATE.getValue()) ? TokenType.ENDTEMPLATE : TokenType.QUERY))))))))))))))))))) : TokenType.STATIC;
        return result;
    }

    @Override
    public Block parseBlock(List<Template> templates, String header, TokenType ... endTypes) throws DocumentParserException {
        Block res = (Block)EcoreUtil.create((EClass)TemplatePackage.Literals.BLOCK);
        TokenType type = this.getNextTokenType();
        HashSet<TokenType> endTypeSet = new HashSet<TokenType>(Arrays.asList(endTypes));
        block17: while (!endTypeSet.contains((Object)type)) {
            switch (type) {
                case QUERY: {
                    res.getStatements().add((Object)this.parseQuery());
                    break;
                }
                case FOR: {
                    res.getStatements().add((Object)this.parseRepetition());
                    break;
                }
                case IF: {
                    res.getStatements().add((Object)this.parseConditional());
                    break;
                }
                case USERDOC: {
                    res.getStatements().add((Object)this.parseUserDoc());
                    break;
                }
                case COMMENT: {
                    res.getStatements().add((Object)this.parseComment());
                    break;
                }
                case COMMENTBLOCK: {
                    res.getStatements().add((Object)this.parseCommentBlock());
                    break;
                }
                case ENDTEMPLATE: 
                case ENDCOMMENTBLOCK: 
                case ENDFOR: 
                case ELSEIF: 
                case ELSE: 
                case ENDIF: 
                case ENDLET: 
                case ENDBOOKMARK: 
                case ENDUSERDOC: {
                    XWPFRun run = this.runIterator.lookAhead(1).getRun();
                    if (run == null) {
                        throw new IllegalStateException("Token of type " + (Object)((Object)type) + " detected. Run shouldn't be null at this place.");
                    }
                    if (header == null) {
                        res.getValidationMessages().add((Object)new TemplateValidationMessage(ValidationMessageLevel.ERROR, M2DocUtils.message(ParsingErrorMessage.UNEXPECTEDTAG, type.getValue()), run));
                    } else {
                        res.getValidationMessages().add((Object)new TemplateValidationMessage(ValidationMessageLevel.ERROR, M2DocUtils.message(ParsingErrorMessage.UNEXPECTEDTAGWITHHEADER, type.getValue(), header), run));
                    }
                    if (!endTypeSet.contains((Object)TokenType.EOF)) {
                        res.getValidationMessages().add((Object)new TemplateValidationMessage(ValidationMessageLevel.INFO, M2DocUtils.message(ParsingErrorMessage.DIDYOUFORGETENDBLOCK, Arrays.toString((Object[])endTypes)), run));
                    }
                    this.readTag(res, (List<XWPFRun>)res.getRuns());
                    break;
                }
                case EOF: {
                    XWPFParagraph lastParagraph = (XWPFParagraph)this.document.getParagraphs().get(this.document.getParagraphs().size() - 1);
                    XWPFRun lastRun = (XWPFRun)lastParagraph.getRuns().get(lastParagraph.getRuns().size() - 1);
                    if (header == null) {
                        res.getValidationMessages().add((Object)new TemplateValidationMessage(ValidationMessageLevel.ERROR, M2DocUtils.message(ParsingErrorMessage.UNEXPECTEDTAGMISSING, new Object[]{type, Arrays.toString((Object[])endTypes)}), lastRun));
                        break block17;
                    }
                    res.getValidationMessages().add((Object)new TemplateValidationMessage(ValidationMessageLevel.ERROR, M2DocUtils.message(ParsingErrorMessage.UNEXPECTEDTAGMISSINGWITHHEADER, new Object[]{type, Arrays.toString((Object[])endTypes), header}), lastRun));
                    break block17;
                }
                case LET: {
                    res.getStatements().add((Object)this.parseLet());
                    break;
                }
                case STATIC: {
                    res.getStatements().add((Object)this.parseStaticFragment());
                    break;
                }
                case BOOKMARK: {
                    res.getStatements().add((Object)this.parseBookmark());
                    break;
                }
                case LINK: {
                    res.getStatements().add((Object)this.parseLink());
                    break;
                }
                case WTABLE: {
                    res.getStatements().add((Object)this.parseTable((XWPFTable)this.runIterator.next().getBodyElement()));
                    break;
                }
                case CONTENTCONTROL: {
                    res.getStatements().add((Object)this.parseContentControl((XWPFSDT)this.runIterator.next().getBodyElement()));
                    break;
                }
                case TEMPLATE: {
                    if (templates != null) {
                        templates.add(this.parseTemplate());
                        break;
                    }
                    XWPFRun templateRun = this.runIterator.lookAhead(1).getRun();
                    if (templateRun == null) {
                        throw new IllegalStateException("Token of type " + (Object)((Object)type) + " detected. Run shouldn't be null at this place.");
                    }
                    res.getValidationMessages().add((Object)new TemplateValidationMessage(ValidationMessageLevel.ERROR, M2DocUtils.message(ParsingErrorMessage.TEMPLATE_NOT_ALLOWED_IN_THIS_BLOCK, new Object[0]), templateRun));
                    break block17;
                }
                default: {
                    throw new UnsupportedOperationException(String.format("Developer error: TokenType %s is not supported", new Object[]{type}));
                }
            }
            type = this.getNextTokenType();
        }
        return res;
    }

    private Let parseLet() throws DocumentParserException {
        int currentIndex = 0;
        Let let = (Let)EcoreUtil.create((EClass)TemplatePackage.Literals.LET);
        String header = this.readTag(let, (List<XWPFRun>)let.getRuns()).trim();
        String tagText = header.substring(TokenType.LET.getValue().length()).trim();
        if (currentIndex < tagText.length() && Character.isJavaIdentifierStart(tagText.charAt(currentIndex))) {
            ++currentIndex;
            while (currentIndex < tagText.length() && Character.isJavaIdentifierPart(tagText.charAt(currentIndex))) {
                ++currentIndex;
            }
            let.setName(tagText.substring(0, currentIndex));
        } else {
            M2DocUtils.validationError(let, M2DocUtils.message(ParsingErrorMessage.MISSINGIDENTIFIER, new Object[0]));
        }
        while (currentIndex < tagText.length() && Character.isWhitespace(tagText.charAt(currentIndex))) {
            ++currentIndex;
        }
        if (currentIndex < tagText.length() && tagText.charAt(currentIndex) == '=') {
            ++currentIndex;
        } else {
            M2DocUtils.validationError(let, M2DocUtils.message(ParsingErrorMessage.MISSINGEQUALS, new Object[0]));
        }
        while (currentIndex < tagText.length() && Character.isWhitespace(tagText.charAt(currentIndex))) {
            ++currentIndex;
        }
        String queryString = tagText.substring(currentIndex);
        IQueryBuilderEngine.AstResult result = this.queryParser.build(queryString);
        let.setValue(result);
        if (!result.getErrors().isEmpty()) {
            XWPFRun lastRun = (XWPFRun)let.getRuns().get(let.getRuns().size() - 1);
            let.getValidationMessages().addAll(this.getValidationMessage(result.getDiagnostic(), queryString, lastRun));
        }
        Block body = this.parseBlock(null, header, TokenType.ENDLET);
        let.setBody(body);
        if (this.getNextTokenType() != TokenType.EOF) {
            this.readTag(let, (List<XWPFRun>)let.getClosingRuns());
        }
        return let;
    }

    private Query parseQuery() throws DocumentParserException {
        Query query = (Query)EcoreUtil.create((EClass)TemplatePackage.Literals.QUERY);
        String tagText = this.readTag(query, (List<XWPFRun>)query.getRuns()).trim();
        String queryText = tagText.substring(TokenType.QUERY.getValue().length()).trim();
        try {
            IQueryBuilderEngine.AstResult result = this.queryParser.build(queryText);
            query.setQuery(result);
            if (!result.getErrors().isEmpty()) {
                XWPFRun lastRun = (XWPFRun)query.getRuns().get(query.getRuns().size() - 1);
                query.getValidationMessages().addAll(this.getValidationMessage(result.getDiagnostic(), queryText, lastRun));
            }
            boolean checkExtraSpace = !result.getErrors().isEmpty() || result.getEndPosition(result.getAst()) != queryText.length();
            TokenType[] tokenTypeArray = TokenType.values();
            int n = tokenTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Matcher matcher;
                TokenType tokenType = tokenTypeArray[n2];
                String value = tokenType.getValue();
                if (tokenType.needExtraSpacesCheck() && (matcher = EXTRA_SPACES_PATTERNS.get((Object)tokenType).matcher(tagText)).find(0) && (matcher.end() == tagText.length() || checkExtraSpace)) {
                    M2DocUtils.validationInfo(query, M2DocUtils.message(ParsingErrorMessage.YOUMIGHTWANTTOREPLACE, matcher.group(), value));
                    break;
                }
                ++n2;
            }
        }
        catch (Exception e) {
            BasicDiagnostic diagnostic = new BasicDiagnostic();
            String message = M2DocUtils.message(ParsingErrorMessage.UNABLETOPARSEAQLEXPRESSION, new Object[0]);
            diagnostic.add((Diagnostic)new BasicDiagnostic(4, "org.obeonetwork.m2doc", 0, message, new Object[0]));
            XWPFRun lastRun = (XWPFRun)query.getRuns().get(query.getRuns().size() - 1);
            query.getValidationMessages().addAll(this.getValidationMessage((Diagnostic)diagnostic, queryText, lastRun));
            query.setQuery(new IQueryBuilderEngine.AstResult(null, new HashMap(), new HashMap(), new ArrayList(), (Diagnostic)diagnostic));
        }
        return query;
    }

    private Comment parseComment() throws DocumentParserException {
        Comment comment = (Comment)EcoreUtil.create((EClass)TemplatePackage.Literals.COMMENT);
        String commentText = this.readTag(comment, (List<XWPFRun>)comment.getRuns()).trim().substring(TokenType.COMMENT.getValue().length());
        comment.setText(commentText.trim());
        return comment;
    }

    private Comment parseCommentBlock() throws DocumentParserException {
        Comment comment = (Comment)EcoreUtil.create((EClass)TemplatePackage.Literals.COMMENT);
        String header = this.readTag(comment, (List<XWPFRun>)comment.getRuns()).trim();
        String commentText = header.substring(TokenType.COMMENTBLOCK.getValue().length());
        comment.setText(commentText.trim());
        XWPFRun lastRun = (XWPFRun)comment.getRuns().get(comment.getRuns().size() - 1);
        Block body = this.parseBlock(null, header, TokenType.ENDCOMMENTBLOCK);
        for (TemplateValidationMessage message : body.getValidationMessages()) {
            comment.getValidationMessages().add((Object)new TemplateValidationMessage(message.getLevel(), message.getMessage(), lastRun));
        }
        if (this.getNextTokenType() != TokenType.EOF) {
            this.readTag(comment, (List<XWPFRun>)comment.getClosingRuns());
        }
        return comment;
    }

    private Conditional parseConditional() throws DocumentParserException {
        Conditional conditional = (Conditional)EcoreUtil.create((EClass)TemplatePackage.Literals.CONDITIONAL);
        String header = this.readTag(conditional, (List<XWPFRun>)conditional.getRuns()).trim();
        boolean headConditionnal = header.startsWith(TokenType.IF.getValue());
        int tagLength = headConditionnal ? TokenType.IF.getValue().length() : TokenType.ELSEIF.getValue().length();
        String query = header.substring(tagLength).trim();
        IQueryBuilderEngine.AstResult result = this.queryParser.build(query);
        conditional.setCondition(result);
        if (!result.getErrors().isEmpty()) {
            XWPFRun lastRun = (XWPFRun)conditional.getRuns().get(conditional.getRuns().size() - 1);
            conditional.getValidationMessages().addAll(this.getValidationMessage(result.getDiagnostic(), query, lastRun));
        }
        Block thenCompound = this.parseBlock(null, header, TokenType.ELSEIF, TokenType.ELSE, TokenType.ENDIF);
        conditional.setThen(thenCompound);
        TokenType nextRunType = this.getNextTokenType();
        switch (nextRunType) {
            case ELSEIF: {
                Block elseIfCompound = (Block)EcoreUtil.create((EClass)TemplatePackage.Literals.BLOCK);
                elseIfCompound.getStatements().add((Object)this.parseConditional());
                conditional.setElse(elseIfCompound);
                break;
            }
            case ELSE: {
                Block block = (Block)EcoreUtil.create((EClass)TemplatePackage.Literals.BLOCK);
                this.readTag(block, (List<XWPFRun>)block.getRuns());
                Block elseCompound = this.parseBlock(null, M2DocUtils.message(ParsingErrorMessage.MISSINGENDIFAFTREELSE, header), TokenType.ENDIF);
                conditional.setElse(elseCompound);
                if (this.getNextTokenType() == TokenType.EOF) break;
                this.readTag(conditional, (List<XWPFRun>)conditional.getClosingRuns());
                break;
            }
            case ENDIF: {
                this.readTag(conditional, (List<XWPFRun>)conditional.getClosingRuns());
                break;
            }
            default: {
                M2DocUtils.validationError(conditional, M2DocUtils.message(ParsingErrorMessage.CONDTAGEXPEXTED, header));
            }
        }
        return conditional;
    }

    private Repetition parseRepetition() throws DocumentParserException {
        Repetition repetition = (Repetition)EcoreUtil.create((EClass)TemplatePackage.Literals.REPETITION);
        String header = this.readTag(repetition, (List<XWPFRun>)repetition.getRuns()).trim();
        String tagText = header.substring(TokenType.FOR.getValue().length());
        int indexOfPipe = tagText.indexOf(124);
        if (indexOfPipe < 0) {
            M2DocUtils.validationError(repetition, M2DocUtils.message(ParsingErrorMessage.MALFORMEDFORMISSINGPIPE, new Object[0]));
            IQueryBuilderEngine.AstResult result = this.queryParser.build(null);
            repetition.setQuery(result);
            Block body = (Block)EcoreUtil.create((EClass)TemplatePackage.Literals.BLOCK);
            repetition.setBody(body);
        } else {
            String iterationVariable = tagText.substring(0, indexOfPipe).trim();
            if ("".equals(iterationVariable)) {
                M2DocUtils.validationError(repetition, M2DocUtils.message(ParsingErrorMessage.MALFORMEDFORMISSINGVARIABLE, new Object[0]));
            }
            repetition.setIterationVar(iterationVariable);
            if (tagText.length() == indexOfPipe + 1) {
                M2DocUtils.validationError(repetition, M2DocUtils.message(ParsingErrorMessage.MALFORMEDFORMISSINGEXPRESSION, tagText));
            }
            String query = tagText.substring(indexOfPipe + 1, tagText.length()).trim();
            IQueryBuilderEngine.AstResult result = this.queryParser.build(query);
            repetition.setQuery(result);
            if (!result.getErrors().isEmpty()) {
                XWPFRun lastRun = (XWPFRun)repetition.getRuns().get(repetition.getRuns().size() - 1);
                repetition.getValidationMessages().addAll(this.getValidationMessage(result.getDiagnostic(), query, lastRun));
            }
        }
        Block body = this.parseBlock(null, header, TokenType.ENDFOR);
        repetition.setBody(body);
        if (this.getNextTokenType() != TokenType.EOF) {
            this.readTag(repetition, (List<XWPFRun>)repetition.getClosingRuns());
        }
        return repetition;
    }

    private Template parseTemplate() throws DocumentParserException {
        Block body;
        Template template = (Template)EcoreUtil.create((EClass)TemplatePackage.Literals.TEMPLATE);
        String header = this.readTag(template, (List<XWPFRun>)template.getRuns()).trim();
        String tagText = header.substring(TokenType.TEMPLATE.getValue().length());
        int indexOfOpenParenthesis = tagText.indexOf(40);
        if (indexOfOpenParenthesis < 0) {
            M2DocUtils.validationError(template, M2DocUtils.message(ParsingErrorMessage.MALFORMEDTEMPLATEMISSINGOPENINGPARENTH, new Object[0]));
            template.setName(tagText);
            body = (Block)EcoreUtil.create((EClass)TemplatePackage.Literals.BLOCK);
            template.setBody(body);
        } else {
            List<Parameter> parameters;
            int indexOfCloseParenthesis;
            String name = tagText.substring(0, indexOfOpenParenthesis).trim();
            if ("".equals(name)) {
                M2DocUtils.validationError(template, M2DocUtils.message(ParsingErrorMessage.MALFORMEDTEMPLATENONAMESPECIFIED, new Object[0]));
            }
            template.setName(name);
            int parametersStart = indexOfOpenParenthesis + 1;
            if (tagText.length() == parametersStart) {
                M2DocUtils.validationError(template, M2DocUtils.message(ParsingErrorMessage.MALFORMEDTEMPLATENOPARAMETERSPECIFIED, tagText));
            }
            if ((indexOfCloseParenthesis = tagText.lastIndexOf(41)) < 0) {
                parameters = this.parseParameters(template, tagText.substring(indexOfOpenParenthesis));
                M2DocUtils.validationError(template, M2DocUtils.message(ParsingErrorMessage.MALFORMEDTEMPLATEMISSINGCLOSINGPARENTH, new Object[0]));
            } else {
                parameters = this.parseParameters(template, tagText.substring(indexOfOpenParenthesis + 1, indexOfCloseParenthesis));
            }
            if (parameters.isEmpty()) {
                M2DocUtils.validationError(template, M2DocUtils.message(ParsingErrorMessage.ATLEASTONEPARAMETERISNEEDED, new Object[0]));
            } else {
                template.getParameters().addAll(parameters);
            }
        }
        body = this.parseBlock(null, header, TokenType.ENDTEMPLATE);
        template.setBody(body);
        if (this.getNextTokenType() != TokenType.EOF) {
            this.readTag(template, (List<XWPFRun>)template.getClosingRuns());
        }
        return template;
    }

    private List<Parameter> parseParameters(Template template, String paramStr) {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        String[] prmStrs = paramStr.trim().split(",");
        if (prmStrs.length != 1 || prmStrs[0].trim().length() != 0) {
            String[] stringArray = prmStrs;
            int n = prmStrs.length;
            int n2 = 0;
            while (n2 < n) {
                String prm = stringArray[n2];
                parameters.add(this.parseParameter(template, prm.trim()));
                ++n2;
            }
        }
        if (paramStr.endsWith(",")) {
            M2DocUtils.validationError(template, M2DocUtils.message(ParsingErrorMessage.MALFORMEDPARAMETERNOCOLON, new Object[0]));
        }
        return parameters;
    }

    private Parameter parseParameter(Template template, String paramStr) {
        Parameter parameter = (Parameter)EcoreUtil.create((EClass)TemplatePackage.Literals.PARAMETER);
        int indexOfColon = paramStr.indexOf(58);
        if (indexOfColon < 0) {
            M2DocUtils.validationError(template, M2DocUtils.message(ParsingErrorMessage.MALFORMEDPARAMETERNOCOLON, new Object[0]));
            parameter.setName(paramStr);
            IQueryBuilderEngine.AstResult type = this.parseWhileAqlTypeLiteral("");
            parameter.setType(type);
            if (!type.getErrors().isEmpty()) {
                XWPFRun lastRun = (XWPFRun)template.getRuns().get(template.getRuns().size() - 1);
                template.getValidationMessages().addAll(this.getValidationMessage(type.getDiagnostic(), "", lastRun));
            }
        } else {
            String name = paramStr.substring(0, indexOfColon).trim();
            if ("".equals(name)) {
                M2DocUtils.validationError(template, M2DocUtils.message(ParsingErrorMessage.MALFORMEDPARAMETERNONAMESPECIFIED, new Object[0]));
            }
            parameter.setName(name);
            IQueryBuilderEngine.AstResult type = this.parseWhileAqlTypeLiteral(paramStr.substring(indexOfColon + 1));
            parameter.setType(type);
            if (!type.getErrors().isEmpty()) {
                XWPFRun lastRun = (XWPFRun)template.getRuns().get(template.getRuns().size() - 1);
                template.getValidationMessages().addAll(this.getValidationMessage(type.getDiagnostic(), name, lastRun));
            }
        }
        return parameter;
    }

    private Bookmark parseBookmark() throws DocumentParserException {
        Bookmark bookmark = (Bookmark)EcoreUtil.create((EClass)TemplatePackage.Literals.BOOKMARK);
        String header = this.readTag(bookmark, (List<XWPFRun>)bookmark.getRuns()).trim();
        String tagText = header.substring(TokenType.BOOKMARK.getValue().length()).trim();
        IQueryBuilderEngine.AstResult result = this.queryParser.build(tagText);
        bookmark.setName(result);
        if (!result.getErrors().isEmpty()) {
            XWPFRun lastRun = (XWPFRun)bookmark.getRuns().get(bookmark.getRuns().size() - 1);
            bookmark.getValidationMessages().addAll(this.getValidationMessage(result.getDiagnostic(), tagText, lastRun));
        }
        Block body = this.parseBlock(null, header, TokenType.ENDBOOKMARK);
        bookmark.setBody(body);
        if (this.getNextTokenType() != TokenType.EOF) {
            this.readTag(bookmark, (List<XWPFRun>)bookmark.getClosingRuns());
        }
        return bookmark;
    }

    private Link parseLink() throws DocumentParserException {
        Link link = (Link)EcoreUtil.create((EClass)TemplatePackage.Literals.LINK);
        String tagText = this.readTag(link, (List<XWPFRun>)link.getRuns()).trim();
        tagText = tagText.substring(TokenType.LINK.getValue().length()).trim();
        IQueryBuilderEngine.AstResult nameResult = this.parseWhileAqlExpression(tagText);
        link.setName(nameResult);
        if (!nameResult.getErrors().isEmpty()) {
            XWPFRun lastRun = (XWPFRun)link.getRuns().get(link.getRuns().size() - 1);
            link.getValidationMessages().addAll(this.getValidationMessage(nameResult.getDiagnostic(), tagText, lastRun));
        }
        tagText = tagText.substring(nameResult.getEndPosition(nameResult.getAst()));
        IQueryBuilderEngine.AstResult textResult = this.parseWhileAqlExpression(tagText);
        link.setText(textResult);
        if (!textResult.getErrors().isEmpty()) {
            XWPFRun lastRun = (XWPFRun)link.getRuns().get(link.getRuns().size() - 1);
            link.getValidationMessages().addAll(this.getValidationMessage(textResult.getDiagnostic(), tagText, lastRun));
        }
        return link;
    }

    private UserDoc parseUserDoc() throws DocumentParserException {
        UserDoc userDoc = (UserDoc)EcoreUtil.create((EClass)TemplatePackage.Literals.USER_DOC);
        String header = this.readTag(userDoc, (List<XWPFRun>)userDoc.getRuns()).trim();
        String tagText = header.substring(TokenType.USERDOC.getValue().length()).trim();
        IQueryBuilderEngine.AstResult id = this.queryParser.build(tagText);
        userDoc.setId(id);
        if (!id.getErrors().isEmpty()) {
            XWPFRun lastRun = (XWPFRun)userDoc.getRuns().get(userDoc.getRuns().size() - 1);
            userDoc.getValidationMessages().addAll(this.getValidationMessage(id.getDiagnostic(), tagText, lastRun));
        }
        Block body = this.parseBlock(null, header, TokenType.ENDUSERDOC);
        userDoc.setBody(body);
        if (this.getNextTokenType() != TokenType.EOF) {
            this.readTag(userDoc, (List<XWPFRun>)userDoc.getClosingRuns());
        }
        return userDoc;
    }

    private IQueryBuilderEngine.AstResult parseWhileAqlExpression(String expression) {
        IQueryBuilderEngine.AstResult result;
        if (expression != null && expression.length() > 0) {
            AstBuilderListener astBuilder = AQL56Compatibility.createAstBuilderListener(this.queryEnvironment);
            UnbufferedCharStream input = new UnbufferedCharStream((Reader)new StringReader(expression), expression.length());
            QueryLexer lexer = new QueryLexer((CharStream)input);
            lexer.setTokenFactory((TokenFactory)new CommonTokenFactory(true));
            lexer.removeErrorListeners();
            lexer.addErrorListener(astBuilder.getErrorListener());
            UnbufferedTokenStream tokens = new UnbufferedTokenStream((TokenSource)lexer);
            QueryParser parser = new QueryParser((TokenStream)tokens);
            parser.addParseListener((ParseTreeListener)astBuilder);
            parser.removeErrorListeners();
            parser.addErrorListener(astBuilder.getErrorListener());
            parser.expression();
            result = astBuilder.getAstResult();
        } else {
            ErrorExpression errorExpression = (ErrorExpression)EcoreUtil.create((EClass)AstPackage.eINSTANCE.getErrorExpression());
            ArrayList<ErrorExpression> errors = new ArrayList<ErrorExpression>(1);
            errors.add(errorExpression);
            HashMap<ErrorExpression, Integer> positions = new HashMap<ErrorExpression, Integer>();
            if (expression != null) {
                positions.put(errorExpression, 0);
            }
            BasicDiagnostic diagnostic = new BasicDiagnostic();
            diagnostic.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.acceleo.query", 0, M2DocUtils.message(ParsingErrorMessage.NULLOREMPTYSTRING, new Object[0]), new Object[]{errorExpression}));
            result = new IQueryBuilderEngine.AstResult((Expression)errorExpression, positions, positions, errors, (Diagnostic)diagnostic);
        }
        return result;
    }

    protected IQueryBuilderEngine.AstResult parseWhileAqlTypeLiteral(String expression) {
        IQueryBuilderEngine.AstResult result;
        if (expression != null && expression.length() > 0) {
            AstBuilderListener astBuilder = AQL56Compatibility.createAstBuilderListener(this.queryEnvironment);
            UnbufferedCharStream input = new UnbufferedCharStream((Reader)new StringReader(expression), expression.length());
            QueryLexer lexer = new QueryLexer((CharStream)input);
            lexer.setTokenFactory((TokenFactory)new CommonTokenFactory(true));
            lexer.removeErrorListeners();
            lexer.addErrorListener(astBuilder.getErrorListener());
            UnbufferedTokenStream tokens = new UnbufferedTokenStream((TokenSource)lexer);
            QueryParser parser = new QueryParser((TokenStream)tokens);
            parser.addParseListener((ParseTreeListener)astBuilder);
            parser.removeErrorListeners();
            parser.addErrorListener(astBuilder.getErrorListener());
            parser.typeLiteral();
            result = astBuilder.getAstResult();
        } else {
            ErrorTypeLiteral errorTypeLiteral = (ErrorTypeLiteral)EcoreUtil.create((EClass)AstPackage.eINSTANCE.getErrorTypeLiteral());
            ArrayList<ErrorTypeLiteral> errs = new ArrayList<ErrorTypeLiteral>(1);
            errs.add(errorTypeLiteral);
            HashMap<ErrorTypeLiteral, Integer> positions = new HashMap<ErrorTypeLiteral, Integer>();
            if (expression != null) {
                positions.put(errorTypeLiteral, 0);
            }
            BasicDiagnostic diagnostic = new BasicDiagnostic();
            diagnostic.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.acceleo.query", 0, M2DocUtils.message(ParsingErrorMessage.MISSINGTYPELITERAL, new Object[0]), new Object[]{errorTypeLiteral}));
            result = new IQueryBuilderEngine.AstResult((Expression)errorTypeLiteral, positions, positions, errs, (Diagnostic)diagnostic);
        }
        return result;
    }

    @Override
    protected AbstractBodyParser getNewParser(IBody inputDocument) {
        M2DocParser parser = new M2DocParser(inputDocument, this.queryParser, this.queryEnvironment);
        return parser;
    }
}

