/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.genconf;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.obeonetwork.m2doc.genconf.GenconfPlugin;
import org.obeonetwork.m2doc.genconf.GenconfUtils;
import org.obeonetwork.m2doc.genconf.Generation;

public class GenconfResourceListener
implements IResourceChangeListener {
    private Map<URI, List<URI>> resultToGenerations = new HashMap<URI, List<URI>>();
    private Map<URI, URI> generationToResult = new HashMap<URI, URI>();
    private Map<URI, List<URI>> templateToGenerations = new HashMap<URI, List<URI>>();
    private Map<URI, URI> generationToTemplate = new HashMap<URI, URI>();

    public void walkWorkspace(IWorkspace workspace) {
        this.walkContainer((IContainer)workspace.getRoot());
    }

    private void walkContainer(IContainer container) {
        try {
            IResource[] iResourceArray = container.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                if (resource instanceof IContainer) {
                    this.walkContainer((IContainer)resource);
                } else if (resource instanceof IFile) {
                    this.addResource(resource);
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getDelta() != null) {
            this.walkDelta(event.getDelta(), new HashMap<IPath, IResource>());
        }
    }

    private void walkDelta(IResourceDelta delta, HashMap<IPath, IResource> movedResources) {
        this.processDelta(delta, movedResources);
        IResourceDelta[] iResourceDeltaArray = delta.getAffectedChildren();
        int n = iResourceDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceDelta child = iResourceDeltaArray[n2];
            this.walkDelta(child, movedResources);
            ++n2;
        }
    }

    private void processDelta(IResourceDelta delta, HashMap<IPath, IResource> movedResources) {
        switch (delta.getKind()) {
            case 1: {
                this.processAddedDelta(delta, movedResources);
                break;
            }
            case 2: {
                this.processRemovedDelta(delta, movedResources);
                break;
            }
            case 4: {
                this.processChangedDelta(delta);
                break;
            }
        }
    }

    private void processChangedDelta(IResourceDelta delta) {
        if ((delta.getFlags() & 0x4000) != 0) {
            delta.getResource().isAccessible();
        } else if ((delta.getFlags() & 0x80000) == 0 && (delta.getFlags() & 0x100) != 0) {
            this.changedResource(delta.getResource());
        }
    }

    private void processRemovedDelta(IResourceDelta delta, HashMap<IPath, IResource> movedResources) {
        if ((delta.getFlags() & 0x2000) != 0) {
            IResource target = movedResources.get(delta.getMovedToPath());
            if (target != null) {
                this.moveResource(delta.getResource(), target);
            } else {
                movedResources.put(delta.getResource().getFullPath(), delta.getResource());
            }
        } else {
            this.removeResource(delta.getResource());
        }
    }

    private void processAddedDelta(IResourceDelta delta, HashMap<IPath, IResource> movedResources) {
        if ((delta.getFlags() & 0x1000) != 0) {
            IResource source = movedResources.get(delta.getMovedFromPath());
            if (source != null) {
                this.moveResource(source, delta.getResource());
            } else {
                movedResources.put(delta.getResource().getFullPath(), delta.getResource());
            }
        } else {
            this.addResource(delta.getResource());
        }
    }

    private void addResource(IResource resource) {
        Generation generation = this.getGeneration(resource);
        if (generation != null) {
            URI templateURI;
            URI resultURI = generation.getResultFileName() != null ? GenconfUtils.getResolvedURI(generation, URI.createURI((String)generation.getResultFileName(), (boolean)false)) : null;
            if (resultURI != null) {
                List<URI> generations = this.resultToGenerations.get(resultURI);
                if (generations == null) {
                    generations = new ArrayList<URI>();
                    this.resultToGenerations.put(resultURI, generations);
                }
                generations.add(generation.eResource().getURI());
                this.generationToResult.put(generation.eResource().getURI(), resultURI);
            }
            if ((templateURI = generation.getTemplateFileName() != null ? GenconfUtils.getResolvedURI(generation, URI.createURI((String)generation.getTemplateFileName(), (boolean)false)) : null) != null) {
                List<URI> generations = this.templateToGenerations.get(templateURI);
                if (generations == null) {
                    generations = new ArrayList<URI>();
                    this.templateToGenerations.put(templateURI, generations);
                }
                generations.add(generation.eResource().getURI());
                this.generationToTemplate.put(generation.eResource().getURI(), templateURI);
            }
        }
    }

    private void removeResource(IResource resource) {
        URI genconfURI = URI.createPlatformResourceURI((String)resource.getFullPath().toString(), (boolean)true);
        URI resultURI = this.generationToResult.remove(genconfURI);
        if (resultURI != null) {
            this.resultToGenerations.get(resultURI).remove(genconfURI);
        }
        URI templateURI = this.generationToTemplate.remove(genconfURI);
        if (resultURI != null) {
            this.templateToGenerations.get(templateURI).remove(genconfURI);
        }
    }

    private void changedResource(IResource resource) {
        this.removeResource(resource);
        this.addResource(resource);
    }

    private void moveResource(IResource source, IResource target) {
        this.removeResource(source);
        this.addResource(target);
    }

    private Generation getGeneration(IResource resource) {
        Generation res;
        if ("genconf".equals(resource.getLocation().getFileExtension()) && resource.isAccessible()) {
            URI genconfURI = URI.createPlatformResourceURI((String)resource.getFullPath().toString(), (boolean)true);
            try {
                res = GenconfUtils.getGeneration(genconfURI);
            }
            catch (Exception e) {
                GenconfPlugin.INSTANCE.log(new Status(4, "org.obeonetwork.m2doc.genconf", 4, "can't load: " + genconfURI, (Throwable)e));
                res = null;
            }
        } else {
            res = null;
        }
        return res;
    }

    public List<URI> getGenconfURIsFromResult(URI resultURI) {
        return this.resultToGenerations.get(resultURI);
    }

    public List<URI> getGenconfURIsFromTempate(URI templateURI) {
        return this.templateToGenerations.get(templateURI);
    }
}

