/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.cdo.tests;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.cdo.common.lob.CDOBlob;
import org.eclipse.emf.cdo.eresource.CDOBinaryResource;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.util.CommitException;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.net4j.connector.IConnector;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.runners.Parameterized;
import org.obeonetwork.m2doc.cdo.M2DocCDOUtils;
import org.obeonetwork.m2doc.cdo.services.configurator.CDOServicesConfigurator;
import org.obeonetwork.m2doc.cdo.tests.CDOServer;
import org.obeonetwork.m2doc.parser.DocumentParserException;
import org.obeonetwork.m2doc.services.configurator.IServicesConfigurator;
import org.obeonetwork.m2doc.services.configurator.IServicesConfiguratorDescriptor;
import org.obeonetwork.m2doc.services.configurator.ServicesConfiguratorDescriptor;
import org.obeonetwork.m2doc.tests.AbstractTemplatesTestSuite;
import org.obeonetwork.m2doc.util.M2DocUtils;

public class ServerWithoutAuthenticationTemplateOnServer
extends AbstractTemplatesTestSuite {
    private static CDOServer server;
    private static final ServicesConfiguratorDescriptor SERVICES_CONFIGURATOR_DESCRIPTOR;
    private static final Map<String, URI> TO_CDO_MAPPING;

    static {
        SERVICES_CONFIGURATOR_DESCRIPTOR = new ServicesConfiguratorDescriptor((IServicesConfigurator)new CDOServicesConfigurator());
        TO_CDO_MAPPING = new HashMap<String, URI>();
    }

    public ServerWithoutAuthenticationTemplateOnServer(String testFolder) throws IOException, DocumentParserException, CommitException {
        super(testFolder);
    }

    protected URI getTemplateURI(File testFolder) {
        return TO_CDO_MAPPING.get(testFolder.getPath());
    }

    @BeforeClass
    public static void startCDOServer() {
        Collection testFolders = ServerWithoutAuthenticationTemplateOnServer.retrieveTestFolders((String)"resources/serverWithoutAuthenticationTemplateOnServer");
        server = new CDOServer(false);
        server.start();
        IConnector connector = M2DocCDOUtils.getConnector((String)"tcp://127.0.0.1:12345");
        CDOSession session = M2DocCDOUtils.openSession((IConnector)connector, (String)"testRepo", (String)"user", (String)"password");
        CDOTransaction transaction = M2DocCDOUtils.openTransaction((CDOSession)session);
        CDOResource resource = transaction.createResource("anydsl.ecore");
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        Resource anyDSLResource = resourceSet.getResource(URI.createFileURI((String)"resources/anydsl.ecore"), true);
        resource.getContents().addAll((Collection)anyDSLResource.getContents());
        try {
            resource.save(null);
            for (Object[] parameters : testFolders) {
                String testFolder = ((String)parameters[0]).replaceAll("\\\\", "/");
                URI uri = URI.createURI((String)ServerWithoutAuthenticationTemplateOnServer.getTemplateFileInternal((File)new File(testFolder)).toURI().toString(), (boolean)false);
                CDOBinaryResource templateResource = transaction.createBinaryResource(uri.lastSegment());
                URIConverter uriConverter = transaction.getResourceSet().getURIConverter();
                InputStream templateInputStream = uriConverter.createInputStream(uri);
                CDOBlob contents = new CDOBlob(templateInputStream);
                templateResource.setContents(contents);
                TO_CDO_MAPPING.put(testFolder, templateResource.getURI());
                templateResource.cdoResource().save(null);
                transaction.commit();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (CommitException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        transaction.close();
        session.close();
        connector.close();
        if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
            M2DocUtils.registerServicesConfigurator((IServicesConfiguratorDescriptor)SERVICES_CONFIGURATOR_DESCRIPTOR);
        }
    }

    @AfterClass
    public static void stopCDOServer() {
        server.stop();
        if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
            M2DocUtils.unregisterServicesConfigurator((IServicesConfiguratorDescriptor)SERVICES_CONFIGURATOR_DESCRIPTOR);
        }
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> retrieveTestFolders() {
        return ServerWithoutAuthenticationTemplateOnServer.retrieveTestFolders((String)"resources/serverWithoutAuthenticationTemplateOnServer");
    }
}

