/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.launcher.internal;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.kohsuke.args4j.spi.StringArrayOptionHandler;
import org.obeonetwork.m2doc.genconf.GenconfUtils;
import org.obeonetwork.m2doc.genconf.Generation;
import org.obeonetwork.m2doc.generator.DocumentGenerationException;
import org.obeonetwork.m2doc.ide.M2DocPlugin;
import org.obeonetwork.m2doc.launcher.internal.CLIUtils;
import org.obeonetwork.m2doc.launcher.internal.M2DocLauncherPlugin;
import org.obeonetwork.m2doc.parser.DocumentParserException;
import org.obeonetwork.m2doc.util.IClassProvider;

public class M2DocLauncher
implements IApplication {
    private static final Integer APPLICATION_ERROR = -1;
    private static final String ERROR_LOADING_GENCONF = "Error loading genconf: '%s' : %s.";
    private static final String ERROR_LAUNCHING_GENCONF = "Error launching genconf: '%s' : %s.";
    @Option(name="-genconfs", usage="Specify the genconf model to use as inputs of the generation. Relative paths might be used or absolute uris (file://,http:/ or platform:/plugins/  for instance.)", metaVar="INPUT", handler=StringArrayOptionHandler.class)
    private String[] genconfs = new String[0];
    @Option(name="-data", usage="Specify the folder which will keep the workspace.", metaVar="FOLDER")
    private File dataFolder;
    @Option(name="-consoleLog", usage="Log messages in the console.")
    private boolean consoleLog;

    public Object start(IApplicationContext context) throws Exception {
        String[] args = (String[])context.getArguments().get("application.args");
        return new M2DocLauncher().doMain(args);
    }

    public Object doMain(String[] args) {
        CmdLineParser parser = new CmdLineParser((Object)this);
        boolean somethingWentWrong = false;
        try {
            System.out.println(CLIUtils.getDecorator().purple(" __          __  _                            _          __  __ ___     _            \n \\ \\        / / | |                          | |        |  \\/  |__ \\   | |           \n  \\ \\  /\\  / /__| | ___ ___  _ __ ___   ___  | |_ ___   | \\  / |  ) |__| | ___   ___ \n   \\ \\/  \\/ / _ \\ |/ __/ _ \\| '_ ` _ \\ / _ \\ | __/ _ \\  | |\\/| | / // _` |/ _ \\ / __|\n    \\  /\\  /  __/ | (_| (_) | | | | | |  __/ | || (_) | | |  | |/ /| (_| | (_) | (__ \n     \\/  \\/ \\___|_|\\___\\___/|_| |_| |_|\\___|  \\__\\___/  |_|  |_|____\\__,_|\\___/ \\___|"));
            System.out.println(CLIUtils.getDecorator().yellow("The command-line launcher to generate .docx from your models."));
            parser.parseArgument(args);
            System.out.println("\u001b[0m");
            Collection<URI> genconfsURIs = this.validateArguments(parser);
            ArrayList<Generation> loadedGenConfs = new ArrayList<Generation>();
            ResourceSetImpl s = new ResourceSetImpl();
            for (URI uri : genconfsURIs) {
                boolean bl = somethingWentWrong = this.loadGenerationConfigs(loadedGenConfs, (ResourceSet)s, uri) || somethingWentWrong;
            }
            CLIUtils.ColoredPrinting monitor = new CLIUtils.ColoredPrinting(System.out);
            monitor.beginTask("Generating .docx documents", loadedGenConfs.size());
            for (Generation generation : loadedGenConfs) {
                this.launchGenerationConfiguration(generation, (Monitor)monitor);
            }
        }
        catch (CmdLineException e) {
            parser.printUsage((OutputStream)System.err);
            System.err.println();
            somethingWentWrong = true;
            M2DocLauncherPlugin.INSTANCE.log(new Status(4, M2DocLauncherPlugin.INSTANCE.getSymbolicName(), e.getMessage(), (Throwable)e));
        }
        if (somethingWentWrong) {
            return APPLICATION_ERROR;
        }
        return IApplication.EXIT_OK;
    }

    private void launchGenerationConfiguration(Generation generation, Monitor monitor) {
        try {
            System.out.println("Input: " + generation.eResource().getURI());
            List generated = GenconfUtils.generate((Generation)generation, (IClassProvider)M2DocPlugin.getClassProvider(), (Monitor)monitor);
            for (URI uri : generated) {
                System.out.println("Output: " + uri.toString());
            }
            monitor.worked(1);
        }
        catch (IOException | DocumentGenerationException | DocumentParserException e) {
            String message = String.format(ERROR_LAUNCHING_GENCONF, generation.eResource().getURI().toString(), e.getMessage());
            M2DocLauncherPlugin.INSTANCE.log(new Status(4, M2DocLauncherPlugin.INSTANCE.getSymbolicName(), message, e));
        }
    }

    private boolean loadGenerationConfigs(Collection<Generation> loadedGenConfs, ResourceSet resourceSet, URI uri) {
        boolean somethingWentWrong;
        if (resourceSet.getURIConverter().exists(uri, Collections.EMPTY_MAP)) {
            try {
                Resource r = resourceSet.getResource(uri, true);
                r.load(Collections.EMPTY_MAP);
                for (EObject eObj : r.getContents()) {
                    if (!(eObj instanceof Generation)) continue;
                    loadedGenConfs.add((Generation)eObj);
                }
                somethingWentWrong = false;
            }
            catch (IOException | RuntimeException e) {
                somethingWentWrong = true;
                String message = String.format(ERROR_LOADING_GENCONF, uri.toString(), e.getMessage());
                M2DocLauncherPlugin.INSTANCE.log(new Status(4, M2DocLauncherPlugin.INSTANCE.getSymbolicName(), message, (Throwable)e));
            }
        } else {
            String message = String.format(ERROR_LOADING_GENCONF, uri.toString(), "does not exist or is not accessible");
            M2DocLauncherPlugin.INSTANCE.log(new Status(4, M2DocLauncherPlugin.INSTANCE.getSymbolicName(), message));
            somethingWentWrong = false;
        }
        return somethingWentWrong;
    }

    private Collection<URI> validateArguments(CmdLineParser parser) throws CmdLineException {
        ArrayList<URI> result = new ArrayList<URI>();
        if (this.genconfs == null || this.genconfs.length == 0) {
            throw new CmdLineException(parser, "You must specify genconfs models.");
        }
        String[] stringArray = this.genconfs;
        int n = this.genconfs.length;
        int n2 = 0;
        while (n2 < n) {
            String modelPath = stringArray[n2];
            URI rawURI = null;
            try {
                rawURI = URI.createURI((String)modelPath, (boolean)true);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (rawURI != null && !rawURI.hasAbsolutePath()) {
                rawURI = URI.createFileURI((String)modelPath);
            }
            result.add(rawURI);
            ++n2;
        }
        return result;
    }

    public void stop() {
    }
}

