/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.genconf.editor.command;

import java.util.ArrayList;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.obeonetwork.m2doc.genconf.GenconfUtils;
import org.obeonetwork.m2doc.genconf.Generation;
import org.obeonetwork.m2doc.genconf.editor.command.AbstractGenerationHandler;
import org.obeonetwork.m2doc.genconf.presentation.M2docconfEditorPlugin;
import org.obeonetwork.m2doc.ide.M2DocPlugin;
import org.obeonetwork.m2doc.util.IClassProvider;

public class GenerateHandler
extends AbstractGenerationHandler {
    @Override
    protected void execute(ExecutionEvent event, Generation generation) {
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        GenerateJob job = new GenerateJob(generation, shell);
        job.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        job.setUser(true);
        job.schedule();
    }

    public static final class GenerateJob
    extends WorkspaceJob {
        private static final String M2_DOC_GENERATION = "M2Doc generation";
        private final Generation generation;
        private final Shell shell;

        public GenerateJob(Generation generation, Shell shell) {
            super("Generating: " + URI.decode((String)generation.eResource().getURI().toString()));
            this.generation = generation;
            this.shell = shell;
        }

        public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
            Status status = new Status(0, M2docconfEditorPlugin.getPlugin().getSymbolicName(), "Generation succesfull");
            final ArrayList generatedfiles = new ArrayList();
            try {
                boolean generate = GenerateHandler.checkM2DocVersion(this.shell, M2_DOC_GENERATION, this.generation);
                if (generate) {
                    generatedfiles.addAll(GenconfUtils.generate((Generation)this.generation, (IClassProvider)M2DocPlugin.getClassProvider(), (Monitor)BasicMonitor.toMonitor((IProgressMonitor)monitor)));
                }
            }
            catch (Exception e) {
                final String msg = e.getMessage();
                status = new Status(4, M2docconfEditorPlugin.getPlugin().getSymbolicName(), 4, "M2Doc : technical error" + (msg == null ? "." : " : " + msg), (Throwable)e);
                M2docconfEditorPlugin.getPlugin().getLog().log((IStatus)status);
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openError((Shell)shell, (String)"Generation problem. See the error log for details", (String)msg);
                    }
                });
            }
            if (generatedfiles.size() == 1) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openInformation((Shell)shell, (String)GenerateJob.M2_DOC_GENERATION, (String)("The document '" + URI.decode((String)((URI)generatedfiles.get(0)).toString()) + "' is generated."));
                    }
                });
            } else if (generatedfiles.size() == 2) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openInformation((Shell)shell, (String)GenerateJob.M2_DOC_GENERATION, (String)("The document '" + URI.decode((String)((URI)generatedfiles.get(0)).toString()) + "' is generated. \n\n The template file contains validation errors, please read '" + URI.decode((String)((URI)generatedfiles.get(1)).toString()) + "'."));
                    }
                });
            }
            return status;
        }
    }
}

