/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.genconf.editor.command;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.Query;
import org.eclipse.acceleo.query.validation.type.EClassifierType;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.obeonetwork.m2doc.genconf.GenconfUtils;
import org.obeonetwork.m2doc.genconf.Generation;
import org.obeonetwork.m2doc.genconf.ModelDefinition;
import org.obeonetwork.m2doc.genconf.editor.wizard.GenerationWithTemplateLibraryWizard;
import org.obeonetwork.m2doc.genconf.impl.GenconfFactoryImpl;
import org.obeonetwork.m2doc.generator.DocumentGenerationException;
import org.obeonetwork.m2doc.ide.M2DocPlugin;
import org.obeonetwork.m2doc.ide.ui.M2DocUIPlugin;
import org.obeonetwork.m2doc.parser.DocumentParserException;
import org.obeonetwork.m2doc.properties.TemplateCustomProperties;
import org.obeonetwork.m2doc.util.IClassProvider;

public class GenerateWithTemplateLibrary
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
            EObject eObj = (EObject)((IStructuredSelection)selection).getFirstElement();
            this.generate(shell, eObj);
        }
        return null;
    }

    protected void generate(Shell shell, EObject eObj) {
        IQueryEnvironment queryEnvironment = Query.newEnvironment();
        queryEnvironment.registerEPackage(eObj.eClass().getEPackage());
        for (EClass superECls : eObj.eClass().getEAllSuperTypes()) {
            queryEnvironment.registerEPackage(superECls.getEPackage());
        }
        HashSet<EClassifierType> variableTypes = new HashSet<EClassifierType>();
        variableTypes.add(new EClassifierType((IReadOnlyQueryEnvironment)queryEnvironment, (EClassifier)eObj.eClass()));
        Map compatibleTemplates = M2DocUIPlugin.getDefault().getCompatibleTemplatesFromLibraries((IReadOnlyQueryEnvironment)queryEnvironment, variableTypes);
        GenerationWithTemplateLibraryWizard genWiz = new GenerationWithTemplateLibraryWizard(new ArrayList<File>(compatibleTemplates.keySet()));
        WizardDialog dialog = new WizardDialog(shell, (IWizard)genWiz){

            public void create() {
                super.create();
                this.getShell().setText("Generation Configuration");
            }
        };
        int result = dialog.open();
        if (result == 0) {
            URI templateFile = URI.createFileURI((String)genWiz.getSelectedTemplate().getAbsolutePath());
            URI resultFile = URI.createFileURI((String)genWiz.getOutputFile().getAbsolutePath());
            TemplateCustomProperties templateCustomProperties = (TemplateCustomProperties)compatibleTemplates.get(genWiz.getSelectedTemplate());
            String variableName = (String)templateCustomProperties.getVariables().keySet().iterator().next();
            Generation generation = GenconfFactoryImpl.eINSTANCE.createGeneration();
            XMIResourceImpl resource = new XMIResourceImpl();
            resource.getContents().add((Object)generation);
            resource.setURI(URI.createURI((String)"inMemory.genconf").resolve(eObj.eResource().getURI()));
            generation.setTemplateFileName(templateFile.toString());
            generation.setResultFileName(resultFile.toString());
            ModelDefinition modelDef = GenconfFactoryImpl.eINSTANCE.createModelDefinition();
            modelDef.setKey(variableName);
            modelDef.setValue(eObj);
            generation.getDefinitions().add((Object)modelDef);
            GenconfUtils.initializeOptions((Generation)generation, (EObject)eObj);
            IClassProvider classProvider = M2DocPlugin.getClassProvider();
            boolean error = false;
            try {
                GenconfUtils.generate((Generation)generation, (IClassProvider)classProvider, (Monitor)new BasicMonitor());
            }
            catch (DocumentGenerationException e) {
                e.printStackTrace();
                error = true;
            }
            catch (IOException e) {
                e.printStackTrace();
                error = true;
            }
            catch (DocumentParserException e) {
                e.printStackTrace();
                error = true;
            }
            if (error) {
                MessageDialog.openError((Shell)shell, (String)"Error", (String)"Generation ended with an error");
            } else {
                MessageDialog.openInformation((Shell)shell, (String)"Complete", (String)"Generation completed");
            }
        }
    }
}

