/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.genconf.editor.dialog;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.StringJoiner;
import org.eclipse.acceleo.query.parser.AstValidator;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.impl.ValidationServices;
import org.eclipse.acceleo.query.validation.type.ICollectionType;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.obeonetwork.m2doc.genconf.BooleanDefinition;
import org.obeonetwork.m2doc.genconf.BooleanOrderedSetDefinition;
import org.obeonetwork.m2doc.genconf.BooleanSequenceDefinition;
import org.obeonetwork.m2doc.genconf.Definition;
import org.obeonetwork.m2doc.genconf.IntegerDefinition;
import org.obeonetwork.m2doc.genconf.IntegerOrderedSetDefinition;
import org.obeonetwork.m2doc.genconf.IntegerSequenceDefinition;
import org.obeonetwork.m2doc.genconf.ModelDefinition;
import org.obeonetwork.m2doc.genconf.ModelOrderedSetDefinition;
import org.obeonetwork.m2doc.genconf.ModelSequenceDefinition;
import org.obeonetwork.m2doc.genconf.RealDefinition;
import org.obeonetwork.m2doc.genconf.RealOrderedSetDefinition;
import org.obeonetwork.m2doc.genconf.RealSequenceDefinition;
import org.obeonetwork.m2doc.genconf.StringDefinition;
import org.obeonetwork.m2doc.genconf.StringOrderedSetDefinition;
import org.obeonetwork.m2doc.genconf.StringSequenceDefinition;
import org.obeonetwork.m2doc.ide.ui.dialog.EObjectSelectionDialog;
import org.obeonetwork.m2doc.properties.TemplateCustomProperties;

public class DefinitionValueDialog
extends EObjectSelectionDialog {
    private static final String DELIMITER = ",";
    private final Definition definition;
    private IReadOnlyQueryEnvironment queryEnvironment;
    private TemplateCustomProperties properties;

    public DefinitionValueDialog(Shell parentShell, AdapterFactory adapterFactory, Definition definition, IReadOnlyQueryEnvironment queryEnvironment, TemplateCustomProperties properties, ResourceSet resourceSet) {
        super(parentShell, adapterFactory, "Select value for " + definition.getKey(), "Select a value of type " + (String)properties.getVariables().get(definition.getKey()), queryEnvironment, resourceSet, null);
        this.definition = definition;
        this.queryEnvironment = queryEnvironment;
        this.properties = properties;
    }

    protected Control createCustomArea(Composite parent) {
        Composite container = new Composite(parent, parent.getStyle());
        container.setLayout((Layout)new GridLayout(1, false));
        container.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        if (this.definition instanceof BooleanDefinition) {
            this.createBooleanCustomArea((BooleanDefinition)this.definition, container);
        } else if (this.definition instanceof BooleanSequenceDefinition) {
            this.createBooleanSequenceCustomArea((BooleanSequenceDefinition)this.definition, container);
        } else if (this.definition instanceof BooleanOrderedSetDefinition) {
            this.createBooleanOrderedSetCustomArea((BooleanOrderedSetDefinition)this.definition, container);
        } else if (this.definition instanceof IntegerDefinition) {
            this.createIntegerCustomArea((IntegerDefinition)this.definition, container);
        } else if (this.definition instanceof IntegerSequenceDefinition) {
            this.createIntegerSequenceCustomArea((IntegerSequenceDefinition)this.definition, container);
        } else if (this.definition instanceof IntegerOrderedSetDefinition) {
            this.createIntegerOrderedSetCustomArea((IntegerOrderedSetDefinition)this.definition, container);
        } else if (this.definition instanceof ModelDefinition) {
            AstValidator validator = new AstValidator(new ValidationServices(this.queryEnvironment));
            Set acceptedTypes = this.properties.getVariableTypes(validator, this.queryEnvironment, (String)this.properties.getVariables().get(this.definition.getKey()));
            this.createModelCustomArea(acceptedTypes, container);
        } else if (this.definition instanceof ModelSequenceDefinition || this.definition instanceof ModelOrderedSetDefinition) {
            this.setMultiSelection(true);
            this.value = new ArrayList();
            AstValidator validator = new AstValidator(new ValidationServices(this.queryEnvironment));
            Set acceptedTypes = this.properties.getVariableTypes(validator, this.queryEnvironment, (String)this.properties.getVariables().get(this.definition.getKey()));
            LinkedHashSet<IType> acceptedRawTypes = new LinkedHashSet<IType>();
            for (IType acceptedType : acceptedTypes) {
                if (!(acceptedType instanceof ICollectionType)) continue;
                acceptedRawTypes.add(((ICollectionType)acceptedType).getCollectionType());
            }
            this.createModelCustomArea(acceptedRawTypes, container);
        } else if (this.definition instanceof RealDefinition) {
            this.createRealCustomArea((RealDefinition)this.definition, container);
        } else if (this.definition instanceof RealSequenceDefinition) {
            this.createRealSequenceCustomArea((RealSequenceDefinition)this.definition, container);
        } else if (this.definition instanceof RealOrderedSetDefinition) {
            this.createRealOrderedSetCustomArea((RealOrderedSetDefinition)this.definition, container);
        } else if (this.definition instanceof StringDefinition) {
            this.createStringCustomArea((StringDefinition)this.definition, container);
        } else if (this.definition instanceof StringSequenceDefinition) {
            this.createStringSequenceCustomArea((StringSequenceDefinition)this.definition, container);
        } else if (this.definition instanceof StringOrderedSetDefinition) {
            this.createStringOrderedSetCustomArea((StringOrderedSetDefinition)this.definition, container);
        } else {
            throw new IllegalStateException("don't know what to do with " + this.definition);
        }
        return container;
    }

    protected void createStringCustomArea(StringDefinition def, Composite container) {
        final Text text = this.addLabelAndText((Definition)def, container);
        if (((StringDefinition)this.definition).getValue() != null) {
            text.setText(((StringDefinition)this.definition).getValue());
        }
        text.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                DefinitionValueDialog.this.value = text.getText();
            }

            public void keyPressed(KeyEvent e) {
            }
        });
    }

    private void createStringSequenceCustomArea(StringSequenceDefinition def, Composite container) {
        final Text text = this.addLabelAndText((Definition)def, container);
        StringJoiner joiner = new StringJoiner(DELIMITER);
        for (String value : def.getValue()) {
            joiner.add(value);
        }
        text.setText(joiner.toString());
        text.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                try {
                    String[] values = text.getText().split(DefinitionValueDialog.DELIMITER);
                    ArrayList<String> res = new ArrayList<String>();
                    String[] stringArray = values;
                    int n = values.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String val = stringArray[n2];
                        res.add(val);
                        ++n2;
                    }
                    DefinitionValueDialog.this.value = res;
                    DefinitionValueDialog.this.getButton(0).setEnabled(true);
                }
                catch (NumberFormatException nfe) {
                    DefinitionValueDialog.this.getButton(0).setEnabled(false);
                }
            }

            public void keyPressed(KeyEvent e) {
            }
        });
    }

    private void createStringOrderedSetCustomArea(StringOrderedSetDefinition def, Composite container) {
        final Text text = this.addLabelAndText((Definition)def, container);
        StringJoiner joiner = new StringJoiner(DELIMITER);
        for (String value : def.getValue()) {
            joiner.add(value);
        }
        text.setText(joiner.toString());
        text.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                try {
                    String[] values = text.getText().split(DefinitionValueDialog.DELIMITER);
                    LinkedHashSet<String> res = new LinkedHashSet<String>();
                    String[] stringArray = values;
                    int n = values.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String val = stringArray[n2];
                        res.add(val);
                        ++n2;
                    }
                    DefinitionValueDialog.this.value = res;
                    DefinitionValueDialog.this.getButton(0).setEnabled(true);
                }
                catch (NumberFormatException nfe) {
                    DefinitionValueDialog.this.getButton(0).setEnabled(false);
                }
            }

            public void keyPressed(KeyEvent e) {
            }
        });
    }

    protected void createRealCustomArea(RealDefinition def, Composite container) {
        final Text text = this.addLabelAndText((Definition)def, container);
        text.setText(String.valueOf(def.getValue()));
        text.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                try {
                    DefinitionValueDialog.this.value = Double.valueOf(text.getText());
                    DefinitionValueDialog.this.getButton(0).setEnabled(true);
                }
                catch (NumberFormatException nfe) {
                    DefinitionValueDialog.this.getButton(0).setEnabled(false);
                }
            }

            public void keyPressed(KeyEvent e) {
            }
        });
    }

    private void createRealSequenceCustomArea(RealSequenceDefinition def, Composite container) {
        final Text text = this.addLabelAndText((Definition)def, container);
        StringJoiner joiner = new StringJoiner(DELIMITER);
        for (Double value : def.getValue()) {
            joiner.add(String.valueOf(value));
        }
        text.setText(joiner.toString());
        text.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                try {
                    String[] values = text.getText().split(DefinitionValueDialog.DELIMITER);
                    ArrayList<Double> res = new ArrayList<Double>();
                    String[] stringArray = values;
                    int n = values.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String val = stringArray[n2];
                        res.add(Double.valueOf(val.trim()));
                        ++n2;
                    }
                    DefinitionValueDialog.this.value = res;
                    DefinitionValueDialog.this.getButton(0).setEnabled(true);
                }
                catch (NumberFormatException nfe) {
                    DefinitionValueDialog.this.getButton(0).setEnabled(false);
                }
            }

            public void keyPressed(KeyEvent e) {
            }
        });
    }

    private void createRealOrderedSetCustomArea(RealOrderedSetDefinition def, Composite container) {
        final Text text = this.addLabelAndText((Definition)def, container);
        StringJoiner joiner = new StringJoiner(DELIMITER);
        for (Double value : def.getValue()) {
            joiner.add(String.valueOf(value));
        }
        text.setText(joiner.toString());
        text.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                try {
                    String[] values = text.getText().split(DefinitionValueDialog.DELIMITER);
                    LinkedHashSet<Double> res = new LinkedHashSet<Double>();
                    String[] stringArray = values;
                    int n = values.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String val = stringArray[n2];
                        res.add(Double.valueOf(val.trim()));
                        ++n2;
                    }
                    DefinitionValueDialog.this.value = res;
                    DefinitionValueDialog.this.getButton(0).setEnabled(true);
                }
                catch (NumberFormatException nfe) {
                    DefinitionValueDialog.this.getButton(0).setEnabled(false);
                }
            }

            public void keyPressed(KeyEvent e) {
            }
        });
    }

    private void createIntegerCustomArea(IntegerDefinition def, Composite container) {
        final Text text = this.addLabelAndText((Definition)def, container);
        text.setText(String.valueOf(def.getValue()));
        text.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                try {
                    DefinitionValueDialog.this.value = Integer.valueOf(text.getText());
                    DefinitionValueDialog.this.getButton(0).setEnabled(true);
                }
                catch (NumberFormatException nfe) {
                    DefinitionValueDialog.this.getButton(0).setEnabled(false);
                }
            }

            public void keyPressed(KeyEvent e) {
            }
        });
    }

    private void createIntegerSequenceCustomArea(IntegerSequenceDefinition def, Composite container) {
        final Text text = this.addLabelAndText((Definition)def, container);
        StringJoiner joiner = new StringJoiner(DELIMITER);
        for (Integer value : def.getValue()) {
            joiner.add(String.valueOf(value));
        }
        text.setText(joiner.toString());
        text.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                try {
                    String[] values = text.getText().split(DefinitionValueDialog.DELIMITER);
                    ArrayList<Integer> res = new ArrayList<Integer>();
                    String[] stringArray = values;
                    int n = values.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String val = stringArray[n2];
                        res.add(Integer.valueOf(val.trim()));
                        ++n2;
                    }
                    DefinitionValueDialog.this.value = res;
                    DefinitionValueDialog.this.getButton(0).setEnabled(true);
                }
                catch (NumberFormatException nfe) {
                    DefinitionValueDialog.this.getButton(0).setEnabled(false);
                }
            }

            public void keyPressed(KeyEvent e) {
            }
        });
    }

    private void createIntegerOrderedSetCustomArea(IntegerOrderedSetDefinition def, Composite container) {
        final Text text = this.addLabelAndText((Definition)def, container);
        StringJoiner joiner = new StringJoiner(DELIMITER);
        for (Integer value : def.getValue()) {
            joiner.add(String.valueOf(value));
        }
        text.setText(joiner.toString());
        text.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                try {
                    String[] values = text.getText().split(DefinitionValueDialog.DELIMITER);
                    LinkedHashSet<Integer> res = new LinkedHashSet<Integer>();
                    String[] stringArray = values;
                    int n = values.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String val = stringArray[n2];
                        res.add(Integer.valueOf(val.trim()));
                        ++n2;
                    }
                    DefinitionValueDialog.this.value = res;
                    DefinitionValueDialog.this.getButton(0).setEnabled(true);
                }
                catch (NumberFormatException nfe) {
                    DefinitionValueDialog.this.getButton(0).setEnabled(false);
                }
            }

            public void keyPressed(KeyEvent e) {
            }
        });
    }

    protected void createBooleanCustomArea(BooleanDefinition def, Composite container) {
        final Button button = new Button(container, 2);
        button.setText(this.definition.getKey());
        button.setSelection(def.isValue());
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DefinitionValueDialog.this.value = button.getSelection();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void createBooleanSequenceCustomArea(BooleanSequenceDefinition def, Composite container) {
        final Text text = this.addLabelAndText((Definition)def, container);
        StringJoiner joiner = new StringJoiner(DELIMITER);
        for (Boolean value : def.getValue()) {
            joiner.add(String.valueOf(value));
        }
        text.setText(joiner.toString());
        text.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                String[] values = text.getText().split(DefinitionValueDialog.DELIMITER);
                ArrayList<Boolean> res = new ArrayList<Boolean>();
                String[] stringArray = values;
                int n = values.length;
                int n2 = 0;
                while (n2 < n) {
                    String val = stringArray[n2];
                    res.add(Boolean.valueOf(val.trim()));
                    ++n2;
                }
                DefinitionValueDialog.this.value = res;
                DefinitionValueDialog.this.getButton(0).setEnabled(true);
            }

            public void keyPressed(KeyEvent e) {
            }
        });
    }

    private void createBooleanOrderedSetCustomArea(BooleanOrderedSetDefinition def, Composite container) {
        final Text text = this.addLabelAndText((Definition)def, container);
        StringJoiner joiner = new StringJoiner(DELIMITER);
        for (Boolean value : def.getValue()) {
            joiner.add(String.valueOf(value));
        }
        text.setText(joiner.toString());
        text.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                String[] values = text.getText().split(DefinitionValueDialog.DELIMITER);
                LinkedHashSet<Boolean> res = new LinkedHashSet<Boolean>();
                String[] stringArray = values;
                int n = values.length;
                int n2 = 0;
                while (n2 < n) {
                    String val = stringArray[n2];
                    res.add(Boolean.valueOf(val.trim()));
                    ++n2;
                }
                DefinitionValueDialog.this.value = res;
                DefinitionValueDialog.this.getButton(0).setEnabled(true);
            }

            public void keyPressed(KeyEvent e) {
            }
        });
    }

    private Text addLabelAndText(Definition def, Composite container) {
        Composite composite = new Composite(container, container.getStyle());
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label label = new Label(composite, container.getStyle());
        label.setText(String.valueOf(def.getKey()) + " = ");
        Text text = new Text(composite, container.getStyle());
        text.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        return text;
    }

    public Object getValue() {
        return this.value;
    }

    protected void createLoadResourceButton(Composite parent) {
    }
}

