/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.genconf.editor.wizard;

import java.io.File;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class GenerationWithTemplateLibraryWizard
extends Wizard {
    private static final String BROWSE_LABEL = "...";
    private final List<File> templateList;
    private File selectedTemplate;
    private File outputFile;

    public GenerationWithTemplateLibraryWizard(List<File> templateList) {
        this.templateList = templateList;
    }

    public boolean performFinish() {
        if (this.outputFile == null) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)"Please define an Output File");
            return false;
        }
        return true;
    }

    public void createPageControls(Composite pageContainer) {
        ScrolledComposite sc = new ScrolledComposite(pageContainer, 512);
        sc.setLayoutData((Object)new GridData(1040));
        sc.setExpandVertical(true);
        sc.setExpandHorizontal(true);
        Composite container = new Composite((Composite)sc, 0);
        container.setLayout((Layout)new GridLayout(3, false));
        sc.setContent((Control)container);
        sc.addListener(11, event -> {
            int width = scrolledComposite.getClientArea().width;
            sc.setMinSize(container.computeSize(width, -1));
        });
        this.createTemplateSelector(container);
        this.createOutputFileSelector(container);
    }

    private void createTemplateSelector(Composite container) {
        GenerationWithTemplateLibraryWizard.createField(container, "List of templates:", () -> {
            ComboViewer field = new ComboViewer(container, 0);
            field.setContentProvider((IContentProvider)new ArrayContentProvider());
            field.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    return ((File)element).getName();
                }
            });
            field.addSelectionChangedListener(event -> {
                this.selectedTemplate = (File)GenerationWithTemplateLibraryWizard.getSelecteElement(field.getSelection());
            });
            field.setInput(this.templateList);
            this.selectedTemplate = this.getDefaultTemplate();
            field.setSelection((ISelection)new StructuredSelection((Object)this.selectedTemplate), true);
            return field.getCombo();
        }, null);
        GenerationWithTemplateLibraryWizard.createField(container, "", () -> {
            Label field = new Label(container, 0);
            field.setText("Templates loaded from Application");
            return field;
        }, null);
    }

    private void createOutputFileSelector(Composite container) {
        GenerationWithTemplateLibraryWizard.createField(container, "Output File:", () -> {
            Text field = new Text(container, 2048);
            field.setEditable(false);
            this.updateOutput(this.getDefaultOutputFile(), field);
            return field;
        }, field -> {
            Button browse = new Button(container, 0);
            browse.setText(BROWSE_LABEL);
            browse.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
                String selectedDirectory;
                FileDialog dialog = new FileDialog(this.getShell());
                dialog.setText("Select output file");
                dialog.setFilterExtensions(new String[]{"*.docx"});
                File initial = this.outputFile;
                while (initial != null && !initial.exists()) {
                    initial = initial.getParentFile();
                }
                if (initial != null) {
                    dialog.setFilterPath(this.outputFile.getPath());
                }
                if ((selectedDirectory = dialog.open()) != null) {
                    this.updateOutput(selectedDirectory, (Text)field);
                }
            }));
            return browse;
        });
    }

    private String getDefaultOutputFile() {
        return null;
    }

    private void updateOutput(String path, Text field) {
        String localPath = path;
        if (localPath != null && (localPath = localPath.trim()).isEmpty()) {
            localPath = null;
        }
        if (localPath != null) {
            if (!localPath.endsWith(".docx")) {
                localPath = String.valueOf(localPath) + ".docx";
            }
            this.outputFile = new File(localPath).getAbsoluteFile();
            field.setText(this.outputFile.toString());
        } else {
            this.outputFile = null;
            field.setText("");
        }
    }

    private File getDefaultTemplate() {
        return this.templateList.get(0);
    }

    private static <T> T getSelecteElement(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection strucSelect = (IStructuredSelection)selection;
            return (T)strucSelect.getFirstElement();
        }
        return null;
    }

    private static <C extends Control> C createField(Composite container, String labelText, Supplier<C> controller, Function<? super C, Control> picker) {
        Label label = new Label(container, 0);
        label.setText(labelText);
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        Control field = (Control)controller.get();
        field.setLayoutData((Object)new GridData(4, 0x1000000, true, false, picker != null ? 1 : 2, 1));
        if (picker != null) {
            Control right = picker.apply(field);
            right.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        }
        return (C)field;
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public File getSelectedTemplate() {
        return this.selectedTemplate;
    }
}

