/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.genconf.editor.wizard;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.Query;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.EStringToStringMapEntryImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.obeonetwork.m2doc.POIServices;
import org.obeonetwork.m2doc.genconf.GenconfPackage;
import org.obeonetwork.m2doc.genconf.GenconfUtils;
import org.obeonetwork.m2doc.genconf.Generation;
import org.obeonetwork.m2doc.genconf.editor.GenerationListener;
import org.obeonetwork.m2doc.genconf.editor.wizard.GenerationFileNamesPage;
import org.obeonetwork.m2doc.genconf.editor.wizard.VariableAndOptionPage;
import org.obeonetwork.m2doc.genconf.presentation.M2docconfEditorPlugin;
import org.obeonetwork.m2doc.properties.TemplateCustomProperties;
import org.obeonetwork.m2doc.util.M2DocUtils;

public class NewGenerationWizard
extends Wizard
implements INewWizard {
    public static final String DEFAULT_GENCONF_FILE_NAME = "MyGeneration.genconf";
    private IStructuredSelection selection = StructuredSelection.EMPTY;
    private final Generation generation = GenconfPackage.eINSTANCE.getGenconfFactory().createGeneration();
    private GenerationFileNamesPage fileNamesPage;
    private VariableAndOptionPage optionPage;
    private GenerationListener generationListener;
    private boolean canChangeTemplateFile = true;

    public NewGenerationWizard() {
        XMIResourceImpl resource = new XMIResourceImpl();
        resource.setEncoding(StandardCharsets.UTF_8.name());
        ResourceSetImpl rs = new ResourceSetImpl();
        rs.getResources().add((Object)resource);
        resource.getContents().add((Object)this.generation);
        TransactionalEditingDomain.Factory.INSTANCE.createEditingDomain((ResourceSet)rs);
    }

    public void init(IWorkbench workbench, IStructuredSelection selected) {
        this.selection = selected;
    }

    public void setCanChangeTemplateFile(boolean canChange) {
        this.canChangeTemplateFile = canChange;
    }

    public void addPages() {
        super.addPages();
        final Generation loadedGeneration = this.getGeneration(this.selection);
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)this.generation);
        if (loadedGeneration == null) {
            final URI genconfURI = this.getGenconfURI(this.selection);
            if (genconfURI != null) {
                this.generation.eResource().setURI(genconfURI);
                editingDomain.getCommandStack().execute((Command)new RecordingCommand(editingDomain){

                    protected void doExecute() {
                        NewGenerationWizard.this.generation.setTemplateFileName(URI.decode((String)NewGenerationWizard.this.getTemplateFileName(genconfURI).toString()));
                        NewGenerationWizard.this.generation.setValidationFileName(NewGenerationWizard.this.getValidationFileName(genconfURI));
                        NewGenerationWizard.this.generation.setResultFileName(NewGenerationWizard.this.getResultFileName(genconfURI));
                        GenconfUtils.initializeOptions((Generation)NewGenerationWizard.this.generation);
                        NewGenerationWizard.this.initializeVariableDefinition(NewGenerationWizard.this.generation);
                    }
                });
            }
        } else {
            this.generation.eResource().setURI(loadedGeneration.eResource().getURI());
            editingDomain.getCommandStack().execute((Command)new RecordingCommand(editingDomain){

                protected void doExecute() {
                    NewGenerationWizard.this.generation.setName(loadedGeneration.getName());
                    NewGenerationWizard.this.generation.setTemplateFileName(loadedGeneration.getTemplateFileName());
                    NewGenerationWizard.this.generation.setValidationFileName(loadedGeneration.getValidationFileName());
                    NewGenerationWizard.this.generation.setResultFileName(loadedGeneration.getResultFileName());
                    NewGenerationWizard.this.generation.getDefinitions().addAll((Collection)loadedGeneration.getDefinitions());
                    NewGenerationWizard.this.generation.getOptions().addAll((Collection)loadedGeneration.getOptions());
                    GenconfUtils.initializeOptions((Generation)NewGenerationWizard.this.generation);
                    NewGenerationWizard.this.initializeVariableDefinition(NewGenerationWizard.this.generation);
                }
            });
        }
        this.generationListener = new GenerationListener();
        this.generationListener.installGenerationListener(this.generation);
        this.fileNamesPage = new GenerationFileNamesPage(this.generation, this.generationListener, this.canChangeTemplateFile);
        this.addPage((IWizardPage)this.fileNamesPage);
        this.optionPage = new VariableAndOptionPage(this.generation, this.generationListener, this.fileNamesPage);
        this.addPage((IWizardPage)this.optionPage);
    }

    private Generation getGeneration(IStructuredSelection selected) {
        Generation res;
        if (selected != null && !selected.isEmpty()) {
            Resource resource;
            ResourceSetImpl rs = new ResourceSetImpl();
            URI genconfURI = URI.createPlatformResourceURI((String)((IResource)this.selection.getFirstElement()).getFullPath().toString(), (boolean)true);
            res = "genconf".equals(genconfURI.fileExtension()) ? (!(resource = rs.getResource(genconfURI, true)).getContents().isEmpty() && resource.getContents().get(0) instanceof Generation ? (Generation)resource.getContents().get(0) : null) : null;
        } else {
            res = null;
        }
        return res;
    }

    private void initializeVariableDefinition(Generation gen) {
        IQueryEnvironment queryEnvironment = Query.newEnvironment();
        try {
            TemplateCustomProperties properties = POIServices.getInstance().getTemplateCustomProperties(URIConverter.INSTANCE, URI.createURI((String)gen.getTemplateFileName()).resolve(gen.eResource().getURI()));
            queryEnvironment.registerEPackage((EPackage)EcorePackage.eINSTANCE);
            queryEnvironment.registerCustomClassMapping((EClassifier)EcorePackage.eINSTANCE.getEStringToStringMapEntry(), EStringToStringMapEntryImpl.class);
            properties.configureQueryEnvironmentWithResult(queryEnvironment);
            ResourceSetImpl defaultResourceSet = new ResourceSetImpl();
            defaultResourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
            defaultResourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().putAll(Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap());
            ResourceSet resourceSetForModel = M2DocUtils.createResourceSetForModels(new ArrayList(), (Object)queryEnvironment, (ResourceSet)defaultResourceSet, (Map)GenconfUtils.getOptions((Generation)gen));
            List newDefinitions = GenconfUtils.getNewDefinitions((Generation)gen, (TemplateCustomProperties)properties);
            gen.getDefinitions().addAll((Collection)newDefinitions);
            GenconfUtils.initializeVariableDefinition((Generation)gen, (IReadOnlyQueryEnvironment)queryEnvironment, (TemplateCustomProperties)properties, (ResourceSet)resourceSetForModel);
            M2DocUtils.cleanResourceSetForModels((Object)queryEnvironment, (ResourceSet)resourceSetForModel);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getTemplateFileName(URI genconfURI) {
        String lastSegment = genconfURI.lastSegment();
        return URI.decode((String)(String.valueOf(lastSegment.substring(0, lastSegment.length() - "genconf".length())) + "docx"));
    }

    private String getValidationFileName(URI genconfURI) {
        String lastSegment = genconfURI.lastSegment();
        return URI.decode((String)(String.valueOf(lastSegment.substring(0, lastSegment.length() - "genconf".length())) + "validation." + "docx"));
    }

    private String getResultFileName(URI genconfURI) {
        String lastSegment = genconfURI.lastSegment();
        return URI.decode((String)(String.valueOf(lastSegment.substring(0, lastSegment.length() - "genconf".length())) + "generated." + "docx"));
    }

    public void dispose() {
        super.dispose();
        this.generationListener.removeGenerationListener(this.generation);
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)this.generation);
        if (editingDomain != null) {
            editingDomain.dispose();
        }
    }

    private URI getGenconfURI(IStructuredSelection selected) {
        URI res;
        if (selected != null && !selected.isEmpty()) {
            if (selected.getFirstElement() instanceof IFile) {
                IFile file = (IFile)selected.getFirstElement();
                if ("docx".equals(file.getFileExtension())) {
                    String fullPathString = file.getFullPath().toString();
                    String genconfFileString = String.valueOf(fullPathString.substring(0, fullPathString.length() - "docx".length())) + "genconf";
                    res = URI.createPlatformResourceURI((String)genconfFileString, (boolean)true);
                } else {
                    String fullPathString = file.getParent().getFullPath().toString();
                    res = URI.createPlatformResourceURI((String)(String.valueOf(fullPathString) + "/" + DEFAULT_GENCONF_FILE_NAME), (boolean)true);
                }
            } else if (selected.getFirstElement() instanceof IContainer) {
                IContainer container = (IContainer)selected.getFirstElement();
                String fullPathString = container.getFullPath().toString();
                res = URI.createPlatformResourceURI((String)(String.valueOf(fullPathString) + "/" + DEFAULT_GENCONF_FILE_NAME), (boolean)true);
            } else {
                res = URI.createPlatformResourceURI((String)"/myproject/MyGeneration.genconf", (boolean)true);
            }
        } else {
            res = URI.createPlatformResourceURI((String)"/myproject/MyGeneration.genconf", (boolean)true);
        }
        return res;
    }

    public boolean performFinish() {
        WorkspaceJob job = new WorkspaceJob("Saving generation configuration: " + URI.decode((String)this.generation.eResource().getURI().toString())){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                Status status = new Status(0, M2docconfEditorPlugin.getPlugin().getSymbolicName(), "Generation configuration succesfully saved");
                try {
                    NewGenerationWizard.this.generation.eResource().save(Collections.emptyMap());
                }
                catch (IOException e) {
                    status = new Status(4, M2docconfEditorPlugin.getPlugin().getSymbolicName(), 4, "M2Doc : technical error" + (e.getMessage() == null ? "." : " : " + e.getMessage()), (Throwable)e);
                }
                return status;
            }
        };
        job.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        job.schedule();
        return true;
    }
}

