/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.genconf.editor.wizard;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.Query;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.EStringToStringMapEntryImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.action.LoadResourceAction;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.obeonetwork.m2doc.genconf.BooleanDefinition;
import org.obeonetwork.m2doc.genconf.BooleanOrderedSetDefinition;
import org.obeonetwork.m2doc.genconf.BooleanSequenceDefinition;
import org.obeonetwork.m2doc.genconf.Definition;
import org.obeonetwork.m2doc.genconf.GenconfPackage;
import org.obeonetwork.m2doc.genconf.GenconfUtils;
import org.obeonetwork.m2doc.genconf.Generation;
import org.obeonetwork.m2doc.genconf.IntegerDefinition;
import org.obeonetwork.m2doc.genconf.IntegerOrderedSetDefinition;
import org.obeonetwork.m2doc.genconf.IntegerSequenceDefinition;
import org.obeonetwork.m2doc.genconf.ModelDefinition;
import org.obeonetwork.m2doc.genconf.ModelOrderedSetDefinition;
import org.obeonetwork.m2doc.genconf.ModelSequenceDefinition;
import org.obeonetwork.m2doc.genconf.Option;
import org.obeonetwork.m2doc.genconf.RealDefinition;
import org.obeonetwork.m2doc.genconf.RealOrderedSetDefinition;
import org.obeonetwork.m2doc.genconf.RealSequenceDefinition;
import org.obeonetwork.m2doc.genconf.StringDefinition;
import org.obeonetwork.m2doc.genconf.StringOrderedSetDefinition;
import org.obeonetwork.m2doc.genconf.StringSequenceDefinition;
import org.obeonetwork.m2doc.genconf.editor.GenerationListener;
import org.obeonetwork.m2doc.genconf.editor.ITemplateCustomPropertiesProvider;
import org.obeonetwork.m2doc.genconf.editor.VariableValueCellLabelProvider;
import org.obeonetwork.m2doc.genconf.editor.dialog.DefinitionValueDialog;
import org.obeonetwork.m2doc.genconf.editor.dialog.M2DocOptionDialog;
import org.obeonetwork.m2doc.properties.TemplateCustomProperties;
import org.obeonetwork.m2doc.util.M2DocUtils;

public class VariableAndOptionPage
extends WizardPage {
    private static final int WIDTH = 300;
    private final Generation generation;
    private final GenerationListener generationListener;
    private TableViewer variablesTable;
    private TableViewer optionsTable;
    private ITemplateCustomPropertiesProvider templateCustomPropertiesProvider;
    private final ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    private TransactionalEditingDomain editingDomain;
    private final IReadOnlyQueryEnvironment queryEnvironment = Query.newEnvironment();
    private boolean createdEditingDomaine;

    public VariableAndOptionPage(Generation generation, GenerationListener generationListener, ITemplateCustomPropertiesProvider provider) {
        super("Set Variables and Options");
        this.setTitle("Set Variables and Options");
        this.generation = generation;
        this.generationListener = generationListener;
        this.templateCustomPropertiesProvider = provider;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, parent.getStyle());
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout(1, false));
        TabFolder tabFolder = new TabFolder(container, 2048);
        tabFolder.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        TabItem variableTabItem = new TabItem(tabFolder, tabFolder.getStyle());
        variableTabItem.setText("Variables");
        Composite variableContainer = new Composite((Composite)tabFolder, tabFolder.getStyle());
        variableTabItem.setControl((Control)variableContainer);
        this.variablesTable = this.createVariablesTable(this.generation, variableContainer, (AdapterFactory)this.adapterFactory, this.templateCustomPropertiesProvider);
        this.generationListener.setVariablesViewer((Viewer)this.variablesTable);
        this.createVariablesButonComposite(this.generation, variableContainer, (Viewer)this.variablesTable);
        TabItem optionTabItem = new TabItem(tabFolder, tabFolder.getStyle());
        optionTabItem.setText("Options (expert)");
        Composite optionContainer = new Composite((Composite)tabFolder, tabFolder.getStyle());
        optionTabItem.setControl((Control)optionContainer);
        optionContainer.setLayout((Layout)new GridLayout(2, false));
        this.optionsTable = this.createOptionsTable(this.generation, optionContainer);
        this.generationListener.setOptionsViewer((Viewer)this.optionsTable);
        this.createOptionsButonComposite(this.generation, optionContainer, (Viewer)this.optionsTable);
        this.initializeGenerationVariableDefinition(this.generation);
    }

    private TableViewer createVariablesTable(Generation gen, Composite composite, AdapterFactory factory, ITemplateCustomPropertiesProvider provider) {
        composite.setLayout((Layout)new GridLayout(2, false));
        TableViewer res = new TableViewer(composite, 2);
        Table table = res.getTable();
        table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        res.getTable().setHeaderVisible(true);
        TableViewerColumn nameColumn = new TableViewerColumn(res, composite.getStyle());
        nameColumn.getColumn().setText("Variable name");
        nameColumn.getColumn().setWidth(300);
        TableViewerColumn valueColumn = new TableViewerColumn(res, composite.getStyle());
        valueColumn.getColumn().setText("Variable value");
        valueColumn.getColumn().setWidth(300);
        res.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return ((Generation)inputElement).getDefinitions().toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        nameColumn.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                Definition definition = (Definition)cell.getElement();
                cell.setText(definition.getKey());
            }
        });
        valueColumn.setLabelProvider((CellLabelProvider)new VariableValueCellLabelProvider(factory));
        res.setInput((Object)gen);
        return res;
    }

    private void createVariablesButonComposite(final Generation gen, Composite composite, Viewer variablesViewer) {
        Composite container = new Composite(composite, composite.getStyle());
        container.setLayoutData((Object)new GridData(131072, 128, false, true, 1, 1));
        container.setLayout((Layout)new GridLayout(1, false));
        Button loadResourceButton = new Button(container, composite.getStyle());
        loadResourceButton.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        loadResourceButton.setText("Load resource");
        loadResourceButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                LoadResourceAction.LoadResourceDialog dialog = new LoadResourceAction.LoadResourceDialog(VariableAndOptionPage.this.getShell(), (EditingDomain)VariableAndOptionPage.this.getEditingDomain(gen));
                dialog.open();
                VariableAndOptionPage.this.initializeGenerationVariableDefinition(gen);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        final Button editButton = new Button(container, composite.getStyle());
        editButton.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        editButton.setText("Edit");
        editButton.setEnabled(((IStructuredSelection)variablesViewer.getSelection()).getFirstElement() != null);
        variablesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                editButton.setEnabled(((IStructuredSelection)event.getSelection()).getFirstElement() instanceof Definition);
            }
        });
        editButton.addSelectionListener((SelectionListener)new EditDefinitionSelectionListener(variablesViewer, gen));
    }

    private TableViewer createOptionsTable(final Generation gen, Composite composite) {
        TableViewer res = new TableViewer(composite, 2050){

            public void refresh() {
                VariableAndOptionPage.this.updateEditingDomain(gen);
                VariableAndOptionPage.this.initializeGenerationVariableDefinition(gen);
                super.refresh();
            }
        };
        Table table = res.getTable();
        table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        res.getTable().setHeaderVisible(true);
        TableViewerColumn nameColumn = new TableViewerColumn(res, composite.getStyle());
        nameColumn.getColumn().setText("Option name");
        nameColumn.getColumn().setWidth(300);
        TableViewerColumn valueColumn = new TableViewerColumn(res, composite.getStyle());
        valueColumn.getColumn().setText("Option value");
        valueColumn.getColumn().setWidth(300);
        res.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return ((Generation)inputElement).getOptions().toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        nameColumn.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                Option option = (Option)cell.getElement();
                cell.setText(option.getName());
            }
        });
        valueColumn.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                Option option = (Option)cell.getElement();
                cell.setText(option.getValue());
            }
        });
        res.setInput((Object)gen);
        return res;
    }

    private void createOptionsButonComposite(final Generation gen, Composite composite, final Viewer optionsViewer) {
        Composite container = new Composite(composite, composite.getStyle());
        container.setLayoutData((Object)new GridData(131072, 128, false, true, 1, 1));
        container.setLayout((Layout)new GridLayout(1, false));
        final TransactionalEditingDomain genEditingDomain = TransactionUtil.getEditingDomain((EObject)gen);
        final Button addButton = new Button(container, composite.getStyle());
        addButton.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        addButton.setText("Add");
        addButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Option option = GenconfPackage.eINSTANCE.getGenconfFactory().createOption();
                List availableOptionNames = GenconfUtils.getAvailableOptionNames((Generation)gen);
                if (!availableOptionNames.isEmpty()) {
                    option.setName((String)availableOptionNames.get(0));
                    genEditingDomain.getCommandStack().execute(AddCommand.create((EditingDomain)genEditingDomain, (Object)gen, (Object)5, (Object)option));
                    VariableAndOptionPage.this.editOption(genEditingDomain, gen, option);
                    addButton.setEnabled(availableOptionNames.size() > 1);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        final Button editButton = new Button(container, composite.getStyle());
        editButton.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        editButton.setText("Edit");
        editButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Option option = (Option)((IStructuredSelection)optionsViewer.getSelection()).getFirstElement();
                VariableAndOptionPage.this.editOption(genEditingDomain, gen, option);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        editButton.setEnabled(!optionsViewer.getSelection().isEmpty());
        optionsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                editButton.setEnabled(!event.getSelection().isEmpty());
            }
        });
        final Button removeButton = new Button(container, composite.getStyle());
        removeButton.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        removeButton.setText("Remove");
        removeButton.setEnabled(!optionsViewer.getSelection().isEmpty());
        removeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                List selected = ((IStructuredSelection)optionsViewer.getSelection()).toList();
                genEditingDomain.getCommandStack().execute(RemoveCommand.create((EditingDomain)genEditingDomain, (Object)gen, (Object)5, (Collection)selected));
                addButton.setEnabled(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        optionsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                removeButton.setEnabled(!event.getSelection().isEmpty());
            }
        });
    }

    private void editOption(TransactionalEditingDomain genEditingDomain, Generation gen, final Option option) {
        final M2DocOptionDialog dialog = new M2DocOptionDialog(this.getShell(), gen, option);
        int dialogResult = dialog.open();
        if (dialogResult == 0) {
            genEditingDomain.getCommandStack().execute((Command)new RecordingCommand(genEditingDomain){

                protected void doExecute() {
                    option.setName(dialog.getOptionName());
                    option.setValue(dialog.getOptionValue());
                }
            });
        }
    }

    public TableViewer getVariablesTable() {
        return this.variablesTable;
    }

    public TableViewer getOptionsTable() {
        return this.optionsTable;
    }

    public void dispose() {
        super.dispose();
        if (this.editingDomain != null) {
            M2DocUtils.cleanResourceSetForModels((Object)this.queryEnvironment, (ResourceSet)this.editingDomain.getResourceSet());
        }
        if (this.createdEditingDomaine) {
            this.editingDomain.dispose();
            this.editingDomain = null;
        }
        this.adapterFactory.dispose();
    }

    private void updateEditingDomain(Generation gen) {
        ResourceSet modelResourceSet;
        TransactionalEditingDomain modelEditingDomain;
        ResourceSetImpl defaultResourceSet = new ResourceSetImpl();
        defaultResourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        defaultResourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().putAll(Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap());
        if (this.editingDomain != null) {
            M2DocUtils.cleanResourceSetForModels((Object)this.queryEnvironment, (ResourceSet)this.editingDomain.getResourceSet());
        }
        if (this.createdEditingDomaine) {
            this.editingDomain.dispose();
            this.editingDomain = null;
        }
        if ((modelEditingDomain = TransactionUtil.getEditingDomain((ResourceSet)(modelResourceSet = M2DocUtils.createResourceSetForModels(new ArrayList(), (Object)this.queryEnvironment, (ResourceSet)defaultResourceSet, (Map)GenconfUtils.getOptions((Generation)gen))))) == null) {
            this.editingDomain = TransactionalEditingDomain.Factory.INSTANCE.createEditingDomain(modelResourceSet);
            this.createdEditingDomaine = true;
        } else {
            this.editingDomain = modelEditingDomain;
            this.createdEditingDomaine = false;
        }
    }

    private void initializeGenerationVariableDefinition(final Generation gen) {
        final TemplateCustomProperties properties = this.templateCustomPropertiesProvider.getTemplateCustomProperties();
        ((IQueryEnvironment)this.queryEnvironment).registerEPackage((EPackage)EcorePackage.eINSTANCE);
        ((IQueryEnvironment)this.queryEnvironment).registerCustomClassMapping((EClassifier)EcorePackage.eINSTANCE.getEStringToStringMapEntry(), EStringToStringMapEntryImpl.class);
        if (properties != null) {
            properties.configureQueryEnvironmentWithResult((IQueryEnvironment)this.queryEnvironment);
        }
        TransactionalEditingDomain generationDomain = TransactionUtil.getEditingDomain((EObject)gen);
        generationDomain.getCommandStack().execute((Command)new RecordingCommand(generationDomain){

            protected void doExecute() {
                GenconfUtils.initializeVariableDefinition((Generation)gen, (IReadOnlyQueryEnvironment)VariableAndOptionPage.this.queryEnvironment, (TemplateCustomProperties)properties, (ResourceSet)VariableAndOptionPage.this.getEditingDomain(gen).getResourceSet());
            }
        });
    }

    private TransactionalEditingDomain getEditingDomain(Generation gen) {
        if (this.editingDomain == null) {
            this.updateEditingDomain(gen);
        }
        return this.editingDomain;
    }

    private final class EditDefinitionSelectionListener
    implements SelectionListener {
        private final Viewer variablesViewer;
        private final Generation gen;

        private EditDefinitionSelectionListener(Viewer variablesViewer, Generation gen) {
            this.variablesViewer = variablesViewer;
            this.gen = gen;
        }

        public void widgetSelected(SelectionEvent e) {
            Definition def = (Definition)((IStructuredSelection)this.variablesViewer.getSelection()).getFirstElement();
            DefinitionValueDialog dialog = new DefinitionValueDialog(VariableAndOptionPage.this.getShell(), (AdapterFactory)VariableAndOptionPage.this.adapterFactory, def, VariableAndOptionPage.this.queryEnvironment, VariableAndOptionPage.this.templateCustomPropertiesProvider.getTemplateCustomProperties(), VariableAndOptionPage.this.getEditingDomain(this.gen).getResourceSet());
            int dialogResult = dialog.open();
            if (dialogResult == 0) {
                TransactionalEditingDomain generationDomain = TransactionUtil.getEditingDomain((EObject)this.gen);
                generationDomain.getCommandStack().execute((Command)new SetValueCommand(generationDomain, def, dialog));
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    private static final class SetValueCommand
    extends RecordingCommand {
        private final Definition definition;
        private final DefinitionValueDialog dialog;

        private SetValueCommand(TransactionalEditingDomain domain, Definition definition, DefinitionValueDialog dialog) {
            super(domain);
            this.definition = definition;
            this.dialog = dialog;
        }

        protected void doExecute() {
            if (this.definition instanceof BooleanDefinition) {
                ((BooleanDefinition)this.definition).setValue(((Boolean)this.dialog.getValue()).booleanValue());
            } else if (this.definition instanceof BooleanSequenceDefinition) {
                ((BooleanSequenceDefinition)this.definition).getValue().clear();
                ((BooleanSequenceDefinition)this.definition).getValue().addAll((Collection)this.dialog.getValue());
            } else if (this.definition instanceof BooleanOrderedSetDefinition) {
                ((BooleanOrderedSetDefinition)this.definition).getValue().clear();
                ((BooleanOrderedSetDefinition)this.definition).getValue().addAll((Collection)this.dialog.getValue());
            } else if (this.definition instanceof IntegerDefinition) {
                ((IntegerDefinition)this.definition).setValue(((Integer)this.dialog.getValue()).intValue());
            } else if (this.definition instanceof IntegerSequenceDefinition) {
                ((IntegerSequenceDefinition)this.definition).getValue().clear();
                ((IntegerSequenceDefinition)this.definition).getValue().addAll((Collection)this.dialog.getValue());
            } else if (this.definition instanceof IntegerOrderedSetDefinition) {
                ((IntegerOrderedSetDefinition)this.definition).getValue().clear();
                ((IntegerOrderedSetDefinition)this.definition).getValue().addAll((Collection)this.dialog.getValue());
            } else if (this.definition instanceof ModelDefinition) {
                ((ModelDefinition)this.definition).setValue((EObject)this.dialog.getValue());
            } else if (this.definition instanceof ModelSequenceDefinition) {
                ((ModelSequenceDefinition)this.definition).getValue().clear();
                ((ModelSequenceDefinition)this.definition).getValue().addAll((Collection)this.dialog.getValue());
            } else if (this.definition instanceof ModelOrderedSetDefinition) {
                ((ModelOrderedSetDefinition)this.definition).getValue().clear();
                ((ModelOrderedSetDefinition)this.definition).getValue().addAll((Collection)this.dialog.getValue());
            } else if (this.definition instanceof RealDefinition) {
                ((RealDefinition)this.definition).setValue(((Double)this.dialog.getValue()).doubleValue());
            } else if (this.definition instanceof RealSequenceDefinition) {
                ((RealSequenceDefinition)this.definition).getValue().clear();
                ((RealSequenceDefinition)this.definition).getValue().addAll((Collection)this.dialog.getValue());
            } else if (this.definition instanceof RealOrderedSetDefinition) {
                ((RealOrderedSetDefinition)this.definition).getValue().clear();
                ((RealOrderedSetDefinition)this.definition).getValue().addAll((Collection)this.dialog.getValue());
            } else if (this.definition instanceof StringDefinition) {
                ((StringDefinition)this.definition).setValue((String)this.dialog.getValue());
            } else if (this.definition instanceof StringSequenceDefinition) {
                ((StringSequenceDefinition)this.definition).getValue().clear();
                ((StringSequenceDefinition)this.definition).getValue().addAll((Collection)this.dialog.getValue());
            } else if (this.definition instanceof StringOrderedSetDefinition) {
                ((StringOrderedSetDefinition)this.definition).getValue().clear();
                ((StringOrderedSetDefinition)this.definition).getValue().addAll((Collection)this.dialog.getValue());
            } else {
                throw new IllegalStateException("don't know what to do with " + this.definition);
            }
        }
    }
}

