/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.ide.ui.dialog;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.validation.type.EClassifierType;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.action.LoadResourceAction;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.TransactionalEditingDomainImpl;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.obeonetwork.m2doc.ide.ui.dialog.EObjectViewerFilter;

public class EObjectSelectionDialog
extends MessageDialog {
    private static final int TABLE_MINIMUM_HEIGHT = 400;
    private static final int TABLE_MINIMUM_WIDTH = 200;
    protected Object value;
    private AdapterFactory adapterFactory;
    private final ResourceSet resourceSet;
    private IReadOnlyQueryEnvironment queryEnvironment;
    private Set<EClass> acceptedEClasses;
    private boolean multiSelection;

    public EObjectSelectionDialog(Shell parentShell, AdapterFactory adapterFactory, String title, String message, IReadOnlyQueryEnvironment queryEnvironment, ResourceSet resourceSet, Set<EClass> acceptedEClasses) {
        super(parentShell, title, null, message, 3, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        this.resourceSet = resourceSet;
        this.adapterFactory = adapterFactory;
        this.queryEnvironment = queryEnvironment;
        this.acceptedEClasses = acceptedEClasses;
    }

    public void setMultiSelection(boolean multiSelection) {
        this.multiSelection = multiSelection;
    }

    protected Control createCustomArea(Composite parent) {
        Composite container = new Composite(parent, parent.getStyle());
        container.setLayout((Layout)new GridLayout(1, false));
        container.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        HashSet<IType> acceptedTypes = new HashSet<IType>();
        for (EClass eCls : this.acceptedEClasses) {
            acceptedTypes.add((IType)new EClassifierType(this.queryEnvironment, (EClassifier)eCls));
        }
        this.createModelCustomArea(acceptedTypes, container);
        return container;
    }

    protected void createModelCustomArea(final Set<IType> acceptedTypes, Composite container) {
        int style = this.multiSelection ? 2852 : 2820;
        FilteredTree filteredTree = new FilteredTree(container, style, new PatternFilter(), true);
        final TreeViewer treeViewer = filteredTree.getViewer();
        if (this.multiSelection) {
            treeViewer.getTree().addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent event) {
                    EObjectSelectionDialog.this.handleEvent(acceptedTypes, event);
                }

                public void widgetDefaultSelected(SelectionEvent event) {
                }
            });
        } else {
            treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    boolean enableOKButton;
                    Object selected = ((IStructuredSelection)event.getSelection()).getFirstElement();
                    if (selected instanceof EObject) {
                        EObject eObj = (EObject)selected;
                        if (EObjectSelectionDialog.this.isValidValue(acceptedTypes, eObj)) {
                            EObjectSelectionDialog.this.value = eObj;
                            enableOKButton = true;
                        } else {
                            enableOKButton = false;
                        }
                    } else {
                        enableOKButton = false;
                    }
                    Button okButton = EObjectSelectionDialog.this.getButton(0);
                    if (okButton != null) {
                        okButton.setEnabled(enableOKButton);
                    }
                }
            });
        }
        treeViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider(this.adapterFactory));
        treeViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider(this.adapterFactory));
        GridData gdTable = new GridData(4, 4, true, true, 1, 1);
        gdTable.minimumWidth = 200;
        gdTable.minimumHeight = 400;
        treeViewer.getTree().setLayoutData((Object)gdTable);
        LinkedHashSet<EStructuralFeature> containingFeatures = new LinkedHashSet<EStructuralFeature>();
        LinkedHashSet<EClass> eClasses = new LinkedHashSet<EClass>();
        for (IType type : acceptedTypes) {
            if (!(type.getType() instanceof EClass)) continue;
            EClass eCls = (EClass)type.getType();
            eClasses.add(eCls);
            Set features = this.queryEnvironment.getEPackageProvider().getAllContainingEStructuralFeatures(eCls);
            containingFeatures.addAll(features);
        }
        final EObjectViewerFilter filter = new EObjectViewerFilter(containingFeatures, eClasses);
        treeViewer.addFilter((ViewerFilter)filter);
        treeViewer.setInput((Object)this.resourceSet);
        Button okButton = this.getButton(0);
        if (okButton != null) {
            okButton.setEnabled(this.multiSelection);
        }
        Composite filterCheckboxComposite = new Composite(container, container.getStyle());
        filterCheckboxComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        filterCheckboxComposite.setLayout((Layout)new GridLayout(3, false));
        Button filterCheckBox = new Button(filterCheckboxComposite, 32);
        filterCheckBox.setSelection(true);
        filterCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button bouton = (Button)e.getSource();
                if (bouton.getSelection()) {
                    treeViewer.addFilter(filter);
                    if (treeViewer.getTree().getItemCount() == 0) {
                        EObjectSelectionDialog.this.messageLabel.setText(String.valueOf(EObjectSelectionDialog.this.message) + " (the tree is empty, you can either load a resource from the previous dialog or deselect the type filter)");
                    }
                } else {
                    treeViewer.removeFilter(filter);
                    if (treeViewer.getTree().getItemCount() == 0) {
                        EObjectSelectionDialog.this.messageLabel.setText(String.valueOf(EObjectSelectionDialog.this.message) + " (the tree is empty, you can load a resource from the previous dialog)");
                    }
                }
            }
        });
        if (treeViewer.getTree().getItemCount() == 0) {
            this.messageLabel.setText(String.valueOf(this.message) + " (the tree is empty, you can either load a resource from the previous dialog or deselect the type filter)");
        }
        Label filterLabel = new Label(filterCheckboxComposite, container.getStyle());
        filterLabel.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        filterLabel.setText("Filter elements by type");
        this.createLoadResourceButton(filterCheckboxComposite);
    }

    private void handleEvent(Set<IType> acceptedTypes, SelectionEvent event) {
        if (event.detail == 32) {
            TreeItem item = (TreeItem)event.item;
            EObject eObj = (EObject)item.getData();
            if (item.getChecked()) {
                if (this.isValidValue(acceptedTypes, eObj)) {
                    ((Collection)this.value).add(eObj);
                } else {
                    item.setChecked(false);
                }
            } else {
                ((Collection)this.value).remove(eObj);
            }
        }
    }

    protected void createLoadResourceButton(Composite parent) {
        Button loadResourceButton = new Button(parent, parent.getStyle());
        loadResourceButton.setLayoutData((Object)new GridData(131072, 128, true, false, 1, 1));
        loadResourceButton.setText("Load resource");
        loadResourceButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((ResourceSet)EObjectSelectionDialog.this.resourceSet);
                if (editingDomain == null) {
                    editingDomain = new TransactionalEditingDomainImpl(EObjectSelectionDialog.this.adapterFactory, EObjectSelectionDialog.this.resourceSet);
                }
                LoadResourceAction.LoadResourceDialog dialog = new LoadResourceAction.LoadResourceDialog(EObjectSelectionDialog.this.getShell(), (EditingDomain)editingDomain);
                dialog.open();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private boolean isValidValue(Set<IType> acceptedTypes, EObject eObj) {
        boolean res = false;
        EClassifierType eObjType = new EClassifierType(this.queryEnvironment, (EClassifier)eObj.eClass());
        for (IType definitionType : acceptedTypes) {
            if (!definitionType.isAssignableFrom((IType)eObjType)) continue;
            res = true;
        }
        return res;
    }

    public Object getValue() {
        return this.value;
    }
}

