/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.ide.ui.dialog;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class M2DocFileSelectionDialog
extends MessageDialog {
    private static final int TABLE_MINIMUM_HEIGHT = 400;
    private static final int TABLE_MINIMUM_WIDTH = 200;
    private Text fileText;
    private final String defaultFileName;
    private final String fileExtension;
    private String fileName;
    private boolean onlyFileSelection;

    public M2DocFileSelectionDialog(Shell parentShell, String title, String defaultFileName, String fileExtension, boolean onlyFileSelection) {
        super(parentShell, title, null, "Select a file.", 3, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        this.defaultFileName = defaultFileName;
        this.fileExtension = fileExtension;
        this.onlyFileSelection = onlyFileSelection;
    }

    protected Control createCustomArea(Composite parent) {
        Composite container = new Composite(parent, parent.getStyle());
        container.setLayout((Layout)new GridLayout(1, false));
        container.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.fileText = this.createFilePathComposite(container, this.defaultFileName);
        TreeViewer containerTreeViewer = new TreeViewer(container, 2048);
        Tree tree = containerTreeViewer.getTree();
        GridData gdTable = new GridData(4, 4, true, true, 1, 1);
        gdTable.minimumWidth = 200;
        gdTable.minimumHeight = 400;
        tree.setLayoutData((Object)gdTable);
        containerTreeViewer.setContentProvider((IContentProvider)new WorkbenchContentProvider(){

            public Object[] getChildren(Object element) {
                ArrayList<Object> res = new ArrayList<Object>();
                Object[] objectArray = super.getChildren(element);
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    if (obj instanceof IContainer || obj instanceof IFile && M2DocFileSelectionDialog.this.fileExtension.equals(((IFile)obj).getFileExtension())) {
                        res.add(obj);
                    }
                    ++n2;
                }
                return res.toArray();
            }
        });
        containerTreeViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        containerTreeViewer.addSelectionChangedListener((ISelectionChangedListener)new ContainerSelectionChangedListener());
        containerTreeViewer.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        if (this.defaultFileName != null && !this.defaultFileName.isEmpty()) {
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(this.defaultFileName));
            containerTreeViewer.setSelection((ISelection)new StructuredSelection((Object)file));
        }
        return container;
    }

    protected Text createFilePathComposite(Composite container, String defaultName) {
        Composite fileComposite = new Composite(container, container.getStyle());
        fileComposite.setLayout((Layout)new GridLayout(2, false));
        fileComposite.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        Label templateURILabel = new Label(fileComposite, container.getStyle());
        templateURILabel.setText("File: ");
        final Text res = new Text(fileComposite, container.getStyle());
        res.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        new Label(fileComposite, container.getStyle());
        new Label(fileComposite, container.getStyle());
        if (defaultName != null) {
            res.setText(defaultName);
            this.fileName = defaultName;
        }
        res.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                M2DocFileSelectionDialog.this.fileName = res.getText();
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        return res;
    }

    public String getFileName() {
        return this.fileName;
    }

    private final class ContainerSelectionChangedListener
    implements ISelectionChangedListener {
        private ContainerSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            boolean enableOkButton;
            Object selected = ((IStructuredSelection)event.getSelection()).getFirstElement();
            Button okButton = M2DocFileSelectionDialog.this.getButton(0);
            if (selected instanceof IFile) {
                IFile file = (IFile)selected;
                M2DocFileSelectionDialog.this.fileText.setText(file.getFullPath().toString());
                M2DocFileSelectionDialog.this.fileName = file.getFullPath().toString();
                enableOkButton = true;
            } else if (!M2DocFileSelectionDialog.this.onlyFileSelection && selected instanceof IContainer) {
                IContainer container = (IContainer)selected;
                int lastSlashIndex = M2DocFileSelectionDialog.this.fileName.lastIndexOf("/");
                String newFileName = lastSlashIndex >= 0 ? String.valueOf(container.getFullPath().toString()) + M2DocFileSelectionDialog.this.fileName.substring(lastSlashIndex) : String.valueOf(container.getFullPath().toString()) + "/" + M2DocFileSelectionDialog.this.fileName;
                M2DocFileSelectionDialog.this.fileText.setText(newFileName);
                M2DocFileSelectionDialog.this.fileName = newFileName;
                enableOkButton = true;
            } else {
                enableOkButton = false;
            }
            if (okButton != null && !okButton.isDisposed()) {
                okButton.setEnabled(enableOkButton);
            }
        }
    }
}

