/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.ide.ui.dialog;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.obeonetwork.m2doc.ide.M2DocPlugin;
import org.obeonetwork.m2doc.ide.ui.wizard.SelectRegisteredTemplatePage;
import org.obeonetwork.m2doc.services.TemplateRegistry;

public class SelectRegistredTemplateDialog
extends MessageDialog {
    private static final int TABLE_MINIMUM_HEIGHT = 400;
    private static final int TABLE_MINIMUM_WIDTH = 200;
    private URI templateURI;

    public SelectRegistredTemplateDialog(Shell parentShell) {
        super(parentShell, "Select registered template.", null, "Select a template in the following registered templates.", 3, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        M2DocPlugin.getDefault();
    }

    protected Control createCustomArea(Composite parent) {
        Composite container = new Composite(parent, parent.getStyle());
        container.setLayout((Layout)new GridLayout(1, false));
        container.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        TableViewer templatesTreeViewer = new TableViewer(container, 2816);
        Table table = templatesTreeViewer.getTable();
        GridData gdTable = new GridData(4, 4, true, true, 1, 1);
        gdTable.minimumWidth = 200;
        gdTable.minimumHeight = 400;
        table.setLayoutData((Object)gdTable);
        templatesTreeViewer.setContentProvider((IContentProvider)new SelectRegisteredTemplatePage.CollectionContentProvider());
        templatesTreeViewer.setLabelProvider((IBaseLabelProvider)new ColumnLabelProvider());
        ArrayList registeredTemplates = new ArrayList(TemplateRegistry.INSTANCE.getTemplates().keySet());
        Collections.sort(registeredTemplates);
        templatesTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SelectRegistredTemplateDialog.this.templateURI = (URI)TemplateRegistry.INSTANCE.getTemplates().get(((IStructuredSelection)event.getSelection()).getFirstElement());
            }
        });
        templatesTreeViewer.setInput(registeredTemplates);
        return container;
    }

    protected boolean isResizable() {
        return true;
    }

    public URI getTemplateURI() {
        return this.templateURI;
    }
}

