/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.ide.ui.wizard;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.obeonetwork.m2doc.ide.M2DocPlugin;
import org.obeonetwork.m2doc.ide.ui.M2DocUIPlugin;
import org.obeonetwork.m2doc.ide.ui.wizard.SelectRegisteredTemplatePage;

public class ImportTemplateWizard
extends Wizard
implements IImportWizard {
    private SelectRegisteredTemplatePage importPage;
    private WizardNewFileCreationPage creationPage;
    private IStructuredSelection structuredSelection;

    public ImportTemplateWizard() {
        M2DocPlugin.getDefault();
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle("Template import");
        this.structuredSelection = selection;
    }

    public void addPages() {
        super.addPages();
        this.creationPage = new WizardNewFileCreationPage("Select destination Template file", this.structuredSelection);
        this.creationPage.setAllowExistingResources(true);
        this.creationPage.setFileExtension("docx");
        this.importPage = new SelectRegisteredTemplatePage(){

            @Override
            protected void setSelectedTemplateURI(URI selectedTemplateURI) {
                super.setSelectedTemplateURI(selectedTemplateURI);
                ImportTemplateWizard.this.creationPage.setFileName(selectedTemplateURI.lastSegment());
            }
        };
        this.addPage((IWizardPage)this.importPage);
        this.addPage((IWizardPage)this.creationPage);
    }

    public boolean performFinish() {
        ImportTemplateJob job = new ImportTemplateJob(this.creationPage.getContainerFullPath(), this.creationPage.getFileName());
        job.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        job.schedule();
        return true;
    }

    private final class ImportTemplateJob
    extends WorkspaceJob {
        private IPath containerFullPath;
        private String fileName;

        private ImportTemplateJob(IPath containerFullPath, String fileName) {
            super("Importing template " + URI.decode((String)ImportTemplateWizard.this.importPage.getSelectedTemplateURI().toString()));
            this.containerFullPath = containerFullPath;
            this.fileName = fileName;
        }

        public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
            Status status = new Status(0, "org.obeonetwork.m2doc.ide.ui", "Template imported succesfully");
            Object container = this.containerFullPath.segmentCount() == 1 ? ResourcesPlugin.getWorkspace().getRoot().getProject(this.containerFullPath.lastSegment()) : ResourcesPlugin.getWorkspace().getRoot().getFolder(this.containerFullPath);
            URI templateURI = ImportTemplateWizard.this.importPage.getSelectedTemplateURI();
            if (templateURI != null) {
                try {
                    Throwable throwable = null;
                    Object var6_9 = null;
                    try (InputStream is = URIConverter.INSTANCE.createInputStream(templateURI);){
                        IFile file = container.getFile((IPath)new Path(this.fileName));
                        if (!file.exists()) {
                            file.create(is, true, (IProgressMonitor)new NullProgressMonitor());
                        } else if (this.openConfirmationDialog(file)) {
                            file.setContents(is, true, true, (IProgressMonitor)new NullProgressMonitor());
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    status = new Status(4, "org.obeonetwork.m2doc.ide.ui", "can't open input stream", (Throwable)e);
                    M2DocUIPlugin.getDefault().getLog().log((IStatus)status);
                }
                catch (CoreException e) {
                    status = new Status(4, "org.obeonetwork.m2doc.ide.ui", "can't save file", (Throwable)e);
                    M2DocUIPlugin.getDefault().getLog().log((IStatus)status);
                }
            } else {
                status = new Status(4, "org.obeonetwork.m2doc.ide.ui", "Null template URI. Check your extension point.");
            }
            return status;
        }

        private boolean openConfirmationDialog(IFile file) {
            OpenMessageBoxRunnable openDialogRunnable = new OpenMessageBoxRunnable(file.getName());
            Display.getDefault().syncExec((Runnable)openDialogRunnable);
            int res = openDialogRunnable.getResult();
            return res == 32 || res == 64;
        }
    }

    private final class OpenMessageBoxRunnable
    implements Runnable {
        private final String fileName;
        private int result;

        private OpenMessageBoxRunnable(String fileName) {
            this.fileName = fileName;
        }

        @Override
        public void run() {
            MessageBox dialog = new MessageBox(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 292);
            dialog.setText(String.valueOf(this.fileName) + " already exists");
            dialog.setMessage("Do you want to overrite it?");
            this.result = dialog.open();
        }

        public int getResult() {
            return this.result;
        }
    }
}

