/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.ide.ui.wizard;

import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.obeonetwork.m2doc.POIServices;
import org.obeonetwork.m2doc.ide.ui.wizard.M2DocMainVariablePage;
import org.obeonetwork.m2doc.ide.ui.wizard.M2DocNewTemplatePage;
import org.obeonetwork.m2doc.util.M2DocUtils;
import org.obeonetwork.m2doc.util.MemoryURIHandler;

public class M2DocNewTemplateWizard
extends Wizard
implements INewWizard {
    private static final String OK_MESSAGE = "M2Doc template %s created.";
    private static final String ERROR_MESSAGE = "M2Doc template %s can't be created.";
    private M2DocNewTemplatePage newTemplatePage;
    private M2DocMainVariablePage variablePage;
    private String defaultTempateName;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        if (selection.getFirstElement() instanceof IFile) {
            this.defaultTempateName = ((IFile)selection.getFirstElement()).getParent().getFullPath() + "/template.docx";
        } else if (selection.getFirstElement() instanceof IContainer) {
            this.defaultTempateName = ((IContainer)selection.getFirstElement()).getFullPath() + "/template.docx";
        }
    }

    public void addPages() {
        this.newTemplatePage = new M2DocNewTemplatePage(this.defaultTempateName);
        this.addPage((IWizardPage)this.newTemplatePage);
        this.variablePage = new M2DocMainVariablePage();
        this.addPage((IWizardPage)this.variablePage);
    }

    public boolean performFinish() {
        String templateName = this.newTemplatePage.getTemplateName();
        String variableName = this.variablePage.getVariableName();
        EObject variableValue = this.variablePage.getVariableValue();
        FinishJob job = new FinishJob(templateName, variableValue, variableName);
        job.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        job.schedule();
        return true;
    }

    public class FinishJob
    extends Job {
        private String templateName;
        private EObject variableValue;
        private String variableName;

        public FinishJob(String templateName, EObject variableValue, String variableName) {
            super("Creating M2Doc template: " + templateName);
            this.templateName = templateName;
            this.variableValue = variableValue;
            this.variableName = variableName;
        }

        protected IStatus run(IProgressMonitor monitor) {
            Status res = new Status(0, "org.obeonetwork.m2doc.ide.ui", String.format(M2DocNewTemplateWizard.OK_MESSAGE, this.templateName));
            ExtensibleURIConverterImpl uriConverter = new ExtensibleURIConverterImpl();
            MemoryURIHandler handler = new MemoryURIHandler();
            uriConverter.getURIHandlers().add(0, (Object)handler);
            try {
                Throwable throwable = null;
                Object var6_9 = null;
                try (XWPFDocument sampleTemplate = M2DocUtils.createSampleTemplate((String)this.variableName, (EClass)this.variableValue.eClass());){
                    URI memoryURI = URI.createURI((String)"m2docmemory://resources/temp.docx");
                    POIServices.getInstance().saveFile((URIConverter)uriConverter, sampleTemplate, memoryURI);
                    try {
                        Throwable throwable2 = null;
                        Object var10_16 = null;
                        try (InputStream source = uriConverter.createInputStream(memoryURI);){
                            IFile templateFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(this.templateName));
                            templateFile.create(source, true, monitor);
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                            } else if (throwable2 != throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            throw throwable2;
                        }
                    }
                    catch (CoreException e) {
                        res = new Status(0, "org.obeonetwork.m2doc.ide.ui", String.format(M2DocNewTemplateWizard.ERROR_MESSAGE, this.templateName), (Throwable)e);
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (InvalidFormatException e) {
                res = new Status(0, "org.obeonetwork.m2doc.ide.ui", String.format(M2DocNewTemplateWizard.ERROR_MESSAGE, this.templateName), (Throwable)e);
            }
            catch (IOException e) {
                res = new Status(0, "org.obeonetwork.m2doc.ide.ui", String.format(M2DocNewTemplateWizard.ERROR_MESSAGE, this.templateName), (Throwable)e);
            }
            return res;
        }
    }
}

