/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.ide.ui.wizard;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.obeonetwork.m2doc.services.TemplateRegistry;

public class SelectRegisteredTemplatePage
extends WizardPage {
    private URI selectedTemplateURI;

    protected SelectRegisteredTemplatePage() {
        super("Select a registered template");
        this.setTitle("Select templates to import in the workspace.");
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, parent.getStyle());
        this.setControl((Control)container);
        container.setLayout((Layout)new FillLayout(768));
        TreeViewer templatesTreeViewer = new TreeViewer(container, 2048);
        templatesTreeViewer.setContentProvider((IContentProvider)new CollectionContentProvider());
        templatesTreeViewer.setLabelProvider((IBaseLabelProvider)new ColumnLabelProvider());
        ArrayList registeredTemplates = new ArrayList(TemplateRegistry.INSTANCE.getTemplates().keySet());
        Collections.sort(registeredTemplates);
        templatesTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SelectRegisteredTemplatePage.this.setSelectedTemplateURI((URI)TemplateRegistry.INSTANCE.getTemplates().get(((IStructuredSelection)event.getSelection()).getFirstElement()));
                SelectRegisteredTemplatePage.this.setPageComplete(SelectRegisteredTemplatePage.this.selectedTemplateURI != null);
            }
        });
        templatesTreeViewer.setInput(registeredTemplates);
        this.setPageComplete(this.selectedTemplateURI != null);
    }

    public URI getSelectedTemplateURI() {
        return this.selectedTemplateURI;
    }

    protected void setSelectedTemplateURI(URI selectedTemplateURI) {
        this.selectedTemplateURI = selectedTemplateURI;
    }

    public static class CollectionContentProvider
    extends ArrayContentProvider
    implements ITreeContentProvider {
        public Object[] getChildren(Object parentElement) {
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }
    }

    public static interface TemplateURISettable {
        public void setTemplateURI(URI var1);
    }
}

