/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.ide.ui.wizard;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.obeonetwork.m2doc.ide.ui.dialog.SelectRegistredTemplateDialog;
import org.obeonetwork.m2doc.ide.ui.wizard.SelectRegisteredTemplatePage;

public class SelectTemplatePage
extends WizardPage {
    private URI templateURI;
    private final WizardNewFileCreationPage page;

    public SelectTemplatePage(WizardNewFileCreationPage page) {
        super("Select output folder");
        this.setTitle("Select the target container.");
        this.page = page;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, parent.getStyle());
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout(1, false));
        final Text templateURIText = this.createTemplateURIComposite(container);
        TreeViewer containerTreeViewer = new TreeViewer(container, 2048);
        Tree tree = containerTreeViewer.getTree();
        tree.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        containerTreeViewer.setContentProvider((IContentProvider)new WorkbenchContentProvider(){

            public Object[] getChildren(Object element) {
                ArrayList<Object> res = new ArrayList<Object>();
                Object[] objectArray = super.getChildren(element);
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    if (obj instanceof IContainer || obj instanceof IFile && "docx".equals(((IFile)obj).getFileExtension())) {
                        res.add(obj);
                    }
                    ++n2;
                }
                return res.toArray();
            }
        });
        containerTreeViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        containerTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object selected = ((IStructuredSelection)event.getSelection()).getFirstElement();
                if (selected instanceof IFile) {
                    IFile file = (IFile)selected;
                    SelectTemplatePage.this.setURI(templateURIText, URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true));
                    SelectTemplatePage.this.setTemplateURI(URI.createURI((String)templateURIText.getText()));
                }
            }
        });
        containerTreeViewer.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        if (this.templateURI != null && this.templateURI.isPlatformResource()) {
            Path filePath = new Path(this.templateURI.toPlatformString(true));
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)filePath);
            containerTreeViewer.setSelection((ISelection)new StructuredSelection((Object)file));
        }
        this.setPageComplete(this.templateURI != null);
    }

    protected Text createTemplateURIComposite(Composite container) {
        Composite templateURIComposite = new Composite(container, container.getStyle());
        templateURIComposite.setLayout((Layout)new GridLayout(2, false));
        templateURIComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label templateURILabel = new Label(templateURIComposite, container.getStyle());
        templateURILabel.setText("Template URI: ");
        final Text templateURIText = new Text(templateURIComposite, container.getStyle());
        templateURIText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        new Label(templateURIComposite, container.getStyle());
        if (this.templateURI != null) {
            this.setURI(templateURIText, this.templateURI);
        }
        templateURIText.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                SelectTemplatePage.this.setTemplateURI(URI.createURI((String)templateURIText.getText(), (boolean)false));
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        Button templateURIButton = new Button(templateURIComposite, container.getStyle());
        templateURIButton.setText("Browse registry");
        templateURIButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.openDialog();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.openDialog();
            }

            private void openDialog() {
                SelectRegistredTemplateDialog dialog = new SelectRegistredTemplateDialog(SelectTemplatePage.this.getShell());
                int dialogResult = dialog.open();
                if (dialogResult == 0 && dialog.getTemplateURI() != null) {
                    SelectTemplatePage.this.setURI(templateURIText, dialog.getTemplateURI());
                }
            }
        });
        return templateURIText;
    }

    private void setURI(Text text, URI uri) {
        String relativeTemplatePath = URI.decode((String)uri.deresolve(this.getBaseURI(this.page)).toString());
        text.setText(relativeTemplatePath);
    }

    public void setTemplateURI(URI templateURI) {
        this.templateURI = templateURI.deresolve(this.getBaseURI(this.page));
        IWizardPage[] iWizardPageArray = this.getWizard().getPages();
        int n = iWizardPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardPage currentPage = iWizardPageArray[n2];
            if (currentPage instanceof SelectRegisteredTemplatePage.TemplateURISettable) {
                ((SelectRegisteredTemplatePage.TemplateURISettable)this.getNextPage()).setTemplateURI(templateURI);
            }
            ++n2;
        }
        this.setPageComplete(templateURI != null);
    }

    public URI getTemplateURI() {
        return this.templateURI;
    }

    public URI getBaseURI(WizardNewFileCreationPage p) {
        String fileName;
        IPath path = p.getContainerFullPath();
        URI res = path != null ? ((fileName = p.getFileName()) != null && !fileName.isEmpty() ? URI.createPlatformResourceURI((String)(String.valueOf(path.toString()) + "/" + fileName), (boolean)true) : null) : null;
        return res;
    }
}

