/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.ide.ui.wizard;

import java.util.Map;
import java.util.Set;
import org.eclipse.acceleo.query.parser.AstValidator;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.Query;
import org.eclipse.acceleo.query.runtime.impl.ValidationServices;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.acceleo.query.validation.type.NothingType;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.EStringToStringMapEntryImpl;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.obeonetwork.m2doc.ide.ui.dialog.M2DocTypeSelectionDialog;
import org.obeonetwork.m2doc.properties.TemplateCustomProperties;

public class TemplateVariablesPage
extends WizardPage {
    private static final int WIDTH = 300;
    private TemplateCustomProperties properties;
    private WizardPage wizardPage;

    protected TemplateVariablesPage(TemplateCustomProperties properties) {
        super("Template variables");
        this.properties = properties;
    }

    public void setWizardPage(WizardPage wizardPage) {
        this.wizardPage = wizardPage;
    }

    public void createControl(Composite parent) {
        this.setMessage("Select variable types");
        Composite container = new Composite(parent, parent.getStyle());
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout(2, false));
        final TableViewer variablesTable = new TableViewer(container, 2);
        Table table = variablesTable.getTable();
        table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        variablesTable.getTable().setHeaderVisible(true);
        TableViewerColumn nameColumn = new TableViewerColumn(variablesTable, variablesTable.getTable().getStyle());
        nameColumn.getColumn().setText("Variable name");
        nameColumn.getColumn().setWidth(300);
        nameColumn.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                cell.setText((String)((Map.Entry)cell.getElement()).getKey());
            }
        });
        TableViewerColumn typeColumn = new TableViewerColumn(variablesTable, variablesTable.getTable().getStyle());
        typeColumn.getColumn().setText("Variable type");
        typeColumn.getColumn().setWidth(300);
        typeColumn.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                cell.setText((String)((Map.Entry)cell.getElement()).getValue());
            }
        });
        variablesTable.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return ((TemplateCustomProperties)inputElement).getVariables().entrySet().toArray();
            }
        });
        variablesTable.setInput((Object)this.properties);
        Composite nsURIButtonComposite = new Composite(container, container.getStyle());
        nsURIButtonComposite.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        nsURIButtonComposite.setLayout((Layout)new GridLayout(1, false));
        final Button editButton = new Button(nsURIButtonComposite, container.getStyle());
        editButton.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        editButton.setText("Edit");
        editButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String variableName = (String)((Map.Entry)((IStructuredSelection)variablesTable.getSelection()).getFirstElement()).getKey();
                M2DocTypeSelectionDialog dialog = new M2DocTypeSelectionDialog(TemplateVariablesPage.this.getShell(), variableName, (String)TemplateVariablesPage.this.properties.getVariables().get(variableName), TemplateVariablesPage.this.properties.getPackagesURIs());
                int dialogResult = dialog.open();
                if (dialogResult == 0) {
                    TemplateVariablesPage.this.properties.getVariables().put(variableName, dialog.getSelectedType());
                    variablesTable.refresh();
                    TemplateVariablesPage.this.validatePage(TemplateVariablesPage.this.properties);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        variablesTable.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                editButton.setEnabled(!variablesTable.getSelection().isEmpty());
            }
        });
        editButton.setEnabled(false);
        this.createM2DocVersion(container, this.properties);
        this.validatePage(this.properties);
    }

    private Composite createM2DocVersion(Composite container, final TemplateCustomProperties customProperties) {
        Composite res = new Composite(container, container.getStyle());
        res.setLayout((Layout)new GridLayout(3, false));
        res.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        Label versionLabel = new Label(res, res.getStyle());
        versionLabel.setText("M2Doc version: ");
        final Text versionText = new Text(res, res.getStyle() | 4);
        versionText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        versionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                customProperties.setM2DocVersion(versionText.getText());
                TemplateVariablesPage.this.validatePage(customProperties);
            }
        });
        if (customProperties.getM2DocVersion() != null) {
            versionText.setText(customProperties.getM2DocVersion());
        } else {
            versionText.setText("3.3.5");
        }
        Button versionButton = new Button(res, res.getStyle());
        versionButton.setText("Current version");
        versionButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                versionText.setText("3.3.5");
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return res;
    }

    public void validatePage(TemplateCustomProperties customProperties) {
        boolean valide = true;
        IQueryEnvironment queryEnvironment = Query.newEnvironment();
        queryEnvironment.registerEPackage((EPackage)EcorePackage.eINSTANCE);
        queryEnvironment.registerCustomClassMapping((EClassifier)EcorePackage.eINSTANCE.getEStringToStringMapEntry(), EStringToStringMapEntryImpl.class);
        customProperties.configureQueryEnvironmentWithResult(queryEnvironment);
        AstValidator aqlValidator = new AstValidator(new ValidationServices((IReadOnlyQueryEnvironment)queryEnvironment));
        for (Map.Entry entry : customProperties.getVariableTypes(aqlValidator, (IReadOnlyQueryEnvironment)queryEnvironment).entrySet()) {
            boolean isValidDeclaration = false;
            String message = "";
            for (IType declaredType : (Set)entry.getValue()) {
                if (declaredType instanceof NothingType) {
                    message = ((NothingType)declaredType).getMessage();
                    continue;
                }
                isValidDeclaration = true;
                break;
            }
            if (isValidDeclaration) continue;
            this.setErrorMessage(message);
            valide = false;
            break;
        }
        if (valide) {
            this.setErrorMessage(null);
            if (!"3.3.5".equals(customProperties.getM2DocVersion())) {
                String mismatcvhVersionMessage = "M2Doc version mismatch: template version is " + customProperties.getM2DocVersion() + " and current M2Doc version is " + "3.3.5";
                this.setMessage(mismatcvhVersionMessage, 2);
                if (this.wizardPage != null) {
                    this.wizardPage.setMessage(mismatcvhVersionMessage, 2);
                }
            } else {
                this.setMessage("Select variable types");
                if (this.wizardPage != null) {
                    this.wizardPage.setMessage("Select services and packages");
                }
            }
        }
        this.setPageComplete(valide);
    }
}

