/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.tests;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.obeonetwork.m2doc.genconf.GenconfFactory;
import org.obeonetwork.m2doc.genconf.GenconfPackage;
import org.obeonetwork.m2doc.genconf.GenconfUtils;
import org.obeonetwork.m2doc.genconf.Generation;
import org.obeonetwork.m2doc.generator.DocumentGenerationException;
import org.obeonetwork.m2doc.generator.GenerationResult;
import org.obeonetwork.m2doc.parser.DocumentParserException;
import org.obeonetwork.m2doc.parser.TemplateValidationMessage;
import org.obeonetwork.m2doc.parser.ValidationMessageLevel;
import org.obeonetwork.m2doc.services.HTTPServiceConfigurator;
import org.obeonetwork.m2doc.services.configurator.IServicesConfigurator;
import org.obeonetwork.m2doc.services.configurator.IServicesConfiguratorDescriptor;
import org.obeonetwork.m2doc.services.configurator.ServicesConfiguratorDescriptor;
import org.obeonetwork.m2doc.template.DocumentTemplate;
import org.obeonetwork.m2doc.tests.M2DocTestUtils;
import org.obeonetwork.m2doc.tests.TemplateAstSerializer;
import org.obeonetwork.m2doc.tests.TestMemoryURIHandler;
import org.obeonetwork.m2doc.util.ClassProvider;
import org.obeonetwork.m2doc.util.IClassProvider;
import org.obeonetwork.m2doc.util.M2DocUtils;

@RunWith(value=Parameterized.class)
public abstract class AbstractTemplatesTestSuite {
    private static final int BUFFER_SIZE = 8192;
    private static final String LOST_DOCX = "-lost.docx";
    private static final String DOESN_T_EXIST = " doesn't exist.";
    private static final String USER_CONTENT_TAG = "-userContent";
    private static final IServicesConfiguratorDescriptor SERVICES_CONFIGURATOR_DESCRIPTOR = new ServicesConfiguratorDescriptor((IServicesConfigurator)new HTTPServiceConfigurator());
    private final TestMemoryURIHandler uriHandler = new TestMemoryURIHandler();
    private static DocumentTemplate documentTemplate;
    private final TemplateAstSerializer templateAstSerializer = new TemplateAstSerializer();
    private final String testFolderPath;
    private final Generation generation;
    private final IQueryEnvironment queryEnvironment;
    private final Map<String, Object> variables;
    private final ResourceSet resourceSetForModels;

    public AbstractTemplatesTestSuite(String testFolder) throws IOException, DocumentParserException {
        this.testFolderPath = testFolder.replaceAll("\\\\", "/");
        URI genconfURI = this.getGenconfURI(new File(this.testFolderPath));
        if (URIConverter.INSTANCE.exists(genconfURI, Collections.EMPTY_MAP)) {
            ResourceSet rs = this.getResourceSetForGenconf();
            this.generation = this.getGeneration(genconfURI, rs);
        } else {
            this.generation = GenconfFactory.eINSTANCE.createGeneration();
            XMIResourceImpl r = new XMIResourceImpl(genconfURI);
            r.getContents().add((Object)this.generation);
        }
        URI templateURI = this.getTemplateURI(new File(this.testFolderPath));
        this.setTemplateFileName(this.generation, URI.decode((String)templateURI.deresolve(genconfURI).toString()));
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        this.resourceSetForModels = this.getResourceSetForModel(exceptions);
        this.queryEnvironment = GenconfUtils.getQueryEnvironment((ResourceSet)this.resourceSetForModels, (Generation)this.generation);
        documentTemplate = M2DocUtils.parse((URIConverter)this.resourceSetForModels.getURIConverter(), (URI)templateURI, (IQueryEnvironment)this.queryEnvironment, (IClassProvider)new ClassProvider(this.getClass().getClassLoader()), (Monitor)new BasicMonitor());
        for (Exception e : exceptions) {
            XWPFRun run = M2DocUtils.getOrCreateFirstRun((XWPFDocument)documentTemplate.getDocument());
            documentTemplate.getBody().getValidationMessages().add((Object)new TemplateValidationMessage(ValidationMessageLevel.ERROR, e.getMessage(), run));
        }
        this.variables = GenconfUtils.getVariables((Generation)this.generation, (ResourceSet)this.resourceSetForModels);
    }

    protected ResourceSet getResourceSetForModel(List<Exception> exceptions) {
        ResourceSetImpl rs = new ResourceSetImpl();
        XMIResourceFactoryImpl xmiResourceFactory = new XMIResourceFactoryImpl();
        rs.getResourceFactoryRegistry().getExtensionToFactoryMap().put("ecore", xmiResourceFactory);
        rs.getResourceFactoryRegistry().getExtensionToFactoryMap().put("xmi", xmiResourceFactory);
        rs.getResourceFactoryRegistry().getExtensionToFactoryMap().put("genconf", xmiResourceFactory);
        rs.getResourceFactoryRegistry().getExtensionToFactoryMap().put("uml", xmiResourceFactory);
        ResourceSet res = M2DocUtils.createResourceSetForModels(exceptions, (Object)this.generation, (ResourceSet)rs, (Map)GenconfUtils.getOptions((Generation)this.generation));
        res.getURIConverter().getURIHandlers().add(0, (Object)this.uriHandler);
        return res;
    }

    @After
    public void after() {
        M2DocUtils.cleanResourceSetForModels((Object)this.generation, (ResourceSet)this.resourceSetForModels);
        this.uriHandler.clear();
    }

    protected void setTemplateFileName(Generation gen, String templateFileName) {
        gen.setTemplateFileName(templateFileName);
    }

    @BeforeClass
    public static void beforeClass() {
        if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
            M2DocUtils.registerServicesConfigurator((IServicesConfiguratorDescriptor)SERVICES_CONFIGURATOR_DESCRIPTOR);
        }
    }

    @AfterClass
    public static void afterClass() throws IOException {
        documentTemplate.close();
        if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
            M2DocUtils.unregisterServicesConfigurator((IServicesConfiguratorDescriptor)SERVICES_CONFIGURATOR_DESCRIPTOR);
        }
    }

    protected Generation getGeneration(URI genconfURI, ResourceSet rs) {
        return (Generation)rs.getResource(genconfURI, true).getContents().get(0);
    }

    protected String getTestFolderPath() {
        return this.testFolderPath;
    }

    protected ResourceSet getResourceSetForGenconf() {
        ResourceSetImpl res = new ResourceSetImpl();
        res.getPackageRegistry().put((Object)"http://www.obeonetwork.org/m2doc/genconf/1.0", (Object)GenconfPackage.eINSTANCE);
        res.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        return res;
    }

    @Test
    public void parsing() throws FileNotFoundException, IOException {
        Throwable throwable;
        URI expectedASTURI = this.getExpectedASTURI(new File(this.testFolderPath));
        String actualAst = this.templateAstSerializer.serialize(documentTemplate);
        if (!this.resourceSetForModels.getURIConverter().exists(expectedASTURI, Collections.EMPTY_MAP)) {
            URI actualASTURI = this.getActualASTURI(new File(this.testFolderPath));
            throwable = null;
            Object var5_8 = null;
            try (OutputStream stream = this.resourceSetForModels.getURIConverter().createOutputStream(actualASTURI);){
                AbstractTemplatesTestSuite.setContent(stream, "UTF-8", actualAst);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            Assert.fail((String)(expectedASTURI + DOESN_T_EXIST));
        }
        Throwable throwable3 = null;
        throwable = null;
        try (InputStream stream = this.resourceSetForModels.getURIConverter().createInputStream(expectedASTURI);){
            String expectedAst = AbstractTemplatesTestSuite.getContent(stream, "UTF-8");
            Assert.assertEquals((Object)expectedAst.replaceAll("\r\n", "\n"), (Object)actualAst.replaceAll("\r\n", "\n"));
        }
        catch (Throwable throwable4) {
            if (throwable3 == null) {
                throwable3 = throwable4;
            } else if (throwable3 != throwable4) {
                throwable3.addSuppressed(throwable4);
            }
            throw throwable3;
        }
    }

    @Test
    public void validation() throws IOException, DocumentGenerationException {
        URI outputURI;
        boolean ignoreVersionCheck = Boolean.valueOf((String)GenconfUtils.getOptions((Generation)this.generation).get("IgnoreVersionCheck"));
        ValidationMessageLevel validationLevel = M2DocUtils.validate((DocumentTemplate)documentTemplate, (IReadOnlyQueryEnvironment)this.queryEnvironment, (boolean)ignoreVersionCheck, (Monitor)new BasicMonitor());
        URI expectedValidationURI = this.getExpectedValidatedURI(new File(this.testFolderPath));
        if (this.resourceSetForModels.getURIConverter().exists(expectedValidationURI, Collections.EMPTY_MAP)) {
            outputURI = this.getValidationOutputURI(this.testFolderPath);
            if (validationLevel != ValidationMessageLevel.OK) {
                M2DocUtils.serializeValidatedDocumentTemplate((URIConverter)this.resourceSetForModels.getURIConverter(), (DocumentTemplate)documentTemplate, (URI)outputURI);
            }
        } else {
            outputURI = this.getActualValidatedURI(new File(this.testFolderPath));
            if (validationLevel != ValidationMessageLevel.OK) {
                M2DocUtils.serializeValidatedDocumentTemplate((URIConverter)this.resourceSetForModels.getURIConverter(), (DocumentTemplate)documentTemplate, (URI)outputURI);
            } else {
                this.touch(outputURI);
            }
            Assert.fail((String)(expectedValidationURI + DOESN_T_EXIST));
        }
        if (!this.isEmpty(outputURI)) {
            M2DocTestUtils.assertDocx(this.resourceSetForModels.getURIConverter(), expectedValidationURI, outputURI);
        } else {
            Assert.assertEquals((Object)ValidationMessageLevel.OK, (Object)validationLevel);
            Assert.assertTrue((boolean)this.resourceSetForModels.getURIConverter().exists(expectedValidationURI, Collections.EMPTY_MAP));
            Assert.assertTrue((boolean)this.isEmpty(expectedValidationURI));
        }
        this.resourceSetForModels.getURIConverter().delete(outputURI, Collections.EMPTY_MAP);
    }

    private URI getValidationOutputURI(String testFolderPath) {
        return URI.createURI((String)("m2doctest://" + testFolderPath + "-validation-test.docx"), (boolean)false);
    }

    private boolean isEmpty(URI uri) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream inputStream = this.resourceSetForModels.getURIConverter().createInputStream(uri);){
                boolean bl = this.resourceSetForModels.getURIConverter().createInputStream(uri).read() == -1;
                return bl;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            return true;
        }
    }

    @Test
    public void generation() throws Exception {
        Closeable stream;
        Object var10_12;
        Throwable throwable;
        URI expectedGeneratedURI = this.getExpectedGeneratedURI(new File(this.testFolderPath));
        URI userContentURI = this.getUserContentURI(new File(this.testFolderPath));
        URI outputURI = null;
        if (this.resourceSetForModels.getURIConverter().exists(expectedGeneratedURI, Collections.EMPTY_MAP)) {
            outputURI = this.getGenerationOutputURI(this.testFolderPath);
        } else {
            outputURI = this.getActualGeneratedURI(new File(this.testFolderPath));
            this.prepareoutputAndGenerate(userContentURI, outputURI);
            Assert.fail((String)(expectedGeneratedURI + DOESN_T_EXIST));
        }
        GenerationResult generationResult = this.prepareoutputAndGenerate(userContentURI, outputURI);
        M2DocTestUtils.assertDocx(this.resourceSetForModels.getURIConverter(), expectedGeneratedURI, outputURI);
        if (generationResult.getLostDocumentURI() != null) {
            URI expectedLostDocumentURI = this.getExpectedLostDocumentURI(new File(this.testFolderPath));
            if (!this.resourceSetForModels.getURIConverter().exists(expectedLostDocumentURI, Collections.EMPTY_MAP)) {
                URI actualLostDocumentURI = this.getActualLostDocumentURI(new File(this.testFolderPath));
                this.copy(generationResult.getLostDocumentURI(), actualLostDocumentURI);
                Assert.fail((String)(expectedLostDocumentURI + DOESN_T_EXIST));
            }
            M2DocTestUtils.assertDocx(this.resourceSetForModels.getURIConverter(), expectedLostDocumentURI, generationResult.getLostDocumentURI());
        }
        List<URI> expectedLostFiles = this.getExpectedLostURIs(this.testFolderPath);
        for (Map.Entry entry : generationResult.getLostUserContents().entrySet()) {
            URI actualLostURI = (URI)entry.getValue();
            URI expectedLostURI = URI.createURI((String)(String.valueOf(expectedGeneratedURI.toString()) + "-" + (String)entry.getKey() + LOST_DOCX), (boolean)false);
            if (!this.resourceSetForModels.getURIConverter().exists(expectedLostURI, Collections.emptyMap())) {
                this.copy(actualLostURI, URI.createURI((String)expectedLostURI.toString().replace("-expected-", "-actual-"), (boolean)false));
                Assert.fail((String)(expectedLostURI + DOESN_T_EXIST));
            }
            M2DocTestUtils.assertDocx(this.resourceSetForModels.getURIConverter(), expectedLostURI, actualLostURI);
            expectedLostFiles.remove(expectedLostURI);
        }
        Assert.assertTrue((String)Arrays.deepToString(expectedLostFiles.toArray()), (boolean)expectedLostFiles.isEmpty());
        String actualGenerationMessages = this.getGenerationMessageText(generationResult);
        URI expectedGenerationMessageURI = this.getExpectedGenerationMessageURI(new File(this.testFolderPath));
        URI actualValidationMessageURI = this.getActualGenerationMessageURI(new File(this.testFolderPath));
        if (!this.resourceSetForModels.getURIConverter().exists(expectedGenerationMessageURI, Collections.emptyMap())) {
            throwable = null;
            var10_12 = null;
            try {
                stream = this.resourceSetForModels.getURIConverter().createOutputStream(actualValidationMessageURI);
                try {
                    AbstractTemplatesTestSuite.setContent((OutputStream)stream, "UTF-8", actualGenerationMessages);
                }
                finally {
                    if (stream != null) {
                        ((OutputStream)stream).close();
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            Assert.fail((String)("missing " + expectedGenerationMessageURI.toString()));
        }
        throwable = null;
        var10_12 = null;
        try {
            stream = this.resourceSetForModels.getURIConverter().createInputStream(expectedGenerationMessageURI);
            try {
                String expectedGenerationMessages = AbstractTemplatesTestSuite.getContent((InputStream)stream, "UTF-8");
                Assert.assertEquals((Object)expectedGenerationMessages.replaceAll("\r\n", "\n"), (Object)actualGenerationMessages.replaceAll("\r\n", "\n"));
            }
            finally {
                if (stream != null) {
                    ((InputStream)stream).close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    protected URI getGenerationOutputURI(String testFolderPath) {
        return URI.createURI((String)("m2doctest://" + testFolderPath + "-generation-test.docx"), (boolean)false);
    }

    private String getGenerationMessageText(GenerationResult generationResult) {
        StringBuilder builder = new StringBuilder();
        for (TemplateValidationMessage message : generationResult.getMessages()) {
            builder.append(message.getLevel());
            builder.append(" - ");
            builder.append(message.getMessage());
            builder.append("\n");
        }
        return M2DocTestUtils.getPortableString(builder.toString());
    }

    private GenerationResult prepareoutputAndGenerate(URI userContentURI, URI outputURI) throws Exception {
        if (this.resourceSetForModels.getURIConverter().exists(userContentURI, Collections.EMPTY_MAP)) {
            this.copy(userContentURI, outputURI);
        }
        for (URI userContentLostURI : this.getUserContentLostURI(new File(this.testFolderPath))) {
            URI destURI = URI.createURI((String)(String.valueOf(outputURI.toString()) + userContentLostURI.lastSegment().substring(userContentLostURI.lastSegment().indexOf(USER_CONTENT_TAG) + USER_CONTENT_TAG.length())), (boolean)false);
            this.copy(userContentLostURI, destURI);
        }
        boolean updateFields = Boolean.valueOf((String)GenconfUtils.getOptions((Generation)this.generation).get("UpdateFields"));
        GenerationResult generationResult = M2DocUtils.generate((DocumentTemplate)documentTemplate, (IReadOnlyQueryEnvironment)this.queryEnvironment, this.variables, (ResourceSet)this.resourceSetForModels, (URI)outputURI, (boolean)updateFields, (Monitor)new BasicMonitor());
        return generationResult;
    }

    private List<URI> getExpectedLostURIs(String folderPath) {
        ArrayList<URI> result = new ArrayList<URI>();
        File folder = new File(folderPath);
        Object[] children = folder.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isFile() && pathname.getName().contains("expected") && pathname.getName().contains(AbstractTemplatesTestSuite.LOST_DOCX);
            }
        });
        Arrays.sort(children);
        Object[] objectArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Object file = objectArray[n2];
            result.add(URI.createURI((String)((File)file).toURI().toString(), (boolean)false));
            ++n2;
        }
        return result;
    }

    protected URI getExpectedLostDocumentURI(File testFolder) {
        return URI.createURI((String)(String.valueOf(testFolder.toURI().toString()) + testFolder.getName() + "-expected-backup.docx"), (boolean)false);
    }

    protected URI getActualLostDocumentURI(File testFolder) {
        return URI.createURI((String)(String.valueOf(testFolder.toURI().toString()) + testFolder.getName() + "-actual-backup.docx"), (boolean)false);
    }

    protected URI getTemplateURI(File testFolder) {
        return URI.createURI((String)AbstractTemplatesTestSuite.getTemplateFileInternal(testFolder).toURI().toString(), (boolean)false);
    }

    protected URI getExpectedASTURI(File testFolder) {
        return URI.createURI((String)(String.valueOf(testFolder.toURI().toString()) + testFolder.getName() + "-expected-ast.txt"), (boolean)false);
    }

    protected URI getActualASTURI(File testFolder) {
        return URI.createURI((String)(String.valueOf(testFolder.toURI().toString()) + testFolder.getName() + "-actual-ast.txt"), (boolean)false);
    }

    protected URI getExpectedGenerationMessageURI(File testFolder) {
        return URI.createURI((String)(String.valueOf(testFolder.toURI().toString()) + testFolder.getName() + "-expected-generation-messages.txt"), (boolean)false);
    }

    protected URI getActualGenerationMessageURI(File testFolder) {
        return URI.createURI((String)(String.valueOf(testFolder.toURI().toString()) + testFolder.getName() + "-actual-generation-messages.txt"), (boolean)false);
    }

    protected URI getExpectedValidatedURI(File testFolder) {
        return URI.createURI((String)(String.valueOf(testFolder.toURI().toString()) + testFolder.getName() + "-expected-validation.docx"), (boolean)false);
    }

    protected URI getActualValidatedURI(File testFolder) {
        return URI.createURI((String)(String.valueOf(testFolder.toURI().toString()) + testFolder.getName() + "-actual-validation.docx"), (boolean)false);
    }

    protected URI getExpectedGeneratedURI(File testFolder) {
        return URI.createURI((String)(String.valueOf(testFolder.toURI().toString()) + testFolder.getName() + "-expected-generation.docx"), (boolean)false);
    }

    protected URI getActualGeneratedURI(File testFolder) {
        return URI.createURI((String)(String.valueOf(testFolder.toURI().toString()) + testFolder.getName() + "-actual-generation.docx"), (boolean)false);
    }

    protected URI getUserContentURI(File testFolder) {
        return URI.createURI((String)(String.valueOf(testFolder.toURI().toString()) + testFolder.getName() + "-userContent.docx"), (boolean)false);
    }

    protected List<URI> getUserContentLostURI(File testFolder) {
        ArrayList<URI> result = new ArrayList<URI>();
        Object[] children = testFolder.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                String name = pathname.getName();
                return name.contains("-userContent-") && name.contains(AbstractTemplatesTestSuite.LOST_DOCX);
            }
        });
        Arrays.sort(children);
        Object[] objectArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Object child = objectArray[n2];
            result.add(URI.createURI((String)((File)child).toURI().toString(), (boolean)false));
            ++n2;
        }
        return result;
    }

    protected URI getGenconfURI(File testFolder) {
        return URI.createURI((String)(String.valueOf(testFolder.toURI().toString()) + testFolder.getName() + ".genconf"), (boolean)false);
    }

    protected static File getTemplateFileInternal(File testFolder) {
        return new File(String.valueOf(testFolder.getAbsolutePath()) + File.separator + testFolder.getName() + "-template.docx");
    }

    public static Collection<Object[]> retrieveTestFolders(String folderPath) {
        ArrayList<Object[]> parameters = new ArrayList<Object[]>();
        File folder = new File(folderPath);
        Object[] children = folder.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                boolean res = pathname.isDirectory() && pathname.canRead() ? AbstractTemplatesTestSuite.getTemplateFileInternal(pathname).exists() : false;
                return res;
            }
        });
        Arrays.sort(children);
        Object[] objectArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Object child = objectArray[n2];
            parameters.add(new Object[]{((File)child).getPath()});
            ++n2;
        }
        return parameters;
    }

    public static String getContent(InputStream stream, String charsetName) throws IOException {
        int len = 8192;
        StringBuilder res = new StringBuilder(8192);
        Throwable throwable = null;
        Object var5_6 = null;
        try (InputStreamReader input = new InputStreamReader((InputStream)new BufferedInputStream(stream), charsetName);){
            char[] buffer = new char[8192];
            int length = input.read(buffer);
            while (length != -1) {
                res.append(buffer, 0, length);
                length = input.read(buffer);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return res.toString();
    }

    public static void setContent(OutputStream stream, String charsetName, String content) throws UnsupportedEncodingException, IOException {
        stream.write(content.getBytes(charsetName));
        stream.flush();
    }

    private void touch(URI uri) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (OutputStream dest = this.resourceSetForModels.getURIConverter().createOutputStream(uri);){
            dest.write(new byte[0]);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     */
    private long copy(URI sourceURI, URI destURI) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try {
            long l;
            OutputStream dest;
            InputStream source;
            block17: {
                block16: {
                    int n;
                    source = this.resourceSetForModels.getURIConverter().createInputStream(sourceURI);
                    dest = this.resourceSetForModels.getURIConverter().createOutputStream(destURI);
                    long nread = 0L;
                    byte[] buf = new byte[8192];
                    while ((n = source.read(buf)) > 0) {
                        dest.write(buf, 0, n);
                        nread += (long)n;
                    }
                    l = nread;
                    if (dest == null) break block16;
                    dest.close();
                }
                if (source == null) break block17;
                source.close();
            }
            return l;
            {
                catch (Throwable throwable2) {
                    try {
                        if (dest != null) {
                            dest.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (source != null) {
                            source.close();
                        }
                        throw throwable;
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }
}

