/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.tests;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import org.junit.Assert;

public final class ImageTestUtils {
    private static final int GREEN_SHIFT = 8;
    private static final int RED_SHIFT = 16;
    private static final int ALPHA_SHIFT = 24;
    private static final int BLUE_MASK = 255;
    private static final int GREEN_MASK = 65280;
    private static final int RED_MASK = 0xFF0000;
    private static final int ALPHA_MASK = -16777216;
    private static final int R = 0;
    private static final int G = 1;
    private static final int B = 2;
    private static final int RGB_SIZE = 3;
    private static final int MAX_RGB_DIFF = 765;

    private ImageTestUtils() {
    }

    public static void assertGIF(File diffOutput, InputStream expectedIs, InputStream actualIs, double threshold) {
        try {
            Assert.assertTrue((boolean)ImageTestUtils.fuzzyCompareImage("GIF", diffOutput, expectedIs, actualIs, threshold));
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    public static void assertPNG(File diffOutput, InputStream expectedIs, InputStream actualIs, double threshold) {
        try {
            Assert.assertTrue((boolean)ImageTestUtils.fuzzyCompareImage("PNG", diffOutput, expectedIs, actualIs, threshold));
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    public static void assertBMP(File diffOutput, InputStream expectedIs, InputStream actualIs, double threshold) {
        try {
            Assert.assertTrue((boolean)ImageTestUtils.fuzzyCompareImage("BMP", diffOutput, expectedIs, actualIs, threshold));
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    public static void assertJPG(File diffOutput, InputStream expectedIs, InputStream actualIs, double threshold) {
        try {
            Assert.assertTrue((boolean)ImageTestUtils.fuzzyCompareImage("JPG", diffOutput, expectedIs, actualIs, threshold));
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    private static boolean fuzzyCompareImage(String imageFormat, File diffOutput, InputStream expectedIs, InputStream actualIs, double threshold) throws IOException {
        boolean result = true;
        BufferedImage expectedImage = ImageIO.read(expectedIs);
        BufferedImage actualImage = ImageIO.read(actualIs);
        if (expectedImage == null) {
            result = actualImage == null;
        } else if (actualImage == null) {
            result = false;
        } else {
            BufferedImage actualImageResized = ImageTestUtils.resize(actualImage, expectedImage.getWidth(), expectedImage.getHeight());
            BufferedImage diffImage = diffOutput != null ? ImageTestUtils.createDiffImage(expectedImage, actualImageResized) : null;
            Graphics2D outImgGraphics = diffImage.createGraphics();
            outImgGraphics.setColor(Color.RED);
            int blockWidth = expectedImage.getWidth() > 20 ? expectedImage.getWidth() / 20 : expectedImage.getWidth();
            int blockHeight = expectedImage.getWidth() > 20 ? expectedImage.getWidth() / 20 : expectedImage.getWidth();
            int nbBlocksX = (int)Math.ceil((float)expectedImage.getWidth() / (float)blockWidth);
            int nbBlocksY = (int)Math.ceil((float)expectedImage.getHeight() / (float)blockHeight);
            int blockIndexX = 0;
            while (blockIndexX < nbBlocksX) {
                int blockIndexY = 0;
                while (blockIndexY < nbBlocksY) {
                    double[] avgRgbActual;
                    int sampleHeight;
                    int sampleWidth = ImageTestUtils.getsampleSize(blockWidth, blockIndexX, expectedImage.getWidth());
                    double[] avgRgbExpected = ImageTestUtils.getAverageRgb(expectedImage.getSubimage(blockIndexX * blockWidth, blockIndexY * blockHeight, sampleWidth, sampleHeight = ImageTestUtils.getsampleSize(blockHeight, blockIndexY, expectedImage.getHeight())));
                    if (ImageTestUtils.getDiffPercentage(avgRgbExpected, avgRgbActual = ImageTestUtils.getAverageRgb(actualImageResized.getSubimage(blockIndexX * blockWidth, blockIndexY * blockHeight, sampleWidth, sampleHeight))) > threshold) {
                        int markerX = blockIndexX * blockWidth + expectedImage.getWidth(null);
                        int markerY = blockIndexY * blockHeight;
                        outImgGraphics.drawRect(markerX, markerY, blockWidth - 1, blockHeight - 1);
                        result = false;
                        if (diffImage == null) break;
                    }
                    ++blockIndexY;
                }
                ++blockIndexX;
            }
            if (!result && diffImage != null) {
                if (!diffOutput.exists()) {
                    diffOutput.createNewFile();
                }
                ImageIO.write((RenderedImage)diffImage, imageFormat, diffOutput);
            }
        }
        return result;
    }

    private static int getsampleSize(int defaultBlockSize, int blockIndex, int limit) {
        int result = defaultBlockSize * (blockIndex + 1) > limit ? limit % defaultBlockSize : defaultBlockSize;
        return result;
    }

    public static BufferedImage resize(BufferedImage image, int newWidth, int newHeight) {
        BufferedImage result = new BufferedImage(newWidth, newHeight, 2);
        Image tmp = image.getScaledInstance(newWidth, newHeight, 4);
        Graphics2D g2d = result.createGraphics();
        g2d.drawImage(tmp, 0, 0, null);
        g2d.dispose();
        return result;
    }

    private static double getDiffPercentage(double[] rgb1, double[] rgb2) {
        double difference = Math.abs(rgb1[0] - rgb2[0]) + Math.abs(rgb1[1] - rgb2[1]) + Math.abs(rgb1[2] - rgb2[2]);
        return difference / 765.0;
    }

    private static double[] getAverageRgb(BufferedImage image) {
        double[] result = new double[]{0.0, 0.0, 0.0};
        int y = 0;
        while (y < image.getHeight()) {
            int x = 0;
            while (x < image.getWidth()) {
                int rgb = image.getRGB(x, y);
                if ((rgb & 0xFF000000) >> 24 != 0) {
                    result[0] = result[0] + (double)((rgb & 0xFF0000) >> 16);
                    result[1] = result[1] + (double)((rgb & 0xFF00) >> 8);
                    result[2] = result[2] + (double)(rgb & 0xFF);
                }
                ++x;
            }
            ++y;
        }
        int sampleSize = image.getHeight() * image.getWidth();
        result[0] = result[0] / (double)sampleSize;
        result[1] = result[1] / (double)sampleSize;
        result[2] = result[2] / (double)sampleSize;
        return result;
    }

    private static BufferedImage createDiffImage(BufferedImage expected, BufferedImage actual) {
        int resultWidth = expected.getWidth(null) + actual.getWidth(null) * 2;
        int resultHeight = Math.max(expected.getHeight(null), actual.getHeight(null));
        BufferedImage result = new BufferedImage(resultWidth, resultHeight, 1);
        Graphics2D g2 = result.createGraphics();
        g2.drawImage((Image)expected, 0, 0, null);
        g2.drawImage((Image)expected, expected.getWidth(null), 0, null);
        g2.drawImage((Image)actual, expected.getWidth(null) * 2, 0, null);
        return result;
    }
}

